/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.cotacaocompra;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.CotacaoCompra;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.LogCotacaoCompra;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.helpers.impl.condicoespagamento.HelperCondicoesPagamento;
import com.touchcomp.basementorservice.helpers.impl.cotacaocompra.AuxSelecionaMelhorFornecedor;
import com.touchcomp.basementorservice.helpers.impl.cotacaocompra.GenMapFornecedorCotacao;
import com.touchcomp.basementorservice.model.genericmap.GenericMapValues;
import com.touchcomp.basementorservice.service.impl.leadtimefornecedor.DTOLeadTimeSimples;
import com.touchcomp.basementorservice.service.impl.leadtimefornecedor.ServiceLeadTimeFornProdutoImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperCotacaoCompra
implements AbstractHelper<CotacaoCompra> {
    @Autowired
    private HelperCondicoesPagamento helperCondicoesPagamento;
    @Autowired
    private ServiceLeadTimeFornProdutoImpl serviceLeadTimeFornProdutoImpl;
    private CotacaoCompra cotacaoCompra;

    public CotacaoCompra get() {
        return this.cotacaoCompra;
    }

    public HelperCotacaoCompra build(CotacaoCompra data) {
        this.cotacaoCompra = data;
        return this;
    }

    public CotacaoCompra buildCotacaoCompra(Empresa empresa, Usuario usuario, OpcoesCompraSuprimentos opcoes) {
        CotacaoCompra cotacaoCompra = new CotacaoCompra();
        cotacaoCompra.setDataAtualizacao(ToolDate.toTimestamp((Date)new Date()));
        cotacaoCompra.setDataCotacaoCompra(new Date());
        cotacaoCompra.setDataCadastro(new Date());
        cotacaoCompra.setDataPrevFinalizacao(ToolDate.nextDays((Date)cotacaoCompra.getDataCotacaoCompra(), (int)opcoes.getDiasValidadeCotCompras().shortValue()));
        cotacaoCompra.setEmpresa(empresa);
        cotacaoCompra.setFechada(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        cotacaoCompra.setItensCotacaoCompra(new ArrayList());
        cotacaoCompra.setUsuarioComprador(usuario);
        cotacaoCompra.setSituacaoCotacaoCompra(opcoes.getSituacaoCotacaoCompraCadastro());
        return cotacaoCompra;
    }

    public ItemCotacaoCompra buildItemCotacaoCompra(GradeCor gradeCor, Double quantidade, NaturezaOperacao naturezaOperacao, Date dataCadastro, CotacaoCompra cotacaoCompra) {
        ItemCotacaoCompra vo = new ItemCotacaoCompra();
        vo.setGradeCor(gradeCor);
        vo.setQuantidade(quantidade);
        vo.setNaturezaOperacao(naturezaOperacao);
        vo.setDataCadastro(dataCadastro);
        vo.setCotacaoCompra(cotacaoCompra);
        return vo;
    }

    public void gerarLogsCotacao(CotacaoCompra vo, Usuario usuario) {
        if (vo.getSituacaoCotacaoCompra() != null) {
            if (vo.getSituacaoCotacaoCompraAnt() == null) {
                LogCotacaoCompra l = new LogCotacaoCompra();
                l.setCotacaoCompra(vo);
                l.setUsuario(usuario);
                l.setSituacaoAtual(vo.getSituacaoCotacaoCompra());
                l.setObservacao(MessagesBaseMentor.getMsg((String)"mudanca_situacao", (Object[])new Object[0]));
                vo.setSituacaoCotacaoCompraAnt(vo.getSituacaoCotacaoCompra());
                vo.getLogsCotacaoCompra().add(l);
            } else if (!vo.getSituacaoCotacaoCompra().equals((Object)vo.getSituacaoCotacaoCompraAnt())) {
                LogCotacaoCompra l = new LogCotacaoCompra();
                l.setCotacaoCompra(vo);
                l.setUsuario(usuario);
                l.setSituacaoAtual(vo.getSituacaoCotacaoCompra());
                l.setSituacaoAnterior(vo.getSituacaoCotacaoCompraAnt());
                l.setObservacao(MessagesBaseMentor.getMsg((String)"mudanca_situacao", (Object[])new Object[0]));
                vo.setSituacaoCotacaoCompraAnt(vo.getSituacaoCotacaoCompra());
                vo.getLogsCotacaoCompra().add(l);
            }
        }
    }

    public NaturezaOperacao getNaturezaOperacaoCotacao(NecessidadeCompra necessidadeCompra, OpcoesCompraSuprimentos opcoes) {
        if (necessidadeCompra != null && necessidadeCompra.getNaturezaOperacao() != null) {
            return necessidadeCompra.getNaturezaOperacao();
        }
        return opcoes.getNaturezaOperacao();
    }

    public void avaliaMelhorFornecedor(CotacaoCompra cotacao, OpcoesCompraSuprimentos opcoesCompraSuprimentos) {
        new AuxSelecionaMelhorFornecedor(this.serviceLeadTimeFornProdutoImpl, opcoesCompraSuprimentos, this.helperCondicoesPagamento).selectBestFornecedor(cotacao);
    }

    public FornecedorItemCotacaoCompra avaliaMelhorFornecedor(ItemCotacaoCompra item, Empresa empresa, OpcoesCompraSuprimentos opcoesCompraSuprimentos) {
        return new AuxSelecionaMelhorFornecedor(this.serviceLeadTimeFornProdutoImpl, opcoesCompraSuprimentos, this.helperCondicoesPagamento).selectBestFornecedor(item, empresa);
    }

    public GenericMapValues<GenMapFornecedorCotacao> avaliaMelhorFornecedor(List<GenericMapValues<GenMapFornecedorCotacao>> fornecedoresItem, OpcoesCompraSuprimentos opcoesCompraSuprimentos) {
        return this.avaliaMelhorFornecedor(fornecedoresItem, opcoesCompraSuprimentos);
    }

    public GenericMapValues<GenMapFornecedorCotacao> avaliaMelhorFornecedor(List<GenericMapValues<GenMapFornecedorCotacao>> fornecedoresItem, OpcoesCompraSuprimentos opcoesCompraSuprimentos, List<DTOLeadTimeSimples> leadsTime, boolean rankear) {
        return new AuxSelecionaMelhorFornecedor(this.serviceLeadTimeFornProdutoImpl, opcoesCompraSuprimentos, this.helperCondicoesPagamento).selectBestFornecedor(fornecedoresItem, opcoesCompraSuprimentos.getEmpresa(), rankear, leadsTime);
    }

    public void definirDataMaxEntrega() {
        if (this.cotacaoCompra == null) {
            return;
        }
        for (ItemCotacaoCompra item : this.cotacaoCompra.getItensCotacaoCompra()) {
            Date max = null;
            for (NecessidadeCompra nec : item.getNecessidadesCompra()) {
                if (max != null && !max.after(nec.getDataNecessidade())) continue;
                max = nec.getDataNecessidade();
            }
            item.setDataMaxEntrega(max);
        }
    }

    public void avaliaFechamentoCotacao(OpcoesCompraSuprimentos opcoesCompraSup) {
        this.cotacaoCompra.setFechada(Short.valueOf(this.isFechada().getValue()));
        if (TMethods.isAffirmative((Number)this.cotacaoCompra.getFechada())) {
            this.cotacaoCompra.setSituacaoCotacaoCompra(opcoesCompraSup.getSituacaoCotacaoCompraGerarOC());
            this.cotacaoCompra.setDataFinalizacao(new Date());
        }
    }

    private EnumConstantsMentorSimNao isFechada() {
        if (!TMethods.isNull((Object)this.cotacaoCompra.getOrdensCompra()).booleanValue() && !this.cotacaoCompra.getOrdensCompra().isEmpty()) {
            return EnumConstantsMentorSimNao.SIM;
        }
        return EnumConstantsMentorSimNao.NAO;
    }

    public void setarSituacaoNecessidadeCompra(OpcoesCompraSuprimentos opcoes) {
        for (ItemCotacaoCompra item : this.cotacaoCompra.getItensCotacaoCompra()) {
            if (TMethods.isNull((Object)item.getNecessidadesCompra()).booleanValue()) continue;
            for (NecessidadeCompra necessidadeCompra : item.getNecessidadesCompra()) {
                necessidadeCompra.setSituacaoNecessidadeCompra(opcoes.getSituacaoNecessidadeOrdemCompra());
            }
        }
    }

    public List<FornecedorItemCotacaoCompra> getFornecedoresValidados(ItemCotacaoCompra item, OpcoesCompraSuprimentos opcoes) {
        ArrayList<FornecedorItemCotacaoCompra> fornecedoresValidados = new ArrayList<FornecedorItemCotacaoCompra>();
        for (FornecedorItemCotacaoCompra vo : item.getFornecedoresItemCotacaoCompra()) {
            if (TMethods.isAffirmative((Number)opcoes.getGerarOCSomenteItensValidos())) {
                if (!TMethods.isAffirmative((Number)vo.getValidado())) continue;
                fornecedoresValidados.add(vo);
                continue;
            }
            fornecedoresValidados.add(vo);
        }
        return fornecedoresValidados;
    }
}

