/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.cotacaocompra;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.impostos.contsocial.EnumConstTipoCalcContSocial;
import com.touchcomp.basementor.constants.enums.impostos.funrural.EnumConstTipoCalcFunrural;
import com.touchcomp.basementor.constants.enums.impostos.lei10833.EnumConstTipoCalcLei10833;
import com.touchcomp.basementor.constants.enums.impostos.outros.EnumConstTipoCalcOutros;
import com.touchcomp.basementor.constants.enums.impostos.sestsenat.EnumConstTipoCalcSestSenat;
import com.touchcomp.basementor.constants.enums.modelofiscal.EnumConstTipoInss;
import com.touchcomp.basementor.constants.enums.modelofiscal.EnumConstTipoIrrf;
import com.touchcomp.basementor.constants.enums.modelofiscal.EnumConstTipoIss;
import com.touchcomp.basementor.constants.enums.piscofins.EnumConstTipoAliquotaPisCofins;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompraLivroFiscal;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.LeadTimeFornProduto;
import com.touchcomp.basementor.model.vo.LeadTimeFornProdutoInfFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.components.notaterceiros.CompNotaTerceiros;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.helpers.impl.modelofiscal.HelperModeloFiscal;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class HelperFornecedorItemCotCompra
implements AbstractHelper<FornecedorItemCotacaoCompra> {
    private FornecedorItemCotacaoCompra fornecedorItem;

    public FornecedorItemCotacaoCompra get() {
        return this.fornecedorItem;
    }

    public HelperFornecedorItemCotCompra build(FornecedorItemCotacaoCompra object) {
        this.fornecedorItem = object;
        return this;
    }

    public ModeloFiscal getModeloFiscal(Empresa empresa) throws ExceptionObjNotFound {
        if (this.fornecedorItem == null) {
            return null;
        }
        if (this.fornecedorItem.getItemCotacaoCompra() == null) {
            return null;
        }
        return this.getModeloFiscal(this.fornecedorItem.getItemCotacaoCompra().getNaturezaOperacao(), this.fornecedorItem.getItemCotacaoCompra().getGradeCor().getProdutoGrade().getProduto(), this.fornecedorItem.getUnidadeFaturamentoFornecedor(), empresa);
    }

    public ModeloFiscal getModeloFiscal(NaturezaOperacao nat, Produto produto, UnidadeFatFornecedor unidade, Empresa empresa) throws ExceptionObjNotFound {
        if (produto == null || nat == null || unidade == null || empresa == null) {
            return null;
        }
        HelperModeloFiscal service = (HelperModeloFiscal)Context.get(HelperModeloFiscal.class);
        ModeloFiscal modeloFiscal = service.getFirst(produto, unidade, nat, empresa);
        return modeloFiscal;
    }

    public FornecedorItemCotacaoCompra buildFornecedorItemCotCompra(ItemCotacaoCompra itemCotacaoCompra, LeadTimeFornProduto leadTimeFornProduto, Empresa emp, OpcoesCompraSuprimentos opcoes, LeadTimeFornProdutoInfFiscal leadTime) {
        FornecedorItemCotacaoCompra f = new FornecedorItemCotacaoCompra();
        f.setItemCotacaoCompra(itemCotacaoCompra);
        f.setAquisicaoPreferencial(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        f.setDataCadastro(itemCotacaoCompra.getDataCadastro());
        f.setItemCotacaoCompra(itemCotacaoCompra);
        f.setAquisicaoPreferencial(leadTimeFornProduto.getAquisicaoPreferencial());
        f.setCondicaoPagamentoMutante(leadTime.getParcelas());
        f.setCondicoesPagamento(leadTime.getCondicoesPagamento());
        f.setDataCadastro(new Date());
        f.setJustficativaAquisicaoPreferencial(leadTime.getMotivoAqPref());
        f.setModeloFiscal(leadTime.getModeloFiscal());
        f.setPrazoEntrega(Long.valueOf(leadTimeFornProduto.getLeadTime().longValue()));
        f.setSelecionado(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        f.setTipoFrete(leadTime.getTipoFrete());
        f.setUnidadeFaturamentoFornecedor(leadTimeFornProduto.getLeadTimeFornecedor().getUnidadeFatFornecedor());
        f.setValorUnitario(leadTime.getValorUnitNegociado());
        f.setAquisicaoPreferencial(leadTimeFornProduto.getAquisicaoPreferencial());
        f.setUnidadeFaturamentoFornecedor(leadTimeFornProduto.getLeadTimeFornecedor().getUnidadeFatFornecedor());
        f.setPrazoEntrega(Long.valueOf(leadTimeFornProduto.getLeadTime().longValue()));
        return f;
    }

    public FornecedorItemCotacaoCompra buildFornecedorItemCotCompra(ItemCotacaoCompra itemCotacaoCompra, LeadTimeFornProduto leadTimeFornProduto, Empresa emp, OpcoesCompraSuprimentos opcoes) throws ExceptionObjNotFound {
        FornecedorItemCotacaoCompra f = new FornecedorItemCotacaoCompra();
        f.setItemCotacaoCompra(itemCotacaoCompra);
        f.setAquisicaoPreferencial(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        f.setDataCadastro(itemCotacaoCompra.getDataCadastro());
        f.setAquisicaoPreferencial(leadTimeFornProduto.getAquisicaoPreferencial());
        f.setUnidadeFaturamentoFornecedor(leadTimeFornProduto.getLeadTimeFornecedor().getUnidadeFatFornecedor());
        if (!ToolMethods.isNull((Object)f.getUnidadeFaturamentoFornecedor()).booleanValue() && !ToolMethods.isNull((Object)f.getUnidadeFaturamentoFornecedor().getFornecedor()).booleanValue()) {
            f.setCondicoesPagamento(f.getUnidadeFaturamentoFornecedor().getFornecedor().getCondicaoPagamento());
        }
        f.setPrazoEntrega(Long.valueOf(leadTimeFornProduto.getLeadTime().longValue()));
        f.setFornecedorItemCotacaoCompraLivroFiscal(new FornecedorItemCotacaoCompraLivroFiscal());
        if (itemCotacaoCompra.getGradeCor() != null && !ToolMethods.isAffirmative((Number)opcoes.getNaoSugCustoAutoCotCompras())) {
            f.setCustoMedio(CompNotaTerceiros.getCustoMedioProd(itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto(), emp));
            f.setUltimoCusto(CompNotaTerceiros.getUltimoCustoProd(itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto(), emp));
            f.setMenorCusto(CompNotaTerceiros.getMenorCustoProd(itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto(), emp));
        }
        return f;
    }

    public FornecedorItemCotacaoCompra buildFornecedorItemCotCompra(ItemCotacaoCompra itemCotacaoCompra, NecessidadeCompra necessidadeCompra) throws ExceptionObjNotFound {
        FornecedorItemCotacaoCompra fornecedorItemCotacao = new FornecedorItemCotacaoCompra();
        fornecedorItemCotacao.setItemCotacaoCompra(itemCotacaoCompra);
        fornecedorItemCotacao.setUnidadeFaturamentoFornecedor(necessidadeCompra.getUnidadeFatFornecedor());
        fornecedorItemCotacao.setModeloFiscal(this.getModeloFiscal(itemCotacaoCompra.getNaturezaOperacao(), itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto(), necessidadeCompra.getUnidadeFatFornecedor(), itemCotacaoCompra.getCotacaoCompra().getEmpresa()));
        fornecedorItemCotacao.setDataCadastro(new Date());
        fornecedorItemCotacao.setAquisicaoPreferencial(necessidadeCompra.getAquisicaoPreferencial());
        fornecedorItemCotacao.setMotivoAquisPref(necessidadeCompra.getMotivoAquisPref());
        fornecedorItemCotacao.setJustficativaAquisicaoPreferencial(necessidadeCompra.getMotivoAquisicaoPreferencial());
        fornecedorItemCotacao.setTipoFrete(necessidadeCompra.getTipoFrete());
        fornecedorItemCotacao.setPrazoEntrega(necessidadeCompra.getPrazoEntrega());
        fornecedorItemCotacao.setDataPrevFaturamento(necessidadeCompra.getDataPrevFaturamento());
        fornecedorItemCotacao.setCondicoesPagamento(necessidadeCompra.getCondicoesPagamento());
        fornecedorItemCotacao.setCondicaoPagamentoMutante(necessidadeCompra.getCondicaoMutante());
        return fornecedorItemCotacao;
    }

    public FornecedorItemCotacaoCompraLivroFiscal buildFornecedorItemCotacaoCompraLivroFiscal(FornecedorItemCotacaoCompra f) {
        ModeloFiscal modeloFiscal = f.getModeloFiscal();
        Produto produto = f.getItemCotacaoCompra().getGradeCor().getProdutoGrade().getProduto();
        FornecedorItemCotacaoCompraLivroFiscal itemFornCotacaoLivroFiscal = new FornecedorItemCotacaoCompraLivroFiscal();
        f.setFornecedorItemCotacaoCompraLivroFiscal(itemFornCotacaoLivroFiscal);
        if (f.getValorUnitario() != null && f.getItemCotacaoCompra() != null && f.getItemCotacaoCompra().getQuantidade() != null) {
            itemFornCotacaoLivroFiscal.setValorTotal(Double.valueOf(f.getValorUnitario() * f.getItemCotacaoCompra().getQuantidade()));
        }
        if (modeloFiscal.getTipoIRRF() != null && ToolMethods.isEquals((Object)modeloFiscal.getTipoIRRF(), (Object)EnumConstTipoIrrf.TIPO_IRRF_CALCULAR.getValue())) {
            itemFornCotacaoLivroFiscal.setAliquotaIrrf(produto.getAliquotaIrrf());
            itemFornCotacaoLivroFiscal.setPercentualReducaoIrrf(produto.getPercRedIrrf());
        } else {
            itemFornCotacaoLivroFiscal.setAliquotaIrrf(Double.valueOf(0.0));
            itemFornCotacaoLivroFiscal.setPercentualReducaoIrrf(Double.valueOf(0.0));
        }
        if (modeloFiscal.getTipoINSS() != null && ToolMethods.isEquals((Object)modeloFiscal.getTipoINSS(), (Object)EnumConstTipoInss.TIPO_INSS_RETIDO.getValue())) {
            itemFornCotacaoLivroFiscal.setAliquotaInss(produto.getAliquotaIrrf());
            itemFornCotacaoLivroFiscal.setPercentualReducaoBaseCalculoInss(produto.getPercRedIrrf());
        } else {
            itemFornCotacaoLivroFiscal.setAliquotaInss(Double.valueOf(0.0));
            itemFornCotacaoLivroFiscal.setPercentualReducaoBaseCalculoInss(Double.valueOf(0.0));
        }
        if (modeloFiscal.getTipoSestSenat() != null && ToolMethods.isEquals((Object)modeloFiscal.getTipoSestSenat(), (Object)EnumConstTipoCalcSestSenat.CALCULAR_NORMAL.getValue())) {
            itemFornCotacaoLivroFiscal.setAliquotaSestSenat(produto.getPercSestSenat());
            itemFornCotacaoLivroFiscal.setPercentualReducaoSestSenat(produto.getPercRedSestSenat());
        } else {
            itemFornCotacaoLivroFiscal.setAliquotaSestSenat(Double.valueOf(0.0));
            itemFornCotacaoLivroFiscal.setPercentualReducaoSestSenat(Double.valueOf(0.0));
        }
        if (modeloFiscal.getTipoFunrural() != null && ToolMethods.isEquals((Object)modeloFiscal.getTipoFunrural(), (Object)EnumConstTipoCalcFunrural.CALCULAR_NORMAL.getValue())) {
            itemFornCotacaoLivroFiscal.setAliquotaFunrural(produto.getAliquotaFunrural());
            itemFornCotacaoLivroFiscal.setPercentualReducaoFunrural(produto.getPercRedFunrural());
        } else {
            itemFornCotacaoLivroFiscal.setAliquotaFunrural(Double.valueOf(0.0));
            itemFornCotacaoLivroFiscal.setPercentualReducaoFunrural(Double.valueOf(0.0));
        }
        if (modeloFiscal.getTipoLei10833() != null && ToolMethods.isEquals((Object)modeloFiscal.getTipoLei10833(), (Object)EnumConstTipoCalcLei10833.CALCULAR_NORMAL.getValue())) {
            itemFornCotacaoLivroFiscal.setAliquotaLei10833(produto.getAliquotaLei10833());
            itemFornCotacaoLivroFiscal.setPercentualReducaoLei10833(produto.getPercRedLei10833());
        } else {
            itemFornCotacaoLivroFiscal.setAliquotaLei10833(Double.valueOf(0.0));
            itemFornCotacaoLivroFiscal.setPercentualReducaoLei10833(Double.valueOf(0.0));
        }
        if (modeloFiscal.getTipoOutros() != null && ToolMethods.isEquals((Object)modeloFiscal.getTipoOutros(), (Object)EnumConstTipoCalcOutros.CALCULAR_NORMAL.getValue())) {
            itemFornCotacaoLivroFiscal.setAliquotaOutros(produto.getAliquotaOutros());
            itemFornCotacaoLivroFiscal.setPercentualReducaoOutros(produto.getPercRedOutros());
        } else {
            itemFornCotacaoLivroFiscal.setAliquotaOutros(Double.valueOf(0.0));
            itemFornCotacaoLivroFiscal.setPercentualReducaoOutros(Double.valueOf(0.0));
        }
        if (modeloFiscal.getTipoContSoc() != null && ToolMethods.isEquals((Object)modeloFiscal.getTipoContSoc(), (Object)EnumConstTipoCalcContSocial.CALCULAR_NORMAL.getValue())) {
            itemFornCotacaoLivroFiscal.setAliquotaContribuicaoSocial(produto.getAliquotaContSoc());
            itemFornCotacaoLivroFiscal.setPercentualReducaoContribuicaoSocial(produto.getPercRedContSoc());
        } else {
            itemFornCotacaoLivroFiscal.setAliquotaContribuicaoSocial(Double.valueOf(0.0));
            itemFornCotacaoLivroFiscal.setPercentualReducaoContribuicaoSocial(Double.valueOf(0.0));
        }
        if (modeloFiscal.getIssRetido() != null && ToolMethods.isEquals((Object)modeloFiscal.getIssRetido(), (Object)EnumConstTipoIss.TIPO_ISS_NAO_CALCULAR.getValue())) {
            itemFornCotacaoLivroFiscal.setAliquotaIss(produto.getAliquotaIss());
        } else {
            itemFornCotacaoLivroFiscal.setAliquotaIss(Double.valueOf(0.0));
        }
        if (ToolMethods.isAffirmative((Number)modeloFiscal.getModeloFiscalPisCofins().getCalcularPisNormal())) {
            if (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                itemFornCotacaoLivroFiscal.setAliquotaPis(modeloFiscal.getModeloFiscalPisCofins().getAliquotaPis());
            } else {
                itemFornCotacaoLivroFiscal.setAliquotaPis(produto.getAliquotaPis());
            }
        } else {
            itemFornCotacaoLivroFiscal.setAliquotaPis(Double.valueOf(0.0));
        }
        if (ToolMethods.isAffirmative((Number)modeloFiscal.getModeloFiscalPisCofins().getCalcularPisSt())) {
            if (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                itemFornCotacaoLivroFiscal.setAliquotaPisSt(modeloFiscal.getModeloFiscalPisCofins().getAliquotaPisSt());
            } else {
                itemFornCotacaoLivroFiscal.setAliquotaPisSt(produto.getAliquotaPisSt());
            }
        } else {
            itemFornCotacaoLivroFiscal.setAliquotaPisSt(Double.valueOf(0.0));
        }
        if (ToolMethods.isAffirmative((Number)modeloFiscal.getModeloFiscalPisCofins().getCalcularCofinsNormal())) {
            if (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                itemFornCotacaoLivroFiscal.setAliquotaCofins(modeloFiscal.getModeloFiscalPisCofins().getAliquotaCofins());
            } else {
                itemFornCotacaoLivroFiscal.setAliquotaCofins(produto.getAliquotaCofins());
            }
        } else {
            itemFornCotacaoLivroFiscal.setAliquotaCofins(Double.valueOf(0.0));
        }
        if (ToolMethods.isAffirmative((Number)modeloFiscal.getModeloFiscalPisCofins().getCalcularCofinsSt())) {
            if (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                itemFornCotacaoLivroFiscal.setAliquotaCofinsSt(modeloFiscal.getModeloFiscalPisCofins().getAliquotaCofinsSt());
            } else {
                itemFornCotacaoLivroFiscal.setAliquotaCofinsSt(produto.getAliquotaCofins());
            }
        } else {
            itemFornCotacaoLivroFiscal.setAliquotaCofinsSt(Double.valueOf(0.0));
        }
        return itemFornCotacaoLivroFiscal;
    }
}

