/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.dashboardgerencial;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencialTipoData;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.model.impl.ControleGerLinha;
import com.touchcomp.basementor.model.impl.ControleGerLinhaVlr;
import com.touchcomp.basementor.model.impl.IndiceGerencialCalculado;
import com.touchcomp.basementor.model.impl.IndiceGerencialParams;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IndiceGerencial;
import com.touchcomp.basementor.model.vo.IntervaloControleGer;
import com.touchcomp.basementor.model.vo.IntervaloControleGerPer;
import com.touchcomp.basementor.model.vo.MetaControleGerencial;
import com.touchcomp.basementorexceptions.exceptions.impl.indicegerencial.ExceptionIndiceGerencial;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.jepparser.ExceptionJEPParser;
import com.touchcomp.basementorservice.service.impl.centrocusto.ServiceCentroCustoImpl;
import com.touchcomp.basementorservice.service.impl.indicegerencial.ServiceBuildIndiceGerencialImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.dashboardgerencial.DTODashboardGerencial;
import com.touchcomp.touchvomodel.vo.indicegerencial.DTOIndiceGerencialParamsVarCentroCusto;
import java.util.ArrayList;
import java.util.LinkedList;
import org.springframework.stereotype.Component;

@Component
public class HelperDashboardGerencial {
    public LinkedList<ControleGerLinha> calcularMensal(DTODashboardGerencial input, IntervaloControleGer intervaloControleGer, IndiceGerencial indiceGerencial, MetaControleGerencial metaControleGerencial, Empresa empresaInicial, Empresa empresaFinal) throws ExceptionJEPParser, ExceptionInvalidData, ExceptionIndiceGerencial {
        LinkedList<ControleGerLinha> processedData = new LinkedList<ControleGerLinha>();
        IndiceGerencialCalculado anterior = null;
        for (IntervaloControleGerPer intervaloControleGerPer : intervaloControleGer.getIntervalos()) {
            IndiceGerencialCalculado returned;
            anterior = returned = this.calcIndice(indiceGerencial, empresaInicial, empresaFinal, metaControleGerencial, intervaloControleGerPer, input);
            this.processData(returned, processedData, intervaloControleGerPer);
        }
        return processedData;
    }

    private IndiceGerencialCalculado calcIndice(IndiceGerencial indiceGerencial, Empresa empresaInicial, Empresa empresaFinal, MetaControleGerencial metaControleGerencial, IntervaloControleGerPer intervaloControleGerPer, DTODashboardGerencial input) throws ExceptionJEPParser, ExceptionInvalidData, ExceptionIndiceGerencial {
        EnumTipoLancamentoCTBGerencial tipoLancamento = EnumTipoLancamentoCTBGerencial.LIQUIDACAO;
        if (ToolMethods.isEquals((Object)input.getTipoLancamento(), (Object)EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue())) {
            tipoLancamento = EnumTipoLancamentoCTBGerencial.COMPETENCIA;
        }
        Short tipoData = EnumLancamentoCTBGerencialTipoData.TIPO_DATA_PREVISTA.getValue();
        if (ToolMethods.isEquals((Object)input.getTipoLancamento(), (Object)EnumLancamentoCTBGerencialTipoData.TIPO_DATA_CADASTRO_COMP.getValue())) {
            tipoData = EnumLancamentoCTBGerencialTipoData.TIPO_DATA_CADASTRO_COMP.getValue();
        }
        ArrayList<IndiceGerencialParams.VarAberta> variaveis = new ArrayList<IndiceGerencialParams.VarAberta>();
        if (ToolMethods.isNotNull((Object)input).booleanValue() && ToolMethods.isNotNull((Object)input.getVarAberta()).booleanValue()) {
            for (Object dto : input.getVarAberta()) {
                IndiceGerencialParams.VarAberta i = new IndiceGerencialParams.VarAberta();
                i.setValor(dto.getValor());
                i.setVariavel(dto.getVariavel());
                variaveis.add(i);
            }
        }
        ArrayList<IndiceGerencialParams.VarCentroCusto> centrosCusto = new ArrayList<IndiceGerencialParams.VarCentroCusto>();
        if (ToolMethods.isNotNull((Object)input).booleanValue() && ToolMethods.isNotNull((Object)input.getVarCentroCusto()).booleanValue()) {
            for (DTOIndiceGerencialParamsVarCentroCusto dto : input.getVarCentroCusto()) {
                IndiceGerencialParams.VarCentroCusto i = new IndiceGerencialParams.VarCentroCusto();
                i.setCentroCusto(((ServiceCentroCustoImpl)ConfApplicationContext.getBean(ServiceCentroCustoImpl.class)).findByCodigo(dto.getCentroCustoCodigo()));
                i.setVariavel(dto.getVariavel());
                centrosCusto.add(i);
            }
        }
        IndiceGerencialParams params = new IndiceGerencialParams(indiceGerencial, intervaloControleGerPer, empresaInicial.getIdentificador(), empresaFinal.getIdentificador(), Short.valueOf(EnumProvisionamentoLancamentoCTBGerencial.PROVISAO.getValue()), Short.valueOf(EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue()), tipoLancamento, tipoData, centrosCusto, variaveis);
        params.setValoresMeta(metaControleGerencial);
        params.setExibirLinhasZeradas(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        return ((ServiceBuildIndiceGerencialImpl)ConfApplicationContext.getBean(ServiceBuildIndiceGerencialImpl.class)).calcularIndiceGerencial(params);
    }

    private void processData(IndiceGerencialCalculado returned, LinkedList<ControleGerLinha> processedData, IntervaloControleGerPer per) {
        for (IndiceGerencialCalculado.LinhaIndice linha : returned.getLinhas()) {
            ControleGerLinha found = null;
            for (ControleGerLinha aux : processedData) {
                if (!aux.getLinhaReferencia().getLinhaIndiceGerencial().equals((Object)linha.getLinhaIndiceGerencial())) continue;
                found = aux;
                break;
            }
            if (found == null) {
                found = new ControleGerLinha();
                found.setLinhaReferencia(linha);
                processedData.add(found);
            }
            ControleGerLinhaVlr valores = new ControleGerLinhaVlr();
            valores.setValorRealizado(linha.getValor());
            valores.setValorMeta(linha.getValorMeta());
            valores.setValorProvisionado(linha.getValorProvisionado());
            valores.setValorProvReal(linha.getValorRealProvisionado());
            valores.setPercMetaReal(linha.getPercMetaRealizado());
            valores.setPercMetaRealProv(linha.getPercMetaRealizadoProv());
            valores.setDifMetaReal(linha.getDifMetaReal());
            valores.setDifMetaRealProv(linha.getDifMetaRealProv());
            valores.setIntervaloControleGer(per);
            found.getValoresLinhas().add(valores);
        }
    }
}

