/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.deparafornecedor;

import com.touchcomp.basementor.constants.ConstantsNotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.DeParaFornecedor;
import com.touchcomp.basementor.model.vo.DeParaFornecedorEmpresa;
import com.touchcomp.basementor.model.vo.DeParaFornecedorForn;
import com.touchcomp.basementor.model.vo.DeParaFornecedorItem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.service.impl.deparafornecedor.ServiceDeParaFornecedorImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceDeParaFornecedor;
import com.touchcomp.basementorservice.service.interfaces.ServiceProduto;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class HelperDeParaFornecedor
extends DaoGenericEntityImpl<DeParaFornecedor, Long>
implements AbstractHelper<DeParaFornecedor> {
    private DeParaFornecedor deParaFornecedor;
    private static final Namespace n = ConstantsNotaFiscalTerceiros.NAMESPACE_XML_NFE_X1;

    public HelperDeParaFornecedor(DeParaFornecedor deParaFornecedor) {
        this.deParaFornecedor = deParaFornecedor;
    }

    public DeParaFornecedor get() {
        return this.deParaFornecedor;
    }

    public static DeParaFornecedor findDeParaFornecedor(UnidadeFatFornecedor unidadeFatFornecedor, NaturezaOperacao natOperacaoSaida, Empresa empresa) {
        DeParaFornecedor dePara = HelperDeParaFornecedor.findDeParaFornEmpresaNatOp(unidadeFatFornecedor, natOperacaoSaida, empresa);
        if (dePara != null) {
            return dePara;
        }
        dePara = HelperDeParaFornecedor.findDeParaFornEmpresa(unidadeFatFornecedor, empresa);
        if (dePara != null) {
            return dePara;
        }
        dePara = HelperDeParaFornecedor.findDeParaForn(unidadeFatFornecedor);
        if (dePara != null) {
            return dePara;
        }
        return HelperDeParaFornecedor.criarDeParaPadrao(unidadeFatFornecedor, natOperacaoSaida, empresa);
    }

    private static DeParaFornecedor findDeParaFornEmpresaNatOp(UnidadeFatFornecedor unidadeFatFornecedor, NaturezaOperacao natOperacaoSaida, Empresa empresaDestino) {
        if (unidadeFatFornecedor != null && natOperacaoSaida != null && empresaDestino != null) {
            ServiceDeParaFornecedorImpl service = (ServiceDeParaFornecedorImpl)ConfApplicationContext.getBean(ServiceDeParaFornecedorImpl.class);
            return service.findDeParaFornEmpresaNatSaida(unidadeFatFornecedor, empresaDestino, natOperacaoSaida);
        }
        return null;
    }

    private static DeParaFornecedor findDeParaFornEmpresa(UnidadeFatFornecedor unidadeFatFornecedor, Empresa empresaDestino) {
        if (unidadeFatFornecedor != null && empresaDestino != null) {
            ServiceDeParaFornecedorImpl service = (ServiceDeParaFornecedorImpl)ConfApplicationContext.getBean(ServiceDeParaFornecedorImpl.class);
            return service.findDeParaFornEmpresa(unidadeFatFornecedor, empresaDestino);
        }
        return null;
    }

    private static DeParaFornecedor findDeParaForn(UnidadeFatFornecedor unidadeFatFornecedor) {
        if (unidadeFatFornecedor != null) {
            ServiceDeParaFornecedorImpl service = (ServiceDeParaFornecedorImpl)ConfApplicationContext.getBean(ServiceDeParaFornecedorImpl.class);
            return service.findDeParaFornecedor(unidadeFatFornecedor);
        }
        return null;
    }

    private static DeParaFornecedor criarDeParaPadrao(UnidadeFatFornecedor unidadeFatFornecedor, NaturezaOperacao natOperacaoSaida, Empresa empresa) {
        DeParaFornecedor d = new DeParaFornecedor();
        d.setFornecedor(unidadeFatFornecedor.getFornecedor());
        d.setDataCadastro(new Date());
        d.setNaturezaOperacaoSaida(natOperacaoSaida);
        DeParaFornecedorForn df = new DeParaFornecedorForn();
        df.setFornecedor(unidadeFatFornecedor.getFornecedor());
        df.setDeParaFornecedor(d);
        d.getFornecedores().add(df);
        if (empresa != null) {
            DeParaFornecedorEmpresa de = new DeParaFornecedorEmpresa();
            de.setEmpresa(empresa);
            de.setDeParaFornecedor(d);
            d.getEmpresas().add(de);
        }
        ServiceDeParaFornecedorImpl service = (ServiceDeParaFornecedorImpl)ConfApplicationContext.getBean(ServiceDeParaFornecedorImpl.class);
        d = service.saveOrUpdate(d);
        return d;
    }

    public static List<DeParaFornecedorItem> findDeParaFornecedorItemPorXML(UnidadeFatFornecedor unidadeFatFornecedor, NaturezaOperacao natOperacaoSaida, Empresa empresa, List<Element> lista, Short formatarCodigoBarras, Short sincronizarCodigoProduto, OpcoesFaturamento op) {
        DeParaFornecedor dePara = HelperDeParaFornecedor.findDeParaFornecedor(unidadeFatFornecedor, natOperacaoSaida, empresa);
        ArrayList<DeParaFornecedorItem> listaDePara = new ArrayList<DeParaFornecedorItem>();
        Iterator<Element> iterator = lista.iterator();
        while (iterator.hasNext()) {
            Element obj;
            Element det = obj = iterator.next();
            DeParaFornecedorItem deParaItem = null;
            String codigo = det.getChild("prod", n).getChild("cProd", n).getText();
            String codigoBarras = det.getChild("prod", n).getChild("cEAN", n).getText();
            String descricao = det.getChild("prod", n).getChild("xProd", n).getText();
            if (formatarCodigoBarras != null && formatarCodigoBarras == 1) {
                codigoBarras = ToolString.removerZerosAEsquerda((String)codigoBarras);
            }
            if ((deParaItem = HelperDeParaFornecedor.findDeParaItem(dePara, codigo)) == null) {
                deParaItem = HelperDeParaFornecedor.gerarDeParaPorCodigoBarras(codigoBarras, codigo, dePara);
            }
            Produto p = null;
            if (deParaItem == null && ToolMethods.isEquals((Object)dePara.getUtilizaProdutoDiferente(), (Object)1) || ToolMethods.isEquals((Object)sincronizarCodigoProduto, (Object)1)) {
                p = HelperDeParaFornecedor.findProduto(codigo, op);
            }
            if (deParaItem == null && p != null && ToolMethods.isEquals((Object)dePara.getUtilizaProdutoDiferente(), (Object)1)) {
                deParaItem = HelperDeParaFornecedor.findDeParaItemProdutoSaida(dePara, p);
            }
            if (deParaItem == null && p != null && ToolMethods.isEquals((Object)sincronizarCodigoProduto, (Object)1)) {
                deParaItem = new DeParaFornecedorItem();
                deParaItem.setDeParaFornecedor(dePara);
                deParaItem.setCodigo(codigo);
                deParaItem.setDescricaoXML(descricao);
                deParaItem.setElement(det);
                deParaItem.setProdutoEntrada(p);
            }
            if (deParaItem == null) {
                deParaItem = new DeParaFornecedorItem();
                deParaItem.setDeParaFornecedor(dePara);
                deParaItem.setCodigo(codigo);
                deParaItem.setDescricaoXML(descricao);
                deParaItem.setElement(det);
            }
            deParaItem.setDescricaoXML(descricao);
            deParaItem.setCodigo(codigo);
            deParaItem.setElement(det);
            if (deParaItem.getNaturezaOperacao() != null && deParaItem.getNaturezaOperacao().getAtivo() != 1) {
                deParaItem.setNaturezaOperacao(null);
                deParaItem.setModeloFiscal(null);
            }
            if (deParaItem.getModeloFiscal() != null && deParaItem.getModeloFiscal().getAtivo() != 1) {
                deParaItem.setModeloFiscal(null);
            }
            listaDePara.add(deParaItem);
        }
        return listaDePara;
    }

    private static DeParaFornecedorItem findDeParaItem(DeParaFornecedor dePara, String codigo) {
        ServiceDeParaFornecedor serviceDeParaFornecedor = (ServiceDeParaFornecedor)ConfApplicationContext.getBean(ServiceDeParaFornecedor.class);
        return serviceDeParaFornecedor.findDeParaFornecedorItemPorCodigo(dePara, codigo);
    }

    private static DeParaFornecedorItem gerarDeParaPorCodigoBarras(String codigoBarras, String codigo, DeParaFornecedor deParaForn) {
        ServiceProduto service;
        Produto p;
        DeParaFornecedorItem deParaItem = null;
        if (codigoBarras != null && !codigoBarras.isEmpty() && !codigoBarras.equalsIgnoreCase("SEM GTIN") && (p = (service = (ServiceProduto)ConfApplicationContext.getBean(ServiceProduto.class)).getByCodigoBarras(codigoBarras)) != null) {
            deParaItem = new DeParaFornecedorItem();
            deParaItem.setCodigo(codigo);
            deParaItem.setDeParaFornecedor(deParaForn);
            deParaItem.setProdutoEntrada(p);
        }
        return deParaItem;
    }

    private static DeParaFornecedorItem findDeParaItemProdutoSaida(DeParaFornecedor dePara, Produto p) {
        ServiceDeParaFornecedor serviceDeParaFornecedor = (ServiceDeParaFornecedor)ConfApplicationContext.getBean(ServiceDeParaFornecedor.class);
        return serviceDeParaFornecedor.findDeParaFornecedorItemPorProdutoSaida(dePara, p);
    }

    private static Produto findProduto(String codigo, OpcoesFaturamento op) {
        Produto p = null;
        ServiceProduto service = (ServiceProduto)ConfApplicationContext.getBean(ServiceProduto.class);
        if (ToolMethods.isEquals((Object)op.getUsarCodigoAuxProduto(), (Object)1) && (p = service.getByCodigoAuxiliar(codigo)) != null) {
            return p;
        }
        if (ToolMethods.isEquals((Object)op.getUsarIdProduto(), (Object)1)) {
            try {
                Long idProduto = Long.valueOf(codigo);
                p = service.getByIdentificadorCastLong(idProduto);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return p;
    }

    public HelperDeParaFornecedor build(DeParaFornecedor deParaFornecedor) {
        this.deParaFornecedor = deParaFornecedor;
        return this;
    }
}

