/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.embalagensproduzidos;

import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeTipoEntSai;
import com.touchcomp.basementor.model.vo.CodigoBarrasEmbProducao;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemEmbalagemProducao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.constants.EnumConstantsSimNao;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.List;

public class HelperEmbalagensProduzidos {
    public static ItemEmbalagemProducao showItemEmbalagemProducaoCodigoProduto(Produto produto) {
        List<GradeCor> grades = ((ServiceGradeCorImpl)ConfApplicationContext.getBean(ServiceGradeCorImpl.class)).get(produto);
        if (grades != null && !grades.isEmpty()) {
            return HelperEmbalagensProduzidos.convertGrades(grades);
        }
        return null;
    }

    private static ItemEmbalagemProducao convertGrades(List<GradeCor> gradesCores) {
        Date dataDia = new Date();
        for (GradeCor o : gradesCores) {
            boolean b;
            GradeCor g = o;
            if (g.getGradePrincipal() != null && g.getGradePrincipal().shortValue() == EnumConstantsSimNao.SIM.getValue() || (b = false)) continue;
            ItemEmbalagemProducao vo = new ItemEmbalagemProducao();
            vo.setGradeCor(g);
            vo.setQuantidade(Double.valueOf(0.0));
            vo.setDataLancamento(new Date());
            return vo;
        }
        return null;
    }

    public static ItemEmbalagemProducao showItemEmbalagemProducaoCodigoBarra(CodigoBarrasEmbProducao codigoBarrasEmbProducao, String codBarras) {
        if (codBarras != null && codBarras.trim().length() > 0) {
            ItemEmbalagemProducao item = HelperEmbalagensProduzidos.findItemComunicadoProducao(codigoBarrasEmbProducao, codBarras);
            return item;
        }
        return null;
    }

    public static ItemEmbalagemProducao findItemComunicadoProducao(CodigoBarrasEmbProducao codigoBarrasEmbProducao, String codBarras) {
        ItemEmbalagemProducao vo = new ItemEmbalagemProducao();
        vo.setDataLancamento(new Date());
        GradeCor gc = null;
        if (codigoBarrasEmbProducao != null) {
            gc = codigoBarrasEmbProducao.getGradeCor();
        } else {
            gc = ((ServiceGradeCorImpl)ConfApplicationContext.getBean(ServiceGradeCorImpl.class)).getByCodigoBarras(codBarras);
            if (ToolMethods.isEquals((Object)gc, null)) {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0429.005"));
            }
        }
        if (ToolMethods.isEquals((Object)gc.getProdutoGrade().getProduto().getAtivo(), (Object)0)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0429.003", new Object[]{gc.getProdutoGrade().getProduto()}));
        }
        if (ToolMethods.isEquals((Object)gc.getProdutoGrade().getProduto().getEntradaSaida(), (Object)Integer.valueOf(ConstNFeTipoEntSai.SAIDA.getCodigo()))) {
            vo.setGradeCor(gc);
            vo.setQuantidade(Double.valueOf(0.0));
            return vo;
        }
        throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0429.004", new Object[]{gc.getProdutoGrade().getProduto()}));
    }
}

