/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.empresa;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaDados;
import com.touchcomp.basementor.model.vo.Proxy;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementortools.tools.downloadweb.ToolDownloadWeb;
import com.touchcomp.basementortools.tools.methods.TMethods;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperEmpresa
implements AbstractHelper<Empresa> {
    private Empresa empresa;
    @Autowired
    private ServiceEmpresaImpl serviceEmpresa;

    public Empresa get() {
        return this.empresa;
    }

    public HelperEmpresa build(Empresa object) {
        this.empresa = object;
        return this;
    }

    public ToolDownloadWeb.InternalProxy getProxy() {
        if (this.empresa == null) {
            return null;
        }
        if (this.empresa.getEmpresaDados().getProxyHTTP() == null) {
            return null;
        }
        Proxy proxy = this.empresa.getEmpresaDados().getProxyHTTP();
        if (!TMethods.isEquals((Object)2, (Object)proxy.getTipoProxy())) {
            return null;
        }
        if (TMethods.isAffirmative((Number)proxy.getRequerAutenticacao())) {
            return new ToolDownloadWeb.InternalProxy(proxy.getHost(), proxy.getPort().intValue(), proxy.getUsuario(), proxy.getSenha());
        }
        return new ToolDownloadWeb.InternalProxy(proxy.getHost(), proxy.getPort().intValue());
    }

    public Empresa verificarEmpresaMatriz(Empresa emp) {
        if (TMethods.isAffirmative((Number)emp.getEmpresaDados().getMatriz())) {
            return emp;
        }
        for (EmpresaDados empDados : emp.getEmpresaDados().getGrupoEmpresa().getEmpresas()) {
            if (!TMethods.isAffirmative((Number)empDados.getMatriz())) continue;
            return this.serviceEmpresa.findEmpresaPorEmpresaDados(empDados);
        }
        return emp;
    }
}

