/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.endereco;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementorexceptions.exceptions.impl.google.EnumExcepGoogle;
import com.touchcomp.basementorexceptions.exceptions.impl.google.ExceptionGoogle;
import com.touchcomp.basementorservice.components.proxy.CompProxy;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.model.net.ProxyNet;
import com.touchcomp.basementortools.tools.googlelocations.ToolGoogleLocations;
import com.touchcomp.basementortools.tools.googlelocations.model.GoogleAddress;
import com.touchcomp.basementortools.tools.googlelocations.model.GoogleGeographicPosition;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import org.springframework.stereotype.Component;

@Component
public class HelperEndereco
implements AbstractHelper<Endereco> {
    private Endereco endereco;

    public Endereco get() {
        return this.endereco;
    }

    public HelperEndereco build(Endereco object) {
        this.endereco = object;
        return this;
    }

    public double getDistancia(Empresa emp, Endereco endDest) throws ExceptionGoogle {
        return this.getDistancia(emp, this.endereco, endDest);
    }

    public double getDistancia(Empresa emp, Endereco endOrig, Endereco endDest) throws ExceptionGoogle {
        if (!ToolMethods.isStrWithData((String)emp.getEmpresaDados().getKeyAPIGoogle())) {
            throw new ExceptionGoogle(EnumExcepGoogle.API_EXCEPTION, new Object[0]);
        }
        if (endOrig == null || endDest == null) {
            return 0.0;
        }
        double d = ToolGoogleLocations.getDistance((String)emp.getEmpresaDados().getKeyAPIGoogle(), (GoogleAddress)new GoogleAddress(endOrig.getLogradouro(), endOrig.getNumero(), endOrig.getBairro(), endOrig.getCidade().getDescricao(), endOrig.getCidade().getUf().getSigla()), (GoogleAddress)new GoogleAddress(endDest.getLogradouro(), endDest.getNumero(), endDest.getBairro(), endDest.getCidade().getDescricao(), endDest.getCidade().getUf().getSigla()), (ProxyNet)CompProxy.convert(emp.getEmpresaDados().getProxyHTTP()));
        return d;
    }

    public GoogleGeographicPosition getPontosGeograficos(Empresa emp) throws ExceptionGoogle {
        return this.getPontosGeograficos(emp, this.endereco);
    }

    public GoogleGeographicPosition getPontosGeograficos(Empresa emp, Endereco end) throws ExceptionGoogle {
        if (!ToolMethods.isStrWithData((String)emp.getEmpresaDados().getKeyAPIGoogle())) {
            throw new ExceptionGoogle(EnumExcepGoogle.API_EXCEPTION, new Object[0]);
        }
        if (end == null) {
            return null;
        }
        GoogleGeographicPosition pos = ToolGoogleLocations.getGeographicPosition((String)emp.getEmpresaDados().getKeyAPIGoogle(), (GoogleAddress)new GoogleAddress(end.getLogradouro(), end.getNumero(), end.getBairro(), end.getCidade().getDescricao(), end.getCidade().getUf().getSigla()), (ProxyNet)CompProxy.convert(emp.getEmpresaDados().getProxyHTTP()));
        return pos;
    }

    public String getCepPrincipal(String cep) {
        if (cep == null) {
            return null;
        }
        if (!(cep = ToolString.completaZerosDireita((String)cep, (int)8)).endsWith("000")) {
            cep = cep.substring(0, 5);
        }
        cep = ToolString.completaZerosDireita((String)cep, (int)8);
        return cep;
    }
}

