/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.esocpreevento;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.EnumEsocialFormaGerEvento;
import com.touchcomp.basementor.constants.enums.EnumEsocialTipoEvento;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstESocialStatus;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstRegistroESocial;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstTipoEventoESocial;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstTipoValorInssESocial;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstTipoValorIrrfESocial;
import com.touchcomp.basementor.constants.enums.esocial.centraleventos.EnumConstTipoBuscaInss;
import com.touchcomp.basementor.constants.enums.rh.EnumIndicativoApuracao;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ESocS1020;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocBasesAquiProdRural;
import com.touchcomp.basementor.model.vo.EsocBasesRemun5011;
import com.touchcomp.basementor.model.vo.EsocCadastroEstabelcimento;
import com.touchcomp.basementor.model.vo.EsocCadastroLotacaoTributaria;
import com.touchcomp.basementor.model.vo.EsocComunicadoAcidTrab;
import com.touchcomp.basementor.model.vo.EsocCondicoesAmbientaisTrabalho;
import com.touchcomp.basementor.model.vo.EsocEstabelecimentos5011;
import com.touchcomp.basementor.model.vo.EsocExameToxicologico;
import com.touchcomp.basementor.model.vo.EsocFechamentoEventosPeriodicos;
import com.touchcomp.basementor.model.vo.EsocFechamentoFolha;
import com.touchcomp.basementor.model.vo.EsocInfoTributosDecorrentesProcessoTrab;
import com.touchcomp.basementor.model.vo.EsocItemS1010;
import com.touchcomp.basementor.model.vo.EsocItemValoresInss;
import com.touchcomp.basementor.model.vo.EsocItemValoresIrrf;
import com.touchcomp.basementor.model.vo.EsocLotacaoTributaria5011;
import com.touchcomp.basementor.model.vo.EsocMonitoramentoSaude;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.EsocProcessoTrabalhista;
import com.touchcomp.basementor.model.vo.EsocReaberturaEventos;
import com.touchcomp.basementor.model.vo.EsocS1010;
import com.touchcomp.basementor.model.vo.EsocValores5011;
import com.touchcomp.basementor.model.vo.EsocValoresContSociaisDevidas;
import com.touchcomp.basementor.model.vo.EsocValoresInssColaborador;
import com.touchcomp.basementor.model.vo.EsocValoresIrrfColaborador;
import com.touchcomp.basementor.model.vo.EsocValoresOutrasEntidades;
import com.touchcomp.basementor.model.vo.ExclusaoEventosEsocial;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.PagamentoFolhaCompColaborador;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementor.model.vo.TabelaProcessosEsoc;
import com.touchcomp.basementor.model.vo.TerminoTrabalhadorSemVinculo;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementor.model.vo.TipoEventoEsocial;
import com.touchcomp.basementor.model.vo.TransferenciaColaborador;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.EnumEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.helpers.impl.empresa.HelperEmpresa;
import com.touchcomp.basementorservice.service.impl.tipoeventoesocial.ServiceTipoEventoEsocialImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.esocpreevento.web.DTOEsocPreEventoEnviado;
import com.touchcomp.touchvomodel.vo.esocpreevento.web.DTOEsocPreEventoNaoEnviado;
import com.touchcomp.touchvomodel.vo.esocvalores5011.DTOTotalizadorInss;
import com.touchcomp.touchvomodel.vo.esocvaloresinsscolaborador.DTOValoresInss;
import com.touchcomp.touchvomodel.vo.esocvaloresirrfcolaborador.DTOValoresIrrf;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperEsocPreEvento {
    @Autowired
    ServiceTipoEventoEsocialImpl serviceTipoEventoEsocial;
    @Autowired
    HelperEmpresa helperEmpresa;

    public EsocPreEvento getEvento(EsocProcessoTrabalhista processo, Usuario usuario, Empresa empresa, EnumConstEventoProducao prodEvento, Short eventoRetificacao) throws ExceptionEsocial {
        EsocPreEvento evento = this.getEvento(prodEvento, usuario, empresa, eventoRetificacao);
        evento.setDescricaoEntidade(MessagesBaseMentor.getMsg((String)"processo", (Object[])new Object[0]));
        evento.setIdentificacaoEntidade(String.valueOf(processo.getIdentificador()));
        evento.setClasseEntidade(processo.getClass().getCanonicalName());
        evento.setTipoEventoEsocial((TipoEventoEsocial)this.serviceTipoEventoEsocial.get(Long.valueOf(EnumConstTipoEventoESocial.PROCESSO_TRABALHISTA.getValue())));
        this.setOrigem(evento, (InterfaceVOEsocial)processo);
        return evento;
    }

    public EsocPreEvento getEvento(TransferenciaColaborador vo, Usuario usuario, Empresa empresa, EnumConstEventoProducao prodEvento, Short eventoRetificacao, EnumConstTipoEventoESocial tipoEventoESocial, EnumConstRegistroESocial registroEsocial) throws ExceptionEsocial {
        EsocPreEvento evento = this.getEvento(prodEvento, usuario, empresa, eventoRetificacao);
        evento.setDescricaoEntidade(MessagesBaseMentor.getMsg((String)"TransferenciaColaborador", (Object[])new Object[0]));
        evento.setIdentificacaoEntidade(String.valueOf(vo.getIdentificador()));
        evento.setClasseEntidade(vo.getClass().getCanonicalName());
        evento.setTipoEventoEsocial((TipoEventoEsocial)this.serviceTipoEventoEsocial.get(Long.valueOf(tipoEventoESocial.getValue())));
        if (TMethods.isAffirmative((Number)evento.getEventoRetificacao())) {
            evento.setNumeroReciboRetificado(this.getReciboRetificacao(vo.getPreEventosEsocial(), registroEsocial, prodEvento.getValue()));
        }
        this.setOrigem(evento, (InterfaceVOEsocial)vo);
        return evento;
    }

    public EsocPreEvento getEvento(EsocExameToxicologico vo, Usuario usuario, Empresa empresa, EnumConstEventoProducao prodEvento, Short eventoRetificacao) throws ExceptionEsocial {
        EsocPreEvento evento = this.getEvento(prodEvento, usuario, empresa, eventoRetificacao);
        evento.setDescricaoEntidade(MessagesBaseMentor.getMsg((String)"Exame Toxicologico", (Object[])new Object[0]));
        evento.setIdentificacaoEntidade(String.valueOf(vo.getIdentificador()));
        evento.setClasseEntidade(vo.getClass().getCanonicalName());
        evento.setTipoEventoEsocial((TipoEventoEsocial)this.serviceTipoEventoEsocial.get(Long.valueOf(EnumConstTipoEventoESocial.EXAME_TOXICOLOGICO.getValue())));
        this.setOrigem(evento, (InterfaceVOEsocial)vo);
        return evento;
    }

    public EsocPreEvento getEvento(ExclusaoEventosEsocial vo, Usuario usuario, Empresa empresa, EnumConstEventoProducao prodEvento, Short eventoRetificacao) throws ExceptionEsocial {
        EsocPreEvento evento = this.getEvento(prodEvento, usuario, empresa, eventoRetificacao);
        evento.setDescricaoEntidade(MessagesBaseMentor.getMsg((String)"Exclusao Eventos", (Object[])new Object[0]));
        evento.setIdentificacaoEntidade(String.valueOf(vo.getIdentificador()));
        evento.setClasseEntidade(vo.getClass().getCanonicalName());
        evento.setTipoEventoEsocial((TipoEventoEsocial)this.serviceTipoEventoEsocial.get(Long.valueOf(EnumConstTipoEventoESocial.EXCLUSAO_EVENTOS.getValue())));
        this.setOrigem(evento, (InterfaceVOEsocial)vo);
        return evento;
    }

    public EsocPreEvento getEvento(EsocCadastroEstabelcimento vo, Usuario usuario, Empresa empresa, EnumConstEventoProducao prodEvento, Short eventoRetificacao) throws ExceptionEsocial {
        EsocPreEvento evento = this.getEvento(prodEvento, usuario, empresa, eventoRetificacao);
        evento.setDescricaoEntidade(MessagesBaseMentor.getMsg((String)"cadastroEstabelecimento", (Object[])new Object[0]));
        evento.setIdentificacaoEntidade(String.valueOf(vo.getIdentificador()));
        evento.setClasseEntidade(vo.getClass().getCanonicalName());
        evento.setTipoEventoEsocial((TipoEventoEsocial)this.serviceTipoEventoEsocial.get(Long.valueOf(EnumConstTipoEventoESocial.TABELA_ESTABELECIMENTOS_OBRAS_UNIDADES.getValue())));
        this.setOrigem(evento, (InterfaceVOEsocial)vo);
        return evento;
    }

    public EsocPreEvento getEvento(EsocFechamentoEventosPeriodicos vo, Usuario usuario, Empresa empresa, EnumConstEventoProducao prodEvento, Short eventoRetificacao) throws ExceptionEsocial {
        EsocPreEvento evento = this.getEvento(prodEvento, usuario, empresa, eventoRetificacao);
        evento.setDescricaoEntidade(MessagesBaseMentor.getMsg((String)"Fechamento Eventos Periodicos", (Object[])new Object[0]));
        evento.setIdentificacaoEntidade(String.valueOf(vo.getIdentificador()));
        evento.setClasseEntidade(vo.getClass().getCanonicalName());
        evento.setTipoEventoEsocial((TipoEventoEsocial)this.serviceTipoEventoEsocial.get(Long.valueOf(EnumConstTipoEventoESocial.FECHAMENTO_EVENTOS_PERIODICOS.getValue())));
        this.setOrigem(evento, (InterfaceVOEsocial)vo);
        return evento;
    }

    public EsocPreEvento getEvento(EsocInfoTributosDecorrentesProcessoTrab vo, Usuario usuario, Empresa empresa, EnumConstEventoProducao prodEvento, Short eventoRetificacao) throws ExceptionEsocial {
        EsocPreEvento evento = this.getEvento(prodEvento, usuario, empresa, eventoRetificacao);
        evento.setDescricaoEntidade(MessagesBaseMentor.getMsg((String)"Informacoes Tributos Decorrentes Processo Trabalhista", (Object[])new Object[0]));
        evento.setIdentificacaoEntidade(String.valueOf(vo.getIdentificador()));
        evento.setClasseEntidade(vo.getClass().getCanonicalName());
        evento.setTipoEventoEsocial((TipoEventoEsocial)this.serviceTipoEventoEsocial.get(Long.valueOf(EnumConstTipoEventoESocial.INFO_TRIBUTOS_DECORRENTES_PROCESSO_TRAB.getValue())));
        this.setOrigem(evento, (InterfaceVOEsocial)vo);
        return evento;
    }

    private EsocPreEvento getEvento(EnumConstEventoProducao prodEvento, Usuario usuario, Empresa empresa, Short eventoRetificacao) {
        EsocPreEvento pre = new EsocPreEvento();
        pre.setDataCadastro(new Date());
        pre.setDataFimVal(null);
        pre.setDataInicioVal(pre.getDataCadastro());
        pre.setEventoProdRestritaProducao(Short.valueOf(prodEvento.getValue()));
        pre.setDesativarEnvio(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        pre.setEmpresa(this.helperEmpresa.verificarEmpresaMatriz(empresa));
        pre.setFormaGeracao(Short.valueOf(EnumEsocialFormaGerEvento.TIPO_EVENTO_AUTOMATICO.value));
        pre.setUsuario(usuario);
        pre.setEventoRetificacao(eventoRetificacao);
        return pre;
    }

    public EsocPreEvento getEvento(EsocComunicadoAcidTrab vo, Usuario usuario, Empresa empresa, EnumConstEventoProducao prodEvento, Short eventoRetificacao) throws ExceptionEsocial {
        EsocPreEvento pre = this.getEvento(prodEvento, usuario, empresa, eventoRetificacao);
        pre.setDescricaoEntidade("Cat");
        pre.setIdentificacaoEntidade(String.valueOf(vo.getIdentificador()));
        pre.setClasseEntidade(vo.getClass().getCanonicalName());
        pre.setTipoEventoEsocial((TipoEventoEsocial)this.serviceTipoEventoEsocial.get(Long.valueOf(EnumConstTipoEventoESocial.COMUNICACAO_ACIDENTE_TRABALHO.getValue())));
        pre.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.getValue()));
        if (TMethods.isAffirmative((Number)pre.getEventoRetificacao())) {
            pre.setNumeroReciboRetificado(this.getReciboRetificacao(vo.getPreEventosEsocial(), EnumConstRegistroESocial.REGISTRO_2250, prodEvento.getValue()));
        }
        this.setOrigem(pre, (InterfaceVOEsocial)vo);
        return pre;
    }

    public EsocPreEvento getEvento(EsocCondicoesAmbientaisTrabalho vo, Usuario usuario, Empresa empresa, EnumConstEventoProducao prodEvento, Short eventoRetificacao) throws ExceptionEsocial {
        EsocPreEvento pre = this.getEvento(prodEvento, usuario, empresa, eventoRetificacao);
        pre.setDescricaoEntidade(MessagesBaseMentor.getMsg((String)"condicoesAmbientaisTrabalho", (Object[])new Object[0]));
        pre.setIdentificacaoEntidade(String.valueOf(vo.getIdentificador()));
        pre.setClasseEntidade(vo.getClass().getCanonicalName());
        pre.setTipoEventoEsocial((TipoEventoEsocial)this.serviceTipoEventoEsocial.get(Long.valueOf(EnumConstTipoEventoESocial.CONDICOES_AMBIENTAIS_TRABALHO.getValue())));
        pre.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.getValue()));
        this.setOrigem(pre, (InterfaceVOEsocial)vo);
        return pre;
    }

    public EsocPreEvento getEvento(TabelaProcessosEsoc vo, Usuario usuario, Empresa empresa, EnumConstEventoProducao prodEvento, Short eventoRetificacao) throws ExceptionEsocial {
        EsocPreEvento pre = this.getEvento(prodEvento, usuario, empresa, eventoRetificacao);
        pre.setDescricaoEntidade(MessagesBaseMentor.getMsg((String)"tabelaProcessosAdministrativosJudiciais", (Object[])new Object[0]));
        pre.setIdentificacaoEntidade(String.valueOf(vo.getIdentificador()));
        pre.setClasseEntidade(vo.getClass().getCanonicalName());
        pre.setTipoEventoEsocial((TipoEventoEsocial)this.serviceTipoEventoEsocial.get(Long.valueOf(EnumConstTipoEventoESocial.TABELA_PROCESSOS_ADM_JUDICIAIS.getValue())));
        pre.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.getValue()));
        pre.setDataInicioVal(vo.getDataInicio());
        pre.setDataCadastro(vo.getDataInicio());
        this.setOrigem(pre, (InterfaceVOEsocial)vo);
        return pre;
    }

    public EsocPreEvento getEvento(EsocReaberturaEventos vo, Usuario usuario, Empresa empresa, EnumConstEventoProducao prodEvento, Short eventoRetificacao) throws ExceptionEsocial {
        EsocPreEvento pre = this.getEvento(prodEvento, usuario, empresa, eventoRetificacao);
        pre.setDescricaoEntidade(MessagesBaseMentor.getMsg((String)"tabelaProcessosAdministrativosJudiciais", (Object[])new Object[0]));
        pre.setIdentificacaoEntidade(String.valueOf(vo.getIdentificador()));
        pre.setClasseEntidade(vo.getClass().getCanonicalName());
        pre.setTipoEventoEsocial((TipoEventoEsocial)this.serviceTipoEventoEsocial.get(Long.valueOf(EnumConstTipoEventoESocial.REABERTURA_EVENTOS_PERIODICOS.getValue())));
        pre.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.getValue()));
        pre.setDataCadastro(new Date());
        pre.setDataFimVal(null);
        pre.setDataInicioVal(pre.getDataCadastro());
        this.setOrigem(pre, (InterfaceVOEsocial)vo);
        return pre;
    }

    public EsocPreEvento getEvento(EsocMonitoramentoSaude vo, Usuario usuario, Empresa empresa, EnumConstEventoProducao prodEvento, Short eventoRetificacao) throws ExceptionEsocial {
        EsocPreEvento pre = this.getEvento(prodEvento, usuario, empresa, eventoRetificacao);
        pre.setDescricaoEntidade(MessagesBaseMentor.getMsg((String)"EsocMonitoramentoSaude", (Object[])new Object[0]));
        pre.setIdentificacaoEntidade(String.valueOf(vo.getIdentificador()));
        pre.setClasseEntidade(vo.getClass().getCanonicalName());
        pre.setTipoEventoEsocial((TipoEventoEsocial)this.serviceTipoEventoEsocial.get(Long.valueOf(EnumConstTipoEventoESocial.MONITORAMENTO_SAUDE_TRABALHADOR.getValue())));
        pre.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.getValue()));
        if (TMethods.isAffirmative((Number)pre.getEventoRetificacao())) {
            pre.setNumeroReciboRetificado(this.getReciboRetificacao(vo.getPreEventosEsocial(), EnumConstRegistroESocial.REGISTRO_2220, prodEvento.getValue()));
        }
        this.setOrigem(pre, (InterfaceVOEsocial)vo);
        return pre;
    }

    public EsocPreEvento getEvento(EsocS1010 vo, Usuario usuario, Empresa empresa, EnumConstEventoProducao prodEvento, Short eventoRetificacao) throws ExceptionEsocial {
        EsocPreEvento pre = this.getEvento(prodEvento, usuario, empresa, eventoRetificacao);
        pre.setDescricaoEntidade(MessagesBaseMentor.getMsg((String)"esocS1200", (Object[])new Object[0]));
        pre.setIdentificacaoEntidade(String.valueOf(vo.getIdentificador()));
        pre.setClasseEntidade(vo.getClass().getCanonicalName());
        pre.setTipoEventoEsocial((TipoEventoEsocial)this.serviceTipoEventoEsocial.get(Long.valueOf(EnumConstTipoEventoESocial.REMUNERACAO_TRABALHADOR_VINC_REGIME_GERAL_PREV_SOCIAL.getValue())));
        if (TMethods.isAffirmative((Number)pre.getEventoRetificacao())) {
            pre.setNumeroReciboRetificado(this.getReciboRetificacao(vo.getPreEventosEsocial(), EnumConstRegistroESocial.REGISTRO_1200, prodEvento.getValue()));
        }
        this.setOrigem(pre, (InterfaceVOEsocial)vo);
        return pre;
    }

    public EsocPreEvento getEvento(ESocS1020 vo, Usuario usuario, Empresa empresa, EnumConstEventoProducao prodEvento, Short eventoRetificacao) throws ExceptionEsocial {
        EsocPreEvento pre = this.getEvento(prodEvento, usuario, empresa, eventoRetificacao);
        pre.setDescricaoEntidade(MessagesBaseMentor.getMsg((String)"esocS1210", (Object[])new Object[0]));
        pre.setIdentificacaoEntidade(String.valueOf(vo.getIdentificador()));
        pre.setClasseEntidade(vo.getClass().getCanonicalName());
        pre.setTipoEventoEsocial((TipoEventoEsocial)this.serviceTipoEventoEsocial.get(Long.valueOf(EnumConstTipoEventoESocial.PAGAMENTO_RENDIMENTOS_TRABALHO.getValue())));
        if (TMethods.isAffirmative((Number)pre.getEventoRetificacao())) {
            pre.setNumeroReciboRetificado(this.getReciboRetificacao(vo.getPreEventosEsocial(), EnumConstRegistroESocial.REGISTRO_1210, prodEvento.getValue()));
        }
        this.setOrigem(pre, (InterfaceVOEsocial)vo);
        return pre;
    }

    public EsocPreEvento getEvento(EsocFechamentoFolha vo, Usuario usuario, Empresa empresa, EnumConstEventoProducao prodEvento, Short eventoRetificacao) throws ExceptionEsocial {
        EsocPreEvento pre = this.getEvento(prodEvento, usuario, empresa, eventoRetificacao);
        pre.setDescricaoEntidade(MessagesBaseMentor.getMsg((String)"esocS1280", (Object[])new Object[0]));
        pre.setIdentificacaoEntidade(String.valueOf(vo.getIdentificador()));
        pre.setClasseEntidade(vo.getClass().getCanonicalName());
        pre.setTipoEventoEsocial((TipoEventoEsocial)this.serviceTipoEventoEsocial.get(Long.valueOf(EnumConstTipoEventoESocial.INFORMACOES_COMP_EVENTOS_PERIODICOS.getValue())));
        if (TMethods.isAffirmative((Number)pre.getEventoRetificacao())) {
            pre.setNumeroReciboRetificado(this.getReciboRetificacao(vo.getPreEventosEsocial(), EnumConstRegistroESocial.REGISTRO_1280, prodEvento.getValue()));
        }
        this.setOrigem(pre, (InterfaceVOEsocial)vo);
        return pre;
    }

    public EsocPreEvento getEvento(EsocCadastroLotacaoTributaria lotacao, Usuario usuario, Empresa empresa, EnumConstEventoProducao prodEvento, Short eventoRetificacao) throws ExceptionEsocial {
        EsocPreEvento evento = this.getEvento(prodEvento, usuario, empresa, eventoRetificacao);
        evento.setDescricaoEntidade(MessagesBaseMentor.getMsg((String)"lotacaoTributaria", (Object[])new Object[0]));
        evento.setIdentificacaoEntidade(String.valueOf(lotacao.getIdentificador()));
        evento.setClasseEntidade(lotacao.getClass().getCanonicalName());
        evento.setTipoEventoEsocial((TipoEventoEsocial)this.serviceTipoEventoEsocial.get(Long.valueOf(EnumConstTipoEventoESocial.TABELA_LOTACOES_TRIBUTARIAS.getValue())));
        this.setOrigem(evento, (InterfaceVOEsocial)lotacao);
        return evento;
    }

    public EsocPreEvento getEvento(TerminoTrabalhadorSemVinculo vo, Usuario usuario, Empresa empresa, EnumConstEventoProducao prodEvento, Short eventoRetificacao) throws ExceptionEsocial {
        EsocPreEvento pre = this.getEvento(prodEvento, usuario, empresa, eventoRetificacao);
        pre.setDescricaoEntidade(MessagesBaseMentor.getMsg((String)"terminoTsv", (Object[])new Object[0]));
        pre.setIdentificacaoEntidade(String.valueOf(vo.getIdentificador()));
        pre.setClasseEntidade(vo.getClass().getCanonicalName());
        pre.setTipoEventoEsocial((TipoEventoEsocial)this.serviceTipoEventoEsocial.get(Long.valueOf(EnumConstTipoEventoESocial.TRABALHADOR_SEM_VINCULO_TERMINO.getValue())));
        if (TMethods.isAffirmative((Number)pre.getEventoRetificacao())) {
            pre.setNumeroReciboRetificado(this.getReciboRetificacao(vo.getPreEventosEsocial(), EnumConstRegistroESocial.REGISTRO_1280, prodEvento.getValue()));
        }
        this.setOrigem(pre, (InterfaceVOEsocial)vo);
        return pre;
    }

    public EsocPreEvento getEvento(Recisao vo, Usuario usuario, PagamentoFolhaCompColaborador folhaComplementar, MovimentoFolha movFolhaRecisao, Empresa empresa, EnumConstEventoProducao prodEvento, Short eventoRetificacao) throws ExceptionEsocial {
        EsocPreEvento pre = this.getEvento(prodEvento, usuario, empresa, eventoRetificacao);
        pre.setDescricaoEntidade(MessagesBaseMentor.getMsg((String)"Desligamento", (Object[])new Object[0]));
        pre.setIdentificacaoEntidade(String.valueOf(vo.getIdentificador()));
        pre.setClasseEntidade(vo.getClass().getCanonicalName());
        pre.setTipoEventoEsocial((TipoEventoEsocial)this.serviceTipoEventoEsocial.get(Long.valueOf(EnumConstTipoEventoESocial.INFORMACOES_COMP_EVENTOS_PERIODICOS.getValue())));
        if (TMethods.isNull((Object)vo.getRecisaoComplementarAc()).booleanValue()) {
            pre.setTipoEventoEsocial((TipoEventoEsocial)this.serviceTipoEventoEsocial.get(Long.valueOf(EnumConstTipoEventoESocial.DESLIGAMENTO.getValue())));
        } else {
            pre.setTipoEventoEsocial((TipoEventoEsocial)this.serviceTipoEventoEsocial.get(Long.valueOf(EnumConstTipoEventoESocial.REMUNERACAO_TRABALHADOR_VINC_REGIME_GERAL_PREV_SOCIAL.getValue())));
        }
        if (TMethods.isAffirmative((Number)pre.getEventoRetificacao())) {
            pre.setNumeroReciboRetificado(this.getReciboRetificacao(vo.getPreEventosEsocial(), EnumConstRegistroESocial.REGISTRO_1280, prodEvento.getValue()));
        }
        pre.setFolhaComplementar(folhaComplementar);
        pre.setMovimentoFolhaRecisao(movFolhaRecisao);
        this.setOrigem(pre, (InterfaceVOEsocial)vo);
        return pre;
    }

    public EsocPreEvento getEvento(Colaborador vo, Usuario usuario, Empresa empresa, EnumConstTipoEventoESocial tipoEvento, EnumConstEventoProducao prodEvento, Short eventoRetificacao) throws ExceptionEsocial {
        EsocPreEvento pre = this.getEvento(prodEvento, usuario, empresa, eventoRetificacao);
        pre.setDescricaoEntidade(MessagesBaseMentor.getMsg((String)"colaborador", (Object[])new Object[0]));
        pre.setIdentificacaoEntidade(vo.getIdentificador() != null ? String.valueOf(vo.getIdentificador()) : "1");
        pre.setClasseEntidade(vo.getClass().getCanonicalName());
        pre.setTipoEventoEsocial((TipoEventoEsocial)this.serviceTipoEventoEsocial.get(Long.valueOf(tipoEvento.getValue())));
        pre.setSalarioColaborador(vo.getValorSalario());
        if (TMethods.isAffirmative((Number)pre.getEventoRetificacao())) {
            pre.setNumeroReciboRetificado(this.getReciboRetificacao(vo.getPreEventosEsocial(), EnumConstRegistroESocial.REGISTRO_2200, prodEvento.getValue()));
        }
        this.setOrigem(pre, (InterfaceVOEsocial)vo);
        return pre;
    }

    private void setOrigem(EsocPreEvento preEvento, InterfaceVOEsocial vo) throws ExceptionEsocial {
        if (vo instanceof EsocComunicadoAcidTrab) {
            preEvento.setCat((EsocComunicadoAcidTrab)vo);
        } else if (vo instanceof EsocProcessoTrabalhista) {
            preEvento.setProcessoTrabalhista((EsocProcessoTrabalhista)vo);
        } else if (vo instanceof EsocExameToxicologico) {
            preEvento.setExameToxicologico((EsocExameToxicologico)vo);
        } else if (vo instanceof ExclusaoEventosEsocial) {
            preEvento.setExclusaoEventos((ExclusaoEventosEsocial)vo);
        } else if (vo instanceof EsocCondicoesAmbientaisTrabalho) {
            preEvento.setCondicoes((EsocCondicoesAmbientaisTrabalho)vo);
        } else if (vo instanceof TabelaProcessosEsoc) {
            preEvento.setTabelaProcesso((TabelaProcessosEsoc)vo);
        } else if (vo instanceof EsocFechamentoEventosPeriodicos) {
            preEvento.setFechamentoEventos((EsocFechamentoEventosPeriodicos)vo);
        } else if (vo instanceof EsocMonitoramentoSaude) {
            preEvento.setMonitoramento((EsocMonitoramentoSaude)vo);
        } else if (vo instanceof EsocReaberturaEventos) {
            preEvento.setReaberturaEventos((EsocReaberturaEventos)vo);
        } else if (vo instanceof EsocInfoTributosDecorrentesProcessoTrab) {
            preEvento.setInfoTributosDecorrentesProcessoTrab((EsocInfoTributosDecorrentesProcessoTrab)vo);
        } else if (vo instanceof EsocS1010) {
            preEvento.setEsocS1200((EsocS1010)vo);
        } else if (vo instanceof ESocS1020) {
            preEvento.setEsocS1210((ESocS1020)vo);
        } else if (vo instanceof EsocFechamentoFolha) {
            preEvento.setEsocFechamentoFolha((EsocFechamentoFolha)vo);
        } else if (vo instanceof EsocCadastroEstabelcimento) {
            preEvento.setEstabelecimento((EsocCadastroEstabelcimento)vo);
        } else if (vo instanceof TipoCalculoEvento) {
            preEvento.setTipoCalculo((TipoCalculoEvento)vo);
        } else if (vo instanceof Colaborador) {
            preEvento.setColaborador((Colaborador)vo);
        } else if (vo instanceof Recisao) {
            preEvento.setRecisao((Recisao)vo);
        } else if (vo instanceof TerminoTrabalhadorSemVinculo) {
            preEvento.setTerminoTsv((TerminoTrabalhadorSemVinculo)vo);
        } else if (vo instanceof EsocCadastroLotacaoTributaria) {
            preEvento.setLotacaoTrbutaria((EsocCadastroLotacaoTributaria)vo);
        } else if (vo instanceof TransferenciaColaborador) {
            preEvento.setTransferenciaColaborador((TransferenciaColaborador)vo);
        } else {
            throw new ExceptionEsocial(EnumEsocial.ENTIDADE_NAO_MAPEADA_GERAR_PRE_EVENTO_ESOCIAL, new Object[]{vo});
        }
    }

    private String getReciboRetificacao(List<EsocPreEvento> eventos, EnumConstRegistroESocial registro, Short prodEvento) {
        if (TMethods.isNull((Object)registro).booleanValue() || TMethods.isNull(eventos).booleanValue()) {
            return MessagesBaseMentor.getMsg((String)"Erro", (Object[])new Object[0]);
        }
        Long tipoEvento = Long.valueOf(String.valueOf(registro.getValue()));
        for (EsocPreEvento e : eventos) {
            if (!TMethods.isEquals((Object)e.getTipoEventoEsocial().getIdentificador(), (Object)tipoEvento) || !TMethods.isEquals((Object)e.getEventoProdRestritaProducao(), (Object)prodEvento) || !TMethods.isNull((Object)e.getEventoPosterior()).booleanValue()) continue;
            return e.getEsocEvento().getNrRecibo();
        }
        return MessagesBaseMentor.getMsg((String)"Erro", (Object[])new Object[0]);
    }

    public List<DTOEsocPreEventoNaoEnviado> buildToDTOColaboradorSemEventos(List<Colaborador> colaboradores, Usuario usuario) {
        LinkedList<DTOEsocPreEventoNaoEnviado> ret = new LinkedList<DTOEsocPreEventoNaoEnviado>();
        if (ToolMethods.isWithData(colaboradores)) {
            for (Colaborador c : colaboradores) {
                DTOEsocPreEventoNaoEnviado dto = new DTOEsocPreEventoNaoEnviado();
                dto.setUsuario(usuario.getUsuarioBasico().getPessoa().getNome());
                dto.setRegistro(MessagesBaseMentor.getMsg((String)"cadastramentoInicialVincAdmIngTrabalhador", (Object[])new Object[0]));
                dto.setTipoEvento(MessagesBaseMentor.getMsg((String)"inclusao", (Object[])new Object[0]));
                dto.setGeracao(MessagesBaseMentor.getMsg((String)"automatica", (Object[])new Object[0]));
                dto.setDataInicioVal(c.getDataAdmissao());
                dto.setDataFimVal(null);
                dto.setOrigem(c.getIdentificador() + "/" + MessagesBaseMentor.getMsg((String)"admissao", (Object[])new Object[0]));
                dto.setDescricaoEntidade(c.getNumeroRegistro() + " - " + c.getPessoa().getNome());
                dto.setStatus("0 - " + MessagesBaseMentor.getMsg((String)"naoCriadoEvento", (Object[])new Object[0]));
                ret.add(dto);
            }
        }
        return ret;
    }

    public List<DTOEsocPreEventoNaoEnviado> buildToDTORecisoesSemEventos(List<Recisao> recisoes, Usuario usuario) {
        LinkedList<DTOEsocPreEventoNaoEnviado> ret = new LinkedList<DTOEsocPreEventoNaoEnviado>();
        if (ToolMethods.isWithData(recisoes)) {
            for (Recisao r : recisoes) {
                DTOEsocPreEventoNaoEnviado dto = new DTOEsocPreEventoNaoEnviado();
                dto.setUsuario(usuario.getUsuarioBasico().getPessoa().getNome());
                dto.setRegistro(MessagesBaseMentor.getMsg((String)"desligamento", (Object[])new Object[0]));
                dto.setTipoEvento(MessagesBaseMentor.getMsg((String)"inclusao", (Object[])new Object[0]));
                dto.setGeracao(MessagesBaseMentor.getMsg((String)"automatica", (Object[])new Object[0]));
                dto.setDataInicioVal(r.getDataAfastamento());
                dto.setDataFimVal(null);
                dto.setOrigem(r.getIdentificador() + "/" + MessagesBaseMentor.getMsg((String)"desligamento", (Object[])new Object[0]));
                dto.setDescricaoEntidade(r.getColaborador().getNumeroRegistro() + " - " + r.getColaborador().getPessoa().getNome());
                dto.setStatus("0 - " + MessagesBaseMentor.getMsg((String)"naoCriadoEvento", (Object[])new Object[0]));
                ret.add(dto);
            }
        }
        return ret;
    }

    public List<DTOEsocPreEventoNaoEnviado> buildToDTOEsocPreEventoNaoEnviado(List<EsocPreEvento> eventos) {
        LinkedList<DTOEsocPreEventoNaoEnviado> ret = new LinkedList<DTOEsocPreEventoNaoEnviado>();
        if (ToolMethods.isWithData(eventos)) {
            for (EsocPreEvento evt : eventos) {
                DTOEsocPreEventoNaoEnviado dto = new DTOEsocPreEventoNaoEnviado();
                dto.setIdentificador(evt.getIdentificador());
                dto.setDataInicioVal(evt.getDataInicioVal());
                dto.setDataFimVal(evt.getDataFimVal());
                if (!TMethods.isNull((Object)evt.getUsuario()).booleanValue()) {
                    dto.setUsuario(evt.getUsuario().getUsuarioBasico().getPessoa().getNome());
                }
                if (!TMethods.isNull((Object)evt.getTipoEventoEsocial()).booleanValue()) {
                    dto.setRegistro(evt.getTipoEventoEsocial().getCodigo());
                } else {
                    dto.setRegistro(MessagesBaseMentor.getMsg((String)"eventoSemOrigem", (Object[])new Object[0]));
                }
                if (TMethods.isEquals((Object)evt.getTipoEvento(), (Object)EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value)) {
                    dto.setTipoEvento(MessagesBaseMentor.getMsg((String)"inclusao", (Object[])new Object[0]));
                } else if (TMethods.isEquals((Object)evt.getTipoEvento(), (Object)EnumEsocialTipoEvento.TIPO_EVENTO_ALTERACAO.value)) {
                    dto.setTipoEvento(MessagesBaseMentor.getMsg((String)"alteracao", (Object[])new Object[0]));
                } else if (TMethods.isEquals((Object)evt.getTipoEvento(), (Object)EnumEsocialTipoEvento.TIPO_EVENTO_EXLUSAO.value)) {
                    dto.setTipoEvento(MessagesBaseMentor.getMsg((String)"exclusao", (Object[])new Object[0]));
                } else {
                    dto.setTipoEvento(MessagesBaseMentor.getMsg((String)"indefinido", (Object[])new Object[0]));
                }
                if (TMethods.isEquals((Object)evt.getFormaGeracao(), (Object)EnumEsocialFormaGerEvento.TIPO_EVENTO_AUTOMATICO.value)) {
                    dto.setGeracao(MessagesBaseMentor.getMsg((String)"automatica", (Object[])new Object[0]));
                } else if (TMethods.isEquals((Object)evt.getFormaGeracao(), (Object)EnumEsocialFormaGerEvento.TIPO_EVENTO_MANUAL.value)) {
                    dto.setGeracao(MessagesBaseMentor.getMsg((String)"manual", (Object[])new Object[0]));
                } else {
                    dto.setGeracao(MessagesBaseMentor.getMsg((String)"indefinido", (Object[])new Object[0]));
                }
                if (TMethods.isNull((Object)evt.getInfoHorario()).booleanValue()) {
                    StringBuilder sb = new StringBuilder();
                    if (ToolMethods.isStrWithData((String)evt.getIdentificacaoEntidade()) && !ToolMethods.isEqualsIgnoreCase((String)evt.getIdentificacaoEntidade(), (String)"null")) {
                        sb.append(evt.getIdentificacaoEntidade());
                        sb.append("/");
                    }
                    if (ToolMethods.isStrWithData((String)evt.getDescricaoEntidade())) {
                        sb.append(evt.getDescricaoEntidade());
                    }
                    dto.setOrigem(sb.toString());
                } else if (!TMethods.isNull((Object)evt.getInfoHorario().getEsocCadastroHorario()).booleanValue()) {
                    dto.setOrigem(evt.getInfoHorario().getEsocCadastroHorario().getHorario().getIdentificador() + "/" + MessagesBaseMentor.getMsg((String)"horarioTrabalho", (Object[])new Object[0]));
                } else if (!TMethods.isNull((Object)evt.getInfoHorario().getEsocAux()).booleanValue()) {
                    dto.setOrigem(evt.getInfoHorario().getEsocAux().getHorario().getIdentificador() + "/" + MessagesBaseMentor.getMsg((String)"horarioTrabalho", (Object[])new Object[0]));
                } else {
                    dto.setOrigem(MessagesBaseMentor.getMsg((String)"horarioTrabalho", (Object[])new Object[0]));
                }
                if (!TMethods.isNull((Object)evt.getEmpresaRH()).booleanValue()) {
                    dto.setDescricaoEntidade(evt.getEmpresaRH().getEmpresa().getPessoa().getNome());
                } else if (!TMethods.isNull((Object)evt.getLotacaoTrbutaria()).booleanValue()) {
                    if (!TMethods.isNull((Object)evt.getLotacaoTrbutaria().getPessoa()).booleanValue()) {
                        dto.setDescricaoEntidade(evt.getLotacaoTrbutaria().getPessoa().getNome());
                    } else {
                        dto.setDescricaoEntidade(evt.getLotacaoTrbutaria().getEmpresa().getPessoa().getNome());
                    }
                } else if (!TMethods.isNull((Object)evt.getEsocS1200()).booleanValue()) {
                    dto.setDescricaoEntidade(this.getDescricaoColaborador(evt.getEsocS1200().getColaborador()));
                } else if (!TMethods.isNull((Object)evt.getEsocPagamentoContigencia()).booleanValue()) {
                    dto.setDescricaoEntidade(MessagesBaseMentor.getMsg((String)"solicitacaoPagamentoContingencia", (Object[])new Object[0]));
                } else if (!TMethods.isNull((Object)evt.getEsocS1210()).booleanValue()) {
                    dto.setDescricaoEntidade(this.getDescricaoColaborador(evt.getEsocS1210().getColaborador()));
                } else if (!TMethods.isNull((Object)evt.getEsocCadastroReintegracao()).booleanValue()) {
                    dto.setDescricaoEntidade(this.getDescricaoColaborador(evt.getEsocCadastroReintegracao().getRescisao().getColaborador()));
                } else if (!TMethods.isNull((Object)evt.getReaberturaEventos()).booleanValue()) {
                    dto.setDescricaoEntidade(MessagesBaseMentor.getMsg((String)"reaberturaEventosNaoPeriodicos", (Object[])new Object[0]));
                } else if (!TMethods.isNull((Object)evt.getEsocFechamentoFolha()).booleanValue()) {
                    dto.setDescricaoEntidade(MessagesBaseMentor.getMsg((String)"informacoesComplementares", (Object[])new Object[0]));
                } else if (!TMethods.isNull((Object)evt.getExclusaoEventos()).booleanValue()) {
                    dto.setDescricaoEntidade(this.getDescricaoColaborador(evt.getExclusaoEventos().getColaborador()));
                } else if (!TMethods.isNull((Object)evt.getFechamentoEventos()).booleanValue()) {
                    dto.setDescricaoEntidade(MessagesBaseMentor.getMsg((String)"fechamentoEventosNaoPeriodicos", (Object[])new Object[0]));
                } else if (!TMethods.isNull((Object)evt.getTransferenciaColaborador()).booleanValue()) {
                    dto.setDescricaoEntidade(this.getDescricaoColaborador(evt.getTransferenciaColaborador().getColaborador()));
                } else if (!TMethods.isNull((Object)evt.getFeriasColaborador()).booleanValue()) {
                    dto.setDescricaoEntidade(this.getDescricaoColaborador(evt.getFeriasColaborador().getPeriodoAqFeriasColab().getColaborador()));
                } else if (!TMethods.isNull((Object)evt.getConvocacao()).booleanValue()) {
                    dto.setDescricaoEntidade(this.getDescricaoColaborador(evt.getConvocacao().getColaborador()));
                } else if (!TMethods.isNull((Object)evt.getEstabelecimento()).booleanValue()) {
                    dto.setDescricaoEntidade(evt.getEmpresa().getPessoa().getNome());
                } else if (!TMethods.isNull((Object)evt.getFuncao()).booleanValue()) {
                    dto.setDescricaoEntidade(evt.getFuncao().getDescricao());
                } else if (!TMethods.isNull((Object)evt.getTipoCalculo()).booleanValue()) {
                    dto.setDescricaoEntidade(evt.getTipoCalculo().getEvento().getDescricao());
                } else if (!TMethods.isNull((Object)evt.getLancamentoAtestado()).booleanValue()) {
                    dto.setDescricaoEntidade(this.getDescricaoColaborador(evt.getLancamentoAtestado().getColaborador()));
                } else if (!TMethods.isNull((Object)evt.getInfoHorario()).booleanValue()) {
                    Object horario = "";
                    if (!TMethods.isNull((Object)evt.getInfoHorario().getDiaSemana()).booleanValue()) {
                        horario = (String)horario + String.valueOf(evt.getInfoHorario().getDiaSemana()) + " - ";
                    }
                    horario = (String)horario + ToolDate.dateToStr((Date)evt.getInfoHorario().getHorarioInicial(), (String)"HH:mm") + " \u00e0s " + ToolDate.dateToStr((Date)evt.getInfoHorario().getHorarioFinal(), (String)"HH:mm");
                    dto.setDescricaoEntidade((String)horario);
                } else if (!TMethods.isNull((Object)evt.getColaborador()).booleanValue()) {
                    dto.setDescricaoEntidade(this.getDescricaoColaborador(evt.getColaborador()));
                } else if (!TMethods.isNull((Object)evt.getTerminoTsv()).booleanValue()) {
                    dto.setDescricaoEntidade(evt.getTerminoTsv().getColaborador().getPessoa().getNome());
                } else if (!TMethods.isNull((Object)evt.getAdmissaoPreLiminar()).booleanValue()) {
                    dto.setDescricaoEntidade(evt.getAdmissaoPreLiminar().getNome());
                } else if (!TMethods.isNull((Object)evt.getAfastamentoColaborador()).booleanValue()) {
                    dto.setDescricaoEntidade(this.getDescricaoColaborador(evt.getAfastamentoColaborador().getColaborador()));
                } else if (!TMethods.isNull((Object)evt.getRecisao()).booleanValue()) {
                    dto.setDescricaoEntidade(this.getDescricaoColaborador(evt.getRecisao().getColaborador()));
                } else if (!TMethods.isNull((Object)evt.getEmissaoAviso()).booleanValue()) {
                    dto.setDescricaoEntidade(this.getDescricaoColaborador(evt.getEmissaoAviso().getColaborador()));
                } else if (!TMethods.isNull((Object)evt.getTabelaProcesso()).booleanValue()) {
                    dto.setDescricaoEntidade(MessagesBaseMentor.getMsg((String)"tabelaProcessos", (Object[])new Object[0]));
                } else if (!TMethods.isNull((Object)evt.getSuspensaoFerias()).booleanValue()) {
                    dto.setDescricaoEntidade(this.getDescricaoColaborador(evt.getSuspensaoFerias().getFerias().getPeriodoAqFeriasColab().getColaborador()));
                } else if (!TMethods.isNull((Object)evt.getCondicoes()).booleanValue()) {
                    dto.setDescricaoEntidade(this.getDescricaoColaborador(evt.getCondicoes().getColaborador()));
                } else if (!TMethods.isNull((Object)evt.getMonitoramento()).booleanValue()) {
                    dto.setDescricaoEntidade(this.getDescricaoColaborador(evt.getMonitoramento().getColaborador()));
                } else {
                    dto.setDescricaoEntidade(evt.getIdentificacaoEntidade());
                }
                if (!TMethods.isNull((Object)evt.getEsocEvento()).booleanValue()) {
                    if (TMethods.isEquals((Object)evt.getEsocEvento().getStatus(), (Object)EnumConstESocialStatus.STATUS_SUCESSO.getValue())) {
                        dto.setStatus(MessagesBaseMentor.getMsg((String)"enviadoSucesso", (Object[])new Object[0]));
                    } else if (TMethods.isEquals((Object)evt.getEsocEvento().getStatus(), (Object)EnumConstESocialStatus.STATUS_SUCESSO_ADVERTENCIA.getValue())) {
                        dto.setStatus(MessagesBaseMentor.getMsg((String)"enviadoSucessoComAdvertencias", (Object[])new Object[0]));
                    } else {
                        dto.setStatus(MessagesBaseMentor.getMsg((String)String.valueOf(evt.getEsocEvento().getStatus()), (Object[])new Object[0]));
                    }
                } else {
                    dto.setStatus(MessagesBaseMentor.getMsg((String)"eventoNaoEnviado", (Object[])new Object[0]));
                }
                ret.add(dto);
            }
        }
        return ret;
    }

    public List<DTOEsocPreEventoEnviado> buildToDTOEventosEnviados(List<Object[]> eventosEnviados) {
        LinkedList<DTOEsocPreEventoEnviado> ret = new LinkedList<DTOEsocPreEventoEnviado>();
        Long count = 0L;
        for (Object[] values : eventosEnviados) {
            count = count + Long.valueOf(String.valueOf(values[0]));
        }
        for (Object[] values : eventosEnviados) {
            DTOEsocPreEventoEnviado dto = new DTOEsocPreEventoEnviado();
            dto.setTipoEventoIdentificador(Long.valueOf(String.valueOf(values[1])));
            dto.setEvento(String.valueOf(values[2]) + "-" + String.valueOf(values[3]));
            dto.setQuantidade(Integer.valueOf(String.valueOf(values[0])));
            dto.setPercentual(Double.valueOf((double)dto.getQuantidade().intValue() / count.doubleValue() * 100.0));
            ret.add(dto);
        }
        return ret;
    }

    public List<DTOValoresInss> buildToDTOValoresInss(List<EsocValoresInssColaborador> valoresInss, EnumConstTipoBuscaInss tipo) {
        LinkedList<DTOValoresInss> ret = new LinkedList<DTOValoresInss>();
        if (ToolMethods.isWithData(valoresInss)) {
            for (EsocValoresInssColaborador vlr : valoresInss) {
                Double valorInssFolha = this.getValorInssFolha(vlr);
                if (ToolMethods.isEquals((Object)tipo, (Object)EnumConstTipoBuscaInss.COM_DIFERENCA)) {
                    if (ToolMethods.isEquals((Object)vlr.getTotalInssEsocial(), (Object)vlr.getTotalDescontado()) || ToolMethods.isEquals((Object)valorInssFolha, (Object)vlr.getTotalInssEsocial())) continue;
                    ret.add(this.getDTOValoresInss(vlr, valorInssFolha));
                    continue;
                }
                ret.add(this.getDTOValoresInss(vlr, valorInssFolha));
            }
        }
        return ret;
    }

    private DTOValoresInss getDTOValoresInss(EsocValoresInssColaborador vlr, Double valorInssFolha) {
        DTOValoresInss dto = new DTOValoresInss();
        if (ToolMethods.isEquals((Object)vlr.getEsocEvento().getPreEvento().getTipoEventoEsocial().getIdentificador(), (Object)EnumConstTipoEventoESocial.DESLIGAMENTO.getValue()) && ToolMethods.isNotNull((Object)vlr.getEsocEvento().getPreEvento().getRecisao()).booleanValue()) {
            dto.setIdColaborador(vlr.getEsocEvento().getPreEvento().getRecisao().getColaborador().getIdentificador());
            dto.setColaborador(this.getDescricaoColaborador(vlr.getEsocEvento().getPreEvento().getRecisao().getColaborador()));
        } else if (ToolMethods.isEquals((Object)vlr.getEsocEvento().getPreEvento().getTipoEventoEsocial().getIdentificador(), (Object)EnumConstTipoEventoESocial.REMUNERACAO_TRABALHADOR_VINC_REGIME_GERAL_PREV_SOCIAL.getValue()) && ToolMethods.isNotNull((Object)vlr.getEsocEvento().getPreEvento().getEsocS1200()).booleanValue()) {
            dto.setIdColaborador(vlr.getEsocEvento().getPreEvento().getEsocS1200().getColaborador().getIdentificador());
            dto.setColaborador(this.getDescricaoColaborador(vlr.getEsocEvento().getPreEvento().getEsocS1200().getColaborador()));
        } else {
            dto.setIdColaborador(vlr.getEsocEvento().getPreEvento().getColaborador().getIdentificador());
            dto.setColaborador(MessagesBaseMentor.getMsg((String)"entidadeNaoMapeada", (Object[])new Object[0]));
        }
        dto.setTipoEvento(vlr.getEsocEvento().getPreEvento().getTipoEventoEsocial().getCodigo() + "-" + String.valueOf(vlr.getEsocEvento().getStatus()));
        dto.setVlrCalcEsocial(vlr.getTotalInssEsocial());
        dto.setVlrEnviado(vlr.getTotalDescontado());
        dto.setVlrFolha(valorInssFolha);
        if (ToolMethods.isWithData((Collection)vlr.getItens())) {
            for (EsocItemValoresInss itemInss : vlr.getItens()) {
                DTOValoresInss.DTOItensValoresInss dtoItem = new DTOValoresInss.DTOItensValoresInss();
                if (ToolMethods.isNotNull((Object)itemInss.getEsocValores().getEsocEvento().getPreEvento().getColaborador()).booleanValue()) {
                    dtoItem.setIdColaborador(itemInss.getEsocValores().getEsocEvento().getPreEvento().getColaborador().getIdentificador());
                }
                if (ToolMethods.isEquals((Object)itemInss.getIndicativoFolha(), (Object)EnumIndicativoApuracao.FOLHA_13.getEnumId())) {
                    dtoItem.setTipoFolha(MessagesBaseMentor.getMsg((String)"13terceiro", (Object[])new Object[0]));
                } else {
                    dtoItem.setTipoFolha(MessagesBaseMentor.getMsg((String)"mensal", (Object[])new Object[0]));
                }
                dtoItem.setCodigoReceita(itemInss.getEsocValores().getCodigoReceita());
                if (ToolMethods.isEquals((Object)itemInss.getTipoValor(), (Object)String.valueOf(EnumConstTipoValorInssESocial.BASE_PREVIDENCIA_NORMAL.getValue()))) {
                    dtoItem.setTipoValor(MessagesBaseMentor.getMsg((String)"basePrevidenciaNormal", (Object[])new Object[0]));
                } else if (ToolMethods.isEquals((Object)itemInss.getTipoValor(), (Object)String.valueOf(EnumConstTipoValorInssESocial.VALOR_DESC_TRABALHADOR_REC_PREVIDENCIA_SOC.getValue()))) {
                    dtoItem.setTipoValor(MessagesBaseMentor.getMsg((String)"valorDescontado", (Object[])new Object[0]));
                } else if (ToolMethods.isEquals((Object)itemInss.getTipoValor(), (Object)String.valueOf(EnumConstTipoValorInssESocial.VALOR_PAGO_SALARIO_FAMILIA.getValue()))) {
                    dtoItem.setTipoValor(MessagesBaseMentor.getMsg((String)"salarioFamilia", (Object[])new Object[0]));
                } else {
                    dtoItem.setTipoValor(itemInss.getTipoValor());
                }
                dtoItem.setValor(itemInss.getValor());
                dto.getItens().add(dtoItem);
            }
        }
        return dto;
    }

    private Double getValorInssFolha(EsocValoresInssColaborador vlr) {
        Double totalFolha = 0.0;
        Boolean refFolhaPag = false;
        if (ToolMethods.isNotNull((Object)vlr.getEsocEvento().getPreEvento().getEsocS1200()).booleanValue()) {
            for (EsocItemS1010 item : vlr.getEsocEvento().getPreEvento().getEsocS1200().getItensS1010()) {
                if (!ToolMethods.isNotNull((Object)item.getMovimentoFolha()).booleanValue()) continue;
                refFolhaPag = true;
                totalFolha = totalFolha + item.getMovimentoFolha().getVrInss13Sal();
                totalFolha = totalFolha + item.getMovimentoFolha().getVrInssFerias();
                totalFolha = totalFolha + item.getMovimentoFolha().getVrInssSalario();
            }
        }
        if (!refFolhaPag.booleanValue()) {
            totalFolha = totalFolha + (vlr.getEsocEvento().getPreEvento().getRecisao().getVlrInss() + vlr.getEsocEvento().getPreEvento().getRecisao().getVlrInss13());
        }
        return ToolFormatter.arrredondarNumero((Double)totalFolha, (int)2);
    }

    public List<DTOValoresIrrf> buildToDTOValoresIrrf(List<EsocValoresIrrfColaborador> valoresIrrf) {
        LinkedList<DTOValoresIrrf> ret = new LinkedList<DTOValoresIrrf>();
        if (ToolMethods.isWithData(valoresIrrf)) {
            for (EsocValoresIrrfColaborador vlr : valoresIrrf) {
                DTOValoresIrrf dto = new DTOValoresIrrf();
                dto.setColaborador(this.getDescricaoColaborador(vlr.getEsocEvento().getPreEvento().getEsocS1210().getColaborador()));
                dto.setEvento(vlr.getEsocEvento().getPreEvento().getTipoEventoEsocial().getCodigo() + "-" + vlr.getEsocEvento().getStatus());
                dto.setTotal(vlr.getTotalDescontado());
                if (ToolMethods.isWithData((Collection)vlr.getItens())) {
                    for (EsocItemValoresIrrf itemVlr : vlr.getItens()) {
                        DTOValoresIrrf.DTOItensValoresIrrf dtoItem = new DTOValoresIrrf.DTOItensValoresIrrf();
                        if (ToolMethods.isNotNull((Object)itemVlr.getEsocValores().getEsocEvento().getPreEvento().getColaborador()).booleanValue()) {
                            dtoItem.setIdColaborador(itemVlr.getEsocValores().getEsocEvento().getPreEvento().getColaborador().getIdentificador());
                        }
                        dtoItem.setCodigoReceita(itemVlr.getEsocValores().getCodigoReceita());
                        if (ToolMethods.isEquals((Object)itemVlr.getTipoValor(), (Object)String.valueOf(EnumConstTipoValorIrrfESocial.BASE_FERIAS.getValue()))) {
                            dtoItem.setTipoValor(MessagesBaseMentor.getMsg((String)"baseFerias", (Object[])new Object[0]));
                        } else if (ToolMethods.isEquals((Object)itemVlr.getTipoValor(), (Object)String.valueOf(EnumConstTipoValorIrrfESocial.VERBAS_NAO_CONSIDERADAS_COMO_BASE.getValue()))) {
                            dtoItem.setTipoValor(MessagesBaseMentor.getMsg((String)"verbasNaoConsideradasBase", (Object[])new Object[0]));
                        } else if (ToolMethods.isEquals((Object)itemVlr.getTipoValor(), (Object)String.valueOf(EnumConstTipoValorIrrfESocial.BASE_MENSAL.getValue()))) {
                            dtoItem.setTipoValor(MessagesBaseMentor.getMsg((String)"baseMensal", (Object[])new Object[0]));
                        } else if (ToolMethods.isEquals((Object)itemVlr.getTipoValor(), (Object)String.valueOf(EnumConstTipoValorIrrfESocial.DIARIAS.getValue()))) {
                            dtoItem.setTipoValor(MessagesBaseMentor.getMsg((String)"diarias", (Object[])new Object[0]));
                        } else if (ToolMethods.isEquals((Object)itemVlr.getTipoValor(), (Object)String.valueOf(EnumConstTipoValorIrrfESocial.VALOR_INSS.getValue()))) {
                            dtoItem.setTipoValor(MessagesBaseMentor.getMsg((String)"valorInss", (Object[])new Object[0]));
                        } else if (ToolMethods.isEquals((Object)itemVlr.getTipoValor(), (Object)String.valueOf(EnumConstTipoValorIrrfESocial.IRRF_FERIAS.getValue()))) {
                            dtoItem.setTipoValor(MessagesBaseMentor.getMsg((String)"irrfFerias", (Object[])new Object[0]));
                        } else if (ToolMethods.isEquals((Object)itemVlr.getTipoValor(), (Object)String.valueOf(EnumConstTipoValorIrrfESocial.PROVISAO_INSS_FERIAS.getValue()))) {
                            dtoItem.setTipoValor(MessagesBaseMentor.getMsg((String)"provisaoInssFerias", (Object[])new Object[0]));
                        } else if (ToolMethods.isEquals((Object)itemVlr.getTipoValor(), (Object)String.valueOf(EnumConstTipoValorIrrfESocial.IRRF_MENSAL.getValue()))) {
                            dtoItem.setTipoValor(MessagesBaseMentor.getMsg((String)"irrfMensal", (Object[])new Object[0]));
                        } else if (ToolMethods.isEquals((Object)itemVlr.getTipoValor(), (Object)String.valueOf(EnumConstTipoValorIrrfESocial.ABONO_PECUNIARIO.getValue()))) {
                            dtoItem.setTipoValor(MessagesBaseMentor.getMsg((String)"abonoPecuniario", (Object[])new Object[0]));
                        } else {
                            dtoItem.setTipoValor(itemVlr.getTipoValor() + ":" + MessagesBaseMentor.getMsg((String)"verificarNoManual", (Object[])new Object[0]));
                        }
                        dtoItem.setValorDescontado(itemVlr.getValor());
                        dto.getItens().add(dtoItem);
                    }
                }
                ret.add(dto);
            }
        }
        return ret;
    }

    public List<DTOTotalizadorInss> buildToDTOTotalizadorInss(List<EsocValores5011> valores) {
        LinkedList<DTOTotalizadorInss> ret = new LinkedList<DTOTotalizadorInss>();
        if (ToolMethods.isWithData(valores)) {
            for (EsocValores5011 vlr : valores) {
                DTOTotalizadorInss dto = new DTOTotalizadorInss();
                dto.setTotalDescontado(vlr.getValorTotalDescontado());
                dto.setTotalCalculado(vlr.getValorTotalCalculado());
                dto.setClassificacaoTributaria(vlr.getCodigoClassificacaoTributaria());
                dto.setFatorMes(vlr.getFatorMes());
                dto.setDebitoApurado(vlr.getDebitoApurado());
                dto.setSalarioFamilia(vlr.getTotalSalFamilia());
                dto.setSalarioMaternidade(vlr.getTotalSalMaternidade());
                dto.setSaldoAPagar(vlr.getSaldoAPagar());
                if (ToolMethods.isWithData((Collection)vlr.getEsocValoresOutrasEntidades())) {
                    for (EsocValoresOutrasEntidades vrOutEnt : vlr.getEsocValoresOutrasEntidades()) {
                        DTOTotalizadorInss.DTODebitoApuradoGeral dtoDebAp = new DTOTotalizadorInss.DTODebitoApuradoGeral();
                        if (ToolMethods.isNotNull((Object)vrOutEnt.getEsocCodigoRecolhimento()).booleanValue()) {
                            dtoDebAp.setCodigoReceita(vrOutEnt.getEsocCodigoRecolhimento().getDescricao());
                        } else {
                            dtoDebAp.setCodigoReceita(vrOutEnt.getCodigoReceita());
                        }
                        dtoDebAp.setValor(vrOutEnt.getValor());
                        dto.getEsocValoresOutrasEntidades().add(dtoDebAp);
                    }
                }
                if (ToolMethods.isWithData((Collection)vlr.getEstabelecimentos())) {
                    for (EsocEstabelecimentos5011 est : vlr.getEstabelecimentos()) {
                        DTOTotalizadorInss.DTOEstabelecimentos dtoEst = new DTOTotalizadorInss.DTOEstabelecimentos();
                        if (TMethods.isNotNull((Object)est.getEstabelecimento()).booleanValue()) {
                            dtoEst.setIdEstabelecimento(est.getEstabelecimento().getIdentificador());
                            dtoEst.setCnpj(est.getEstabelecimento().getEmpresa().getPessoa().getComplemento().getCnpj());
                            dtoEst.setEstabelecimento(est.getEstabelecimento().getEmpresa().getPessoa().getNome());
                        }
                        if (ToolMethods.isWithData((Collection)vlr.getEstabelecimentos())) {
                            for (EsocLotacaoTributaria5011 lot : est.getLotacoes()) {
                                DTOTotalizadorInss.DTOEstabelecimentos.DTOLotacaoTributaria dtoLot = new DTOTotalizadorInss.DTOEstabelecimentos.DTOLotacaoTributaria();
                                dtoLot.setIdEstabelecimento(lot.getEstabelecimento().getIdentificador());
                                if (ToolMethods.isNotNull((Object)lot.getLotacaoTributaria()).booleanValue()) {
                                    dtoLot.setIdLotacao(lot.getLotacaoTributaria().getIdentificador());
                                    dtoLot.setCodigo(lot.getLotacaoTributaria().getCodigo());
                                    if (ToolMethods.isNotNull((Object)lot.getLotacaoTributaria().getPessoa()).booleanValue()) {
                                        dtoLot.setLotacaoTributaria(lot.getLotacaoTributaria().getPessoa().getNome());
                                    } else if (ToolMethods.isNotNull((Object)lot.getLotacaoTributaria().getEmpresa()).booleanValue()) {
                                        dtoLot.setLotacaoTributaria(lot.getLotacaoTributaria().getEmpresa().getPessoa().getNome());
                                    } else {
                                        dtoLot.setLotacaoTributaria(MessagesBaseMentor.getMsg((String)"lotacaoNaoEncontrada", (Object[])new Object[0]));
                                    }
                                    dtoLot.setFpas(lot.getLotacaoTributaria().getCodigoFpas());
                                    dtoLot.setCodigoTerceiros(lot.getLotacaoTributaria().getCodigoTerceiros());
                                    if (ToolMethods.isNotNull((Object)lot.getBasesRetorno()).booleanValue()) {
                                        for (EsocBasesRemun5011 baseRet : lot.getBasesRetorno()) {
                                            DTOTotalizadorInss.DTOEstabelecimentos.DTOLotacaoTributaria.DTOInssCategoriaTrabalhador dtoInssCatTrab = new DTOTotalizadorInss.DTOEstabelecimentos.DTOLotacaoTributaria.DTOInssCategoriaTrabalhador();
                                            if (ToolMethods.isNotNull((Object)baseRet.getEsocLotacao()).booleanValue()) {
                                                dtoInssCatTrab.setIdLotacao(baseRet.getEsocLotacao().getIdentificador());
                                            }
                                            dtoInssCatTrab.setCategoria(baseRet.getCodigoCategoria());
                                            dtoInssCatTrab.setBaseCalculo(baseRet.getBcCp00());
                                            dtoInssCatTrab.setBc15anos(baseRet.getBcCp15());
                                            dtoInssCatTrab.setBc20anos(baseRet.getBcCp20());
                                            dtoInssCatTrab.setBc25anos(baseRet.getBcCp25());
                                            dtoInssCatTrab.setSestCalculado(baseRet.getVlrCalcSest());
                                            dtoInssCatTrab.setSestDescontado(baseRet.getVlrDescSest());
                                            dtoInssCatTrab.setSenatDescontado(baseRet.getVlrDescSenat());
                                            dtoInssCatTrab.setSenatCalculado(baseRet.getVlrCalcSenat());
                                            dtoInssCatTrab.setSalarioFamilia(baseRet.getVlrSalFamilia());
                                            dtoInssCatTrab.setSalarioMaternidade(baseRet.getVlrSalMaternidade());
                                            dtoLot.getBasesRetorno().add(dtoInssCatTrab);
                                        }
                                    }
                                }
                                dtoEst.getLotacoes().add(dtoLot);
                            }
                        }
                        if (ToolMethods.isWithData((Collection)est.getBasesAquiProdRural())) {
                            for (EsocBasesAquiProdRural baseAqRural : est.getBasesAquiProdRural()) {
                                DTOTotalizadorInss.DTOEstabelecimentos.DTOAquisicaoRural dtoAqRural = new DTOTotalizadorInss.DTOEstabelecimentos.DTOAquisicaoRural();
                                if (ToolMethods.isNotNull((Object)baseAqRural.getEsocEstabelecimento()).booleanValue()) {
                                    dtoAqRural.setIdEstabelecimento(baseAqRural.getEsocEstabelecimento().getIdentificador());
                                }
                                dtoAqRural.setIndAquisicao(baseAqRural.getIndAquisicao());
                                dtoAqRural.setVlrAquisicao(baseAqRural.getVlrAquis());
                                dtoAqRural.setInssDescontado(baseAqRural.getVrCPDescPR());
                                dtoAqRural.setInssCalculado(baseAqRural.getVlrCpCalcPR());
                                dtoAqRural.setRatDescontado(baseAqRural.getVrRatDescPR());
                                dtoAqRural.setRatCalculado(baseAqRural.getVrRatCalcPR());
                                dtoAqRural.setSenarDescontado(baseAqRural.getVrSenarDesc());
                                dtoAqRural.setSenarCalculado(baseAqRural.getVrSenarCalc());
                                dtoEst.getBasesAquiProdRural().add(dtoAqRural);
                            }
                        }
                        if (ToolMethods.isWithData((Collection)est.getValoresDevidos())) {
                            for (EsocValoresContSociaisDevidas valDev : est.getValoresDevidos()) {
                                DTOTotalizadorInss.DTOEstabelecimentos.DTODebitoApuradoEstabelecimento dtoValDev = new DTOTotalizadorInss.DTOEstabelecimentos.DTODebitoApuradoEstabelecimento();
                                dtoValDev.setIdEstabelecimento(valDev.getEsocEstabelecimento().getIdentificador());
                                if (ToolMethods.isNotNull((Object)valDev.getEsocCodigoRecolhimento()).booleanValue()) {
                                    dtoValDev.setCodigoReceita(valDev.getEsocCodigoRecolhimento().getDescricao());
                                } else {
                                    dtoValDev.setCodigoReceita(valDev.getCodigoReceita());
                                }
                                dtoValDev.setValor(valDev.getValor());
                                dtoEst.getValoresDevidos().add(dtoValDev);
                            }
                        }
                        dto.getEstabelecimentos().add(dtoEst);
                    }
                }
                ret.add(dto);
            }
        }
        return ret;
    }

    private String getDescricaoColaborador(Colaborador colaborador) {
        if (ToolMethods.isNotNull((Object)colaborador).booleanValue()) {
            return colaborador.getNumeroRegistro() + " - " + colaborador.getPessoa().getNome();
        }
        return "";
    }

    public EsocPreEvento getExistePreEvento(InterfaceVOEsocial evento, Empresa empresa) {
        if (TMethods.isNull((Object)evento).booleanValue() || !TMethods.isWithData((Collection)evento.getPreEventosEsocial())) {
            return null;
        }
        for (EsocPreEvento esocPreEvento : evento.getPreEventosEsocial()) {
            if (!TMethods.isEquals((Object)esocPreEvento.getEmpresa().getEmpresaDados().getGrupoEmpresa(), (Object)empresa.getEmpresaDados().getGrupoEmpresa()) || !TMethods.isEquals((Object)esocPreEvento.getEventoProdRestritaProducao(), (Object)EnumConstEventoProducao.EVENTO_PRODUCAO.getEnumId()) || !TMethods.isNull((Object)esocPreEvento.getEventoPosterior()).booleanValue()) continue;
            return esocPreEvento;
        }
        return null;
    }
}

