/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.esocpreevento;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.EnumEsocialTipoEvento;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocCadastroEstabelcimento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.ExclusaoEventosEsocial;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.helpers.impl.esocpreevento.HelperEsocPreEvento;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperExclusaoEventosEsocial {
    @Autowired
    private HelperEsocPreEvento helper;

    private ExclusaoEventosEsocial getEvento(EsocPreEvento e) {
        ExclusaoEventosEsocial vo = new ExclusaoEventosEsocial();
        vo.setEmpresa(e.getEmpresa());
        vo.setDataCadastro(new Date());
        vo.setDataAtualizacao(null);
        vo.setEsocEventoAExcluir(e.getEsocEvento());
        vo.setMotivo(MessagesBaseMentor.getMsg((String)"exclusaoPorFechamentoFolha", (Object[])new Object[0]));
        vo.setTipoEventoEsocial(e.getTipoEventoEsocial());
        vo.setNumeroRecibo(e.getEsocEvento().getNrRecibo());
        return vo;
    }

    public EsocPreEvento gerarEventoExclusao(EsocCadastroEstabelcimento vo, EsocPreEvento esocPreEvento, EnumConstEventoProducao tipo, Date dataInicio, Date dataFinal, Usuario usuario, Empresa empresa) throws ExceptionEsocial {
        EsocPreEvento newPreEvento = this.helper.getEvento(vo, usuario, empresa, tipo, (Short)EnumConstantsMentorSimNao.SIM.getValue());
        newPreEvento.setDataCadastro(vo.getDataInicio());
        newPreEvento.setDataFimVal(dataFinal);
        newPreEvento.setDataInicioVal(dataInicio);
        newPreEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_EXLUSAO.getValue()));
        newPreEvento.setEventoAnterior(esocPreEvento);
        esocPreEvento.setEventoPosterior(newPreEvento);
        return esocPreEvento;
    }

    public ExclusaoEventosEsocial criarExclusaoEvento1200(EsocPreEvento e) {
        ExclusaoEventosEsocial vo = this.getEvento(e);
        vo.setPeriodoApuracao(e.getEsocS1200().getEsocFechamentoFolha().getPeriodoApuracao());
        vo.setColaborador(e.getEsocS1200().getColaborador());
        return vo;
    }

    public ExclusaoEventosEsocial criarExclusaoEvento1210(EsocPreEvento e) {
        ExclusaoEventosEsocial vo = this.getEvento(e);
        vo.setPeriodoApuracao(e.getEsocS1200().getEsocFechamentoFolha().getPeriodoApuracao());
        vo.setColaborador(e.getEsocS1200().getColaborador());
        return vo;
    }
}

