/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.eventoosprodlinhaprod;

import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.ComunicadoProducao;
import com.touchcomp.basementor.model.vo.EventoOsProducaoLinhaProd;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.GradeItemRequisicao;
import com.touchcomp.basementor.model.vo.ItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.ItemGradeFormulaProduto;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementor.model.vo.TipoProducao;
import com.touchcomp.basementor.model.vo.TipoProducaoSped;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacaoctbrequisicao.ExceptionParamCtbRequisicao;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.helpers.impl.comunicadoproducao.HelperItemComunicadoProducao;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperEventoOSProdLinhaProd
implements AbstractHelper<EventoOsProducaoLinhaProd> {
    private EventoOsProducaoLinhaProd evtOS;
    @Autowired
    private HelperItemComunicadoProducao helperItemComunicado;

    public EventoOsProducaoLinhaProd get() {
        return this.evtOS;
    }

    public HelperEventoOSProdLinhaProd build(EventoOsProducaoLinhaProd object) {
        this.evtOS = object;
        return this;
    }

    public void novoItemComunicadoAvaDuplicidade(TipoProducao tipoProducao, TipoProducaoSped tipoProducaoSped, GradeCor gradeCor, CentroEstoque centroEst, LoteFabricacao loteFab, double qtdProducao) {
        ComunicadoProducao prod = this.evtOS.getComunicadoProducao();
        if (prod == null) {
            this.novoItemComunicado(tipoProducao, tipoProducaoSped, gradeCor, centroEst, loteFab, qtdProducao);
            return;
        }
        Optional<ItemComunicadoProducao> item = prod.getItemComunicadoProducao().stream().filter(i -> ToolMethods.isEquals((Object)i.getProduto(), (Object)gradeCor.getProdutoGrade().getProduto())).findFirst();
        if (!item.isPresent()) {
            this.novoItemComunicado(tipoProducao, tipoProducaoSped, gradeCor, centroEst, loteFab, qtdProducao);
            return;
        }
        Optional<GradeItemComunicadoProducao> grade = item.get().getGradeItemComunicadoProducao().stream().filter(i -> ToolMethods.isEquals((Object)i.getGradeCor().getIdentificador(), (Object)gradeCor.getIdentificador()) && ToolMethods.isEquals((Object)i.getLoteFabricacao(), (Object)loteFab)).findFirst();
        if (!grade.isPresent()) {
            this.novoItemComunicado(tipoProducao, tipoProducaoSped, gradeCor, centroEst, loteFab, qtdProducao);
            return;
        }
        grade.get().setQuantidade(Double.valueOf(qtdProducao));
        grade.get().setQuantidadeReferencia(Double.valueOf(qtdProducao));
        ((HelperItemComunicadoProducao)Context.get(HelperItemComunicadoProducao.class)).calcularTotais(item.get());
    }

    public void novoItemComunicado(TipoProducao tipoProducao, TipoProducaoSped tipoProducaoSped, GradeCor gradeCor, CentroEstoque centroEst, LoteFabricacao loteFab, double qtdProducao) {
        ComunicadoProducao com = this.evtOS.getComunicadoProducao();
        if (com == null) {
            com = new ComunicadoProducao();
            com.setDataCadastro(new Date());
            com.setDataEntradaSaida(this.evtOS.getDataFechamento());
            com.setDataFinal(this.evtOS.getDataFechamento());
            com.setEmpresa(this.evtOS.getEmpresa());
            com.setEventoOsProducao(this.evtOS);
            com.setTipoRateioDesmProdConjunta(this.evtOS.getSubdivisaoOSProd().getGradeFormulaProduto().getTipoRateioDesmProdConjunta());
            com.setTipoProducaoSped(tipoProducaoSped);
            this.evtOS.setComunicadoProducao(com);
        }
        ItemComunicadoProducao item = new ItemComunicadoProducao();
        item.setCentroCusto(this.evtOS.getFaseProdutiva().getCelulaProdutiva().getCentroCusto());
        item.setCentroEstoque(centroEst);
        item.setComunicadoProducao(com);
        item.setGradeFormulaProduto(this.evtOS.getSubdivisaoOSProd().getGradeFormulaProduto());
        item.setProduto(gradeCor.getProdutoGrade().getProduto());
        ((HelperItemComunicadoProducao)Context.get(HelperItemComunicadoProducao.class)).calcularTotais(item);
        item.setTipoProducao(tipoProducao);
        item.setTiposDefeitos(null);
        item.setUnidadeMedida(item.getProduto().getUnidadeMedida());
        com.getItemComunicadoProducao().add(item);
        GradeItemComunicadoProducao gi = new GradeItemComunicadoProducao();
        gi.setDataMovimentacao(com.getDataEntradaSaida());
        gi.setGradeCor(gradeCor);
        gi.setItemComunicadoProducao(item);
        gi.setLoteFabricacao(loteFab);
        gi.setQuantidade(Double.valueOf(qtdProducao));
        gi.setQuantidadeReferencia(Double.valueOf(qtdProducao));
        gi.setCentroEstoque(item.getCentroEstoque());
        gi.setEmpresa(com.getEmpresa());
        item.getGradeItemComunicadoProducao().add(gi);
    }

    public ItemGradeFormulaProduto getItemGradeFormula(Produto produto) {
        Optional<ItemGradeFormulaProduto> item = this.evtOS.getSubdivisaoOSProd().getGradeFormulaProduto().getItemGradeFormulaProduto().stream().filter(i -> ToolMethods.isEquals((Object)produto, (Object)i.getGradeCor().getProdutoGrade().getProduto())).findFirst();
        return item.isPresent() ? item.get() : null;
    }

    public void novoItemRequisicaoAvaDuplicidade(ItemGradeFormulaProduto itemGradeFormula, CentroEstoque centroEstoque, LoteFabricacao lote, Double peso) throws ExceptionParamCtbRequisicao {
        Optional<ItemComunicadoProducao> found = this.evtOS.getComunicadoProducao().getItemComunicadoProducao().stream().filter(i -> ToolMethods.isEquals((Object)i.getProduto(), (Object)this.evtOS.getSubdivisaoOSProd().getGradeCor().getProdutoGrade().getProduto())).findFirst();
        if (!found.isPresent()) {
            return;
        }
        ItemComunicadoProducao item = found.get();
        if (item.getRequisicoes().isEmpty()) {
            this.novoItemRequisicao(itemGradeFormula, centroEstoque, lote, peso);
            return;
        }
        Requisicao req = (Requisicao)item.getRequisicoes().get(0);
        Optional<ItemRequisicao> itemReq = req.getItensRequisicao().stream().filter(i -> ToolMethods.isEquals((Object)i.getProduto(), (Object)itemGradeFormula.getGradeCor().getProdutoGrade().getProduto())).findAny();
        if (!itemReq.isPresent()) {
            this.novoItemRequisicao(itemGradeFormula, centroEstoque, lote, peso);
            return;
        }
        Optional<GradeItemRequisicao> grade = itemReq.get().getGradeItemRequisicao().stream().filter(i -> ToolMethods.isEquals((Object)i.getGradeCor(), (Object)itemGradeFormula.getGradeCor()) && ToolMethods.isEquals((Object)i.getLoteFabricacao(), (Object)lote)).findAny();
        if (!grade.isPresent()) {
            this.novoItemRequisicao(itemGradeFormula, centroEstoque, lote, peso);
            return;
        }
        itemReq.get().setQuantidadeTotal(peso);
        grade.get().setQuantidade(peso);
    }

    public void novoItemRequisicao(ItemGradeFormulaProduto itemGradeFormula, CentroEstoque centroEstoque, LoteFabricacao lote, Double peso) throws ExceptionParamCtbRequisicao {
        Requisicao req = null;
        Optional<ItemComunicadoProducao> found = this.evtOS.getComunicadoProducao().getItemComunicadoProducao().stream().filter(i -> ToolMethods.isEquals((Object)i.getProduto(), (Object)this.evtOS.getSubdivisaoOSProd().getGradeCor().getProdutoGrade().getProduto())).findFirst();
        if (!found.isPresent()) {
            return;
        }
        GradeCor gradeCor = itemGradeFormula.getGradeCor();
        ItemComunicadoProducao item = found.get();
        if (item.getRequisicoes().size() > 0) {
            req = (Requisicao)item.getRequisicoes().get(0);
        }
        if (req == null) {
            req = new Requisicao();
            req.setDataCadastro(new Date());
            req.setDataRequisicao(this.evtOS.getDataFechamento());
            req.setEmpresa(this.evtOS.getEmpresa());
            req.setItemComunicadoProducao(item);
            item.getRequisicoes().add(req);
        }
        ItemRequisicao itemReq = new ItemRequisicao();
        itemReq.setCentroCusto(this.evtOS.getFaseProdutiva().getCelulaProdutiva().getCentroCusto());
        itemReq.setCentroEstoque(centroEstoque);
        itemReq.setNaturezaRequisicao(itemGradeFormula.getNaturezaRequisicao());
        itemReq.setProduto(gradeCor.getProdutoGrade().getProduto());
        itemReq.setQuantidadeTotal(peso);
        itemReq.setRequisicao(req);
        itemReq.setValorPrecoMedioCont(peso);
        req.getItensRequisicao().add(itemReq);
        GradeItemRequisicao gr = new GradeItemRequisicao();
        gr.setDataMovimentacao(this.evtOS.getDataFechamento());
        gr.setGradeCor(gradeCor);
        gr.setItemRequisicao(itemReq);
        gr.setLoteFabricacao(lote);
        gr.setQuantidade(peso);
        gr.setCentroEstoque(itemReq.getCentroEstoque());
        gr.setEmpresa(req.getEmpresa());
        itemReq.getGradeItemRequisicao().add(gr);
    }

    public void avaliaRemoveItensReq(EventoOsProducaoLinhaProd vo, OpcoesPCP opcoesPCP) {
        if (vo.getComunicadoProducao() == null) {
            return;
        }
        if (!ToolMethods.isAffirmative((Number)opcoesPCP.getRemoverItensZeradosRequisicao())) {
            return;
        }
        for (ItemComunicadoProducao item : vo.getComunicadoProducao().getItemComunicadoProducao()) {
            for (Requisicao req : item.getRequisicoes()) {
                this.removerItensZerados(req);
            }
        }
        this.removerItensZerados(vo.getComunicadoProducao().getRequisicao());
    }

    private void removerItensZerados(Requisicao requisicao) {
        if (requisicao == null) {
            return;
        }
        for (ItemRequisicao item : requisicao.getItensRequisicao()) {
            ArrayList<GradeItemRequisicao> listGrade = new ArrayList<GradeItemRequisicao>();
            for (GradeItemRequisicao grade : item.getGradeItemRequisicao()) {
                if (ToolMethods.isWithData((Number)grade.getQuantidade())) {
                    listGrade.add(grade);
                }
                item.setGradeItemRequisicao(listGrade);
            }
        }
        requisicao.getItensRequisicao().removeIf(i -> !ToolMethods.isWithData((Collection)i.getGradeItemRequisicao()));
    }
}

