/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.eventoosproducaolinhaprod;

import com.touchcomp.basementor.model.vo.ComunicadoProducao;
import com.touchcomp.basementor.model.vo.EventoOsProducaoLinhaProd;
import com.touchcomp.basementor.model.vo.ItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidDataRuntime;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Collection;

public class HelperEventoOsProducaoLinhaProd
implements AbstractHelper<EventoOsProducaoLinhaProd> {
    private EventoOsProducaoLinhaProd evento;

    public EventoOsProducaoLinhaProd get() {
        return this.evento;
    }

    public HelperEventoOsProducaoLinhaProd build(EventoOsProducaoLinhaProd data) {
        this.evento = data;
        return this;
    }

    public void validarQuantidades() {
        Double quantidadeTotalProduzida = 0.0;
        Double quantidadeTotalRequisicao = 0.0;
        if (this.evento != null) {
            if (this.evento.getComunicadoProducao() != null && ToolMethods.isWithData((Collection)this.evento.getComunicadoProducao().getItemComunicadoProducao())) {
                ComunicadoProducao comunicado = this.evento.getComunicadoProducao();
                for (ItemComunicadoProducao ic : comunicado.getItemComunicadoProducao()) {
                    quantidadeTotalProduzida = quantidadeTotalProduzida + ic.getQuantidadeTotal();
                    for (Requisicao r : ic.getRequisicoes()) {
                        quantidadeTotalRequisicao = quantidadeTotalRequisicao + this.getQtdTotal(r);
                    }
                }
            }
            if (this.evento.getRequisicao() != null && ToolMethods.isWithData((Collection)this.evento.getRequisicao().getItensRequisicao())) {
                quantidadeTotalRequisicao = quantidadeTotalRequisicao + this.getQtdTotal(this.evento.getRequisicao());
            }
            if (this.evento.getComunicadoProducao() != null && this.evento.getComunicadoProducao().getRequisicao() != null) {
                quantidadeTotalRequisicao = quantidadeTotalRequisicao + this.getQtdTotal(this.evento.getComunicadoProducao().getRequisicao());
            }
        }
        if (!TMethods.isEquals((Object)ToolFormatter.arrredondarNumero((Double)quantidadeTotalProduzida, (int)3), (Object)ToolFormatter.arrredondarNumero((Double)quantidadeTotalRequisicao, (int)3))) {
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("V.ERP.0426.019"));
        }
    }

    private Double getQtdTotal(Requisicao r) {
        Double quantidadeTotalRequisicao = 0.0;
        if (r == null) {
            return quantidadeTotalRequisicao;
        }
        for (ItemRequisicao ir : r.getItensRequisicao()) {
            quantidadeTotalRequisicao = quantidadeTotalRequisicao + ir.getQuantidadeTotal();
        }
        return quantidadeTotalRequisicao;
    }
}

