/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.eventoossobencomenda;

import com.touchcomp.basementor.constants.enums.opcoespcp.EnumConstOpcoesPCPOP;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.vo.ColaboradorEvtOsProdSobEnc;
import com.touchcomp.basementor.model.vo.DiaHorarioTrabalho;
import com.touchcomp.basementor.model.vo.EventoOsProdSobEnc;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.PeriodoHorTrab;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoespcp.HelperOpcoesPCP;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperEventoOSSobEncomenda
implements AbstractHelper<EventoOsProdSobEnc> {
    private EventoOsProdSobEnc evtOS;
    @Autowired
    private HelperOpcoesPCP helperOpcoesPCP;

    public EventoOsProdSobEnc get() {
        return this.evtOS;
    }

    public HelperEventoOSSobEncomenda build(EventoOsProdSobEnc object) {
        this.evtOS = object;
        return this;
    }

    private void verificarDataAberturaFechamento(EventoOsProdSobEnc aux) {
        Integer diaAbertura = ToolDate.dayFromDate((Date)aux.getDataAbertura());
        Integer diaFechamento = ToolDate.dayFromDate((Date)aux.getDataFechamento());
        if (aux.getDataFechamento().before(aux.getDataAbertura()) && ToolMethods.isEquals((Object)diaFechamento, (Object)diaAbertura)) {
            aux.setDataFechamento(ToolDate.nextDays((Date)aux.getDataFechamento(), (int)1));
        }
    }

    public void calculaHoras(EventoOsProdSobEnc aux, OpcoesPCP opcoesPCP) throws ExceptionInvalidData {
        if (aux.getDataAbertura() == null || aux.getDataFechamento() == null) {
            aux.setHoraEvento(Double.valueOf(0.0));
            return;
        }
        this.verificarDataAberturaFechamento(aux);
        Double totalHorasColaborador = 0.0;
        Double totalHorasAjuste = 0.0;
        Double totalHorasPerNaoProd = 0.0;
        if (aux.getColaboradoresEvtProd() != null && ToolMethods.isAffirmative((Number)((Number)CompOpcoes.getOption(this.helperOpcoesPCP.build(opcoesPCP).getItens(), (EnumOpDinamicasInterface)EnumConstOpcoesPCPOP.DESCONTAR_HORA_REPOUSO_APONTAMENTO, Short.class)))) {
            if (aux.getColaboradoresEvtProd().size() > 1) {
                throw new ExceptionInvalidData("E.ERP.0693.001", new Object[0]);
            }
            for (ColaboradorEvtOsProdSobEnc colab : aux.getColaboradoresEvtProd()) {
                for (DiaHorarioTrabalho diaHorarioTrabalho : colab.getColaborador().getHorarioTrabalho().getDiaHorarioTrabalho()) {
                    if (!ToolDate.dateBetween((Date)diaHorarioTrabalho.getDataHorTrab(), (Date)ToolDate.dataPrimHora((Date)aux.getDataAbertura()), (Date)ToolDate.dataUltHora((Date)aux.getDataFechamento())).booleanValue()) continue;
                    if (diaHorarioTrabalho.getPeriodosTrabalho() == null || diaHorarioTrabalho.getPeriodosTrabalho().isEmpty()) {
                        throw new ExceptionInvalidData("E.ERP.0693.002", new Object[]{ToolDate.dateToStr((Date)diaHorarioTrabalho.getDataHorTrab())});
                    }
                    Date dataEnc = aux.getDataFechamento();
                    Date dataAbert = aux.getDataAbertura();
                    if (!ToolDate.dayFromDate((Date)aux.getDataFechamento()).equals(ToolDate.dayFromDate((Date)aux.getDataAbertura()))) {
                        if (!ToolDate.dayFromDate((Date)aux.getDataFechamento()).equals(ToolDate.dayFromDate((Date)diaHorarioTrabalho.getDataHorTrab()))) {
                            dataEnc = ToolDate.dataUltHora((Date)diaHorarioTrabalho.getDataHorTrab());
                        }
                        if (!ToolDate.dayFromDate((Date)aux.getDataAbertura()).equals(ToolDate.dayFromDate((Date)diaHorarioTrabalho.getDataHorTrab()))) {
                            dataAbert = ToolDate.dataPrimHora((Date)diaHorarioTrabalho.getDataHorTrab());
                        }
                    }
                    for (PeriodoHorTrab periodo : diaHorarioTrabalho.getPeriodosTrabalho()) {
                        if (ToolMethods.isAffirmative((Number)periodo.getTipoTempo())) {
                            if (ToolDate.getHorasEmNumero((Date)dataAbert) > periodo.getHoraFinal()) continue;
                            if (ToolDate.getHorasEmNumero((Date)dataAbert) < periodo.getHoraInicial()) {
                                if (ToolDate.getHorasEmNumero((Date)dataEnc) > periodo.getHoraFinal()) {
                                    totalHorasColaborador = totalHorasColaborador + (periodo.getHoraFinal() - periodo.getHoraInicial());
                                    continue;
                                }
                                if (!(periodo.getHoraInicial() <= ToolDate.getHorasEmNumero((Date)dataEnc))) continue;
                                totalHorasColaborador = totalHorasColaborador + (ToolDate.getHorasEmNumero((Date)dataEnc) - periodo.getHoraInicial());
                                continue;
                            }
                            if (ToolDate.getHorasEmNumero((Date)dataEnc) > periodo.getHoraFinal()) {
                                totalHorasColaborador = totalHorasColaborador + (periodo.getHoraFinal() - ToolDate.getHorasEmNumero((Date)dataAbert));
                                continue;
                            }
                            totalHorasColaborador = totalHorasColaborador + (ToolDate.getHorasEmNumero((Date)dataEnc) - ToolDate.getHorasEmNumero((Date)dataAbert));
                            continue;
                        }
                        totalHorasPerNaoProd = totalHorasPerNaoProd + (periodo.getHoraFinal() - periodo.getHoraInicial());
                    }
                    if (!(ToolDate.calcularDifHoras((Date)dataAbert, (Date)dataEnc) > totalHorasColaborador)) continue;
                    Date dataEncAux = dataEnc;
                    List collect = diaHorarioTrabalho.getPeriodosTrabalho().stream().filter(c -> c.getHoraInicial() > ToolDate.getHorasEmNumero((Date)dataEncAux)).collect(Collectors.toList());
                    if (!collect.isEmpty()) continue;
                    totalHorasAjuste = totalHorasAjuste + (ToolDate.calcularDifHoras((Date)dataAbert, (Date)dataEnc) - totalHorasColaborador);
                }
            }
        }
        aux.setHorasInformada(ToolDate.calcularDifHoras((Date)aux.getDataAbertura(), (Date)aux.getDataFechamento()));
        aux.setHorasNaoProdutiva(totalHorasPerNaoProd);
        aux.setHoraEvento(Double.valueOf(aux.getHorasInformada() - aux.getHorasNaoProdutiva() - aux.getAjusteHorasNaoProdutiva()));
    }
}

