/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.fechamentoordemservico;

import com.touchcomp.basementor.constants.enums.fechamentoordemservico.status.EnumConstStatusProcedimento;
import com.touchcomp.basementor.constants.enums.fechamentoordemservico.status.EnumConstStatusServico;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Executante;
import com.touchcomp.basementor.model.vo.FechamentoOrdemServico;
import com.touchcomp.basementor.model.vo.ItemConsumoAtivo;
import com.touchcomp.basementor.model.vo.Procedimento;
import com.touchcomp.basementor.model.vo.ServicoManutencao;
import com.touchcomp.basementor.model.vo.ServicoProcedimento;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class HelperFechamentoOrdemServico
implements AbstractHelper<FechamentoOrdemServico> {
    FechamentoOrdemServico fechamentoOrdemServicoOrdemServico;

    public FechamentoOrdemServico get() {
        return this.fechamentoOrdemServicoOrdemServico;
    }

    public HelperFechamentoOrdemServico build(FechamentoOrdemServico data) {
        this.fechamentoOrdemServicoOrdemServico = data;
        return this;
    }

    public void calculaVlrCustoTotal() {
        this.fechamentoOrdemServicoOrdemServico.setVlrCustoTotal(this.getVlrCustoTotal(this.fechamentoOrdemServicoOrdemServico));
    }

    public Double getVlrCustoTotal(FechamentoOrdemServico vo) {
        Double vlr = 0.0;
        if (vo.getExecutantes() != null) {
            for (Executante e : vo.getExecutantes()) {
                vlr = vlr + e.getValorTotal();
            }
        }
        if (vo.getConsumoAtivo() != null && vo.getConsumoAtivo().getItemConsumoAtivo() != null) {
            for (ItemConsumoAtivo it : vo.getConsumoAtivo().getItemConsumoAtivo()) {
                vlr = vlr + it.getValorTotal();
            }
        }
        return vlr;
    }

    public void calculaVlrExecutantes() {
        if (this.fechamentoOrdemServicoOrdemServico.getExecutantes() != null) {
            for (Executante executante : this.fechamentoOrdemServicoOrdemServico.getExecutantes()) {
                if (executante.getColaborador() == null || executante.getColaborador().getValorPorHora() == null || executante.getDataHoraInicio() == null || executante.getDataHoraFinal() == null) continue;
                Double total = ToolDate.calcularDifHoras((Date)executante.getDataHoraInicio(), (Date)executante.getDataHoraFinal());
                executante.setValorTotal(Double.valueOf(executante.getColaborador().getValorPorHora() * total));
                executante.setValorHora(executante.getColaborador().getValorPorHora());
            }
        }
    }

    public EnumConstStatusServico getStatusServico(List<Procedimento> procedimentos) {
        Integer contNaoExecutado;
        Integer contExecutado = contNaoExecutado = Integer.valueOf(0);
        for (Procedimento procedimento : procedimentos) {
            Integer n;
            if (TMethods.isEquals((Object)procedimento.getExecutado(), (Object)EnumConstStatusProcedimento.PENDENTE.getValue())) {
                return EnumConstStatusServico.PENDENTE;
            }
            if (TMethods.isEquals((Object)procedimento.getExecutado(), (Object)EnumConstStatusProcedimento.EXECUTADO.getValue())) {
                n = contExecutado;
                contExecutado = contExecutado + 1;
                continue;
            }
            if (!TMethods.isEquals((Object)procedimento.getExecutado(), (Object)EnumConstStatusProcedimento.NAO_EXECUTADO.getValue())) continue;
            n = contNaoExecutado;
            contNaoExecutado = contNaoExecutado + 1;
        }
        if (TMethods.isEquals((Object)contExecutado, (Object)procedimentos.size())) {
            return EnumConstStatusServico.EXECUTADO;
        }
        if (TMethods.isEquals((Object)contNaoExecutado, (Object)procedimentos.size())) {
            return EnumConstStatusServico.NAO_EXECUTADO;
        }
        if (TMethods.isEquals((Object)(contNaoExecutado + contExecutado), (Object)procedimentos.size()) && !TMethods.isEquals((Object)contNaoExecutado, (Object)0) && !TMethods.isEquals((Object)contExecutado, (Object)0)) {
            return EnumConstStatusServico.PARCIAL;
        }
        return EnumConstStatusServico.NAO_EXECUTADO;
    }

    public void validarDataAbertura(Long lData, Long lHora) throws ExceptionValidacaoDados {
        Date dataAtual;
        Date hora;
        if (TMethods.isNull((Object)lData).booleanValue() || TMethods.isNull((Object)lHora).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.0753.005", new Object[0]);
        }
        Date data = new Date(lData);
        Date dataAbertura = ToolDate.mergeDateWithHour((Date)data, (Date)(hora = new Date(lHora)));
        if (dataAbertura.after(dataAtual = new Date())) {
            throw new ExceptionValidacaoDados("E.ERP.0753.005", new Object[0]);
        }
    }

    public void validarDataFechamento(Long dataAb, Long horaAb, Long dataFec, Long horaFec) throws ExceptionValidacaoDados {
        Date dataAtual;
        if (TMethods.isNull((Object)dataAb).booleanValue() || TMethods.isNull((Object)horaAb).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.0753.005", new Object[0]);
        }
        if (TMethods.isNull((Object)dataFec).booleanValue() || TMethods.isNull((Object)horaFec).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.0753.005", new Object[0]);
        }
        Date dataAbertura = ToolDate.mergeDateWithHour((Long)dataAb, (Long)horaAb);
        Date dataFechamento = ToolDate.mergeDateWithHour((Long)dataFec, (Long)horaFec);
        if (dataFechamento.after(dataAtual = new Date())) {
            throw new ExceptionValidacaoDados("E.ERP.0753.005", new Object[0]);
        }
        if (ToolDate.compareDateHourAndMinute((Date)dataAbertura, (Date)dataFechamento).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.0753.006", new Object[0]);
        }
    }

    public Executante buildExecutante(Colaborador colaborador, Empresa empresa, Long dataAb, Long horaAb, Long dataFec, Long horaFec) throws ExceptionObjNotFound {
        Date dataAbertura = ToolDate.mergeDateWithHour((Long)dataAb, (Long)horaAb);
        Date dataFechamento = ToolDate.mergeDateWithHour((Long)dataFec, (Long)horaFec);
        return this.buildExecutante(colaborador, empresa, dataAbertura, dataFechamento);
    }

    public Executante buildExecutante(Colaborador colaborador, Empresa empresa, Date dataAbertura, Date dataFechamento) throws ExceptionObjNotFound {
        Executante executante = new Executante();
        if (TMethods.isNotNull((Object)colaborador).booleanValue()) {
            executante.setColaborador(colaborador);
            executante.setDataCadastro(new Date());
            executante.setEmpresa(empresa);
            executante.setDataHoraFinal(ToolDate.toTimestamp((Date)dataFechamento));
            executante.setDataHoraInicio(ToolDate.toTimestamp((Date)dataAbertura));
            executante.setPessoa(colaborador.getPessoa());
            Double total = ToolDate.calcularDifHoras((Date)executante.getDataHoraInicio(), (Date)executante.getDataHoraFinal());
            executante.setTempo(total);
            executante.setValorTotal(Double.valueOf(executante.getColaborador().getValorPorHora() * total));
            executante.setValorHora(executante.getColaborador().getValorPorHora());
        }
        return executante;
    }

    public ServicoProcedimento buildServicoProcedimento(ServicoManutencao servico, EnumConstStatusProcedimento status, String procedimento, Empresa empresa) {
        Procedimento vo = this.buildProcedimento(status, procedimento, empresa);
        ServicoProcedimento servicoProcedimento = new ServicoProcedimento();
        servicoProcedimento.setEmpresa(empresa);
        servicoProcedimento.setDataCadastro(new Date());
        servicoProcedimento.setServico(servico);
        servicoProcedimento.getProcedimento().add(vo);
        return servicoProcedimento;
    }

    public Procedimento buildProcedimento(EnumConstStatusProcedimento status, String procedimento, Empresa empresa) {
        Procedimento vo = new Procedimento();
        vo.setDataCadastro(new Date());
        vo.setEmpresa(empresa);
        vo.setExecutado(Short.valueOf(status.getValue()));
        vo.setDescricao(procedimento);
        return vo;
    }
}

