/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.fornecedor;

import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoa;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class HelperFornecedor
implements AbstractHelper<Fornecedor> {
    Fornecedor fornecedor;

    public Fornecedor get() {
        return this.fornecedor;
    }

    public HelperFornecedor build(Fornecedor fornecedor) {
        this.fornecedor = fornecedor;
        return this;
    }

    public UnidadeFatFornecedor criarUnidadeFatPadrao(Fornecedor f) {
        UnidadeFatFornecedor vo = new UnidadeFatFornecedor();
        vo.setPessoa(f.getPessoa());
        vo.setCategoriaPessoa(f.getCategoriaPessoa());
        vo.setFornecedor(f);
        vo.setUnidadeFatPadrao(Short.valueOf((short)1));
        return vo;
    }

    public UnidadeFatFornecedor criarUnidadeFatPadrao(Pessoa p) {
        UnidadeFatFornecedor vo = this.criarUnidadeFat(p);
        vo.setUnidadeFatPadrao(Short.valueOf((short)1));
        return vo;
    }

    public UnidadeFatFornecedor criarUnidadeFat(Pessoa p) {
        UnidadeFatFornecedor vo = new UnidadeFatFornecedor();
        vo.setPessoa(p);
        return vo;
    }

    public UnidadeFatFornecedor criarUnidadeFat(Fornecedor f) {
        if (f == null) {
            return null;
        }
        UnidadeFatFornecedor vo = this.criarUnidadeFat(f.getPessoa());
        vo.setCategoriaPessoa(f.getCategoriaPessoa());
        return vo;
    }

    public Fornecedor criarFornecedor(Pessoa p, Empresa empresa) {
        return this.criarFornecedor(p, empresa, null);
    }

    public Fornecedor criarFornecedor(Pessoa p, Empresa empresa, CategoriaPessoa categoriaFornecedor) {
        Fornecedor f = new Fornecedor();
        f.setDataCadastro(new Date());
        f.setEmpresa(empresa);
        f.setPessoa(p);
        f.setTipoEpp(Short.valueOf((short)0));
        f.setTipo(Short.valueOf((short)0));
        f.setCategoriaPessoa(categoriaFornecedor);
        UnidadeFatFornecedor unidade = this.criarUnidadeFatPadrao(f);
        f.setUnidadesFatForn(TMethods.toList((Object[])new Object[]{unidade}));
        return f;
    }

    public UnidadeFatFornecedor criarUnidadeFatPes(Pessoa p) {
        UnidadeFatFornecedor vo = new UnidadeFatFornecedor();
        vo.setUnidadeFatPadrao(Short.valueOf((short)0));
        Pessoa pu = new Pessoa();
        pu.setNome(p.getNome());
        pu.setDataInicioRelacionamento(new Date());
        pu.setTipoPessoa(Short.valueOf(EnumConstTipoPessoa.PESSOA_SECUNDARIA.value));
        vo.setPessoa(pu);
        Endereco end = new Endereco();
        pu.setEndereco(end);
        Complemento comp = new Complemento();
        comp.setCnpj(p.getComplemento().getCnpj());
        pu.setComplemento(comp);
        vo.setFornecedor(this.fornecedor);
        return vo;
    }
}

