/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.geracaoreciborpa;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.helper.impl.colaborador.HelperColaborador;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.GeracaoReciboRpa;
import com.touchcomp.basementor.model.vo.ItemTabelaIRRF;
import com.touchcomp.basementor.model.vo.TabelaINSS;
import com.touchcomp.basementor.model.vo.TabelaIRRF;
import com.touchcomp.basementor.model.vo.TipoColaborador;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.helpers.impl.terminotrabalhadorsemvinculo.HelperCalculoInss;
import com.touchcomp.basementorservice.helpers.impl.terminotrabalhadorsemvinculo.HelperCalculoIrrf;
import com.touchcomp.basementorservice.service.impl.tabelainss.ServiceTabelaINSSImpl;
import com.touchcomp.basementorservice.service.impl.tabelairrf.ServiceTabelaIRRFImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import java.util.Comparator;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperGeracaoReciboRpa
implements AbstractHelper<GeracaoReciboRpa> {
    GeracaoReciboRpa geracaoReciboRpa;
    @Autowired
    ServiceTabelaINSSImpl serviceTabelaINSSImpl;
    @Autowired
    HelperCalculoInss helperCalculoInss;
    @Autowired
    ServiceTabelaIRRFImpl serviceTabelaIRRFImpl;
    @Autowired
    HelperCalculoIrrf helperCalculoIrrf;

    public GeracaoReciboRpa get() {
        return this.geracaoReciboRpa;
    }

    public HelperGeracaoReciboRpa build(GeracaoReciboRpa geracaoReciboRpa) {
        this.geracaoReciboRpa = geracaoReciboRpa;
        return this;
    }

    public GeracaoReciboRpa calcularValoresRpa(GeracaoReciboRpa vo, EmpresaRh empresaRh, Map valoresAnterioresInss, Map valoresAnterioresIrrf) {
        HelperColaborador helperColaborador = new HelperColaborador();
        Integer dependentesIrrf = helperColaborador.build(vo.getColaborador()).getDependentesIRRF(vo.getDataPagamento()).size();
        if (ToolMethods.isEquals((Object)vo.getInformarImpostoManual(), (Object)EnumConstantsMentorSimNao.NAO.getValue())) {
            TabelaIRRF tabelaIRRF;
            if (ToolMethods.isNull((Object)vo.getColaborador().getEsocIndicativoInss()).booleanValue() || ToolMethods.isEquals((Object)vo.getColaborador().getEsocIndicativoInss().getCodigo(), (Object)"3")) {
                this.calcularInss(vo, empresaRh, valoresAnterioresInss);
            }
            if (ToolMethods.isEquals((Object)vo.getColaborador().getTipoColaborador().getIdentificador(), (Object)EnumConstTipoColaborador.AUTONOMO_FRETE.getValue())) {
                this.calcularSestSenat(vo, empresaRh);
            }
            if (ToolMethods.isNull((Object)(tabelaIRRF = this.serviceTabelaIRRFImpl.getTabelaIrrfPorDataPagamento(vo.getDataPagamento()))).booleanValue()) {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1146.011"));
            }
            this.calcularIrrf(vo, dependentesIrrf, tabelaIRRF, valoresAnterioresIrrf);
        }
        this.calcularTotalizadores(vo);
        return vo;
    }

    private void calcularInss(GeracaoReciboRpa vo, EmpresaRh empresaRh, Map valoresRpaAnterior) {
        if (ToolMethods.isNull((Object)empresaRh.getPercAutonomo()).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1146.009"));
        }
        Double bcInssAnterior = ToolMethods.isNotNull(valoresRpaAnterior.get("valorRpa")) != false ? (Double)valoresRpaAnterior.get("valorRpa") : 0.0;
        Double vlrInssAnterior = ToolMethods.isNotNull(valoresRpaAnterior.get("vlrInss")) != false ? (Double)valoresRpaAnterior.get("vlrInss") : 0.0;
        Double aliqInss = empresaRh.getPercAutonomo();
        Double percentualBcFrete = empresaRh.getPercBcFrete();
        TabelaINSS tabelaInss = this.serviceTabelaINSSImpl.getTabelaInssPorPeriodoFolha(vo.getPeriodoFolha());
        if (ToolMethods.isNull((Object)tabelaInss).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1146.010"));
        }
        Double vrLimiteInss = tabelaInss.getVrLimiteMaximoInss();
        Double bcInss = this.calcularBaseCalculoInssArredondada(vo.getColaborador().getTipoColaborador(), vo.getValorRpa(), percentualBcFrete, bcInssAnterior, vrLimiteInss);
        Map valores = this.helperCalculoInss.calcularInss(bcInss, aliqInss, vlrInssAnterior);
        vo.setBcInss((Double)valores.get("baseInss"));
        vo.setAliqInss((Double)valores.get("aliquotaInss"));
        vo.setVlrInss((Double)valores.get("valorInss"));
    }

    private Double calcularBaseCalculoInssArredondada(TipoColaborador tipoColaborador, Double valorRpa, Double percentualBcFrete, Double bcInssAnterior, Double vrLimiteInss) {
        Double bcInss = 0.0;
        if (ToolMethods.isEquals((Object)tipoColaborador.getIdentificador(), (Object)EnumConstTipoColaborador.AUTONOMO_FRETE.getValue())) {
            bcInss = ToolNumber.arredondarNumero((Double)(valorRpa * (percentualBcFrete / 100.0)), (Integer)2, (Integer)0);
            return bcInss >= vrLimiteInss ? vrLimiteInss : bcInss;
        }
        if (ToolMethods.isEquals((Object)tipoColaborador.getIdentificador(), (Object)EnumConstTipoColaborador.AUTONOMO.getValue())) {
            bcInss = ToolNumber.arredondarNumero((Double)(valorRpa + bcInssAnterior), (Integer)2, (Integer)0);
            return bcInss >= vrLimiteInss ? vrLimiteInss : bcInss;
        }
        return bcInss;
    }

    private void calcularSestSenat(GeracaoReciboRpa vo, EmpresaRh empresaRh) {
        Double vlrSenat = vo.getBcInss() * (empresaRh.getPercSENAT() / 100.0);
        Double vlrSest = vo.getBcInss() * (empresaRh.getPercSEST() / 100.0);
        Double vlrSestSenat = ToolNumber.arredondarNumero((Double)(vlrSest + vlrSenat), (Integer)2, (Integer)0);
        vo.setSestSenac(vlrSestSenat);
    }

    private void calcularIrrf(GeracaoReciboRpa vo, Integer dependentesIrrf, TabelaIRRF tabelaIRRF, Map valoresRpaAnterior) {
        Double bcIrrfAnterior = ToolMethods.isNotNull(valoresRpaAnterior.get("valorRpa")) != false ? (Double)valoresRpaAnterior.get("valorRpa") : 0.0;
        Double vlrIrrfAnterior = ToolMethods.isNotNull(valoresRpaAnterior.get("vlrIrrf")) != false ? (Double)valoresRpaAnterior.get("vlrIrrf") : 0.0;
        Double vlrInssAnterior = ToolMethods.isNotNull(valoresRpaAnterior.get("vlrInss")) != false ? (Double)valoresRpaAnterior.get("vlrInss") : 0.0;
        Double vrDeducaoDependentes = (double)dependentesIrrf.intValue() * tabelaIRRF.getVrDeducaoPorDependente();
        Double bcIrrfSemDesconto = vo.getValorRpa() + bcIrrfAnterior;
        Double descontoIrrf = vo.getVlrInss() + vlrInssAnterior + vrDeducaoDependentes;
        if (descontoIrrf < tabelaIRRF.getValorDescontoSimplicado()) {
            descontoIrrf = tabelaIRRF.getValorDescontoSimplicado();
        }
        Double bcIrrf = bcIrrfSemDesconto - descontoIrrf;
        ItemTabelaIRRF itemTabelaIrrf = tabelaIRRF.getItensTabela().stream().filter(i -> i.getValorAte() >= bcIrrf).min(Comparator.comparingDouble(ItemTabelaIRRF::getValorAte)).get();
        Map valores = this.helperCalculoIrrf.calcularIRRF(bcIrrf, itemTabelaIrrf.getAliquota(), itemTabelaIrrf.getVrDeducao(), tabelaIRRF.getVrMinimoADescontar(), vlrIrrfAnterior);
        vo.setBcIrrf((Double)valores.get("baseIrrf"));
        vo.setAliqIrrf((Double)valores.get("aliquotaIrrf"));
        vo.setVlrIrrf((Double)valores.get("valorIrrf"));
    }

    private void calcularTotalizadores(GeracaoReciboRpa vo) {
        vo.setValorProventos(vo.getValorRpa());
        vo.setValorDescontos(ToolNumber.arredondarNumero((Double)(vo.getVlrInss() + vo.getVlrIrrf() + vo.getSestSenac() + vo.getVlrIss()), (Integer)2, (Integer)0));
        vo.setLiquido(ToolNumber.arredondarNumero((Double)(vo.getValorProventos() - vo.getValorDescontos()), (Integer)2, (Integer)0));
    }
}

