/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.grupofaturatitulos;

import com.touchcomp.basementor.constants.enums.titulo.EnumConstTipoTitulo;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FaturaTituloNF;
import com.touchcomp.basementor.model.vo.FaturaTitulos;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.InfPagamentoNfPropria;
import com.touchcomp.basementor.model.vo.InfPagamentoNfTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperGrupoFaturaTitulos {
    @Autowired
    private SCompPlanoConta scPlanoConta;

    public Double getValorTotalNfTerceiros(List<InfPagamentoNfTerceiros> dados, FaturaTitulos fat) {
        Double valorTotal = 0.0;
        if (TMethods.isWithData(dados)) {
            for (InfPagamentoNfTerceiros o : dados) {
                FaturaTituloNF f = new FaturaTituloNF();
                f.setInfPagamentoNfTerceiros(o);
                f.setFaturaTitulos(fat);
                fat.getFaturaTituloNF().add(f);
                valorTotal = valorTotal + o.getNotaFiscalTerceiros().getValoresNfTerceiros().getValorTotal();
            }
        }
        return valorTotal;
    }

    public Double getValorTotalNfPropria(List<InfPagamentoNfPropria> dados, FaturaTitulos fat) {
        Double valorTotal = 0.0;
        if (TMethods.isWithData(dados)) {
            for (InfPagamentoNfPropria o : dados) {
                FaturaTituloNF f = new FaturaTituloNF();
                f.setInfPagamentoNfPropria(o);
                f.setFaturaTitulos(fat);
                fat.getFaturaTituloNF().add(f);
                valorTotal = valorTotal + o.getNotaFiscalPropria().getValoresNfPropria().getValorTotal();
            }
        }
        return valorTotal;
    }

    public FaturaTitulos buildFaturaTitulos(Fornecedor fornecedor, Date dataInicial, Date dataFinal, Date dataFatura, Empresa empresa, CondicoesPagamento condicoesFatura, EnumConstTipoTitulo pagRec, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        FaturaTitulos f = this.buildFaturaTitulos(dataInicial, dataFinal, dataFatura, empresa, pagRec);
        f.setPessoa(fornecedor.getPessoa());
        f.setPlanoConta(this.scPlanoConta.getPlanoConta(fornecedor, opcoes));
        if (ToolMethods.isNotNull((Object)condicoesFatura).booleanValue()) {
            f.setCondicoesPagamento(condicoesFatura);
        } else {
            f.setCondicoesPagamento(fornecedor.getCondicaoPagamento());
        }
        if (TMethods.isNotNull((Object)f.getCondicoesPagamento()).booleanValue()) {
            f.setParcelas(f.getCondicoesPagamento().getParcelasMutante());
        }
        return f;
    }

    public FaturaTitulos buildFaturaTitulos(Cliente cliente, Date dataInicial, Date dataFinal, Date dataFatura, Empresa empresa, CondicoesPagamento condicoesFatura, EnumConstTipoTitulo pagRec, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        FaturaTitulos f = this.buildFaturaTitulos(dataInicial, dataFinal, dataFatura, empresa, pagRec);
        f.setPessoa(cliente.getPessoa());
        f.setPlanoConta(this.scPlanoConta.getPlanoConta(cliente, opcoes));
        if (ToolMethods.isNotNull((Object)condicoesFatura).booleanValue()) {
            f.setCondicoesPagamento(condicoesFatura);
        } else {
            f.setCondicoesPagamento(cliente.getFaturamento().getCondicaoPagamento());
        }
        if (TMethods.isNotNull((Object)f.getCondicoesPagamento()).booleanValue()) {
            f.setParcelas(f.getCondicoesPagamento().getParcelasMutante());
        }
        return f;
    }

    private FaturaTitulos buildFaturaTitulos(Date dataInicial, Date dataFinal, Date dataFatura, Empresa empresa, EnumConstTipoTitulo pagRec) {
        FaturaTitulos f = new FaturaTitulos();
        f.setDataCadastro(new Date());
        f.setDataInicial(dataInicial);
        f.setDataFinal(dataFinal);
        f.setDataFatura(dataFatura);
        f.setEmpresa(empresa);
        if (ToolMethods.isNotNull((Object)pagRec).booleanValue()) {
            f.setPagRec(Short.valueOf(pagRec.getValue()));
        }
        return f;
    }
}

