/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.liberacaonotaterceiros;

import com.touchcomp.basementor.model.vo.ConferenciaNFTerceiros;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.InfAdicionalItemConfNFTerc;
import com.touchcomp.basementor.model.vo.ItemConfNFTerceiros;
import com.touchcomp.basementor.model.vo.ItemLiberacaoNFTerceirosQualidade;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.LiberacaoNFTerceiros;
import com.touchcomp.basementor.model.vo.LiberacaoNFTerceirosFinanceiro;
import com.touchcomp.basementor.model.vo.LiberacaoNFTerceirosFiscal;
import com.touchcomp.basementor.model.vo.LiberacaoNFTerceirosQualidade;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class HelperLiberacaoNotaTerceiros
implements AbstractHelper<NotaFiscalTerceiros> {
    private NotaFiscalTerceiros notaTerceiros;

    public NotaFiscalTerceiros get() {
        return this.notaTerceiros;
    }

    public HelperLiberacaoNotaTerceiros build(NotaFiscalTerceiros data) {
        this.notaTerceiros = data;
        return this;
    }

    public LiberacaoNFTerceirosFinanceiro createLiberacaoFinanceiraNFT(Empresa empresa, Usuario usuario) {
        LiberacaoNFTerceirosFinanceiro vo = new LiberacaoNFTerceirosFinanceiro();
        vo.setConferida(Short.valueOf((short)0));
        vo.setDataCadastro(new Date());
        vo.setDataLiberacao(new Timestamp(new Date().getTime()));
        vo.setEmpresa(empresa);
        vo.setUsuario(usuario);
        LiberacaoNFTerceiros lib = this.notaTerceiros.getLiberacaoNFTerceiros();
        if (lib == null) {
            lib = new LiberacaoNFTerceiros();
            lib.setNotaTerceiros(this.notaTerceiros);
        }
        lib.setLiberacaoFinanceira(vo);
        lib.setNotaTerceiros(this.notaTerceiros);
        vo.setLiberacaoNota(lib);
        this.notaTerceiros.setLiberacaoNFTerceiros(lib);
        return vo;
    }

    public LiberacaoNFTerceirosFiscal createLiberacaoFiscalNFT(Empresa empresa, Usuario usuario) {
        LiberacaoNFTerceirosFiscal vo = new LiberacaoNFTerceirosFiscal();
        vo.setConferida(Short.valueOf((short)0));
        vo.setDataCadastro(new Date());
        vo.setDataLiberacao(new Timestamp(new Date().getTime()));
        vo.setEmpresa(empresa);
        vo.setUsuario(usuario);
        LiberacaoNFTerceiros lib = this.notaTerceiros.getLiberacaoNFTerceiros();
        if (lib == null) {
            lib = new LiberacaoNFTerceiros();
            lib.setNotaTerceiros(this.notaTerceiros);
        }
        lib.setLiberacaoFiscal(vo);
        lib.setNotaTerceiros(this.notaTerceiros);
        vo.setLiberacaoNota(lib);
        this.notaTerceiros.setLiberacaoNFTerceiros(lib);
        return vo;
    }

    public ConferenciaNFTerceiros createLiberacaoEstoqueNFT(Empresa empresa, Usuario usuario) {
        ConferenciaNFTerceiros vo = new ConferenciaNFTerceiros();
        vo.setConferida(Short.valueOf((short)0));
        vo.setDataCadastro(new Date());
        vo.setDataLiberacao(new Timestamp(new Date().getTime()));
        vo.setEmpresa(empresa);
        vo.setUsuario(usuario);
        LiberacaoNFTerceiros lib = this.notaTerceiros.getLiberacaoNFTerceiros();
        if (lib == null) {
            lib = new LiberacaoNFTerceiros();
            lib.setNotaTerceiros(this.notaTerceiros);
        }
        vo.setItemConfNFTerceiros(this.createItemConfNFTerceiros(this.notaTerceiros, vo));
        lib.setLiberacaoEstoque(vo);
        lib.setNotaTerceiros(this.notaTerceiros);
        vo.setLiberacaoNota(lib);
        this.notaTerceiros.setLiberacaoNFTerceiros(lib);
        return vo;
    }

    private List<ItemConfNFTerceiros> createItemConfNFTerceiros(NotaFiscalTerceiros n, ConferenciaNFTerceiros vo) {
        if (n == null) {
            return new ArrayList<ItemConfNFTerceiros>();
        }
        ArrayList<ItemConfNFTerceiros> dados = new ArrayList<ItemConfNFTerceiros>();
        for (ItemNotaTerceiros i : n.getItemNotaTerceiros()) {
            HashMap<GradeCor, Double> h = new HashMap<GradeCor, Double>();
            for (GradeItemNotaTerceiros g : i.getGrade()) {
                if (h.containsKey(g.getGradeCor())) {
                    Double qtdeAnt = (Double)h.get(g.getGradeCor());
                    h.put(g.getGradeCor(), qtdeAnt + g.getQuantidade() * i.getFatorConversao());
                    continue;
                }
                h.put(g.getGradeCor(), g.getQuantidade() * i.getFatorConversao());
            }
            Set set = h.keySet();
            for (GradeCor gradeCor : set) {
                Double qtde = (Double)h.get(gradeCor);
                ItemConfNFTerceiros itemConf = new ItemConfNFTerceiros();
                itemConf.setGradeCor(gradeCor);
                itemConf.setQuantidadeAConferir(qtde);
                itemConf.setConferenciaNFTerceiros(vo);
                dados.add(itemConf);
            }
        }
        return dados;
    }

    public LiberacaoNFTerceirosQualidade createLiberacaoQualidadeNFT(Empresa empresa, Usuario usuario) {
        LiberacaoNFTerceirosQualidade vo = new LiberacaoNFTerceirosQualidade();
        vo.setConferida(Short.valueOf((short)0));
        vo.setDataCadastro(new Date());
        vo.setDataLiberacao(new Timestamp(new Date().getTime()));
        vo.setEmpresa(empresa);
        vo.setUsuario(usuario);
        LiberacaoNFTerceiros lib = this.notaTerceiros.getLiberacaoNFTerceiros();
        if (lib == null) {
            lib = new LiberacaoNFTerceiros();
            lib.setNotaTerceiros(this.notaTerceiros);
        }
        lib.setLiberacaoQualidade(vo);
        lib.setNotaTerceiros(this.notaTerceiros);
        vo.setItensLiberacao(this.createItemConfNFTerceirosQualidade(this.notaTerceiros, vo));
        vo.setLiberacaoNota(lib);
        this.notaTerceiros.setLiberacaoNFTerceiros(lib);
        return vo;
    }

    List<ItemLiberacaoNFTerceirosQualidade> createItemConfNFTerceirosQualidade(NotaFiscalTerceiros notaTerceiros, LiberacaoNFTerceirosQualidade liberacaoQualidade) {
        if (notaTerceiros == null) {
            return new ArrayList<ItemLiberacaoNFTerceirosQualidade>();
        }
        ArrayList<ItemLiberacaoNFTerceirosQualidade> dados = new ArrayList<ItemLiberacaoNFTerceirosQualidade>();
        for (ItemNotaTerceiros i : notaTerceiros.getItemNotaTerceiros()) {
            HashMap<GradeCor, Double> h = new HashMap<GradeCor, Double>();
            for (GradeItemNotaTerceiros g : i.getGrade()) {
                if (h.containsKey(g.getGradeCor())) {
                    Double qtdeAnt = (Double)h.get(g.getGradeCor());
                    h.put(g.getGradeCor(), qtdeAnt + g.getQuantidade() * i.getFatorConversao());
                    continue;
                }
                h.put(g.getGradeCor(), g.getQuantidade() * i.getFatorConversao());
            }
            Set set = h.keySet();
            for (GradeCor gradeCor : set) {
                Double qtde = (Double)h.get(gradeCor);
                dados.add(this.getItemLiberacaoNFTerceirosQualidade(gradeCor, qtde, liberacaoQualidade));
            }
        }
        return dados;
    }

    ItemLiberacaoNFTerceirosQualidade getItemLiberacaoNFTerceirosQualidade(GradeCor gradeCor, Double qtde, LiberacaoNFTerceirosQualidade liberacaoQualidade) {
        ItemLiberacaoNFTerceirosQualidade itemQualidade = new ItemLiberacaoNFTerceirosQualidade();
        itemQualidade.setGradeCor(gradeCor);
        itemQualidade.setQuantidade(qtde);
        itemQualidade.setLiberacaoQualidade(liberacaoQualidade);
        InfAdicionalItemConfNFTerc inf = new InfAdicionalItemConfNFTerc();
        inf.setItemLiberacaoQualidade(itemQualidade);
        itemQualidade.setInfAdicionalItemConfNFTerc(inf);
        return itemQualidade;
    }
}

