/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.lotecontabil;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class HelperLoteContabil
implements AbstractHelper<LoteContabil> {
    private LoteContabil loteContabil;

    public LoteContabil get() {
        return this.loteContabil;
    }

    public HelperLoteContabil build(LoteContabil loteContabil) {
        this.loteContabil = loteContabil;
        return this;
    }

    public LoteContabil criaRecriaLoteContabil(Date dataLote, Empresa emp, ConstEnumOrigemLoteContabil origem) {
        return this.criaRecriaLoteContabil(null, dataLote, emp.getEmpresaDados().getGrupoEmpresa(), origem);
    }

    public LoteContabil criaRecriaLoteContabil(Date dataLote, GrupoEmpresa grupoEmp, ConstEnumOrigemLoteContabil origem) {
        return this.criaRecriaLoteContabil(null, dataLote, grupoEmp, origem);
    }

    public LoteContabil criaRecriaLoteContabil(LoteContabil lote, Date dataLote, Empresa emp, ConstEnumOrigemLoteContabil origem) {
        return this.criaRecriaLoteContabil(lote, dataLote, emp.getEmpresaDados().getGrupoEmpresa(), origem);
    }

    public LoteContabil criaRecriaLoteContabil(LoteContabil lote, Date dataLote, GrupoEmpresa grupoEmp, ConstEnumOrigemLoteContabil origem) {
        if (lote == null) {
            lote = new LoteContabil();
            lote.setLancamentos(new ArrayList());
        } else {
            lote.getLancamentos().clear();
        }
        lote.setDataLote(dataLote);
        lote.setGrupoEmpresa(grupoEmp);
        lote.setDataCadastro(new Date());
        lote.setIndicador(Integer.valueOf(EnumConstantsMentorSimNao.NAO.value));
        lote.setOrigem(origem.getValue());
        if (TMethods.isEquals((Object)origem, (Object)ConstEnumOrigemLoteContabil.ENCERRAMENTO_CONTABIL)) {
            lote.setIndicador(Integer.valueOf(1));
        }
        return lote;
    }
}

