/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.lotefabricacao;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.FichaTecnicaLoteFabricacao;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.ModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementor.model.vo.ValoresFichaLoteFab;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import org.springframework.stereotype.Component;

@Component
public class HelperLoteFabricacao
extends BaseMethods
implements AbstractHelper<LoteFabricacao> {
    private LoteFabricacao loteFabricacao;

    public LoteFabricacao get() {
        return this.loteFabricacao;
    }

    public HelperLoteFabricacao build(LoteFabricacao object) {
        this.loteFabricacao = object;
        return this;
    }

    public FichaTecnicaLoteFabricacao novaFichaTecnica(ModeloFichaTecnica modelo, Usuario user) {
        FichaTecnicaLoteFabricacao f = new FichaTecnicaLoteFabricacao();
        f.setModeloFichaTecnica(modelo);
        f.setLoteFabricacao(this.loteFabricacao);
        f.setUsuario(user);
        for (ItemModeloFichaTecnica item : modelo.getItensModeloFichaTecnica()) {
            ValoresFichaLoteFab v = new ValoresFichaLoteFab();
            v.setChave(item.getDescricao());
            v.setFichaTecnica(f);
            v.setItemModeloFichaTecnica(item);
            v.setValor(item.getValorSugerido());
            v.setValorObrigatorio(item.getCampoObrigatorio());
            f.getValoresFicha().add(v);
        }
        return f;
    }

    public LoteFabricacao getLoteUnico(GradeCor gradeCor) {
        return this.getLoteUnico(gradeCor.getProdutoGrade().getProduto());
    }

    public LoteFabricacao getLoteUnico(Produto produto) {
        LoteFabricacao lote = new LoteFabricacao();
        lote.setLoteFabricacao("UNICO");
        lote.setProduto(produto);
        lote.setUnico(Short.valueOf((short)1));
        this.setStatusLoteFabricacao(lote, produto);
        return lote;
    }

    public LoteFabricacao getLote(Produto produto, String nrLoteFab) {
        LoteFabricacao lote = new LoteFabricacao();
        lote.setLoteFabricacao(nrLoteFab);
        lote.setProduto(produto);
        lote.setUnico(Short.valueOf((short)0));
        this.setStatusLoteFabricacao(lote, produto);
        return lote;
    }

    public LoteFabricacao getLoteAuto(Produto produto) {
        LoteFabricacao lote = this.getLote(produto, "");
        lote.setConfiGerarLoteAuto(produto.getConfigGerarLoteAuto());
        if (this.isNotNull(lote.getConfiGerarLoteAuto()).booleanValue()) {
            lote.setLoteFabricacao("Lote sera gerado automaticamente ao salvar");
        }
        return lote;
    }

    private void setStatusLoteFabricacao(LoteFabricacao lote, Produto produto) {
        lote.setStatusLoteFabricacao(produto.getStatusLoteFabricacao());
        if (this.isEquals(produto.getStatusLoteFabricacao().getLoteBloqueado(), EnumConstantsMentorSimNao.SIM.getValue())) {
            lote.setLoteBloqueado(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        } else if (this.isEquals(produto.getStatusLoteFabricacao().getLoteBloqueado(), EnumConstantsMentorSimNao.NAO.getValue())) {
            lote.setLoteBloqueado(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        }
    }
}

