/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.manifestocteeletronico;

import com.touchcomp.basementor.model.vo.ManifestoCteEletronico;
import com.touchcomp.basementorxml.model.XMLManifestoCte;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLManifestoCTe;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperManifestoCteEletronico {
    @Autowired
    ServiceXMLManifestoCTe serviceXMLManifestoCTes;

    public String toXMLString(ManifestoCteEletronico manifesto) throws Exception {
        try {
            System.out.println("\n\n Nr. Manifesto: " + manifesto.getNumero() + " ID:" + manifesto.getIdentificador() + "\n\n");
            SAXBuilder sb = new SAXBuilder();
            SAXBuilder sb1 = new SAXBuilder();
            XMLManifestoCte xml = this.serviceXMLManifestoCTes.getXMLManifestoCte(manifesto.getIdentificador());
            if (xml == null || xml.getConteudoXML() == null) {
                throw new Exception("Nota sem arquivo xml.");
            }
            Document d = sb.build((InputStream)new ByteArrayInputStream(xml.getConteudoXML().getBytes()));
            Element e = null;
            if (xml.getConteudoAprovacao() != null) {
                Document a = sb1.build((InputStream)new ByteArrayInputStream(xml.getConteudoAprovacao().getBytes()));
                e = a.detachRootElement();
            }
            Element mdfeProc = new Element("mdfeProc");
            Attribute at = new Attribute("versao", manifesto.getVersaoManifestoCte().getCodigo());
            mdfeProc.setAttribute(at);
            mdfeProc.setNamespace(Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/mdfe"));
            Element root = d.detachRootElement();
            mdfeProc.addContent((Content)root);
            if (e != null) {
                mdfeProc.addContent((Content)e);
            }
            return new XMLOutputter().outputString(mdfeProc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception("Erro ao exportar o arquivo." + ex.getMessage());
        }
    }
}

