/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.manutencaorotinasperiodicas;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ExamePeriodo;
import com.touchcomp.basementor.model.vo.ItemManutencaoRotinasPessoas;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Veiculo;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.service.impl.colaborador.ServiceColaboradorImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperManutencaoRotinasPeriodicas
extends BaseMethods {
    @Autowired
    private ServiceColaboradorImpl serviceColaborador;

    private boolean verificarExistePessoa(List<ItemManutencaoRotinasPessoas> listManutencao, Pessoa pessoa, ExamePeriodo rotinaPeriodicas) {
        Optional<ItemManutencaoRotinasPessoas> optional = listManutencao.stream().filter(i -> this.isEquals(i.getPessoa(), pessoa) && this.isEquals(i.getRotina(), rotinaPeriodicas)).findFirst();
        return !optional.isPresent();
    }

    private boolean verificarExisteVeiculo(List<ItemManutencaoRotinasPessoas> listManutencao, Veiculo veiculo, ExamePeriodo rotinaPeriodicas) {
        Optional<ItemManutencaoRotinasPessoas> optional = listManutencao.stream().filter(i -> this.isEquals(i.getVeiculo(), veiculo) && this.isEquals(i.getRotina(), rotinaPeriodicas)).findFirst();
        return !optional.isPresent();
    }

    private void processaManutencaoFuncao(ExamePeriodo rotinaPeriodicas, List<Colaborador> listFuncao, List<ItemManutencaoRotinasPessoas> listManutencao) {
        if (TMethods.isWithData(listFuncao)) {
            for (Colaborador c : listFuncao) {
                if (!this.verificarExistePessoa(listManutencao, c.getPessoa(), rotinaPeriodicas)) continue;
                ItemManutencaoRotinasPessoas i = new ItemManutencaoRotinasPessoas();
                i.setPessoa(c.getPessoa());
                i.setFuncao(c.getFuncao());
                i.setRotina(rotinaPeriodicas);
                i.setQtdOcorrenciaRealizada(Long.valueOf(1L));
                if (rotinaPeriodicas != null && rotinaPeriodicas.getClassificacao() != null) {
                    i.setPossuiInformacaoAdicional(rotinaPeriodicas.getClassificacao().getPossuiInformacaoAdicional());
                }
                listManutencao.add(i);
            }
        }
    }

    private void processaManutencaoPessoa(ExamePeriodo rotinaPeriodicas, List<Pessoa> listPessoa, List<ItemManutencaoRotinasPessoas> listManutencao) {
        if (TMethods.isWithData(listPessoa)) {
            for (Pessoa p : listPessoa) {
                if (!this.verificarExistePessoa(listManutencao, p, rotinaPeriodicas)) continue;
                ItemManutencaoRotinasPessoas i = new ItemManutencaoRotinasPessoas();
                i.setPessoa(p);
                Colaborador c = this.serviceColaborador.getColaboradorByPessoa(p);
                if (c != null) {
                    i.setFuncao(c.getFuncao());
                }
                i.setRotina(rotinaPeriodicas);
                i.setQtdOcorrenciaRealizada(Long.valueOf(1L));
                if (rotinaPeriodicas != null && rotinaPeriodicas.getClassificacao() != null) {
                    i.setPossuiInformacaoAdicional(rotinaPeriodicas.getClassificacao().getPossuiInformacaoAdicional());
                }
                listManutencao.add(i);
            }
        }
    }

    private void processaManutencaoVeiculo(ExamePeriodo rotinaPeriodicas, List<Veiculo> listVeiculo, List<ItemManutencaoRotinasPessoas> listManutencao) {
        if (TMethods.isWithData(listVeiculo)) {
            for (Veiculo v : listVeiculo) {
                if (!this.verificarExisteVeiculo(listManutencao, v, rotinaPeriodicas)) continue;
                ItemManutencaoRotinasPessoas i = new ItemManutencaoRotinasPessoas();
                i.setVeiculo(v);
                i.setRotina(rotinaPeriodicas);
                i.setQtdOcorrenciaRealizada(Long.valueOf(1L));
                if (rotinaPeriodicas != null && rotinaPeriodicas.getClassificacao() != null) {
                    i.setPossuiInformacaoAdicional(rotinaPeriodicas.getClassificacao().getPossuiInformacaoAdicional());
                }
                listManutencao.add(i);
            }
        }
    }

    private void processaManutencaoFuncaoPessoaVeiculoVencida(ExamePeriodo rotinaPeriodicas, List<ItemManutencaoRotinasPessoas> listFuncaoPessoaVeiculoVencida, List<ItemManutencaoRotinasPessoas> listManutencao) {
        if (TMethods.isWithData(listFuncaoPessoaVeiculoVencida)) {
            for (ItemManutencaoRotinasPessoas m : listFuncaoPessoaVeiculoVencida) {
                Colaborador c;
                if (!this.verificarExistePessoa(listManutencao, m.getPessoa(), rotinaPeriodicas) || !this.verificarExisteVeiculo(listManutencao, m.getVeiculo(), rotinaPeriodicas)) continue;
                ItemManutencaoRotinasPessoas i = new ItemManutencaoRotinasPessoas();
                i.setPessoa(m.getPessoa());
                if (i.getPessoa() != null && (c = this.serviceColaborador.getColaboradorByPessoa(i.getPessoa())) != null) {
                    i.setFuncao(c.getFuncao());
                }
                i.setVeiculo(m.getVeiculo());
                i.setRotina(rotinaPeriodicas);
                i.setQtdOcorrenciaRealizada(Long.valueOf(m.getQtdOcorrenciaRealizada() + 1L));
                i.setItemAnterior(m);
                if (rotinaPeriodicas != null && rotinaPeriodicas.getClassificacao() != null) {
                    i.setPossuiInformacaoAdicional(rotinaPeriodicas.getClassificacao().getPossuiInformacaoAdicional());
                }
                listManutencao.add(i);
            }
        }
    }

    public void getItensManutencao(List<Colaborador> listFuncao, List<Pessoa> listPessoa, List<Veiculo> listVeiculo, List<ItemManutencaoRotinasPessoas> listFuncaoPessoaVeiculoVencida, List<ItemManutencaoRotinasPessoas> listManutencao, ExamePeriodo rotinaPeriodicas) {
        this.processaManutencaoFuncao(rotinaPeriodicas, listFuncao, listManutencao);
        this.processaManutencaoPessoa(rotinaPeriodicas, listPessoa, listManutencao);
        this.processaManutencaoVeiculo(rotinaPeriodicas, listVeiculo, listManutencao);
        this.processaManutencaoFuncaoPessoaVeiculoVencida(rotinaPeriodicas, listFuncaoPessoaVeiculoVencida, listManutencao);
    }
}

