/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.metadashboardgerencial;

import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencialTipoData;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.metadashboardgerencial.EnumConstantsControleGerencial;
import com.touchcomp.basementor.model.impl.SaldoContaGerencial;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.IndiceGerencial;
import com.touchcomp.basementor.model.vo.IntervaloControleGer;
import com.touchcomp.basementor.model.vo.IntervaloControleGerPer;
import com.touchcomp.basementor.model.vo.LinhasIndiceGerencial;
import com.touchcomp.basementor.model.vo.MetaControleGerLinha;
import com.touchcomp.basementor.model.vo.MetaControleGerLinhaVlr;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementorservice.service.impl.centrocusto.ServiceCentroCustoImpl;
import com.touchcomp.basementorservice.service.impl.planocontagerencial.ServicePlanoContaGerencialImpl;
import com.touchcomp.basementorservice.service.impl.saldocontagerencial.ServiceSaldoContaGerencialImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.vo.indicegerencial.DTOIndiceGerencialParamsVarCentroCusto;
import com.touchcomp.touchvomodel.vo.metacontrolegerencial.web.DTOMetaControleGerencial;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class HelperMetaDashboardGerencial {
    public LinkedList<MetaControleGerLinha> calcularMensal(DTOMetaControleGerencial input, IntervaloControleGer intervaloControleGer, IndiceGerencial indiceGerencial) {
        LinkedList link = this.getPlanoContas(indiceGerencial, input);
        for (IntervaloControleGerPer per : intervaloControleGer.getIntervalos()) {
            this.processData(link, per);
        }
        if (input.getCalcularHistorico() != null && input.getCalcularHistorico() == 1) {
            this.setMetasAnteriores(intervaloControleGer, input, link);
        }
        return link;
    }

    private LinkedList getPlanoContas(IndiceGerencial indiceGerencial, DTOMetaControleGerencial input) {
        LinkedList linhas = new LinkedList();
        for (Object obj : indiceGerencial.getLinhas()) {
            LinhasIndiceGerencial linha = (LinhasIndiceGerencial)obj;
            String exp = this.getReplaceCentroCustoExpressao(linha.getExpressao(), input);
            this.getPCCentroCusto(linhas, exp, input);
        }
        return linhas;
    }

    private String getReplaceCentroCustoExpressao(String expressao, DTOMetaControleGerencial input) {
        if (expressao == null) {
            return "";
        }
        List token = ToolString.getReplaceTokens((String)expressao);
        HashMap m = new HashMap();
        for (Object o : token) {
            StringToken sk = (StringToken)o;
            String valorCentroCustoVariavel = this.getReplaceExpressao(sk.getChave(), input);
            if (valorCentroCustoVariavel == null) continue;
            expressao = expressao.replaceAll(sk.getChave(), valorCentroCustoVariavel);
        }
        return expressao;
    }

    private String getReplaceExpressao(String chave, DTOMetaControleGerencial input) {
        if (chave.startsWith("plano.conta")) {
            String cc;
            String temp = chave.substring(0, 27);
            String codigoPC = chave.substring(chave.indexOf("_") + 1);
            String centroCusto = null;
            if (codigoPC.indexOf("_") > 0) {
                int aux = codigoPC.indexOf("_");
                centroCusto = codigoPC.substring(aux + 1);
            }
            if ((cc = this.getTextoCentroCusto(centroCusto, input)) != null) {
                return temp + "_" + cc;
            }
        }
        return null;
    }

    private String getTextoCentroCusto(String centroCusto, DTOMetaControleGerencial input) {
        if (centroCusto != null) {
            Boolean isCodigo = true;
            try {
                Long l = Long.parseLong(centroCusto);
            }
            catch (NumberFormatException ex) {
                isCodigo = false;
            }
            if (centroCusto.trim().length() == 9 && isCodigo.booleanValue()) {
                return null;
            }
            for (DTOIndiceGerencialParamsVarCentroCusto o : input.getVarCentroCusto()) {
                if (!ToolMethods.isEquals((Object)o.getCentroCustoCodigo(), (Object)centroCusto)) continue;
                return o.getCentroCustoCodigo();
            }
        }
        return null;
    }

    private void getPCCentroCusto(LinkedList linhas, String exp, DTOMetaControleGerencial input) {
        if (exp == null) {
            return;
        }
        List token = ToolString.getReplaceTokens((String)exp);
        for (Object o : token) {
            StringToken sk = (StringToken)o;
            this.getFixedValue(sk.getChave(), linhas, input);
        }
    }

    private Object getFixedValue(String chave, LinkedList linhas, DTOMetaControleGerencial input) {
        if (chave.startsWith("plano.conta")) {
            String codigoPC = chave.substring(chave.indexOf("_") + 1);
            String centroCusto = null;
            if (codigoPC.indexOf("_") > 0) {
                int aux = codigoPC.indexOf("_");
                centroCusto = codigoPC.substring(aux + 1);
                codigoPC = codigoPC.substring(0, aux);
            }
            PlanoContaGerencial pc = ((ServicePlanoContaGerencialImpl)ConfApplicationContext.getBean(ServicePlanoContaGerencialImpl.class)).findByCodigo(codigoPC);
            CentroCusto cc = this.getCentroCusto(centroCusto, input);
            this.criaAddPCGer(pc, cc, linhas);
        }
        return null;
    }

    private CentroCusto getCentroCusto(String centroCusto, DTOMetaControleGerencial input) {
        if (centroCusto == null) {
            return null;
        }
        ServiceCentroCustoImpl serviceCentroCusto = (ServiceCentroCustoImpl)ConfApplicationContext.getBean(ServiceCentroCustoImpl.class);
        if (ToolMethods.isStrWithDataLength((String)centroCusto, (int)9) && ToolString.isAIntegerNumber((String)centroCusto)) {
            return serviceCentroCusto.findByCodigo(centroCusto);
        }
        if (ToolString.isAIntegerNumber((String)centroCusto)) {
            return (CentroCusto)serviceCentroCusto.get(Long.valueOf(centroCusto));
        }
        for (DTOIndiceGerencialParamsVarCentroCusto o : input.getVarCentroCusto()) {
            if (!ToolMethods.isEquals((Object)o.getVariavel(), (Object)centroCusto)) continue;
            return ((ServiceCentroCustoImpl)ConfApplicationContext.getBean(ServiceCentroCustoImpl.class)).findByCodigo(o.getCentroCustoCodigo());
        }
        return null;
    }

    private void criaAddPCGer(PlanoContaGerencial pc, CentroCusto cc, LinkedList<MetaControleGerLinha> linhas) {
        if (pc == null) {
            return;
        }
        boolean achou = false;
        for (MetaControleGerLinha aux : linhas) {
            boolean b = pc.equals((Object)aux.getPlanoContaGerencial());
            b = b && aux.getCentroCusto() == null && cc == null ? true : b && cc != null && aux.getCentroCusto() != null && aux.getCentroCusto().equals((Object)cc);
            if (!b) continue;
            achou = b;
            break;
        }
        if (!achou) {
            MetaControleGerLinha m = new MetaControleGerLinha();
            m.setCentroCusto(cc);
            m.setPlanoContaGerencial(pc);
            linhas.add(m);
        }
    }

    private void processData(LinkedList<MetaControleGerLinha> link, IntervaloControleGerPer per) {
        for (MetaControleGerLinha aux : link) {
            MetaControleGerLinhaVlr valores = new MetaControleGerLinhaVlr();
            valores.setValorMeta(Double.valueOf(0.0));
            valores.setIntervaloControleGerPer(per);
            aux.getValoresLinhas().add(valores);
        }
    }

    private void setMetasAnteriores(IntervaloControleGer intervaloControleGer, DTOMetaControleGerencial input, LinkedList<MetaControleGerLinha> link) {
        if (input.getTipoHistorico().shortValue() == EnumConstantsControleGerencial.TIPO_META_CONTROLE_MEDIA.getValue()) {
            this.setarMediaMeta(input, link);
        } else {
            this.setarMediaMesmoPeriodo(intervaloControleGer, input, link);
        }
    }

    private void setarMediaMeta(DTOMetaControleGerencial input, LinkedList<MetaControleGerLinha> link) {
        EnumTipoLancamentoCTBGerencial tipoLacamento = EnumTipoLancamentoCTBGerencial.LIQUIDACAO;
        if (ToolMethods.isEquals((Object)input.getTipoLancamento(), (Object)EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue())) {
            tipoLacamento = EnumTipoLancamentoCTBGerencial.COMPETENCIA;
        }
        Short tipoData = EnumLancamentoCTBGerencialTipoData.TIPO_DATA_PREVISTA.getValue();
        if (ToolMethods.isEquals((Object)input.getTipoLancamento(), (Object)EnumLancamentoCTBGerencialTipoData.TIPO_DATA_CADASTRO_COMP.getValue())) {
            tipoData = EnumLancamentoCTBGerencialTipoData.TIPO_DATA_CADASTRO_COMP.getValue();
        }
        List<SaldoContaGerencial> saldosMedios = ((ServiceSaldoContaGerencialImpl)ConfApplicationContext.getBean(ServiceSaldoContaGerencialImpl.class)).findSaldoGerencial(input.getDataInicial(), input.getDataFinal(), "010000000000000", "999999999999999", input.getEmpresaInicialIdentificador(), input.getEmpresaFinalIdentificador(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue(), tipoLacamento, tipoData);
        this.setSaldo(link, saldosMedios, input.getPercReajuste());
    }

    private void setSaldo(LinkedList<MetaControleGerLinha> link, List saldosMedios, Double percReajuste) {
        for (Object e : link) {
            SaldoContaGerencial saldo;
            MetaControleGerLinha meta = (MetaControleGerLinha)e;
            if (meta.getCentroCusto() != null || (saldo = this.getSaldo(meta.getPlanoContaGerencial(), saldosMedios)) == null) continue;
            for (MetaControleGerLinhaVlr m : meta.getValoresLinhas()) {
                Double saldoAtual = saldo.getSaldoAtual() / (double)meta.getValoresLinhas().size();
                m.setValorMeta(Double.valueOf(saldoAtual + percReajuste / 100.0 * saldoAtual));
            }
        }
    }

    private SaldoContaGerencial getSaldo(PlanoContaGerencial planoContaGerencial, List saldosMedios) {
        if (saldosMedios == null) {
            return null;
        }
        for (Object o : saldosMedios) {
            SaldoContaGerencial s = (SaldoContaGerencial)o;
            if (!planoContaGerencial.getCodigo().trim().equalsIgnoreCase(s.getCodigo().trim())) continue;
            return s;
        }
        return null;
    }

    private void setarMediaMesmoPeriodo(IntervaloControleGer intervaloControleGer, DTOMetaControleGerencial input, LinkedList<MetaControleGerLinha> link) {
        HashMap saldos = this.getSaldos(intervaloControleGer, input);
        for (Object e : link) {
            MetaControleGerLinha meta = (MetaControleGerLinha)e;
            if (meta.getCentroCusto() != null) continue;
            for (MetaControleGerLinhaVlr m : meta.getValoresLinhas()) {
                List saldosGerenciais = (List)saldos.get(m.getIntervaloControleGerPer());
                SaldoContaGerencial saldo = this.getSaldo(meta.getPlanoContaGerencial(), saldosGerenciais);
                if (saldo == null) continue;
                m.setValorMeta(Double.valueOf(saldo.getSaldoAtual() + input.getPercReajuste() / 100.0 * saldo.getSaldoAtual()));
            }
        }
    }

    private HashMap getSaldos(IntervaloControleGer intervaloControleGer, DTOMetaControleGerencial input) {
        HashMap<IntervaloControleGerPer, List<SaldoContaGerencial>> saldos = new HashMap<IntervaloControleGerPer, List<SaldoContaGerencial>>();
        EnumTipoLancamentoCTBGerencial tipoLacamento = EnumTipoLancamentoCTBGerencial.LIQUIDACAO;
        if (ToolMethods.isEquals((Object)input.getTipoLancamento(), (Object)EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue())) {
            tipoLacamento = EnumTipoLancamentoCTBGerencial.COMPETENCIA;
        }
        Short tipoData = EnumLancamentoCTBGerencialTipoData.TIPO_DATA_PREVISTA.getValue();
        if (ToolMethods.isEquals((Object)input.getTipoLancamento(), (Object)EnumLancamentoCTBGerencialTipoData.TIPO_DATA_CADASTRO_COMP.getValue())) {
            tipoData = EnumLancamentoCTBGerencialTipoData.TIPO_DATA_CADASTRO_COMP.getValue();
        }
        for (IntervaloControleGerPer per : intervaloControleGer.getIntervalos()) {
            List<SaldoContaGerencial> saldosMedios = ((ServiceSaldoContaGerencialImpl)ConfApplicationContext.getBean(ServiceSaldoContaGerencialImpl.class)).findSaldoGerencial(this.getDataAnoAnterior(per.getDataInicial()), this.getDataAnoAnterior(per.getDataFinal()), "010000000000000", "999999999999999", input.getEmpresaInicialIdentificador(), input.getEmpresaFinalIdentificador(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue(), tipoLacamento, tipoData);
            saldos.put(per, saldosMedios);
        }
        return saldos;
    }

    private Date getDataAnoAnterior(Date dataInicial) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(dataInicial);
        gc.set(1, gc.get(1) - 1);
        return gc.getTime();
    }
}

