/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.modelofiscal;

import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalIpi;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NaturezaOperacaoModFiscal;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.UnidadeFederativaOrigDest;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.helpers.impl.unidadefatcliente.HelperUnidadeFatCliente;
import com.touchcomp.basementorservice.helpers.impl.unidadefatfornecedor.HelperUnidadeFatFornecedor;
import com.touchcomp.basementorservice.service.impl.modelofiscal.ServiceModeloFiscalImpl;
import com.touchcomp.basementorservice.service.impl.unidadefederativaorigdest.ServiceUnidadeFederativaOrigDestImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.modelofiscal.web.DTOModeloFiscalProdutoRes;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperModeloFiscal
implements AbstractHelper<ModeloFiscal> {
    private ModeloFiscal modeloFiscal;
    @Autowired
    HelperUnidadeFatCliente helperUnidadeFatCliente;
    @Autowired
    HelperUnidadeFatFornecedor helperUnidadeFatFornecedor;
    @Autowired
    ServiceModeloFiscalImpl serviceModeloFiscal;
    @Autowired
    ServiceUnidadeFederativaOrigDestImpl serviceUnidadeFederativaOrigDestImpl;

    public ModeloFiscal get() {
        return this.modeloFiscal;
    }

    public HelperModeloFiscal build(ModeloFiscal data) {
        this.modeloFiscal = data;
        return this;
    }

    public void setOpcaoDisponivelNFCe() {
        Optional<NaturezaOperacaoModFiscal> found = this.modeloFiscal.getNaturezaOperacao().stream().filter(i -> ToolMethods.isEquals((Object)i.getNaturezaOperacao().getNatOperacaoDispNFCe(), (Object)1)).findFirst();
        short opcao = 0;
        if (found.isPresent()) {
            opcao = 1;
        }
        this.setOpcaoDisponivelNFCe(opcao);
    }

    public void setOpcaoDisponivelNFCe(Short opcao) {
        this.modeloFiscal.setDisponivelNFCe(opcao);
        this.modeloFiscal.getNaturezaOperacao().forEach(i -> i.setDisponivelNFCe(this.modeloFiscal.getDisponivelNFCe()));
        this.modeloFiscal.getObservacoesFisco().forEach(i -> i.setDisponivelNFCe(this.modeloFiscal.getDisponivelNFCe()));
        this.modeloFiscal.getObservacoesContrib().forEach(i -> i.setDisponivelNFCe(this.modeloFiscal.getDisponivelNFCe()));
        this.modeloFiscal.getCategoriaPessoa().forEach(i -> i.setDisponivelNFCe(this.modeloFiscal.getDisponivelNFCe()));
        this.modeloFiscal.getEmpresas().forEach(i -> i.setDisponivelNFCe(this.modeloFiscal.getDisponivelNFCe()));
        this.modeloFiscal.getNcms().forEach(i -> i.setDisponivelNFCe(this.modeloFiscal.getDisponivelNFCe()));
        this.modeloFiscal.getUnidadeFederativas().forEach(i -> i.setDisponivelNFCe(this.modeloFiscal.getDisponivelNFCe()));
        if (this.modeloFiscal.getModeloFiscalProduto() != null) {
            this.modeloFiscal.getModeloFiscalProduto().getProduto().forEach(i -> i.setDisponivelNFCe(this.modeloFiscal.getDisponivelNFCe()));
            this.modeloFiscal.getModeloFiscalProduto().setDisponivelNFCe(this.modeloFiscal.getDisponivelNFCe());
        }
    }

    public ModeloFiscal getFirst(Produto produto, UnidadeFatCliente unidade, NaturezaOperacao naturezaOperacao, Empresa empresa) throws ExceptionObjNotFound {
        Short habilitarSuframa;
        Short contribuinteEstado;
        String cnpj;
        UnidadeFederativa uf;
        ModeloFiscal mf;
        CategoriaPessoa categoriaPessoa = unidade.getCategoriaPessoa();
        if (categoriaPessoa == null) {
            categoriaPessoa = unidade.getCliente().getFaturamento().getCategoriaPessoa();
        }
        if ((mf = this.serviceModeloFiscal.getFirst(produto, categoriaPessoa, uf = unidade.getPessoa().getEndereco().getCidade().getUf(), naturezaOperacao, cnpj = unidade.getCliente().getPessoa().getComplemento().getCnpj(), contribuinteEstado = this.helperUnidadeFatCliente.build(unidade).getContribuinteEstado(), habilitarSuframa = unidade.getCliente().getPessoa().getComplemento().getHabilitarSuframa(), empresa)) == null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.0103.003", new Object[]{empresa, naturezaOperacao, produto, uf, categoriaPessoa, contribuinteEstado, habilitarSuframa}));
        }
        return mf;
    }

    public List<ModeloFiscal> getModelosFiscais(Produto produto, UnidadeFatCliente unidade, NaturezaOperacao naturezaOperacao, Empresa empresa) throws ExceptionObjNotFound {
        Short habilitarSuframa;
        Short contribuinteEstado;
        String cnpj;
        UnidadeFederativa uf;
        List<ModeloFiscal> modelos;
        if (produto == null || naturezaOperacao == null || unidade == null || empresa == null) {
            return new LinkedList<ModeloFiscal>();
        }
        CategoriaPessoa categoriaPessoa = unidade.getCategoriaPessoa();
        if (categoriaPessoa == null) {
            categoriaPessoa = unidade.getCliente().getFaturamento().getCategoriaPessoa();
        }
        if ((modelos = this.serviceModeloFiscal.get(categoriaPessoa, produto, uf = unidade.getPessoa().getEndereco().getCidade().getUf(), naturezaOperacao, cnpj = unidade.getCliente().getPessoa().getComplemento().getCnpj(), contribuinteEstado = this.helperUnidadeFatCliente.build(unidade).getContribuinteEstado(), habilitarSuframa = unidade.getCliente().getPessoa().getComplemento().getHabilitarSuframa(), empresa)) == null || modelos.isEmpty()) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.0103.001", new Object[]{empresa, naturezaOperacao, uf, categoriaPessoa, contribuinteEstado, habilitarSuframa}));
        }
        return modelos;
    }

    public List<ModeloFiscal> getModelosFiscais(Produto produto, Cliente cliente, NaturezaOperacao naturezaOperacao, Empresa empresa) throws ExceptionObjNotFound {
        Short habilitarSuframa;
        Short contribuinteEstado;
        String cnpj;
        UnidadeFederativa uf;
        if (produto == null || naturezaOperacao == null || cliente == null || empresa == null) {
            return new LinkedList<ModeloFiscal>();
        }
        CategoriaPessoa categoriaPessoa = cliente.getFaturamento().getCategoriaPessoa();
        List<ModeloFiscal> modelos = this.serviceModeloFiscal.get(categoriaPessoa, produto, uf = cliente.getPessoa().getEndereco().getCidade().getUf(), naturezaOperacao, cnpj = cliente.getPessoa().getComplemento().getCnpj(), contribuinteEstado = this.helperUnidadeFatCliente.getContribuinteEstado(cliente), habilitarSuframa = cliente.getPessoa().getComplemento().getHabilitarSuframa(), empresa);
        if (modelos == null || modelos.isEmpty()) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.0103.001", new Object[]{empresa, naturezaOperacao, uf, categoriaPessoa, contribuinteEstado, habilitarSuframa}));
        }
        return modelos;
    }

    public ModeloFiscal getFirst(Produto produto, UnidadeFatFornecedor unidade, NaturezaOperacao naturezaOperacao, Empresa empresa) throws ExceptionObjNotFound {
        Short habilitarSuframa;
        Short contribuinteEstado;
        String cnpj;
        UnidadeFederativa uf;
        ModeloFiscal mf;
        CategoriaPessoa categoriaPessoa = unidade.getCategoriaPessoa();
        if (categoriaPessoa == null) {
            categoriaPessoa = unidade.getFornecedor().getCategoriaPessoa();
        }
        if ((mf = this.serviceModeloFiscal.getFirst(produto, categoriaPessoa, uf = unidade.getPessoa().getEndereco().getCidade().getUf(), naturezaOperacao, cnpj = unidade.getFornecedor().getPessoa().getComplemento().getCnpj(), contribuinteEstado = this.helperUnidadeFatFornecedor.build(unidade).getContribuinteEstado(), habilitarSuframa = unidade.getFornecedor().getPessoa().getComplemento().getHabilitarSuframa(), empresa)) == null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.0103.001", new Object[]{empresa, naturezaOperacao, uf, categoriaPessoa, contribuinteEstado, habilitarSuframa}));
        }
        return mf;
    }

    public List<ModeloFiscal> getModelosFiscais(Produto produto, UnidadeFatFornecedor unidade, NaturezaOperacao naturezaOperacao, Empresa empresa) throws ExceptionObjNotFound {
        Short habilitarSuframa;
        Short contribuinteEstado;
        String cnpj;
        UnidadeFederativa uf;
        List<ModeloFiscal> modelos;
        if (produto == null || naturezaOperacao == null || unidade == null || empresa == null) {
            return new LinkedList<ModeloFiscal>();
        }
        CategoriaPessoa categoriaPessoa = unidade.getCategoriaPessoa();
        if (categoriaPessoa == null) {
            categoriaPessoa = unidade.getFornecedor().getCategoriaPessoa();
        }
        if ((modelos = this.serviceModeloFiscal.get(categoriaPessoa, produto, uf = unidade.getPessoa().getEndereco().getCidade().getUf(), naturezaOperacao, cnpj = unidade.getFornecedor().getPessoa().getComplemento().getCnpj(), contribuinteEstado = this.helperUnidadeFatFornecedor.build(unidade).getContribuinteEstado(), habilitarSuframa = unidade.getFornecedor().getPessoa().getComplemento().getHabilitarSuframa(), empresa)) == null || modelos.isEmpty()) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.0103.001", new Object[]{empresa, naturezaOperacao, uf, categoriaPessoa, contribuinteEstado, habilitarSuframa}));
        }
        return modelos;
    }

    public List<ModeloFiscal> getModelosFiscais(Produto produto, Fornecedor fornecedor, NaturezaOperacao naturezaOperacao, Empresa empresa) throws ExceptionObjNotFound {
        Short habilitarSuframa;
        Short contribuinteEstado;
        String cnpj;
        UnidadeFederativa uf;
        if (produto == null || naturezaOperacao == null || fornecedor == null || empresa == null) {
            return new LinkedList<ModeloFiscal>();
        }
        CategoriaPessoa categoriaPessoa = fornecedor.getCategoriaPessoa();
        List<ModeloFiscal> modelos = this.serviceModeloFiscal.get(categoriaPessoa, produto, uf = fornecedor.getPessoa().getEndereco().getCidade().getUf(), naturezaOperacao, cnpj = fornecedor.getPessoa().getComplemento().getCnpj(), contribuinteEstado = this.helperUnidadeFatFornecedor.getContribuinteEstado(fornecedor), habilitarSuframa = fornecedor.getPessoa().getComplemento().getHabilitarSuframa(), empresa);
        if (modelos == null || modelos.isEmpty()) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.0103.001", new Object[]{empresa, naturezaOperacao, uf, categoriaPessoa, contribuinteEstado, habilitarSuframa}));
        }
        return modelos;
    }

    public List<DTOModeloFiscalProdutoRes> getModelosFiscaisCotacao(Produto produto, UnidadeFatFornecedor unidade, NaturezaOperacao naturezaOperacao, Empresa empresa) throws ExceptionObjNotFound {
        ArrayList<DTOModeloFiscalProdutoRes> result = new ArrayList<DTOModeloFiscalProdutoRes>();
        List<ModeloFiscal> dados = this.getModelosFiscais(produto, unidade, naturezaOperacao, empresa);
        if (dados != null) {
            for (ModeloFiscal m : dados) {
                DTOModeloFiscalProdutoRes dto = new DTOModeloFiscalProdutoRes();
                dto.setDescricao(m.getDescricao());
                dto.setIdentificador(m.getIdentificador());
                if (produto != null) {
                    dto.setProdutoIdentificador(produto.getIdentificador());
                }
                result.add(dto);
            }
        }
        return result;
    }

    public Double getAliquotaICMS(UnidadeFederativa unidadeFederativafOrigem, UnidadeFederativa unidadeFederativaDestino, Produto produto, ModeloFiscal modeloFiscal) {
        if (produto == null) {
            return 0.0;
        }
        if (modeloFiscal == null) {
            return 0.0;
        }
        if (modeloFiscal.getModeloFiscalIcms() != null && modeloFiscal.getModeloFiscalIcms().getTipoAliquotaIcms() != null && modeloFiscal.getModeloFiscalIcms().getTipoAliquotaIcms() == 2) {
            return modeloFiscal.getModeloFiscalIcms().getAliquotaIcms();
        }
        if (unidadeFederativaDestino.equals((Object)unidadeFederativafOrigem)) {
            return produto.getAliquotaIcms();
        }
        UnidadeFederativaOrigDest unidadeFederativaOrigDest = this.serviceUnidadeFederativaOrigDestImpl.get(unidadeFederativafOrigem, unidadeFederativaDestino);
        if (unidadeFederativaOrigDest != null) {
            return unidadeFederativaOrigDest.getAliquotaICMS();
        }
        return 0.0;
    }

    public Double getAliquotaIpi(Produto produto, ModeloFiscalIpi modIpi) {
        if (modIpi == null) {
            return 0.0;
        }
        Double aliquotaIpi = 0.0;
        if (modIpi == null || produto == null) {
            return aliquotaIpi;
        }
        aliquotaIpi = modIpi.getTipoAliquotaIpi() == 1 ? produto.getAliquotaIpi() : (modIpi.getTipoAliquotaIpi() == 2 ? modIpi.getAliquotaIpi() : (modIpi.getTipoAliquotaIpi() == 3 ? Double.valueOf(produto.getNcm() != null ? produto.getNcm().getAliquotaIpi() : 0.0) : Double.valueOf(0.0)));
        return aliquotaIpi;
    }

    public Double getAliquotaIpi(Produto produto, ModeloFiscal modeloFiscal) {
        if (modeloFiscal == null) {
            return 0.0;
        }
        return this.getAliquotaIpi(produto, modeloFiscal.getModeloFiscalIpi());
    }

    public Double getReducaoBaseCalcIcms(Produto produto, ModeloFiscal modeloFiscal) {
        if (modeloFiscal != null && modeloFiscal.getModeloFiscalIcms() != null && produto != null) {
            if (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalIcms().getTipoPercReducaoBaseCalcIcms(), (Object)2)) {
                return modeloFiscal.getModeloFiscalIcms().getReducaoBaseCalcIcms();
            }
            return produto.getReducaoBaseCalcIcms();
        }
        return 0.0;
    }
}

