/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.naturezaoperacao;

import com.touchcomp.basementor.constants.enums.naturezaoperacao.EnumConstNatOpSugVlrNFe;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NaturezaOperacaoEmpresa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorservice.components.estoque.CompEstoque;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.service.impl.tabelaprecobaseproduto.ServiceTabelaPrecoBaseImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class HelperNaturezaOperacao
implements AbstractHelper<NaturezaOperacao> {
    private NaturezaOperacao naturezaOperacao;

    public NaturezaOperacao get() {
        return this.naturezaOperacao;
    }

    public String getSerie(Empresa emp) {
        Optional<NaturezaOperacaoEmpresa> found = this.naturezaOperacao.getEmpresas().stream().filter(i -> ToolMethods.isEquals((Object)emp, (Object)i.getEmpresa())).findFirst();
        if (found.isPresent()) {
            return found.get().getSerie();
        }
        return null;
    }

    public Double getValorSugConfNatOperacaoNFe(Produto prod, Empresa emp) {
        return this.getValorSugConfNatOperacaoNFe(this.naturezaOperacao, prod, emp);
    }

    public Double getValorSugConfNatOperacaoNFe(ModeloFiscal modFiscal, NaturezaOperacao natOperacao, Produto produto, Empresa empresa) {
        return this.getValorSugConfNatOperacaoNFe(modFiscal, natOperacao, produto, empresa, null);
    }

    public Double getValorSugConfNatOperacaoNFe(ModeloFiscal modFiscal, NaturezaOperacao natOperacao, Produto produto, Empresa empresa, Date dataBaseConsulPrecoMedio) {
        if (modFiscal == null) {
            return this.build(natOperacao).getValorSugConfNatOperacaoNFe(produto, empresa, dataBaseConsulPrecoMedio);
        }
        EnumConstNatOpSugVlrNFe sugValorUnitarioFatNFe = EnumConstNatOpSugVlrNFe.valueOfCodigo((int)modFiscal.getSugValorUnitarioFatNFe().shortValue());
        Double vlr = ToolMethods.isEquals((Object)sugValorUnitarioFatNFe, (Object)EnumConstNatOpSugVlrNFe.VALOR_NATUREZA_OPERACAO) ? this.build(natOperacao).getValorSugConfNatOperacaoNFe(produto, empresa, dataBaseConsulPrecoMedio) : this.getSugValorUnitarioFatNFe(sugValorUnitarioFatNFe, produto, empresa, dataBaseConsulPrecoMedio);
        return vlr;
    }

    public Double getSugValorUnitarioFatNFe(EnumConstNatOpSugVlrNFe tipoVlr, Produto prod, Empresa emp, Date dataBaseConsulPrecoMedio) {
        return this.getValorSugConfNatOperacaoNFe(tipoVlr, prod, emp, dataBaseConsulPrecoMedio);
    }

    public Double getSugValorUnitarioFatNFe(EnumConstNatOpSugVlrNFe tipoVlr, Produto prod, Empresa emp) {
        return this.getValorSugConfNatOperacaoNFe(tipoVlr, prod, emp, null);
    }

    public Double getValorSugConfNatOperacaoNFe(Produto prod, Empresa emp, Date dataBaseConsulPrecoMedio) {
        return this.getValorSugConfNatOperacaoNFe(this.naturezaOperacao, prod, emp, dataBaseConsulPrecoMedio);
    }

    public HelperNaturezaOperacao build(NaturezaOperacao data) {
        this.naturezaOperacao = data;
        return this;
    }

    public Double getValorSugConfNatOperacaoNFe(NaturezaOperacao naturezaOperacao, Produto prod, Empresa emp) {
        return this.getValorSugConfNatOperacaoNFe(naturezaOperacao, prod, emp, null);
    }

    private Double getValorSugConfNatOperacaoNFe(NaturezaOperacao naturezaOperacao, Produto prod, Empresa emp, Date dataBaseConsulPrecoMedio) {
        if (naturezaOperacao == null || emp == null) {
            return 0.0;
        }
        EnumConstNatOpSugVlrNFe tipoVlr = EnumConstNatOpSugVlrNFe.valueOfCodigo((int)naturezaOperacao.getSugValorUnitarioFatNFe().shortValue());
        return this.getValorSugConfNatOperacaoNFe(tipoVlr, prod, emp, dataBaseConsulPrecoMedio);
    }

    private Double getValorSugConfNatOperacaoNFe(EnumConstNatOpSugVlrNFe tipoVlr, Produto prod, Empresa emp, Date dataBaseConsulPrecoMedio) {
        CompEstoque comp = (CompEstoque)Context.get(CompEstoque.class);
        ServiceTabelaPrecoBaseImpl serviceTabPrecoBase = (ServiceTabelaPrecoBaseImpl)Context.get(ServiceTabelaPrecoBaseImpl.class);
        switch (tipoVlr) {
            case VALOR_CUSTO_MEDIO: {
                return comp.getCustoMedioEstoque(prod, emp, dataBaseConsulPrecoMedio);
            }
            case VALOR_CUSTO_TAB_PRECO: {
                return serviceTabPrecoBase.getValorCustoTabPrincipal(prod, emp);
            }
            case VALOR_TRANSFERENCIA: {
                return comp.getUltCustoVlrTransf(prod, emp);
            }
            case VALOR_ULT_CUSTO: {
                return comp.getUltimoCusto(prod, emp);
            }
            case VALOR_VENDA_TAB_PRECO: {
                return serviceTabPrecoBase.getValorVendaTabPrincipal(prod, emp);
            }
            case VALOR_ULT_COMPRA: {
                return comp.getUltValorCompra(prod, emp);
            }
            case VALOR_NAO_SUGERIR: {
                return 0.0;
            }
        }
        return 0.0;
    }
}

