/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.necessidadecomrpas;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.impostos.contsocial.EnumConstTipoCalcContSocial;
import com.touchcomp.basementor.constants.enums.impostos.funrural.EnumConstTipoCalcFunrural;
import com.touchcomp.basementor.constants.enums.impostos.lei10833.EnumConstTipoCalcLei10833;
import com.touchcomp.basementor.constants.enums.impostos.outros.EnumConstTipoCalcOutros;
import com.touchcomp.basementor.constants.enums.impostos.sestsenat.EnumConstTipoCalcSestSenat;
import com.touchcomp.basementor.constants.enums.modelofiscal.EnumConstTipoInss;
import com.touchcomp.basementor.constants.enums.modelofiscal.EnumConstTipoIrrf;
import com.touchcomp.basementor.constants.enums.modelofiscal.EnumConstTipoIss;
import com.touchcomp.basementor.constants.enums.opcoesestoque.EnumConstOpEstoqueOp;
import com.touchcomp.basementor.constants.enums.piscofins.EnumConstTipoAliquotaPisCofins;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.vo.AliquotaSt;
import com.touchcomp.basementor.model.vo.CategoriaSt;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.CotacaoCompra;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompraLivroFiscal;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.ItemUnidadeMedida;
import com.touchcomp.basementor.model.vo.LeadTimeFornProduto;
import com.touchcomp.basementor.model.vo.LeadTimeFornProdutoInfFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.UnidadeMedida;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacao.ExceptionParametrizacao;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorservice.components.calculovalores.BaseCalculoValores;
import com.touchcomp.basementorservice.components.contabil.CompParametrizacaoContabilNF;
import com.touchcomp.basementorservice.components.estoque.CompEstoque;
import com.touchcomp.basementorservice.components.notaterceiros.CompNotaTerceiros;
import com.touchcomp.basementorservice.helpers.impl.cotacaocompra.HelperCotacaoCompra;
import com.touchcomp.basementorservice.helpers.impl.cotacaocompra.HelperFornecedorItemCotCompra;
import com.touchcomp.basementorservice.helpers.impl.modelofiscal.HelperModeloFiscal;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesestoque.HelperOpcoesEstoque;
import com.touchcomp.basementorservice.helpers.impl.produto.HelperProduto;
import com.touchcomp.basementorservice.service.impl.aliquotast.ServiceAliquotaStImpl;
import com.touchcomp.basementorservice.service.impl.cfop.ServiceCfopImpl;
import com.touchcomp.basementorservice.service.impl.condicoespagamento.ServiceCondicoesPagamentoImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class HelperNecessidadeCompras {
    private final HelperCotacaoCompra helperCotacaoCompra;
    private final CompParametrizacaoContabilNF compParametrizacaoContabilNF;
    private final HelperOpcoesEstoque helperOpcoesEstoque;

    public CotacaoCompra gerarCotacaoCompraFromNecessidade(List<NecessidadeCompra> necessidades, List<HashMap> leadTimes, Usuario usuario, Empresa empresa, OpcoesCompraSuprimentos opcoesCompra, OpcoesContabeis opcoesContabeis, OpcoesEstoque opcoesEstoque) throws Exception {
        CotacaoCompra cotacaoCompra = this.buildCotacaoCompra(empresa, usuario, opcoesCompra);
        Object observacao = "";
        HashMap<Long, String> hh = new HashMap<Long, String>();
        Short gerarObsNecessidade = opcoesCompra.getReplicarObsNecessidadeCotacao();
        Short gerarObsGrupoNecessidade = opcoesCompra.getReplicarObsGrupoNecessidadeCotacao();
        for (NecessidadeCompra necessidadeCompra : necessidades) {
            if (necessidadeCompra.getObservacao() != null && ToolMethods.isEquals((Object)gerarObsNecessidade, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
                observacao = (String)observacao + necessidadeCompra.getObservacao() + " ";
            }
            if (necessidadeCompra.getGrupoNecCompra() != null && ToolMethods.isEquals((Object)gerarObsGrupoNecessidade, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
                hh.put(necessidadeCompra.getGrupoNecCompra().getIdentificador(), necessidadeCompra.getGrupoNecCompra().getObservacao());
            }
            if (necessidadeCompra.getItemCotacaoCompraGerada() != null) {
                throw new Exception("A Necessidade de Compra " + necessidadeCompra.getIdentificador() + " j\u00e1 possui uma Cotacao de Compra gerada: " + necessidadeCompra.getItemCotacaoCompraGerada().getCotacaoCompra().getIdentificador());
            }
            this.buildItemCotacaoCompra(cotacaoCompra, leadTimes, necessidadeCompra, opcoesCompra, opcoesContabeis, opcoesEstoque);
            necessidadeCompra.setSituacaoNecessidadeCompra(opcoesCompra.getSituacaoNecessidadeCotacao());
        }
        Set set = hh.keySet();
        Object obsGrupoNecessidade = "";
        for (Long id : set) {
            String ob = (String)hh.get(id);
            if (ob == null) continue;
            obsGrupoNecessidade = (String)obsGrupoNecessidade + ob + " ";
        }
        cotacaoCompra.setObservacao(((String)observacao).trim() + " " + ((String)obsGrupoNecessidade).trim());
        this.helperCotacaoCompra.build(cotacaoCompra).definirDataMaxEntrega();
        return cotacaoCompra;
    }

    private CotacaoCompra buildCotacaoCompra(Empresa empresa, Usuario usuario, OpcoesCompraSuprimentos opcoes) {
        CotacaoCompra cotacaoCompra = new CotacaoCompra();
        cotacaoCompra.setDataAtualizacao(ToolDate.toTimestamp((Date)new Date()));
        cotacaoCompra.setDataCotacaoCompra(new Date());
        cotacaoCompra.setDataCadastro(new Date());
        cotacaoCompra.setDataPrevFinalizacao(ToolDate.nextDays((Date)cotacaoCompra.getDataCotacaoCompra(), (int)opcoes.getDiasValidadeCotCompras().shortValue()));
        cotacaoCompra.setEmpresa(empresa);
        cotacaoCompra.setFechada(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        cotacaoCompra.setItensCotacaoCompra(new ArrayList());
        cotacaoCompra.setUsuarioComprador(usuario);
        cotacaoCompra.setSituacaoCotacaoCompra(opcoes.getSituacaoCotacaoCompraCadastro());
        return cotacaoCompra;
    }

    private void buildItemCotacaoCompra(CotacaoCompra cotacaoCompra, List<HashMap> leadTimes, NecessidadeCompra necessidadeCompra, OpcoesCompraSuprimentos opcoes, OpcoesContabeis opcoesContabeis, OpcoesEstoque opcoesEstoque) throws Exception {
        ItemCotacaoCompra itemCotacaoCompra = this.findItemCotacaoCompra(cotacaoCompra, leadTimes, necessidadeCompra, opcoes, opcoesContabeis, opcoesEstoque);
        itemCotacaoCompra.getNecessidadesCompra().add(necessidadeCompra);
    }

    private ItemCotacaoCompra findItemCotacaoCompra(CotacaoCompra cotacaoCompra, List<HashMap> leadTimes, NecessidadeCompra necessidadeCompra, OpcoesCompraSuprimentos opcoes, OpcoesContabeis opcoesContabeis, OpcoesEstoque opcoesEstoque) throws Exception {
        ItemCotacaoCompra itemCotacaoCompra = null;
        if (ToolMethods.isAffirmative((Number)((Number)CompOpcoes.getOption(this.helperOpcoesEstoque.build(opcoesEstoque).getItens(), (EnumOpDinamicasInterface)EnumConstOpEstoqueOp.UNIFICAR_ITENS_NECESSIDADE_COTACAO, Short.class)))) {
            for (ItemCotacaoCompra existentItemCotacaoCompra : cotacaoCompra.getItensCotacaoCompra()) {
                if (!ToolMethods.isEquals((Object)existentItemCotacaoCompra.getGradeCor().getIdentificador(), (Object)necessidadeCompra.getGradeCor().getIdentificador()) || necessidadeCompra.getNaturezaOperacao() != null && !ToolMethods.isEquals((Object)necessidadeCompra.getNaturezaOperacao(), (Object)existentItemCotacaoCompra.getNaturezaOperacao()) || necessidadeCompra.getCentroCusto() != null && !ToolMethods.isEquals((Object)necessidadeCompra.getCentroCusto(), (Object)existentItemCotacaoCompra.getCentroCustoReq())) continue;
                itemCotacaoCompra = existentItemCotacaoCompra;
            }
        }
        if (itemCotacaoCompra == null) {
            itemCotacaoCompra = new ItemCotacaoCompra();
            if (necessidadeCompra.getNaturezaOperacao() != null) {
                itemCotacaoCompra.setNaturezaOperacao(necessidadeCompra.getNaturezaOperacao());
            } else {
                itemCotacaoCompra.setNaturezaOperacao(opcoes.getNaturezaOperacao());
            }
            itemCotacaoCompra.setCotacaoCompra(cotacaoCompra);
            itemCotacaoCompra.setDataCadastro(cotacaoCompra.getDataCadastro());
            itemCotacaoCompra.setFatorConversao(this.getFatorConversao(necessidadeCompra.getGradeCor()));
            itemCotacaoCompra.setUnidadeMedida(this.getUnidadeMedida(necessidadeCompra.getGradeCor()));
            itemCotacaoCompra.setGradeCor(necessidadeCompra.getGradeCor());
            itemCotacaoCompra.setNecessidadesCompra(new ArrayList());
            itemCotacaoCompra.getNecessidadesCompra().add(necessidadeCompra);
            itemCotacaoCompra.setQuantidade(necessidadeCompra.getQuantidadeNecessidade());
            itemCotacaoCompra.setAtivo(necessidadeCompra.getAtivo());
            itemCotacaoCompra.setCentroCustoReq(necessidadeCompra.getCentroCusto());
            itemCotacaoCompra.setObservacao(necessidadeCompra.getObservacao());
            if (necessidadeCompra.getAquisicaoPreferencial().shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
                itemCotacaoCompra.setFornecedoresItemCotacaoCompra(this.criarFornecedoresItemCotacaoCompra(itemCotacaoCompra, necessidadeCompra, necessidadeCompra.getEmpresa(), opcoesContabeis, opcoes));
            } else {
                LeadTimeFornProduto leadPref = this.getLeadTimesPreferencial(leadTimes);
                if (leadPref != null) {
                    itemCotacaoCompra.setFornecedoresItemCotacaoCompra(this.buildFornecedorPreferencial(itemCotacaoCompra, leadPref, necessidadeCompra.getEmpresa(), opcoesContabeis, opcoes));
                } else {
                    itemCotacaoCompra.setFornecedoresItemCotacaoCompra(this.findFornecedoresItemCotacaoCompra(itemCotacaoCompra, this.getLeadTimesSelecionados(leadTimes), opcoes.getEmpresa(), opcoesContabeis, opcoes));
                }
            }
            cotacaoCompra.getItensCotacaoCompra().add(itemCotacaoCompra);
        } else {
            itemCotacaoCompra.setQuantidade(Double.valueOf(itemCotacaoCompra.getQuantidade() + necessidadeCompra.getQuantidadeNecessidade()));
            itemCotacaoCompra.setObservacao(itemCotacaoCompra.getObservacao() + " " + necessidadeCompra.getObservacao());
        }
        necessidadeCompra.setItemCotacaoCompraGerada(itemCotacaoCompra);
        return itemCotacaoCompra;
    }

    private LeadTimeFornProduto getLeadTimesPreferencial(List<HashMap> leadTimeFornecedor) {
        for (HashMap map : leadTimeFornecedor) {
            LeadTimeFornProduto leadProd = (LeadTimeFornProduto)map.get("LEAD_TIME");
            if (!ToolMethods.isNotNull((Object)leadProd).booleanValue() || !ToolMethods.isAffirmative((Number)leadProd.getAquisicaoPreferencial())) continue;
            return leadProd;
        }
        return null;
    }

    private List<FornecedorItemCotacaoCompra> buildFornecedorPreferencial(ItemCotacaoCompra item, LeadTimeFornProduto leadPref, Empresa emp, OpcoesContabeis opcoesContabeis, OpcoesCompraSuprimentos opcoes) throws ExceptionParametrizacao, Exception {
        LeadTimeFornProdutoInfFiscal inf = this.getInfFiscalLeadTime(leadPref);
        item.setNaturezaOperacao(inf.getNaturezaOperacao());
        FornecedorItemCotacaoCompra f = new FornecedorItemCotacaoCompra();
        f.setItemCotacaoCompra(item);
        f.setAquisicaoPreferencial(leadPref.getAquisicaoPreferencial());
        f.setCondicaoPagamentoMutante(inf.getParcelas());
        f.setCondicoesPagamento(inf.getCondicoesPagamento());
        f.setDataCadastro(new Date());
        f.setJustficativaAquisicaoPreferencial(inf.getMotivoAqPref());
        f.setModeloFiscal(inf.getModeloFiscal());
        f.setPrazoEntrega(Long.valueOf(leadPref.getLeadTime().longValue()));
        f.setSelecionado(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        f.setTipoFrete(inf.getTipoFrete());
        f.setUnidadeFaturamentoFornecedor(leadPref.getLeadTimeFornecedor().getUnidadeFatFornecedor());
        f.setValorUnitario(inf.getValorUnitNegociado());
        CompParametrizacaoContabilNF.DadosContas dados = this.compParametrizacaoContabilNF.getPlanoContasNfTerceiros(f.getModeloFiscal(), item.getGradeCor().getProdutoGrade().getProduto(), leadPref.getLeadTimeFornecedor().getUnidadeFatFornecedor(), item.getNaturezaOperacao(), emp, leadPref.getLeadTimeFornecedor().getUnidadeFatFornecedor().getCategoriaPessoa(), opcoesContabeis);
        f.setPlanoConta(dados.getPlanoContaDeb());
        f.setPlanoContaGerencial(dados.getPcGerencial());
        ArrayList<FornecedorItemCotacaoCompra> ret = new ArrayList<FornecedorItemCotacaoCompra>();
        this.setFornecedorItemCotacaoCompraLivroFiscal(f, emp, opcoesContabeis, opcoes);
        ret.add(f);
        return ret;
    }

    private Double getFatorConversao(GradeCor gradeCor) {
        List<ItemUnidadeMedida> itens;
        if (gradeCor.getProdutoGrade() != null && gradeCor.getProdutoGrade().getProduto() != null && gradeCor.getProdutoGrade().getProduto().getItemUnidadeMedida() != null && !gradeCor.getProdutoGrade().getProduto().getItemUnidadeMedida().isEmpty() && (itens = new HelperProduto().build(gradeCor.getProdutoGrade().getProduto()).getItensUnidMedidasAtivoUnProd()).size() > 0) {
            return itens.get(0).getFatorConversao();
        }
        return 1.0;
    }

    private UnidadeMedida getUnidadeMedida(GradeCor gradeCor) throws Exception {
        if (gradeCor.getProdutoGrade() != null && gradeCor.getProdutoGrade().getProduto() != null && gradeCor.getProdutoGrade().getProduto().getUnidadeMedida() != null) {
            return gradeCor.getProdutoGrade().getProduto().getUnidadeMedida();
        }
        if (gradeCor.getProdutoGrade() != null && gradeCor.getProdutoGrade().getProduto() != null && gradeCor.getProdutoGrade().getProduto().getItemUnidadeMedida() != null && !gradeCor.getProdutoGrade().getProduto().getItemUnidadeMedida().isEmpty()) {
            return ((ItemUnidadeMedida)gradeCor.getProdutoGrade().getProduto().getItemUnidadeMedida().get(0)).getUnidadeMedida();
        }
        throw new Exception("N\u00e3o foi poss\u00edvel encontrar a unidade de medida para o produto: " + gradeCor.getProdutoGrade().getProduto().getIdentificador() + " - " + gradeCor.getProdutoGrade().getProduto().getNome());
    }

    private List<FornecedorItemCotacaoCompra> criarFornecedoresItemCotacaoCompra(ItemCotacaoCompra itemCotacaoCompra, NecessidadeCompra necessidadeCompra, Empresa empresa, OpcoesContabeis opcoesContabeis, OpcoesCompraSuprimentos opcoes) throws ExceptionObjNotFound, ExceptionParametrizacao, Exception {
        ArrayList<FornecedorItemCotacaoCompra> ret = new ArrayList<FornecedorItemCotacaoCompra>();
        FornecedorItemCotacaoCompra fornecedorItemCotacao = new FornecedorItemCotacaoCompra();
        fornecedorItemCotacao.setItemCotacaoCompra(itemCotacaoCompra);
        fornecedorItemCotacao.setUnidadeFaturamentoFornecedor(necessidadeCompra.getUnidadeFatFornecedor());
        fornecedorItemCotacao.setModeloFiscal(this.findModeloFiscal(itemCotacaoCompra, necessidadeCompra, opcoes));
        CompParametrizacaoContabilNF comp = (CompParametrizacaoContabilNF)ConfApplicationContext.getBean(CompParametrizacaoContabilNF.class);
        CompParametrizacaoContabilNF.DadosContas dados = comp.getPlanoContasNfTerceiros(fornecedorItemCotacao.getModeloFiscal(), itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto(), necessidadeCompra.getUnidadeFatFornecedor(), itemCotacaoCompra.getNaturezaOperacao(), empresa, necessidadeCompra.getUnidadeFatFornecedor().getCategoriaPessoa(), opcoesContabeis);
        fornecedorItemCotacao.setPlanoConta(dados.getPlanoContaDeb());
        fornecedorItemCotacao.setPlanoContaGerencial(dados.getPcGerencial());
        fornecedorItemCotacao.setDataCadastro(new Date());
        fornecedorItemCotacao.setAquisicaoPreferencial(necessidadeCompra.getAquisicaoPreferencial());
        fornecedorItemCotacao.setMotivoAquisPref(necessidadeCompra.getMotivoAquisPref());
        fornecedorItemCotacao.setJustficativaAquisicaoPreferencial(necessidadeCompra.getMotivoAquisicaoPreferencial());
        fornecedorItemCotacao.setTipoFrete(necessidadeCompra.getTipoFrete());
        fornecedorItemCotacao.setPrazoEntrega(necessidadeCompra.getPrazoEntrega());
        fornecedorItemCotacao.setDataPrevFaturamento(necessidadeCompra.getDataPrevFaturamento());
        fornecedorItemCotacao.setCondicoesPagamento(necessidadeCompra.getCondicoesPagamento());
        fornecedorItemCotacao.setCondicaoPagamentoMutante(necessidadeCompra.getCondicaoMutante());
        if (fornecedorItemCotacao.getModeloFiscal() != null) {
            this.setFornecedorItemCotacaoCompraLivroFiscal(fornecedorItemCotacao, empresa, opcoesContabeis, opcoes);
        }
        fornecedorItemCotacao.setValorUnitario(necessidadeCompra.getValor());
        if (itemCotacaoCompra.getGradeCor() != null && !ToolMethods.isAffirmative((Number)opcoes.getNaoSugCustoAutoCotCompras())) {
            fornecedorItemCotacao.setCustoMedio(CompNotaTerceiros.getCustoMedioProd(itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto(), empresa));
            fornecedorItemCotacao.setUltimoCusto(CompNotaTerceiros.getUltimoCustoProd(itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto(), empresa));
            fornecedorItemCotacao.setMenorCusto(CompNotaTerceiros.getMenorCustoProd(itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto(), empresa));
        }
        ret.add(fornecedorItemCotacao);
        return ret;
    }

    private ModeloFiscal findModeloFiscal(ItemCotacaoCompra itemCotacao, NecessidadeCompra necessidadeCompra, OpcoesCompraSuprimentos opcoes) throws ExceptionObjNotFound {
        Produto produto = itemCotacao.getGradeCor().getProdutoGrade().getProduto();
        NaturezaOperacao naturezaOperacao = itemCotacao.getNaturezaOperacao();
        UnidadeFatFornecedor unidadeFornecedor = necessidadeCompra.getUnidadeFatFornecedor();
        Empresa empresa = itemCotacao.getCotacaoCompra().getEmpresa();
        if (naturezaOperacao != null && produto != null && unidadeFornecedor != null && unidadeFornecedor.getFornecedor() != null && !ToolMethods.isAffirmative((Number)opcoes.getNaoSugAutoModFiscalCotCompras())) {
            HelperModeloFiscal helper = (HelperModeloFiscal)ConfApplicationContext.getBean(HelperModeloFiscal.class);
            return helper.getFirst(produto, unidadeFornecedor, naturezaOperacao, empresa);
        }
        return null;
    }

    public void setFornecedorItemCotacaoCompraLivroFiscal(FornecedorItemCotacaoCompra f, Empresa emp, OpcoesContabeis opcoesContabeis, OpcoesCompraSuprimentos opcoes) throws Exception {
        Produto produto = f.getItemCotacaoCompra().getGradeCor().getProdutoGrade().getProduto();
        ModeloFiscal modeloFiscal = f.getModeloFiscal();
        FornecedorItemCotacaoCompraLivroFiscal itemFornCotacaoLivroFiscal = new FornecedorItemCotacaoCompraLivroFiscal();
        f.setFornecedorItemCotacaoCompraLivroFiscal(itemFornCotacaoLivroFiscal);
        itemFornCotacaoLivroFiscal.setCfop(this.getCfop(f, emp));
        if (modeloFiscal.getTipoIRRF() != null && modeloFiscal.getTipoIRRF().shortValue() == EnumConstTipoIrrf.TIPO_IRRF_CALCULAR.getValue()) {
            itemFornCotacaoLivroFiscal.setAliquotaIrrf(produto.getAliquotaIrrf());
            itemFornCotacaoLivroFiscal.setPercentualReducaoIrrf(produto.getPercRedIrrf());
        } else {
            itemFornCotacaoLivroFiscal.setAliquotaIrrf(Double.valueOf(0.0));
            itemFornCotacaoLivroFiscal.setPercentualReducaoIrrf(Double.valueOf(0.0));
        }
        if (modeloFiscal.getTipoINSS() != null && modeloFiscal.getTipoINSS().shortValue() == EnumConstTipoInss.TIPO_INSS_RETIDO.getValue()) {
            itemFornCotacaoLivroFiscal.setAliquotaInss(produto.getAliquotaIrrf());
            itemFornCotacaoLivroFiscal.setPercentualReducaoBaseCalculoInss(produto.getPercRedIrrf());
        } else {
            itemFornCotacaoLivroFiscal.setAliquotaInss(Double.valueOf(0.0));
            itemFornCotacaoLivroFiscal.setPercentualReducaoBaseCalculoInss(Double.valueOf(0.0));
        }
        if (modeloFiscal.getTipoSestSenat() != null && modeloFiscal.getTipoSestSenat().shortValue() == EnumConstTipoCalcSestSenat.CALCULAR_NORMAL.getValue()) {
            itemFornCotacaoLivroFiscal.setAliquotaSestSenat(produto.getPercSestSenat());
            itemFornCotacaoLivroFiscal.setPercentualReducaoSestSenat(produto.getPercRedSestSenat());
        } else {
            itemFornCotacaoLivroFiscal.setAliquotaSestSenat(Double.valueOf(0.0));
            itemFornCotacaoLivroFiscal.setPercentualReducaoSestSenat(Double.valueOf(0.0));
        }
        if (modeloFiscal.getTipoFunrural() != null && modeloFiscal.getTipoFunrural().shortValue() == EnumConstTipoCalcFunrural.CALCULAR_NORMAL.getValue()) {
            itemFornCotacaoLivroFiscal.setAliquotaFunrural(produto.getAliquotaFunrural());
            itemFornCotacaoLivroFiscal.setPercentualReducaoFunrural(produto.getPercRedFunrural());
        } else {
            itemFornCotacaoLivroFiscal.setAliquotaFunrural(Double.valueOf(0.0));
            itemFornCotacaoLivroFiscal.setPercentualReducaoFunrural(Double.valueOf(0.0));
        }
        if (modeloFiscal.getTipoLei10833() != null && modeloFiscal.getTipoLei10833().shortValue() == EnumConstTipoCalcLei10833.CALCULAR_NORMAL.getValue()) {
            itemFornCotacaoLivroFiscal.setAliquotaLei10833(produto.getAliquotaLei10833());
            itemFornCotacaoLivroFiscal.setPercentualReducaoLei10833(produto.getPercRedLei10833());
        } else {
            itemFornCotacaoLivroFiscal.setAliquotaLei10833(Double.valueOf(0.0));
            itemFornCotacaoLivroFiscal.setPercentualReducaoLei10833(Double.valueOf(0.0));
        }
        if (modeloFiscal.getTipoOutros() != null && modeloFiscal.getTipoOutros().shortValue() == EnumConstTipoCalcOutros.CALCULAR_NORMAL.getValue()) {
            itemFornCotacaoLivroFiscal.setAliquotaOutros(produto.getAliquotaOutros());
            itemFornCotacaoLivroFiscal.setPercentualReducaoOutros(produto.getPercRedOutros());
        } else {
            itemFornCotacaoLivroFiscal.setAliquotaOutros(Double.valueOf(0.0));
            itemFornCotacaoLivroFiscal.setPercentualReducaoOutros(Double.valueOf(0.0));
        }
        if (modeloFiscal.getTipoContSoc() != null && modeloFiscal.getTipoContSoc().shortValue() == EnumConstTipoCalcContSocial.CALCULAR_NORMAL.getValue()) {
            itemFornCotacaoLivroFiscal.setAliquotaContribuicaoSocial(produto.getAliquotaContSoc());
            itemFornCotacaoLivroFiscal.setPercentualReducaoContribuicaoSocial(produto.getPercRedContSoc());
        } else {
            itemFornCotacaoLivroFiscal.setAliquotaContribuicaoSocial(Double.valueOf(0.0));
            itemFornCotacaoLivroFiscal.setPercentualReducaoContribuicaoSocial(Double.valueOf(0.0));
        }
        if (modeloFiscal.getIssRetido() != null && modeloFiscal.getIssRetido().shortValue() != EnumConstTipoIss.TIPO_ISS_NAO_CALCULAR.getValue()) {
            itemFornCotacaoLivroFiscal.setAliquotaIss(produto.getAliquotaIss());
        } else {
            itemFornCotacaoLivroFiscal.setAliquotaIss(Double.valueOf(0.0));
        }
        if (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getCalcularPisNormal(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            if (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                itemFornCotacaoLivroFiscal.setAliquotaPis(modeloFiscal.getModeloFiscalPisCofins().getAliquotaPis());
            } else {
                itemFornCotacaoLivroFiscal.setAliquotaPis(produto.getAliquotaPis());
            }
        } else {
            itemFornCotacaoLivroFiscal.setAliquotaPis(Double.valueOf(0.0));
        }
        if (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getCalcularPisSt(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            if (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                itemFornCotacaoLivroFiscal.setAliquotaPisSt(modeloFiscal.getModeloFiscalPisCofins().getAliquotaPisSt());
            } else {
                itemFornCotacaoLivroFiscal.setAliquotaPisSt(produto.getAliquotaPisSt());
            }
        } else {
            itemFornCotacaoLivroFiscal.setAliquotaPisSt(Double.valueOf(0.0));
        }
        if (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getCalcularCofinsNormal(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            if (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                itemFornCotacaoLivroFiscal.setAliquotaCofins(modeloFiscal.getModeloFiscalPisCofins().getAliquotaCofins());
            } else {
                itemFornCotacaoLivroFiscal.setAliquotaCofins(produto.getAliquotaCofins());
            }
        } else {
            itemFornCotacaoLivroFiscal.setAliquotaCofins(Double.valueOf(0.0));
        }
        if (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getCalcularCofinsSt(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            if (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                itemFornCotacaoLivroFiscal.setAliquotaCofinsSt(modeloFiscal.getModeloFiscalPisCofins().getAliquotaCofinsSt());
            } else {
                itemFornCotacaoLivroFiscal.setAliquotaCofinsSt(produto.getAliquotaCofins());
            }
        } else {
            itemFornCotacaoLivroFiscal.setAliquotaCofinsSt(Double.valueOf(0.0));
        }
        Double aliquotaIpi = BaseCalculoValores.getAliquotaIpi(produto, modeloFiscal.getModeloFiscalIpi());
        itemFornCotacaoLivroFiscal.setAliquotaIpi(aliquotaIpi);
        Double alICMS = ((HelperModeloFiscal)ConfApplicationContext.getBean(HelperModeloFiscal.class)).getAliquotaICMS(f.getUnidadeFaturamentoFornecedor().getPessoa().getEndereco().getCidade().getUf(), emp.getPessoa().getEndereco().getCidade().getUf(), produto, f.getModeloFiscal());
        itemFornCotacaoLivroFiscal.setAliquotaIcms(alICMS);
        this.calcularImpostosFiscaisFornecedorItemCotacaoCompra(f, f.getUnidadeFaturamentoFornecedor(), emp.getPessoa().getEndereco().getCidade().getUf(), f.getItemCotacaoCompra().getGradeCor(), f.getItemCotacaoCompra().getQuantidade(), f.getItemCotacaoCompra().getFatorConversao(), emp, opcoesContabeis, opcoes);
        AliquotaSt aliquotaSt = null;
        if (itemFornCotacaoLivroFiscal.getCategoriaSt() != null && itemFornCotacaoLivroFiscal.getUnidadeFederativaIcmsSt() != null) {
            aliquotaSt = this.procurarAliquotaSt(itemFornCotacaoLivroFiscal.getCategoriaSt(), itemFornCotacaoLivroFiscal.getUnidadeFederativaIcmsSt());
        } else if (modeloFiscal.getModeloFiscalIcms() != null && modeloFiscal.getModeloFiscalIcms().getIncidenciaIcms() != null && modeloFiscal.getModeloFiscalIcms().getIncidenciaIcms().getIcmsSt() != null && modeloFiscal.getModeloFiscalIcms().getIncidenciaIcms().getIcmsSt().intValue() == EnumConstantsMentorSimNao.SIM.getValue() && produto != null && produto.getCategoriaSutr() != null) {
            aliquotaSt = this.procurarAliquotaSt(produto.getCategoriaSutr(), f.getUnidadeFaturamentoFornecedor().getPessoa().getEndereco().getCidade().getUf());
            itemFornCotacaoLivroFiscal.setCategoriaSt(produto.getCategoriaSutr());
            itemFornCotacaoLivroFiscal.setUnidadeFederativaIcmsSt(f.getUnidadeFaturamentoFornecedor().getPessoa().getEndereco().getCidade().getUf());
        }
        if (aliquotaSt != null) {
            itemFornCotacaoLivroFiscal.setIndicadorAlteracaoIcmsST(aliquotaSt.getIndiceAlteracao());
            itemFornCotacaoLivroFiscal.setDescontoPadraoIcmsST(aliquotaSt.getDescontoPadrao());
            itemFornCotacaoLivroFiscal.setAliquotaIcmsST(aliquotaSt.getAliquotaIcms());
        } else {
            itemFornCotacaoLivroFiscal.setIndicadorAlteracaoIcmsST(Double.valueOf(0.0));
            itemFornCotacaoLivroFiscal.setDescontoPadraoIcmsST(Double.valueOf(0.0));
            itemFornCotacaoLivroFiscal.setAliquotaIcmsST(Double.valueOf(0.0));
        }
        this.valoresDadosIcmsSt(itemFornCotacaoLivroFiscal);
    }

    private Cfop getCfop(FornecedorItemCotacaoCompra f, Empresa emp) throws Exception {
        Cfop cfop = ((ServiceCfopImpl)ConfApplicationContext.getBean(ServiceCfopImpl.class)).findCfopEntrada(emp.getPessoa().getEndereco().getCidade().getUf(), f.getUnidadeFaturamentoFornecedor().getPessoa().getEndereco().getCidade().getUf(), f.getModeloFiscal());
        return cfop;
    }

    private AliquotaSt procurarAliquotaSt(CategoriaSt categoriaSt, UnidadeFederativa unidadeFederativaCliente) throws Exception {
        AliquotaSt aliquotaSt = ((ServiceAliquotaStImpl)ConfApplicationContext.getBean(ServiceAliquotaStImpl.class)).get(categoriaSt, unidadeFederativaCliente);
        if (aliquotaSt == null) {
            throw new Exception("Al\u00edquota de Substitui\u00e7\u00e3o Tribut\u00e1ria n\u00e3o encontrada para a Categoria " + (categoriaSt != null ? categoriaSt.getNome() : "") + " e UF " + unidadeFederativaCliente.getSigla());
        }
        return aliquotaSt;
    }

    private void valoresDadosIcmsSt(FornecedorItemCotacaoCompraLivroFiscal itemFornCotacaoLivroFiscal) {
        itemFornCotacaoLivroFiscal.setValorBaseCalculoIcmsSt(Double.valueOf(itemFornCotacaoLivroFiscal.getValorBaseCalculoIcms() * itemFornCotacaoLivroFiscal.getIndicadorAlteracaoIcmsST() - itemFornCotacaoLivroFiscal.getValorBaseCalculoIcms() * (itemFornCotacaoLivroFiscal.getDescontoPadraoIcmsST() / 100.0)));
        itemFornCotacaoLivroFiscal.setValorIcmsSt(Double.valueOf(itemFornCotacaoLivroFiscal.getValorBaseCalculoIcms() * (itemFornCotacaoLivroFiscal.getAliquotaIcmsST() / 100.0) - itemFornCotacaoLivroFiscal.getValorIcms()));
        if (itemFornCotacaoLivroFiscal.getValorIcmsSt() < 0.0) {
            itemFornCotacaoLivroFiscal.setValorIcmsSt(Double.valueOf(0.0));
        }
    }

    private List<LeadTimeFornProduto> getLeadTimesSelecionados(List<HashMap> leadTimeFornecedor) {
        ArrayList<LeadTimeFornProduto> toRet = new ArrayList<LeadTimeFornProduto>();
        for (HashMap h : leadTimeFornecedor) {
            LeadTimeFornProduto leadProd = (LeadTimeFornProduto)h.get("LEAD_TIME");
            Short cotar = (Short)h.get("COTAR");
            if (!ToolMethods.isAffirmative((Number)cotar) || !ToolMethods.isNotNull((Object)leadProd).booleanValue()) continue;
            toRet.add(leadProd);
        }
        return toRet;
    }

    private LeadTimeFornProdutoInfFiscal getInfFiscalLeadTim(LeadTimeFornProduto leadPref) throws Exception {
        if (leadPref.getInfFiscalLeadTime() == null || leadPref.getInfFiscalLeadTime().isEmpty()) {
            throw new Exception("Foi determinado aquisi\u00e7\u00e3o preferencial para o fornecedor/produto e n\u00e3o foi definido as caracter\u00edsticas fiscais.\n" + leadPref.getLeadTimeFornecedor().getUnidadeFatFornecedor().getFornecedor().getPessoa().getNome() + " - " + leadPref.getGradeCor().getProdutoGrade().getProduto().getNome());
        }
        return (LeadTimeFornProdutoInfFiscal)leadPref.getInfFiscalLeadTime().get(0);
    }

    public List<FornecedorItemCotacaoCompra> findFornecedoresItemCotacaoCompra(ItemCotacaoCompra itemCotacaoCompra, List<LeadTimeFornProduto> leadTimeFornecedor, Empresa emp, OpcoesContabeis opcoesContabeis, OpcoesCompraSuprimentos opcoes) throws Exception {
        ArrayList<FornecedorItemCotacaoCompra> fornecedoresItemCotacaoCompra = new ArrayList<FornecedorItemCotacaoCompra>();
        for (LeadTimeFornProduto leadProd : leadTimeFornecedor) {
            FornecedorItemCotacaoCompra f = this.buildFornecedorItemCotacaoCompra(itemCotacaoCompra, leadProd, emp, opcoesContabeis, opcoes);
            if (!ToolMethods.isNotNull((Object)f).booleanValue() || !ToolMethods.isAffirmative((Number)f.getUnidadeFaturamentoFornecedor().getFornecedor().getAtivo())) continue;
            fornecedoresItemCotacaoCompra.add(f);
        }
        return fornecedoresItemCotacaoCompra;
    }

    private FornecedorItemCotacaoCompra buildFornecedorItemCotacaoCompra(ItemCotacaoCompra itemCotacaoCompra, LeadTimeFornProduto leadTimeFornProduto, Empresa emp, OpcoesContabeis opcocoesContabeis, OpcoesCompraSuprimentos opcoes) throws Exception {
        LeadTimeFornProdutoInfFiscal leadTime = this.getInfFiscalLeadTime(leadTimeFornProduto);
        if (leadTime != null) {
            FornecedorItemCotacaoCompra f = new FornecedorItemCotacaoCompra();
            f.setItemCotacaoCompra(itemCotacaoCompra);
            f.setAquisicaoPreferencial(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
            f.setCondicoesPagamento(this.findCondicaoPagamentoMutante());
            f.setDataCadastro(itemCotacaoCompra.getDataCadastro());
            f.setItemCotacaoCompra(itemCotacaoCompra);
            f.setAquisicaoPreferencial(leadTimeFornProduto.getAquisicaoPreferencial());
            f.setCondicaoPagamentoMutante(leadTime.getParcelas());
            f.setCondicoesPagamento(leadTime.getCondicoesPagamento());
            f.setDataCadastro(new Date());
            f.setJustficativaAquisicaoPreferencial(leadTime.getMotivoAqPref());
            f.setModeloFiscal(leadTime.getModeloFiscal());
            f.setPrazoEntrega(Long.valueOf(leadTimeFornProduto.getLeadTime().longValue()));
            f.setSelecionado(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            f.setTipoFrete(leadTime.getTipoFrete());
            f.setUnidadeFaturamentoFornecedor(leadTimeFornProduto.getLeadTimeFornecedor().getUnidadeFatFornecedor());
            f.setValorUnitario(leadTime.getValorUnitNegociado());
            f.setAquisicaoPreferencial(leadTimeFornProduto.getAquisicaoPreferencial());
            f.setUnidadeFaturamentoFornecedor(leadTimeFornProduto.getLeadTimeFornecedor().getUnidadeFatFornecedor());
            f.setPrazoEntrega(Long.valueOf(leadTimeFornProduto.getLeadTime().longValue()));
            this.setFornecedorItemCotacaoCompraLivroFiscal(f, emp, opcocoesContabeis, opcoes);
            return f;
        }
        FornecedorItemCotacaoCompra f = new FornecedorItemCotacaoCompra();
        f.setItemCotacaoCompra(itemCotacaoCompra);
        f.setAquisicaoPreferencial(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        f.setDataCadastro(itemCotacaoCompra.getDataCadastro());
        f.setAquisicaoPreferencial(leadTimeFornProduto.getAquisicaoPreferencial());
        f.setUnidadeFaturamentoFornecedor(leadTimeFornProduto.getLeadTimeFornecedor().getUnidadeFatFornecedor());
        if (ToolMethods.isNotNull((Object)f.getUnidadeFaturamentoFornecedor()).booleanValue() && ToolMethods.isNotNull((Object)f.getUnidadeFaturamentoFornecedor().getFornecedor()).booleanValue()) {
            f.setCondicoesPagamento(f.getUnidadeFaturamentoFornecedor().getFornecedor().getCondicaoPagamento());
        }
        f.setPrazoEntrega(Long.valueOf(leadTimeFornProduto.getLeadTime().longValue()));
        f.setFornecedorItemCotacaoCompraLivroFiscal(new FornecedorItemCotacaoCompraLivroFiscal());
        f.setModeloFiscal(this.findModeloFiscal(itemCotacaoCompra, f.getUnidadeFaturamentoFornecedor(), emp, opcoes));
        if (itemCotacaoCompra.getGradeCor() != null && !ToolMethods.isAffirmative((Number)opcoes.getNaoSugCustoAutoCotCompras())) {
            f.setCustoMedio(CompNotaTerceiros.getCustoMedioProd(itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto(), emp));
            f.setUltimoCusto(CompNotaTerceiros.getUltimoCustoProd(itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto(), emp));
            f.setMenorCusto(CompNotaTerceiros.getMenorCustoProd(itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto(), emp));
        }
        return f;
    }

    private LeadTimeFornProdutoInfFiscal getInfFiscalLeadTime(LeadTimeFornProduto leadPref) {
        if (leadPref.getInfFiscalLeadTime() == null || leadPref.getInfFiscalLeadTime().isEmpty()) {
            return null;
        }
        return (LeadTimeFornProdutoInfFiscal)leadPref.getInfFiscalLeadTime().get(0);
    }

    private CondicoesPagamento findCondicaoPagamentoMutante() throws Exception {
        List<CondicoesPagamento> list = ((ServiceCondicoesPagamentoImpl)ConfApplicationContext.getBean(ServiceCondicoesPagamentoImpl.class)).getCondicoesPagamentoMutante();
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        throw new Exception("Primeiro, cadastre uma condi\u00e7\u00e3o de pagamento mutante e liberada para ser utilizada na entrada!");
    }

    private ModeloFiscal findModeloFiscal(ItemCotacaoCompra itemCotacao, UnidadeFatFornecedor unidadeFornecedor, Empresa empresa, OpcoesCompraSuprimentos opcoes) throws ExceptionObjNotFound {
        Produto produto = itemCotacao.getGradeCor().getProdutoGrade().getProduto();
        NaturezaOperacao naturezaOperacao = itemCotacao.getNaturezaOperacao();
        if (naturezaOperacao != null && produto != null && unidadeFornecedor.getIdentificador() != null && unidadeFornecedor.getFornecedor() != null && !ToolMethods.isAffirmative((Number)opcoes.getNaoSugAutoModFiscalCotCompras())) {
            HelperModeloFiscal helper = (HelperModeloFiscal)ConfApplicationContext.getBean(HelperModeloFiscal.class);
            return helper.getFirst(produto, unidadeFornecedor, naturezaOperacao, empresa);
        }
        return null;
    }

    private void calcularImpostosFiscaisFornecedorItemCotacaoCompra(FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, UnidadeFatFornecedor fornecedor, UnidadeFederativa unidadeFederativaEmpresa, GradeCor gradeCor, Double quantidade, Double fatorConversao, Empresa empresa, OpcoesContabeis opcoesContabeis, OpcoesCompraSuprimentos opcoes) throws ExceptionObjNotFound {
        if (fornecedorItemCotacaoCompra.getValorUnitario() <= 0.0) {
            fornecedorItemCotacaoCompra.setValidado(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
            return;
        }
        FornecedorItemCotacaoCompraLivroFiscal fornecedorItemCotacaoCompraLivroFiscal = fornecedorItemCotacaoCompra.getFornecedorItemCotacaoCompraLivroFiscal();
        ModeloFiscal modeloFiscal = fornecedorItemCotacaoCompra.getModeloFiscal();
        if (modeloFiscal == null) {
            modeloFiscal = this.getModeloFiscal(fornecedorItemCotacaoCompra, empresa);
        }
        if (modeloFiscal == null) {
            return;
        }
        Produto produto = gradeCor.getProdutoGrade().getProduto();
        this.setInfoEstatisticasCusto(fornecedorItemCotacaoCompra, opcoesContabeis.getEmpresa(), opcoes);
    }

    private ModeloFiscal getModeloFiscal(FornecedorItemCotacaoCompra fornecedorItem, Empresa empresa) throws ExceptionObjNotFound {
        return new HelperFornecedorItemCotCompra().build(fornecedorItem).getModeloFiscal(empresa);
    }

    private void setInfoEstatisticasCusto(FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Empresa empresa, OpcoesCompraSuprimentos opcoes) {
        if (ToolMethods.isAffirmative((Number)opcoes.getNaoSugCustoAutoCotCompras())) {
            return;
        }
        if (fornecedorItemCotacaoCompra.getItemCotacaoCompra() != null && fornecedorItemCotacaoCompra.getItemCotacaoCompra().getGradeCor() != null) {
            Produto produto = fornecedorItemCotacaoCompra.getItemCotacaoCompra().getGradeCor().getProdutoGrade().getProduto();
            ServiceNotaFiscalTerceirosImpl service = (ServiceNotaFiscalTerceirosImpl)ConfApplicationContext.getBean(ServiceNotaFiscalTerceirosImpl.class);
            CompEstoque compEstoque = (CompEstoque)ConfApplicationContext.getBean(CompEstoque.class);
            double ultVlrCusto = compEstoque.getUltimoCusto(produto, empresa);
            double custoMedio = service.getCustoMedioProd(produto.getIdentificador(), empresa);
            double menorCusto = service.getMenorCustoProd(produto.getIdentificador(), empresa);
            fornecedorItemCotacaoCompra.setCustoMedio(Double.valueOf(custoMedio));
            fornecedorItemCotacaoCompra.setUltimoCusto(Double.valueOf(ultVlrCusto));
            fornecedorItemCotacaoCompra.setMenorCusto(Double.valueOf(menorCusto));
        }
    }

    @Generated
    public HelperNecessidadeCompras(HelperCotacaoCompra helperCotacaoCompra, CompParametrizacaoContabilNF compParametrizacaoContabilNF, HelperOpcoesEstoque helperOpcoesEstoque) {
        this.helperCotacaoCompra = helperCotacaoCompra;
        this.compParametrizacaoContabilNF = compParametrizacaoContabilNF;
        this.helperOpcoesEstoque = helperOpcoesEstoque;
    }
}

