/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.notapropria;

import com.touchcomp.basementor.constants.enums.modelofiscal.EnumConstModeloFiscalObs;
import com.touchcomp.basementor.model.vo.GradeItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.IncidenciaIcms;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalObsFisco;
import com.touchcomp.basementor.model.vo.ObsFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorservice.components.obsfaturamento.CompOBSFaturamento;
import com.touchcomp.basementorservice.service.impl.fichaconteudoimportacao.ServiceFichaConteudoImportacaoImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;

class AuxBuildOBSItemNota {
    AuxBuildOBSItemNota() {
    }

    public String getInfAdItemSistema(ItemNotaFiscalPropria i, UnidadeFederativa ufEmitente, UnidadeFederativa ufDestinatario, OpcoesFaturamento op) {
        StringBuilder s = new StringBuilder();
        s.append((CharSequence)this.getDescLote(i, op));
        s.append((CharSequence)this.getDescUnMedida(i, op));
        s.append((CharSequence)this.getPrevImpostosProd(i, op));
        s.append((CharSequence)this.getFichaConteudoImportacao(i, ufEmitente, ufDestinatario, op));
        s.append((CharSequence)this.getValoresFCP(i, op));
        s.append(this.checkAndSetObsMod(i));
        if (s.length() > 500) {
            return s.substring(0, 500);
        }
        return s.toString();
    }

    private StringBuilder getDescLote(ItemNotaFiscalPropria i, OpcoesFaturamento op) {
        StringBuilder s = new StringBuilder();
        if (op.getObsLoteFabItemNota() != null) {
            return s;
        }
        if (!ToolMethods.isWithData((Collection)i.getGradesNotaFiscalPropria())) {
            return s;
        }
        if (i.getProduto() == null || ToolMethods.isEquals((Object)i.getProduto().getLoteUnico(), (Object)1) || ToolMethods.isEquals((Object)op.getDesconsiderarInformLoteNotaNaoMovEstoque(), (Object)1) && ToolMethods.isEquals((Object)((GradeItemNotaFiscalPropria)i.getGradesNotaFiscalPropria().get(0)).getMovimentacaoFisica(), (Object)0)) {
            return s;
        }
        for (GradeItemNotaFiscalPropria g : i.getGradesNotaFiscalPropria()) {
            s.append(CompOBSFaturamento.buildOBS(op.getObsItemLoteFabricacao(), g));
        }
        return s;
    }

    private StringBuilder getDescUnMedida(ItemNotaFiscalPropria i, OpcoesFaturamento op) {
        StringBuilder s = new StringBuilder();
        if (ToolMethods.isEquals((Object)op.getNaoExibirMensagemConversaoItemNota(), (Object)0)) {
            return s;
        }
        if (ToolMethods.isEquals((Object)i.getUnidadeMedida(), (Object)i.getProduto().getUnidadeMedida())) {
            return s;
        }
        if (i.getUnidadeMedida() != null && i.getProduto() != null && !i.getUnidadeMedida().equals((Object)i.getProduto().getUnidadeMedida())) {
            s.append(CompOBSFaturamento.buildOBS(op.getObsItemConversaoUn(), i, ToolMethods.toList((Object[])new Object[]{new StringToken("QUANTIDADE_CONVERTIDA", ToolFormatter.formataNumero((Number)(i.getQuantidadeTotal() * i.getFatorConversao()), (int)3))})));
        }
        return s;
    }

    private StringBuilder getPrevImpostosProd(ItemNotaFiscalPropria i, OpcoesFaturamento op) {
        StringBuilder s = new StringBuilder();
        if (i.getModeloFiscal() == null) {
            return s;
        }
        if (!ToolMethods.isEquals((Object)i.getModeloFiscal().getImprimirPrevImpInfProd(), (Object)1)) {
            return s;
        }
        s.append(CompOBSFaturamento.buildOBS(op.getObsItemPrevImpostos(), i));
        return s;
    }

    private StringBuilder getFichaConteudoImportacao(ItemNotaFiscalPropria i, UnidadeFederativa ufEmitente, UnidadeFederativa ufDestinatario, OpcoesFaturamento op) {
        ServiceFichaConteudoImportacaoImpl service = (ServiceFichaConteudoImportacaoImpl)Context.get(ServiceFichaConteudoImportacaoImpl.class);
        StringBuilder s = new StringBuilder();
        if (i.getModeloFiscal() == null) {
            return s;
        }
        if (!this.isIncidenciaFCI(i.getModeloFiscal().getModeloFiscalIcms().getIncidenciaIcms(), ufEmitente, ufDestinatario)) {
            return s;
        }
        Map hash = service.findDadosProdutoFCI(i.getProduto());
        if (hash == null) {
            return s;
        }
        Double coeficienteImportacao = (Double)hash.get("COEFICIENTE_IMPORTACAO");
        String codigoFCI = (String)hash.get("CODIGO_FCI");
        s.append(CompOBSFaturamento.buildOBS(op.getObsItemFCI(), i, ToolMethods.toList((Object[])new Object[]{new StringToken("CODIGO_FCI", codigoFCI), new StringToken("COEFICIENTE_IMPORTACAO", ToolFormatter.formataNumero((Number)coeficienteImportacao, (int)2))})));
        return s;
    }

    private boolean isIncidenciaFCI(IncidenciaIcms incidenciaIcms, UnidadeFederativa ufEmitente, UnidadeFederativa ufDestinatario) {
        return (incidenciaIcms.getCodigo().equals("300") || incidenciaIcms.getCodigo().equals("310") || incidenciaIcms.getCodigo().equals("320") || incidenciaIcms.getCodigo().equals("330") || incidenciaIcms.getCodigo().equals("340") || incidenciaIcms.getCodigo().equals("341") || incidenciaIcms.getCodigo().equals("350") || incidenciaIcms.getCodigo().equals("351") || incidenciaIcms.getCodigo().equals("360") || incidenciaIcms.getCodigo().equals("370") || incidenciaIcms.getCodigo().equals("390") || incidenciaIcms.getCodigo().equals("500") || incidenciaIcms.getCodigo().equals("510") || incidenciaIcms.getCodigo().equals("520") || incidenciaIcms.getCodigo().equals("530") || incidenciaIcms.getCodigo().equals("540") || incidenciaIcms.getCodigo().equals("541") || incidenciaIcms.getCodigo().equals("550") || incidenciaIcms.getCodigo().equals("551") || incidenciaIcms.getCodigo().equals("560") || incidenciaIcms.getCodigo().equals("570") || incidenciaIcms.getCodigo().equals("590")) && !ufDestinatario.equals((Object)ufEmitente);
    }

    private StringBuilder getValoresFCP(ItemNotaFiscalPropria i, OpcoesFaturamento op) {
        StringBuilder s = new StringBuilder();
        if (i != null && i.getItemNotaLivroFiscal() != null) {
            ItemNotaLivroFiscal ilf = i.getItemNotaLivroFiscal();
            if (ilf.getValorBCFCP() > 0.0 && ilf.getValorFCP() > 0.0 && ilf.getAliquotaFCP() > 0.0) {
                s.append(CompOBSFaturamento.buildOBS(op.getObsItemValoresFCP(), i));
            }
            if (ilf.getValorBCFCPSt() > 0.0 && ilf.getValorFCPSt() > 0.0 && ilf.getAliquotaFCPSt() > 0.0) {
                s.append(CompOBSFaturamento.buildOBS(op.getObsItemValoresFCPST(), i));
            }
            if (ilf.getValorBCFCPStRetido() > 0.0 && ilf.getValorFCPStRetido() > 0.0 && ilf.getAliquotaFCPStRetido() > 0.0) {
                s.append(CompOBSFaturamento.buildOBS(op.getObsItemValoresFCPSTRet(), i));
            }
        }
        return s;
    }

    private String checkAndSetObsMod(ItemNotaFiscalPropria i) {
        if (i == null || i.getModeloFiscal() == null) {
            return "";
        }
        LinkedList<ObsFaturamento> obs = new LinkedList<ObsFaturamento>();
        for (ModeloFiscalObsFisco ob : i.getModeloFiscal().getObservacoesFisco()) {
            if (!ToolMethods.isEquals((Object)ob.getAtivo(), (Object)1) || !ToolMethods.isEquals((Object)ob.getTipoObservacao(), (Object)EnumConstModeloFiscalObs.TIPO_OBS_PRODUTO.getValue()) || ToolMethods.isStrWithData((String)ob.getObsFaturamento().getChave())) continue;
            obs.add(ob.getObsFaturamento());
        }
        for (ModeloFiscalObsFisco ob : i.getModeloFiscal().getObservacoesContrib()) {
            if (!ToolMethods.isEquals((Object)ob.getAtivo(), (Object)1) || !ToolMethods.isEquals((Object)ob.getTipoObservacao(), (Object)EnumConstModeloFiscalObs.TIPO_OBS_PRODUTO.getValue()) || ToolMethods.isStrWithData((String)ob.getObsFaturamento().getChave())) continue;
            obs.add(ob.getObsFaturamento());
        }
        StringBuilder sb = new StringBuilder();
        for (ObsFaturamento ob : obs) {
            sb.append(CompOBSFaturamento.buildOBS(ob, i));
        }
        return sb.toString();
    }
}

