/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.notapropria;

import com.touchcomp.basementor.constants.enums.modelodocfiscal.EnumConstModDocFiscal;
import com.touchcomp.basementor.constants.enums.piscofins.EnumConstTipoAliquotaPisCofins;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.ClasseEnquadramentoIPI;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaPropriaCbs;
import com.touchcomp.basementor.model.vo.ItemNotaPropriaIS;
import com.touchcomp.basementor.model.vo.ItemNotaPropriaIbs;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.ItemOrdemCompra;
import com.touchcomp.basementor.model.vo.ItemPedidoComercio;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalIpi;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.ParamTribCbsIbsClass;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.UnidadeFederativaOrigDest;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorrules.suframa.CompSuframa;
import com.touchcomp.basementorrules.suframa.model.SuframaCalculado;
import com.touchcomp.basementorrules.suframa.model.SuframaParams;
import com.touchcomp.basementorservice.components.calculovalores.BaseCalculoValores;
import com.touchcomp.basementorservice.components.contabil.CompParametrizacaoContabilNF;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.helpers.impl.cfop.HelperCfop;
import com.touchcomp.basementorservice.helpers.impl.modelofiscal.HelperModeloFiscal;
import com.touchcomp.basementorservice.helpers.impl.notapropria.AuxBuildOBSItemNota;
import com.touchcomp.basementorservice.helpers.impl.produto.HelperProduto;
import com.touchcomp.basementorservice.service.impl.impostos.cbs.params.SCompCBSParams;
import com.touchcomp.basementorservice.service.impl.impostos.ibs.params.SCompIBSParams;
import com.touchcomp.basementorservice.service.impl.impostos.is.params.SCompISParams;
import com.touchcomp.basementorservice.service.impl.paramtribcbsibs.ServiceParamTribCbsIbsImpl;
import com.touchcomp.basementorservice.service.impl.unidadefederativaorigdest.ServiceUnidadeFederativaOrigDestImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.List;

public class HelperItemNotaPropria
implements AbstractHelper<ItemNotaFiscalPropria> {
    private ItemNotaFiscalPropria item;

    public ItemNotaFiscalPropria get() {
        return this.item;
    }

    public HelperItemNotaPropria(ItemNotaFiscalPropria item) {
        this.item = item;
    }

    public HelperItemNotaPropria() {
    }

    public HelperItemNotaPropria build(ItemNotaFiscalPropria data) {
        this.item = data;
        return this;
    }

    public void setNatReceitaPisCofins() {
        this.item.setNatReceitaPisCofins(new HelperProduto().build(this.item.getProduto()).getNaturezaReceitaPisCofins(this.item.getIncidenciaPisCofins()));
    }

    public String getInfAdItemSistema(UnidadeFederativa ufEmitente, UnidadeFederativa ufDestinatario, ItemNotaFiscalPropria i, OpcoesFaturamento op) {
        String str = new AuxBuildOBSItemNota().getInfAdItemSistema(i, ufEmitente, ufDestinatario, op);
        return str;
    }

    public void buildAndSetInfAdItemSistema(UnidadeFederativa ufEmitente, UnidadeFederativa ufDestinatario, ItemNotaFiscalPropria i, OpcoesFaturamento op) {
        String str = this.getInfAdItemSistema(ufEmitente, ufDestinatario, i, op);
        i.setInfAdicionalItemSistema(str);
    }

    public ItemNotaFiscalPropria recalcularItem(ItemNotaFiscalPropria item, NaturezaOperacao natOP, UnidadeFatCliente unid, Empresa empresa, OpcoesContabeis opCont, Date dataEmissao) throws Exception {
        List<ModeloFiscal> modelos = this.procurarModelosFiscais(item.getProduto(), natOP, unid, empresa);
        if (ToolMethods.isWithData(modelos)) {
            for (ModeloFiscal modelo : modelos) {
                if (!ToolMethods.isEquals((Object)item.getModeloFiscal(), (Object)modelo)) continue;
                return item;
            }
            ModeloFiscal mod = modelos.get(0);
            item.setModeloFiscal(mod);
            item.setGerarFinanceiro(item.getModeloFiscal().getGerarFinanceiro());
            item.setIssRetido(Short.valueOf(item.getModeloFiscal().getIssRetido().equals((short)1) ? (short)1 : 0));
            item.getItemNotaLivroFiscal().setCfop(this.findCfop(natOP, mod, empresa.getPessoa().getEndereco().getCidade().getUf(), unid.getPessoa().getEndereco().getCidade().getUf()));
            item.setIncidenciaIcms(item.getModeloFiscal().getModeloFiscalIcms().getIncidenciaIcms());
            item.setModalidadeIcms(item.getModeloFiscal().getModeloFiscalIcms().getModalidadeIcms());
            item.setModalidadeIcmsSt(item.getModeloFiscal().getModeloFiscalIcms().getModalidadeIcmsSt());
            item.getItemNotaLivroFiscal().setAliquotaIcms(this.findAliquotaIcms(natOP, mod, empresa.getPessoa().getEndereco().getCidade().getUf(), unid.getPessoa().getEndereco().getCidade().getUf(), item.getProduto()));
            item.getItemNotaLivroFiscal().setAliquotaICMSSimples(this.findAliquotaIcmsSimples(empresa));
            if (item.getModeloFiscal().getModeloFiscalIcms() != null && item.getModeloFiscal().getModeloFiscalIcms().getMotivoDesoneracaoIcms() != null) {
                item.setMotivoDesoneracaoIcms(item.getModeloFiscal().getModeloFiscalIcms().getMotivoDesoneracaoIcms());
            }
            if (mod != null && ToolMethods.isEquals((Object)mod.getModeloFiscalIcms().getTipoPercReducaoBaseCalcIcms(), (Object)2)) {
                item.getItemNotaLivroFiscal().setPercReducaoBCIcms(mod.getModeloFiscalIcms().getReducaoBaseCalcIcms());
            } else {
                item.getItemNotaLivroFiscal().setPercReducaoBCIcms(item.getProduto().getReducaoBaseCalcIcms());
            }
            item.setIncidenciaIpi(item.getModeloFiscal().getModeloFiscalIpi().getIncidenciaIpi());
            item.setClasseEnquadramentoIpi(this.getClasseEnquadramentoIpi(item));
            item.getItemNotaLivroFiscal().setAliquotaIpi(this.findAliquotaIpi(item.getProduto(), item.getModeloFiscal().getModeloFiscalIpi()));
            item.setIncidenciaPisCofins(item.getModeloFiscal().getModeloFiscalPisCofins().getIncidenciaPisCofins());
            new HelperItemNotaPropria(item).setNatReceitaPisCofins();
            if (mod.getModeloFiscalPisCofins().getCalcularPisNormal().equals((short)1)) {
                if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                    item.getItemNotaLivroFiscal().setAliquotaPis(mod.getModeloFiscalPisCofins().getAliquotaPis());
                } else {
                    item.getItemNotaLivroFiscal().setAliquotaPis(item.getProduto().getAliquotaPis());
                }
            } else {
                item.getItemNotaLivroFiscal().setAliquotaPis(Double.valueOf(0.0));
            }
            if (mod.getModeloFiscalPisCofins().getCalcularPisSt().equals((short)1)) {
                if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                    item.getItemNotaLivroFiscal().setAliquotaPisSt(mod.getModeloFiscalPisCofins().getAliquotaPisSt());
                } else {
                    item.getItemNotaLivroFiscal().setAliquotaPisSt(item.getProduto().getAliquotaPisSt());
                }
            } else {
                item.getItemNotaLivroFiscal().setAliquotaPisSt(Double.valueOf(0.0));
            }
            if (mod.getModeloFiscalPisCofins().getCalcularCofinsNormal().equals((short)1)) {
                if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                    item.getItemNotaLivroFiscal().setAliquotaCofins(mod.getModeloFiscalPisCofins().getAliquotaCofins());
                } else {
                    item.getItemNotaLivroFiscal().setAliquotaCofins(item.getProduto().getAliquotaCofins());
                }
            } else {
                item.getItemNotaLivroFiscal().setAliquotaCofins(Double.valueOf(0.0));
            }
            if (mod.getModeloFiscalPisCofins().getCalcularCofinsSt().equals((short)1)) {
                if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                    item.getItemNotaLivroFiscal().setAliquotaCofinsSt(mod.getModeloFiscalPisCofins().getAliquotaCofinsSt());
                } else {
                    item.getItemNotaLivroFiscal().setAliquotaCofinsSt(item.getProduto().getAliquotaCofinsSt());
                }
            } else {
                item.getItemNotaLivroFiscal().setAliquotaCofinsSt(Double.valueOf(0.0));
            }
            if (mod.getTipoIRRF() != null && mod.getTipoIRRF() == 1) {
                item.getItemNotaLivroFiscal().setAliquotaIrrf(item.getProduto().getAliquotaIrrf());
                item.getItemNotaLivroFiscal().setPercRedIrrf(item.getProduto().getPercRedIrrf());
            }
            if (mod.getTipoFunrural() != null && mod.getTipoFunrural() == 1) {
                item.getItemNotaLivroFiscal().setAliquotaFunrural(item.getProduto().getAliquotaFunrural());
                item.getItemNotaLivroFiscal().setPercRedFunrural(item.getProduto().getPercRedFunrural());
            }
            if (mod.getTipoSenar() != null && mod.getTipoSenar() == 1) {
                item.getItemNotaLivroFiscal().setAliquotaSenar(item.getProduto().getAliquotaSenar());
            }
            if (mod.getTipoRat() != null && mod.getTipoRat() == 1) {
                item.getItemNotaLivroFiscal().setAliquotaRat(item.getProduto().getAliquotaRat());
            }
            if (mod.getTipoTaxaAnimal() != null && mod.getTipoTaxaAnimal() == 1) {
                item.getItemNotaLivroFiscal().setTaxaSanidadeAnimal(item.getProduto().getTaxaSanidadeAnimal());
                item.getItemNotaLivroFiscal().setFatorTaxaSanidadeAnimal(item.getProduto().getFatorTaxaSanidadeAnimal());
            }
            if (mod.getTipoLei10833() != null && mod.getTipoLei10833() == 1) {
                item.getItemNotaLivroFiscal().setAliquotaLei10833(item.getProduto().getAliquotaLei10833());
                item.getItemNotaLivroFiscal().setPercRedLei10833(item.getProduto().getPercRedLei10833());
            }
            if (mod.getTipoOutros() != null && mod.getTipoOutros() == 1) {
                item.getItemNotaLivroFiscal().setAliquotaOutros(item.getProduto().getAliquotaOutros());
                item.getItemNotaLivroFiscal().setPercRedOutros(item.getProduto().getPercRedOutros());
            }
            if (mod.getTipoContSoc() != null && mod.getTipoContSoc() == 1) {
                item.getItemNotaLivroFiscal().setAliquotaContSoc(item.getProduto().getAliquotaContSoc());
                item.getItemNotaLivroFiscal().setPercRedContSoc(item.getProduto().getPercRedContSoc());
            }
            if (mod.getIssRetido() != null && mod.getIssRetido() != 2) {
                item.getItemNotaLivroFiscal().setAliquotaIss(item.getProduto().getAliquotaIss());
            }
            this.setDadosContabeis(item, unid, natOP, empresa, opCont, item.getItemNotaLivroFiscal().getCfop());
        } else {
            item.setModeloFiscal(null);
        }
        return item;
    }

    public ItemNotaFiscalPropria novoItem(Produto prod, NaturezaOperacao natOP, UnidadeFatCliente unid) {
        return null;
    }

    private List<ModeloFiscal> procurarModelosFiscais(Produto produto, NaturezaOperacao natOP, UnidadeFatCliente unid, Empresa empresa) throws ExceptionObjNotFound {
        HelperModeloFiscal helper = (HelperModeloFiscal)ConfApplicationContext.getBean(HelperModeloFiscal.class);
        return helper.getModelosFiscais(produto, unid, natOP, empresa);
    }

    private Cfop findCfop(NaturezaOperacao natOP, ModeloFiscal mod, UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino) {
        return ((HelperCfop)Context.get(HelperCfop.class)).getCfop(natOP, ufOrigem, ufDestino, mod);
    }

    public Double findAliquotaIcms(NaturezaOperacao naturezaOperacao, ModeloFiscal mod, UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino, Produto produto) {
        double alICMS = 0.0;
        if (mod != null) {
            if (mod.getModeloFiscalIcms().getTipoAliquotaIcms() == 2) {
                alICMS = mod.getModeloFiscalIcms().getAliquotaIcms();
            } else if (mod.getModeloFiscalIcms().getTipoAliquotaIcms() == 1) {
                alICMS = ToolMethods.isEquals((Object)naturezaOperacao.getEntradaSaida(), (Object)1) ? this.getAliquotaICMS(ufOrigem, ufDestino, produto).doubleValue() : this.getAliquotaICMS(ufDestino, ufOrigem, produto).doubleValue();
            }
        }
        return alICMS;
    }

    private Double getAliquotaICMS(UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino, Produto prod) {
        if (prod == null) {
            return 0.0;
        }
        if (ufDestino.equals((Object)ufOrigem)) {
            return prod.getAliquotaIcms();
        }
        return this.getAliquotaICMS(ufOrigem, ufDestino);
    }

    private Double getAliquotaICMS(UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino) {
        ServiceUnidadeFederativaOrigDestImpl serviceUnidadeFederativaOrigDest = (ServiceUnidadeFederativaOrigDestImpl)ConfApplicationContext.getBean(ServiceUnidadeFederativaOrigDestImpl.class);
        UnidadeFederativaOrigDest found = serviceUnidadeFederativaOrigDest.get(ufOrigem, ufDestino);
        if (found != null) {
            return found.getAliquotaICMS();
        }
        return 0.0;
    }

    private Double findAliquotaIcmsSimples(Empresa empresa) {
        return empresa.getEmpresaDados().getAliquotaICMSSimples() != null ? empresa.getEmpresaDados().getAliquotaICMSSimples() : 0.0;
    }

    private Double findAliquotaIpi(Produto produto, ModeloFiscalIpi modeloFiscalIpi) {
        return BaseCalculoValores.getAliquotaIpi(produto, modeloFiscalIpi);
    }

    private void setDadosContabeis(ItemNotaFiscalPropria i, UnidadeFatCliente unid, NaturezaOperacao natOperacao, Empresa empresa, OpcoesContabeis opCont, Cfop cfop) throws Exception {
        CompParametrizacaoContabilNF comp = (CompParametrizacaoContabilNF)Context.get(CompParametrizacaoContabilNF.class);
        CompParametrizacaoContabilNF.DadosContas dados = comp.getPlanoContasNfPropria(i.getModeloFiscal(), i.getProduto(), unid, natOperacao, empresa, unid.getCategoriaPessoa(), opCont, cfop);
        i.setPlanoContaCred(dados.getPlanoContaCred());
        i.setPlanoContaDeb(dados.getPlanoContaDeb());
        i.setPlanoContaGerencial(dados.getPcGerencial());
        if (i.getPlanoContaGerencial() == null) {
            i.setPlanoContaGerencial(this.item.getProduto().getPlanoContaGerencial());
        }
        if (i.getPlanoContaGerencial() == null) {
            throw new Exception("Plano de conta gerencial n\u00c3\u00a3o definido na parametriza\u00c3\u00a7\u00c3\u00a3o cont\u00c3\u00a1bil do modelo fiscal ou no produto.");
        }
    }

    private ClasseEnquadramentoIPI getClasseEnquadramentoIpi(ItemNotaFiscalPropria item) {
        ClasseEnquadramentoIPI classeEnqIpi = item.getProduto().getClasseEnqIpi();
        if (classeEnqIpi == null && item.getModeloFiscal().getModeloFiscalIpi().getClasseEnquadramentoIpi() != null) {
            item.setClasseEnquadramentoIpi(item.getModeloFiscal().getModeloFiscalIpi().getClasseEnquadramentoIpi());
        }
        return classeEnqIpi;
    }

    public ItemNotaFiscalPropria calcularValoresAcessoriosInformados(ItemNotaFiscalPropria item) {
        this.setDescontoInformadoItem(item);
        this.setFreteInformadoItem(item);
        this.setSeguroInformadoItem(item);
        this.setDespAcessInformadoItem(item);
        this.calcularTotalizadoresAcessoriosItem(item);
        return item;
    }

    private void setDescontoInformadoItem(ItemNotaFiscalPropria item) {
        double vlrProduto = this.getValorTotalBruto(item);
        double valorDescCalc = 0.0;
        double percDescCalc = 0.0;
        if (ToolMethods.isEquals((Object)item.getTipoDesconto(), (Object)0)) {
            valorDescCalc = ToolFormatter.arrredondarNumero((Double)(item.getPercDescontoItemInf() / 100.0 * vlrProduto), (int)2);
            item.setValorDescontoItemInf(Double.valueOf(valorDescCalc));
        } else {
            percDescCalc = item.getValorDescontoItemInf() > 0.0 ? ToolFormatter.arrredondarNumero((Double)(item.getValorDescontoItemInf() / vlrProduto * 100.0), (int)4) : 0.0;
            item.setPercDescontoItemInf(Double.valueOf(percDescCalc));
        }
    }

    private void setFreteInformadoItem(ItemNotaFiscalPropria item) {
        double vlrProduto = this.getValorTotalBruto(item);
        double valorCalc = 0.0;
        double percCalc = 0.0;
        if (ToolMethods.isEquals((Object)item.getTipoFrete(), (Object)0)) {
            valorCalc = ToolFormatter.arrredondarNumero((Double)(item.getPercFreteItemInf() / 100.0 * vlrProduto), (int)2);
            item.setValorFreteItemInf(Double.valueOf(valorCalc));
        } else {
            percCalc = item.getValorFreteItemInf() > 0.0 ? ToolFormatter.arrredondarNumero((Double)(item.getValorFreteItemInf() / vlrProduto * 100.0), (int)4) : 0.0;
            item.setPercFreteItemInf(Double.valueOf(percCalc));
        }
    }

    private void setSeguroInformadoItem(ItemNotaFiscalPropria item) {
        double vlrProduto = this.getValorTotalBruto(item);
        double valorCalc = 0.0;
        double percCalc = 0.0;
        if (ToolMethods.isEquals((Object)item.getTipoSeguro(), (Object)0)) {
            valorCalc = ToolFormatter.arrredondarNumero((Double)(item.getPercSeguroItemInf() / 100.0 * vlrProduto), (int)2);
            item.setValorSeguroItemInf(Double.valueOf(valorCalc));
        } else {
            percCalc = item.getValorSeguroItemInf() > 0.0 ? ToolFormatter.arrredondarNumero((Double)(item.getValorSeguroItemInf() / vlrProduto * 100.0), (int)4) : 0.0;
            item.setPercSeguroItemInf(Double.valueOf(percCalc));
        }
    }

    private void setDespAcessInformadoItem(ItemNotaFiscalPropria item) {
        double vlrProduto = this.getValorTotalBruto(item);
        double valorCalc = 0.0;
        double percCalc = 0.0;
        if (ToolMethods.isEquals((Object)item.getTipoDespAcessoria(), (Object)0)) {
            valorCalc = ToolFormatter.arrredondarNumero((Double)(item.getPercDespAcessItemInf() / 100.0 * vlrProduto), (int)2);
            item.setValorDespAcessItemInf(Double.valueOf(valorCalc));
        } else {
            percCalc = item.getValorDespAcessItemInf() > 0.0 ? ToolFormatter.arrredondarNumero((Double)(item.getValorDespAcessItemInf() / vlrProduto * 100.0), (int)4) : 0.0;
            item.setPercDespAcessItemInf(Double.valueOf(percCalc));
        }
    }

    public void calcularTotalizadoresAcessoriosItem(ItemNotaFiscalPropria item) {
        this.calcularTotalDesconto(item);
        this.calcularTotalFrete(item);
        this.calcularTotalSeguro(item);
        this.calcularTotalDespAcessoria(item);
    }

    private void calcularTotalDesconto(ItemNotaFiscalPropria item) {
        Double valorTotalBruto = this.getValorTotalBruto(item);
        Double valorTotalDesconto = ToolFormatter.arrredondarNumero((Double)(item.getValorDescontoItemInf() + item.getValorDescontoRateado() + item.getValorDescontoTrib() + item.getValorDescontoPromocional()), (int)2);
        Double percDesconto = 0.0;
        if (valorTotalDesconto > 0.0 && valorTotalBruto > 0.0) {
            percDesconto = ToolFormatter.arrredondarNumero((Double)(valorTotalDesconto * 100.0 / valorTotalBruto), (int)4);
        }
        item.setValorDesconto(valorTotalDesconto);
        item.setPercDesconto(percDesconto);
    }

    private void calcularTotalFrete(ItemNotaFiscalPropria item) {
        Double valorTotalBruto = this.getValorTotalBruto(item);
        Double valorTotalFrete = ToolFormatter.arrredondarNumero((Double)(item.getValorFreteItemInf() + item.getValorFreteRateado()), (int)2);
        Double percFrete = 0.0;
        if (valorTotalFrete > 0.0 && valorTotalBruto > 0.0) {
            percFrete = ToolFormatter.arrredondarNumero((Double)(valorTotalFrete * 100.0 / valorTotalBruto), (int)4);
        }
        item.setValorFrete(valorTotalFrete);
        item.setPercFrete(percFrete);
    }

    private void calcularTotalDespAcessoria(ItemNotaFiscalPropria item) {
        Double valorTotalBruto = this.getValorTotalBruto(item);
        Double valorTotalDesp = ToolFormatter.arrredondarNumero((Double)(item.getValorDespAcessItemInf() + item.getValorDespAcessRateado()), (int)2);
        Double percDesp = 0.0;
        if (valorTotalDesp > 0.0 && valorTotalBruto > 0.0) {
            percDesp = ToolFormatter.arrredondarNumero((Double)(valorTotalDesp * 100.0 / valorTotalBruto), (int)4);
        }
        item.setValorDespAcessoria(valorTotalDesp);
        item.setPercDespAcessoria(percDesp);
    }

    private void calcularTotalSeguro(ItemNotaFiscalPropria item) {
        Double valorTotalBruto = this.getValorTotalBruto(item);
        Double valorTotalSeguro = ToolFormatter.arrredondarNumero((Double)(item.getValorSeguroItemInf() + item.getValorSeguroRateado()), (int)2);
        Double percSeguro = 0.0;
        if (valorTotalSeguro > 0.0 && valorTotalBruto > 0.0) {
            percSeguro = ToolFormatter.arrredondarNumero((Double)(valorTotalSeguro * 100.0 / valorTotalBruto), (int)4);
        }
        item.setVrSeguro(valorTotalSeguro);
        item.setPercSeguro(percSeguro);
    }

    public void calcularSuframa(ItemNotaFiscalPropria item, Cliente cliente) {
        Double valorTotalBruto;
        if (item.getModeloFiscal() == null || cliente == null) {
            return;
        }
        SuframaParams params = new SuframaParams();
        params.setHabilitarSuframa(cliente.getPessoa().getComplemento().getHabilitarSuframa());
        params.setInscricaoSuframa(cliente.getPessoa().getComplemento().getSuframa());
        params.setNaoCalcularSuframaModelo(item.getModeloFiscal().getNaoCalcularSuframa());
        params.setNaoCalcularSuframaProduto(item.getProduto().getNaoAplicaSuframa());
        params.setAliqSuframaIpi(cliente.getFaturamento().getPercentualIpiSufr());
        params.setAliqSuframaPis(cliente.getFaturamento().getPercentualPisSufr());
        params.setAliqSuframaCofins(cliente.getFaturamento().getPercentualCofinsSufr());
        if (item.getModeloFiscal() == null || !item.getModeloFiscal().getModeloFiscalIcms().getIcmsDispensadoDesconto().equals((short)1) || item.getModeloFiscal().getModeloFiscalIcms().getMotivoDesoneracaoIcms() == null || !item.getModeloFiscal().getModeloFiscalIcms().getMotivoDesoneracaoIcms().getCodigo().equals("7")) {
            params.setAliqSuframaIcms(cliente.getFaturamento().getPercentualIcmsSufr());
        } else {
            params.setAliqSuframaIcms(Double.valueOf(0.0));
        }
        Double bcPis = valorTotalBruto = this.getValorTotalBruto(item);
        Double bcCofins = valorTotalBruto;
        Double bcIcms = valorTotalBruto;
        Double bcIpi = valorTotalBruto;
        if (ToolMethods.isEquals((Object)item.getModeloFiscal().getModeloFiscalIcms().getIncluiFrete(), (Object)1)) {
            bcIcms = bcIcms + item.getValorFrete();
        }
        if (ToolMethods.isEquals((Object)item.getModeloFiscal().getModeloFiscalIcms().getIncluiSeguro(), (Object)1)) {
            bcIcms = bcIcms + item.getVrSeguro();
        }
        if (ToolMethods.isEquals((Object)item.getModeloFiscal().getModeloFiscalIcms().getIncluiDespAcess(), (Object)1)) {
            bcIcms = bcIcms + item.getValorDespAcessoria();
        }
        if (ToolMethods.isEquals((Object)item.getModeloFiscal().getModeloFiscalIpi().getIncluiFrete(), (Object)1)) {
            bcIpi = bcIpi + item.getValorFrete();
        }
        if (ToolMethods.isEquals((Object)item.getModeloFiscal().getModeloFiscalIpi().getIncluiSeguro(), (Object)1)) {
            bcIpi = bcIpi + item.getVrSeguro();
        }
        if (ToolMethods.isEquals((Object)item.getModeloFiscal().getModeloFiscalIpi().getIncluiDespAcess(), (Object)1)) {
            bcIpi = bcIpi + item.getValorDespAcessoria();
        }
        if (ToolMethods.isEquals((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiFrete(), (Object)1)) {
            bcPis = bcPis + item.getValorFrete();
            bcCofins = bcCofins + item.getValorFrete();
        }
        if (ToolMethods.isEquals((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiSeguro(), (Object)1)) {
            bcPis = bcPis + item.getVrSeguro();
            bcCofins = bcCofins + item.getVrSeguro();
        }
        if (ToolMethods.isEquals((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiDespAcess(), (Object)1)) {
            bcPis = bcPis + item.getValorDespAcessoria();
            bcCofins = bcCofins + item.getValorDespAcessoria();
        }
        if (ToolMethods.isEquals((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getAbaterValorIcms(), (Object)1)) {
            bcPis = bcPis - item.getItemNotaLivroFiscal().getVrIcms();
            bcCofins = bcCofins - item.getItemNotaLivroFiscal().getVrIcms();
        }
        if (ToolMethods.isEquals((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIcmsDesonerado(), (Object)1)) {
            bcPis = bcPis - item.getItemNotaLivroFiscal().getVrIcmsDesonerado();
            bcCofins = bcCofins - item.getItemNotaLivroFiscal().getVrIcmsDesonerado();
        }
        if (ToolMethods.isEquals((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIcmsSemAproveitamento(), (Object)1)) {
            bcPis = bcPis - item.getItemNotaLivroFiscal().getVrIcmsSemAprov();
            bcCofins = bcCofins - item.getItemNotaLivroFiscal().getVrIcmsSemAprov();
        }
        params.setBcIcms(bcIcms);
        params.setBcIpi(bcIpi);
        params.setBcPis(bcPis);
        params.setBcCofins(bcCofins);
        SuframaCalculado calc = CompSuframa.calcularSuframa((SuframaParams)params);
        item.setPercDescontoTrib(calc.getPercSuframa());
        item.setValorDescontoTrib(calc.getValorSuframa());
        this.calcularTotalDesconto(item);
    }

    public void setOutrosValoresAcessoriosFromItemNotaTerceiros(ItemNotaFiscalPropria ip, ItemNotaTerceiros it) {
        if (it.getValorDesconto() > 0.0) {
            if (ToolMethods.isEquals((Object)it.getDescontoItem(), (Object)1)) {
                ip.setValorDescontoItemInf(it.getValorDesconto());
                ip.setPercDescontoItemInf(it.getPercDesconto());
            } else {
                ip.setValorDescontoRateado(it.getValorDesconto());
                ip.setPercDescontoRateado(it.getPercDesconto());
            }
        }
        if (it.getValorFrete() > 0.0) {
            if (ToolMethods.isEquals((Object)it.getFreteItem(), (Object)1)) {
                ip.setValorFreteItemInf(it.getValorFrete());
                ip.setPercFreteItemInf(it.getPercFrete());
            } else {
                ip.setValorFreteRateado(it.getValorFrete());
                ip.setPercFreteRateado(it.getPercFrete());
            }
        }
        if (it.getVrSeguro() > 0.0) {
            if (ToolMethods.isEquals((Object)it.getSeguroItem(), (Object)1)) {
                ip.setValorSeguroItemInf(it.getVrSeguro());
                ip.setPercSeguroItemInf(it.getPercSeguro());
            } else {
                ip.setValorSeguroRateado(it.getVrSeguro());
                ip.setPercSeguroRateado(it.getPercSeguro());
            }
        }
        if (it.getValorDespAcessoria() > 0.0) {
            if (ToolMethods.isEquals((Object)it.getDespAcessItem(), (Object)1)) {
                ip.setValorDespAcessItemInf(it.getValorDespAcessoria());
                ip.setPercDespAcessItemInf(it.getPercDespAcessoria());
            } else {
                ip.setValorDespAcessRateado(it.getValorDespAcessoria());
                ip.setPercDespAcessRateado(it.getPercDespAcessoria());
            }
        }
    }

    public void setOutrosValoresAcessoriosFromItemOrdemCompra(ItemNotaFiscalPropria ip, ItemOrdemCompra it) {
        if (it.getValorDesconto() > 0.0) {
            if (ToolMethods.isEquals((Object)it.getDescontoItem(), (Object)1)) {
                ip.setValorDescontoItemInf(it.getValorDesconto());
                ip.setPercDescontoItemInf(it.getPercDesconto());
            } else {
                ip.setValorDescontoRateado(it.getValorDesconto());
                ip.setPercDescontoRateado(it.getPercDesconto());
            }
        }
        if (it.getValorFrete() > 0.0) {
            if (ToolMethods.isEquals((Object)it.getFreteItem(), (Object)1)) {
                ip.setValorFreteItemInf(it.getValorFrete());
                ip.setPercFreteItemInf(it.getPercFrete());
            } else {
                ip.setValorFreteRateado(it.getValorFrete());
                ip.setPercFreteRateado(it.getPercFrete());
            }
        }
        if (it.getVrSeguro() > 0.0) {
            if (ToolMethods.isEquals((Object)it.getSeguroItem(), (Object)1)) {
                ip.setValorSeguroItemInf(it.getVrSeguro());
                ip.setPercSeguroItemInf(it.getPercSeguro());
            } else {
                ip.setValorSeguroRateado(it.getVrSeguro());
                ip.setPercSeguroRateado(it.getPercSeguro());
            }
        }
        if (it.getValorDespAcessoria() > 0.0) {
            if (ToolMethods.isEquals((Object)it.getDespAcessItem(), (Object)1)) {
                ip.setValorDespAcessItemInf(it.getValorDespAcessoria());
                ip.setPercDespAcessItemInf(it.getPercDespesaAcessoria());
            } else {
                ip.setValorDespAcessRateado(it.getValorDespAcessoria());
                ip.setPercDespAcessRateado(it.getPercDespesaAcessoria());
            }
        }
    }

    public void setOutrosValoresAcessoriosFromItemPedidoComercio(ItemNotaFiscalPropria ip, ItemPedidoComercio it) {
        if (it.getValorDesconto() > 0.0) {
            if (ToolMethods.isEquals((Object)it.getDescontoItem(), (Object)1)) {
                ip.setValorDescontoItemInf(it.getValorDesconto());
                ip.setPercDescontoItemInf(it.getPercentualDesconto());
            } else {
                ip.setValorDescontoRateado(it.getValorDesconto());
                ip.setPercDescontoRateado(it.getPercentualDesconto());
            }
        }
        if (it.getValorAcrescimo() > 0.0) {
            if (ToolMethods.isEquals((Object)it.getAcrescimoItem(), (Object)1)) {
                ip.setValorDespAcessItemInf(it.getValorAcrescimo());
                ip.setPercDespAcessItemInf(it.getPercAcrescimo());
            } else {
                ip.setValorDespAcessRateado(it.getValorAcrescimo());
                ip.setPercDespAcessRateado(it.getPercAcrescimo());
            }
        }
    }

    private Double getValorTotalBruto(ItemNotaFiscalPropria item) {
        return ToolFormatter.arrredondarNumero((Double)(item.getValorUnitario() * item.getQuantidadeTotal()), (int)2);
    }

    public void setParamTribAndParametrosCBSIBSIS(ItemNotaFiscalPropria itemNF, Empresa empresa, Date dataMovimentacao, NaturezaOperacao naturezaOperacao, UnidadeFatCliente unidadeFatCliente) throws ExceptionInvalidData {
        ServiceParamTribCbsIbsImpl service = (ServiceParamTribCbsIbsImpl)Context.get(ServiceParamTribCbsIbsImpl.class);
        if (itemNF.getParamTribCbsIbsClass() == null) {
            ParamTribCbsIbsClass param = service.getParametrizacaoNFe(dataMovimentacao, empresa, unidadeFatCliente, itemNF.getProduto(), EnumConstModDocFiscal.get((Object)naturezaOperacao.getModeloDocFiscal().getCodigo()), itemNF.getItemNotaLivroFiscal().getCfop());
            itemNF.setParamTribCbsIbsClass(param);
        }
        this.setParametrosCBSIBSIS(itemNF, empresa, dataMovimentacao, naturezaOperacao, unidadeFatCliente);
    }

    public void setParametrosCBSIBSIS(ItemNotaFiscalPropria itemNF, Empresa empresa, Date dataMovimentacao, NaturezaOperacao naturezaOperacao, UnidadeFatCliente unidadeFatCliente) throws ExceptionInvalidData {
        if (itemNF.getImpostoCBS() == null) {
            itemNF.setImpostoCBS(new ItemNotaPropriaCbs());
        }
        if (itemNF.getImpostoIBS() == null) {
            itemNF.setImpostoIBS(new ItemNotaPropriaIbs());
        }
        if (itemNF.getImpostoSeletivo() == null) {
            itemNF.setImpostoSeletivo(new ItemNotaPropriaIS());
        }
        SCompCBSParams cbsParams = (SCompCBSParams)Context.get(SCompCBSParams.class);
        cbsParams.setParams(itemNF, empresa, dataMovimentacao, naturezaOperacao.getModeloDocFiscal());
        SCompIBSParams ibsParams = (SCompIBSParams)Context.get(SCompIBSParams.class);
        ibsParams.setParams(itemNF, empresa, dataMovimentacao, naturezaOperacao.getModeloDocFiscal(), unidadeFatCliente.getPessoa().getEndereco().getCidade());
        SCompISParams isParams = new SCompISParams();
        isParams.setParams(itemNF);
    }
}

