/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.notapropria;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeTipoEmissao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.helpers.impl.notapropria.HelperItemNotaPropria;
import com.touchcomp.basementorservice.service.impl.opcoescontabeis.ServiceOpcoesContabeisImpl;
import com.touchcomp.basementorspringcontext.Context;
import org.springframework.stereotype.Component;

@Component
public class HelperNotaPropria
implements AbstractHelper<NotaFiscalPropria> {
    private NotaFiscalPropria notaFiscalPropria;

    public NotaFiscalPropria get() {
        return this.notaFiscalPropria;
    }

    public HelperNotaPropria build(NotaFiscalPropria object) {
        this.notaFiscalPropria = object;
        return this;
    }

    public NotaFiscalPropria alterarClienteAndRecalcularItens(NotaFiscalPropria nf) throws Exception {
        OpcoesContabeis opContabeis = this.getOpcoesContabeis(nf.getEmpresa());
        for (ItemNotaFiscalPropria item : nf.getItensNotaPropria()) {
            new HelperItemNotaPropria().recalcularItem(item, nf.getNaturezaOperacao(), nf.getUnidadeFatCliente(), nf.getEmpresa(), opContabeis, nf.getDataEmissaoNota());
        }
        return nf;
    }

    private OpcoesContabeis getOpcoesContabeis(Empresa empresa) {
        ServiceOpcoesContabeisImpl service = (ServiceOpcoesContabeisImpl)Context.get(ServiceOpcoesContabeisImpl.class);
        return service.findByEmpresa(empresa);
    }

    public boolean isStatusAutorizada(NotaFiscalPropria nf) {
        return EnumConstNFeStatus.isStatusAutorizada((Integer)nf.getStatus().intValue()) || nf.getPeriodoEmissaoNFe().getTipoEmissaoNfe().getCodigo().shortValue() == EnumConstNFeTipoEmissao.CONTIGENCIA_EMISSAO_FS.getValue() || nf.getPeriodoEmissaoNFe().getTipoEmissaoNfe().getCodigo().shortValue() == EnumConstNFeTipoEmissao.CONTIGENCIA_FSDA.getValue() || nf.getPeriodoEmissaoNFe().getTipoEmissaoNfe().getCodigo().shortValue() == EnumConstNFeTipoEmissao.CONTIGENCIA_EPEC_EVENTO_EPEC.getValue();
    }
}

