/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesestoque;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.OpcoesEstoqueOp;
import com.touchcomp.basementorrules.opcoesdinamicas.interfaces.ModelOpDinamicasInterface;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class HelperOpcoesEstoque
implements AbstractHelper<OpcoesEstoque> {
    private OpcoesEstoque opcoes;

    public HelperOpcoesEstoque build(OpcoesEstoque opcoes) {
        this.opcoes = opcoes;
        return this;
    }

    public OpcoesEstoque get() {
        return this.opcoes;
    }

    public OpcoesEstoque getOpcoesDefault(Empresa empresa) {
        OpcoesEstoque w = new OpcoesEstoque();
        w.setEmpresa(empresa);
        w.setDataCadastro(new Date());
        return w;
    }

    public List<ModelOpDinamicasInterface> getItens() {
        if (TMethods.isNull((Object)this.opcoes).booleanValue() || !TMethods.isWithData((Collection)this.opcoes.getOpcoesEstoqueOp())) {
            return new LinkedList<ModelOpDinamicasInterface>();
        }
        LinkedList<ModelOpDinamicasInterface> options = new LinkedList<ModelOpDinamicasInterface>();
        for (final OpcoesEstoqueOp opcoesMobileOp : this.opcoes.getOpcoesEstoqueOp()) {
            ModelOpDinamicasInterface a = new ModelOpDinamicasInterface(){

                public String getValor() {
                    return opcoesMobileOp.getValor();
                }

                public String getChave() {
                    return opcoesMobileOp.getCodigo();
                }

                public String getObservacao() {
                    return opcoesMobileOp.getObservacao();
                }

                public Long getIdentificador() {
                    return opcoesMobileOp.getIdentificador();
                }
            };
            options.add(a);
        }
        return options;
    }
}

