/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfinanceiras;

import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesFinanceirasOp;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementorrules.opcoesdinamicas.interfaces.ModelOpDinamicasInterface;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class HelperOpcoesFinanceiras
implements AbstractHelper<OpcoesFinanceiras> {
    private OpcoesFinanceiras opcoesFinanceiras;

    public HelperOpcoesFinanceiras build(OpcoesFinanceiras opcoesFinanceiras) {
        this.opcoesFinanceiras = opcoesFinanceiras;
        return this;
    }

    public OpcoesFinanceiras get() {
        return this.opcoesFinanceiras;
    }

    public CarteiraCobranca getCarteiraCobranca(short pagRec) {
        if (ToolMethods.isEquals((Object)pagRec, (Object)0)) {
            return this.get().getCarteiraCobrancaTitPag();
        }
        return this.get().getCarteiraCobranca();
    }

    public CarteiraCobranca getCarteiraCobrancaDestino(Pessoa p) {
        return this.getCarteiraCobrancaDestino(p, null);
    }

    public CarteiraCobranca getCarteiraCobrancaDestino(Pessoa p, CondicoesPagamento cp) {
        if (p != null && p.getPessoaDadosFinanceiros() != null && p.getPessoaDadosFinanceiros().getCarteiraCobranca() != null) {
            return p.getPessoaDadosFinanceiros().getCarteiraCobranca();
        }
        if (cp != null && cp.getCartCobrancaDestino() != null) {
            return cp.getCartCobrancaDestino();
        }
        return this.get().getCarteiraCobrancaDestino();
    }

    public OpcoesFinanceiras getOpcoesDefault(Empresa empresa) {
        OpcoesFinanceiras w = new OpcoesFinanceiras();
        w.setEmpresa(empresa);
        w.setDataCadastro(new Date());
        return w;
    }

    public List<ModelOpDinamicasInterface> getItens() {
        LinkedList<ModelOpDinamicasInterface> options = new LinkedList<ModelOpDinamicasInterface>();
        if (TMethods.isNotNull((Object)this.opcoesFinanceiras).booleanValue() && TMethods.isWithData((Collection)this.opcoesFinanceiras.getOpcoesFinanceirasOp())) {
            for (final OpcoesFinanceirasOp opcoesMobileOp : this.opcoesFinanceiras.getOpcoesFinanceirasOp()) {
                ModelOpDinamicasInterface a = new ModelOpDinamicasInterface(){

                    public String getValor() {
                        return opcoesMobileOp.getValor();
                    }

                    public String getChave() {
                        return opcoesMobileOp.getCodigo();
                    }

                    public String getObservacao() {
                        return opcoesMobileOp.getObservacao();
                    }

                    public Long getIdentificador() {
                        return opcoesMobileOp.getIdentificador();
                    }
                };
                options.add(a);
            }
        }
        return options;
    }
}

