/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.opcoes.opcoespatrimonio;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.OpcoesPatrimonio;
import com.touchcomp.basementor.model.vo.OpcoesPatrimonioOp;
import com.touchcomp.basementorrules.opcoesdinamicas.interfaces.ModelOpDinamicasInterface;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class HelperOpcoesPatrimonio
implements AbstractHelper<OpcoesPatrimonio> {
    private OpcoesPatrimonio opcoes;

    public HelperOpcoesPatrimonio build(OpcoesPatrimonio opcoes) {
        this.opcoes = opcoes;
        return this;
    }

    public OpcoesPatrimonio get() {
        return this.opcoes;
    }

    public OpcoesPatrimonio getOpcoesDefault(Empresa empresa) {
        OpcoesPatrimonio w = new OpcoesPatrimonio();
        w.setEmpresa(empresa);
        w.setDataCadastro(new Date());
        return w;
    }

    public List<ModelOpDinamicasInterface> getItens() {
        if (TMethods.isNull((Object)this.opcoes).booleanValue() || !TMethods.isWithData((Collection)this.opcoes.getOpcoesPatrimonioOp())) {
            return new LinkedList<ModelOpDinamicasInterface>();
        }
        LinkedList<ModelOpDinamicasInterface> options = new LinkedList<ModelOpDinamicasInterface>();
        for (final OpcoesPatrimonioOp option : this.opcoes.getOpcoesPatrimonioOp()) {
            ModelOpDinamicasInterface a = new ModelOpDinamicasInterface(){

                public String getValor() {
                    return option.getValor();
                }

                public String getChave() {
                    return option.getCodigo();
                }

                public String getObservacao() {
                    return option.getObservacao();
                }

                public Long getIdentificador() {
                    return option.getIdentificador();
                }
            };
            options.add(a);
        }
        return options;
    }
}

