/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.ordemcompra;

import com.touchcomp.basementor.model.vo.EmailGrupoNecCompra;
import com.touchcomp.basementor.model.vo.EmailsOrdemCompra;
import com.touchcomp.basementor.model.vo.ItemOrdemCompra;
import com.touchcomp.basementor.model.vo.ItemOrdemCompraNecCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OrdemCompra;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.stereotype.Component;

@Component
public class HelperOrdemCompra
implements AbstractHelper<OrdemCompra> {
    private OrdemCompra ordemCompra;

    public OrdemCompra get() {
        return this.ordemCompra;
    }

    public HelperOrdemCompra build(OrdemCompra data) {
        this.ordemCompra = data;
        return this;
    }

    public Double calcularQuantidadeProduto(Long produto) {
        Double quantidade = 0.0;
        if (produto == null) {
            return quantidade;
        }
        for (ItemOrdemCompra i : this.ordemCompra.getItemOrdemCompra()) {
            if (i.getProduto() == null || !ToolMethods.isEquals((Object)i.getProduto().getIdentificador(), (Object)produto)) continue;
            quantidade = quantidade + i.getQuantidadeTotal();
        }
        return quantidade;
    }

    public void setarObservacao() {
        if (!TMethods.isNull((Object)this.ordemCompra.getCotacaoCompra()).booleanValue()) {
            this.ordemCompra.setObservacao(this.ordemCompra.getCotacaoCompra().getObservacao());
        }
    }

    public void setarEmails() {
        for (ItemOrdemCompra item : this.ordemCompra.getItemOrdemCompra()) {
            for (ItemOrdemCompraNecCompra itemNecCompra : item.getItemOrdemCompraNecCompra()) {
                for (EmailGrupoNecCompra eg : itemNecCompra.getNecessidadeCompra().getEmailGrupoNecCompra()) {
                    Predicate<EmailsOrdemCompra> p2 = e -> e.getEmail().equals(eg.getEmail());
                    if (this.ordemCompra.getEmailsOrdemCompra().stream().anyMatch(p2)) continue;
                    EmailsOrdemCompra o = new EmailsOrdemCompra();
                    o.setOrdemCompra(this.ordemCompra);
                    o.setEmail(eg.getEmail());
                    this.ordemCompra.getEmailsOrdemCompra().add(o);
                }
            }
        }
    }

    public void setarNrSequencial(OpcoesCompraSuprimentos opcoesCompra) {
        block3: {
            List itens;
            block2: {
                itens = this.ordemCompra.getItemOrdemCompra();
                if (!TMethods.isAffirmative((Number)opcoesCompra.getAlterarNrSeqItemCompraNaEdicao())) break block2;
                for (int i = 1; i <= itens.size(); ++i) {
                    ((ItemOrdemCompra)itens.get(i - 1)).setNrSequencial(Integer.valueOf(i));
                }
                break block3;
            }
            Boolean existeItensNaoSalvos = this.verificaItensNaoSalvos(itens);
            if (!existeItensNaoSalvos.booleanValue()) break block3;
            Integer maiorNrSeq = this.getMaiorNrSequencialItem(itens);
            for (ItemOrdemCompra item : itens) {
                if (!TMethods.isNull((Object)item.getIdentificador()).booleanValue() || !TMethods.isNull((Object)item.getNrSequencial()).booleanValue() && item.getNrSequencial() != 0) continue;
                Integer n = maiorNrSeq;
                maiorNrSeq = maiorNrSeq + 1;
                item.setNrSequencial(maiorNrSeq);
            }
        }
    }

    private Boolean verificaItensNaoSalvos(List<ItemOrdemCompra> itens) {
        for (ItemOrdemCompra item : itens) {
            if (!TMethods.isNull((Object)item.getIdentificador()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private Integer getMaiorNrSequencialItem(List<ItemOrdemCompra> itens) {
        Integer nrSeq = 0;
        for (ItemOrdemCompra item : itens) {
            if (TMethods.isNull((Object)item.getNrSequencial()).booleanValue() || item.getNrSequencial() <= nrSeq) continue;
            nrSeq = item.getNrSequencial();
        }
        return nrSeq;
    }

    public void setarPrazoMaximoEntItens(OpcoesCompraSuprimentos opCompra) {
        Long value = 0L;
        for (ItemOrdemCompra item : this.ordemCompra.getItemOrdemCompra()) {
            if (TMethods.isNull((Object)item.getPrazoEntrega()).booleanValue() || item.getPrazoEntrega() <= value) continue;
            value = item.getPrazoEntrega();
        }
        this.ordemCompra.setPrazoMaxEntregaItens(value);
        if (TMethods.isAffirmative((Number)opCompra.getUsarDtEmissaoPrevChegada())) {
            Long qtd = ToolDate.difBetweenDatesInDays((Date)this.ordemCompra.getDataPrevChegada(), (Date)this.ordemCompra.getDataEmissao());
            this.ordemCompra.setPrazoEntrega(Math.abs(qtd) + " Dia(s)");
        }
    }
}

