/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.ordemservico;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.CronogramaOrdemServico;
import com.touchcomp.basementor.model.vo.CronogramaPlanoManutencaoAtivo;
import com.touchcomp.basementor.model.vo.OrdemServico;
import com.touchcomp.basementor.model.vo.PlanoManutencaoAtivo;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class HelperCronogramaOrdemServico
implements AbstractHelper<CronogramaOrdemServico> {
    CronogramaOrdemServico cronograma;

    public CronogramaOrdemServico get() {
        return this.cronograma;
    }

    public HelperCronogramaOrdemServico build(CronogramaOrdemServico data) {
        this.cronograma = data;
        return this;
    }

    public CronogramaOrdemServico build(OrdemServico os) {
        this.cronograma = new CronogramaOrdemServico();
        this.cronograma.setCentroCusto(os.getCentroCusto());
        this.cronograma.setDataCadastro(new Date());
        this.cronograma.setDataProgramada(os.getDataProgramada());
        this.cronograma.setEmpresa(os.getEmpresa());
        this.cronograma.setStatus(os.getStatus());
        this.cronograma.setTipoServico(os.getTipoServico());
        this.cronograma.setEquipamento(os.getEquipamento());
        this.cronograma.setSimulado(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        this.cronograma.setSetorExecutante(os.getSetorExecutante());
        this.cronograma.setOrdemServico(os);
        this.cronograma.setPlanoManutencao(this.getPlanoManutencaoCronograma(os, this.cronograma));
        return this.cronograma;
    }

    private List<CronogramaPlanoManutencaoAtivo> getPlanoManutencaoCronograma(OrdemServico os, CronogramaOrdemServico crono) {
        ArrayList<CronogramaPlanoManutencaoAtivo> planos = new ArrayList<CronogramaPlanoManutencaoAtivo>();
        if (os.getPlanosManutencaoAtivo() != null && !os.getPlanosManutencaoAtivo().isEmpty()) {
            for (PlanoManutencaoAtivo p : os.getPlanosManutencaoAtivo()) {
                CronogramaPlanoManutencaoAtivo c = new CronogramaPlanoManutencaoAtivo();
                c.setCronograma(crono);
                c.setPlanoManutencaoAtivo(p);
                planos.add(c);
            }
        }
        return planos;
    }
}

