/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.ordemservico;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.ordemservico.EnumConstStatusOrdemServico;
import com.touchcomp.basementor.model.vo.CronogramaOrdemServico;
import com.touchcomp.basementor.model.vo.Executante;
import com.touchcomp.basementor.model.vo.FechamentoOrdemServico;
import com.touchcomp.basementor.model.vo.OpcoesManutencEquip;
import com.touchcomp.basementor.model.vo.OrdemServico;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.helpers.impl.ordemservico.HelperCronogramaOrdemServico;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.sql.Timestamp;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperOrdemServico
implements AbstractHelper<OrdemServico> {
    @Autowired
    HelperCronogramaOrdemServico helperCronogramaOrdemServico;
    OrdemServico ordemServico;

    public OrdemServico get() {
        return this.ordemServico;
    }

    public HelperOrdemServico build(OrdemServico data) {
        this.ordemServico = data;
        return this;
    }

    public OrdemServico build(FechamentoOrdemServico fechamento, OpcoesManutencEquip opcoesManutencEquip) {
        OrdemServico ordemServicoGerada = new OrdemServico();
        Timestamp data = ToolDate.toTimestamp((Date)ToolDate.nextDays((Date)this.getDataFinalizacaoOrdemServico(fechamento), (int)opcoesManutencEquip.getDiasNovaOS()));
        ordemServicoGerada.setCentroCusto(fechamento.getOrdemServico().getCentroCusto());
        ordemServicoGerada.setDataCadastro(new Date());
        ordemServicoGerada.setDataEmissao(new Date());
        ordemServicoGerada.setDataPrevisao(data);
        ordemServicoGerada.setDataProgramada(data);
        ordemServicoGerada.setDescricaoServico("Ordem de servico gerada devido a existencia de servicos pendentes no fechamento da ordem de servi\u00e7o c\u00f3digo " + fechamento.getOrdemServico().getCodigo() + "Cod.");
        ordemServicoGerada.setEmpresa(fechamento.getOrdemServico().getEmpresa());
        ordemServicoGerada.setEquipamento(fechamento.getOrdemServico().getEquipamento());
        ordemServicoGerada.setFornecedor(fechamento.getOrdemServico().getFornecedor());
        ordemServicoGerada.setGerado(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        ordemServicoGerada.setPrioridade(fechamento.getOrdemServico().getPrioridade());
        ordemServicoGerada.setResponsavel(fechamento.getOrdemServico().getResponsavel());
        ordemServicoGerada.setSetorExecutante(fechamento.getOrdemServico().getSetorExecutante());
        ordemServicoGerada.setSolicitante(fechamento.getOrdemServico().getSolicitante());
        ordemServicoGerada.setStatus(Short.valueOf(EnumConstStatusOrdemServico.ABERTO.getValue()));
        ordemServicoGerada.setTipoServico(fechamento.getOrdemServico().getTipoServico());
        CronogramaOrdemServico cronograma = this.helperCronogramaOrdemServico.build(ordemServicoGerada);
        ordemServicoGerada.setCronogramaOrdemServico(cronograma);
        return ordemServicoGerada;
    }

    public Timestamp getDataFinalizacaoOrdemServico(FechamentoOrdemServico fechamento) {
        Timestamp dataToReturn = ((Executante)fechamento.getExecutantes().get(0)).getDataHoraFinal();
        for (Executante executante : fechamento.getExecutantes()) {
            if (!executante.getDataHoraFinal().after(dataToReturn)) continue;
            dataToReturn = executante.getDataHoraFinal();
        }
        return dataToReturn;
    }
}

