/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.ossobencomenda;

import com.touchcomp.basementor.model.vo.OrdemServicoProdSobEnc;
import com.touchcomp.basementor.model.vo.PrevOcupCelulaProdutiva;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdSobEnc;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class HelperOrdemServicoProdSobEnc
implements AbstractHelper<OrdemServicoProdSobEnc> {
    private OrdemServicoProdSobEnc ordemProducao;

    public OrdemServicoProdSobEnc get() {
        return this.ordemProducao;
    }

    public HelperOrdemServicoProdSobEnc build(OrdemServicoProdSobEnc object) {
        this.ordemProducao = object;
        return this;
    }

    public Date getMaxDate(List<SubdivisaoOSProdSobEnc> subDivisoesOS) {
        Date aux = null;
        for (SubdivisaoOSProdSobEnc s : subDivisoesOS) {
            for (PrevOcupCelulaProdutiva p : s.getPrevOcupCelProdutiva()) {
                if (aux != null && !aux.before(p.getDataFinal())) continue;
                aux = p.getDataFinal();
            }
        }
        return aux;
    }

    public Date getMaxDatePrev(List<PrevOcupCelulaProdutiva> prev) {
        Date aux = null;
        for (PrevOcupCelulaProdutiva p : prev) {
            if (aux != null && !aux.before(p.getDataFinal())) continue;
            aux = p.getDataFinal();
        }
        return aux;
    }

    public Date getMinDate(List<SubdivisaoOSProdSobEnc> subDivisoesOS) {
        Date aux = null;
        for (SubdivisaoOSProdSobEnc s : subDivisoesOS) {
            for (PrevOcupCelulaProdutiva p : s.getPrevOcupCelProdutiva()) {
                if (aux != null && !aux.before(p.getDataInicial())) continue;
                aux = p.getDataInicial();
            }
        }
        return aux;
    }

    public Boolean osFechada() {
        return this.ordemProducao.getDataFechamento() != null;
    }
}

