/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.pedido;

import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.ItemPedidoFiscal;
import com.touchcomp.basementor.model.vo.TabelaPrecoPromocoesProdQtd;
import com.touchcomp.basementorrules.suframa.CompSuframa;
import com.touchcomp.basementorrules.suframa.model.SuframaCalculado;
import com.touchcomp.basementorrules.suframa.model.SuframaParams;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;

public class HelperItemPedido
implements AbstractHelper<ItemPedido> {
    private ItemPedido item;

    public ItemPedido get() {
        return this.item;
    }

    public HelperItemPedido build(ItemPedido item) {
        this.item = item;
        return this;
    }

    public void calcularTotalizadoresAcessoriosItem(ItemPedido item) {
        this.calcularTotalDesconto(item);
        this.calcularTotalFrete(item);
        this.calcularTotalSeguro(item);
        this.calcularTotalDespAcessoria(item);
    }

    private void calcularTotalDesconto(ItemPedido item) {
        Double valorTotalBruto = this.getValorTotalBruto(item);
        Double valorTotalDesconto = ToolFormatter.arrredondarNumero((Double)(item.getValorDescontoItemInf() + item.getValorDescontoRateado()), (int)2);
        if (item.getValorDescontoPromocional() != null) {
            valorTotalDesconto = valorTotalDesconto + item.getValorDescontoPromocional();
        }
        Double percDesconto = 0.0;
        if (valorTotalDesconto > 0.0 && valorTotalBruto > 0.0) {
            percDesconto = ToolFormatter.arrredondarNumero((Double)(valorTotalDesconto * 100.0 / valorTotalBruto), (int)4);
        }
        item.setValorDesconto(valorTotalDesconto);
        item.setPercDesconto(percDesconto);
    }

    private void calcularTotalFrete(ItemPedido item) {
        Double valorTotalBruto = this.getValorTotalBruto(item);
        Double valorTotalFrete = ToolFormatter.arrredondarNumero((Double)(item.getValorFreteItemInf() + item.getValorFreteRateado()), (int)2);
        Double percFrete = 0.0;
        if (valorTotalFrete > 0.0 && valorTotalBruto > 0.0) {
            percFrete = ToolFormatter.arrredondarNumero((Double)(valorTotalFrete * 100.0 / valorTotalBruto), (int)4);
        }
        item.setValorFrete(valorTotalFrete);
        item.setPercFrete(percFrete);
    }

    private void calcularTotalDespAcessoria(ItemPedido item) {
        Double valorTotalBruto = this.getValorTotalBruto(item);
        Double valorTotalDesp = ToolFormatter.arrredondarNumero((Double)(item.getValorDespAcessItemInf() + item.getValorDespAcessRateado()), (int)2);
        Double percDesp = 0.0;
        if (valorTotalDesp > 0.0 && valorTotalBruto > 0.0) {
            percDesp = ToolFormatter.arrredondarNumero((Double)(valorTotalDesp * 100.0 / valorTotalBruto), (int)4);
        }
        item.setValorDespesaAcessoria(valorTotalDesp);
        item.setPercDespesaAcessoria(percDesp);
    }

    private void calcularTotalSeguro(ItemPedido item) {
        Double valorTotalBruto = this.getValorTotalBruto(item);
        Double valorTotalSeguro = ToolFormatter.arrredondarNumero((Double)(item.getValorSeguroItemInf() + item.getValorSeguroRateado()), (int)2);
        Double percSeguro = 0.0;
        if (valorTotalSeguro > 0.0 && valorTotalBruto > 0.0) {
            percSeguro = ToolFormatter.arrredondarNumero((Double)(valorTotalSeguro * 100.0 / valorTotalBruto), (int)4);
        }
        item.setValorSeguro(valorTotalSeguro);
        item.setPercSeguro(percSeguro);
    }

    public ItemPedido calcularValoresAcessoriosInformados(ItemPedido item) {
        this.setDescontoInformadoItem(item);
        this.setFreteInformadoItem(item);
        this.setSeguroInformadoItem(item);
        this.setDespAcessInformadoItem(item);
        this.calcularTotalizadoresAcessoriosItem(item);
        return item;
    }

    private void setDescontoInformadoItem(ItemPedido item) {
        double vlrProduto = this.getValorTotalBruto(item);
        double valorDescCalc = 0.0;
        double percDescCalc = 0.0;
        if (ToolMethods.isEquals((Object)item.getTipoDesconto(), (Object)0)) {
            valorDescCalc = ToolFormatter.arrredondarNumero((Double)(item.getPercDescontoItemInf() / 100.0 * vlrProduto), (int)2);
            item.setValorDescontoItemInf(Double.valueOf(valorDescCalc));
        } else {
            percDescCalc = item.getValorDescontoItemInf() > 0.0 ? ToolFormatter.arrredondarNumero((Double)(item.getValorDescontoItemInf() / vlrProduto * 100.0), (int)4) : 0.0;
            item.setPercDescontoItemInf(Double.valueOf(percDescCalc));
        }
    }

    private void setFreteInformadoItem(ItemPedido item) {
        double vlrProduto = this.getValorTotalBruto(item);
        double valorCalc = 0.0;
        double percCalc = 0.0;
        if (ToolMethods.isEquals((Object)item.getTipoFrete(), (Object)0)) {
            valorCalc = ToolFormatter.arrredondarNumero((Double)(item.getPercFreteItemInf() / 100.0 * vlrProduto), (int)2);
            item.setValorFreteItemInf(Double.valueOf(valorCalc));
        } else {
            percCalc = item.getValorFreteItemInf() > 0.0 ? ToolFormatter.arrredondarNumero((Double)(item.getValorFreteItemInf() / vlrProduto * 100.0), (int)4) : 0.0;
            item.setPercFreteItemInf(Double.valueOf(percCalc));
        }
    }

    private void setSeguroInformadoItem(ItemPedido item) {
        double vlrProduto = this.getValorTotalBruto(item);
        double valorCalc = 0.0;
        double percCalc = 0.0;
        if (ToolMethods.isEquals((Object)item.getTipoSeguro(), (Object)0)) {
            valorCalc = ToolFormatter.arrredondarNumero((Double)(item.getPercSeguroItemInf() / 100.0 * vlrProduto), (int)2);
            item.setValorSeguroItemInf(Double.valueOf(valorCalc));
        } else {
            percCalc = item.getValorSeguroItemInf() > 0.0 ? ToolFormatter.arrredondarNumero((Double)(item.getValorSeguroItemInf() / vlrProduto * 100.0), (int)4) : 0.0;
            item.setPercSeguroItemInf(Double.valueOf(percCalc));
        }
    }

    private void setDespAcessInformadoItem(ItemPedido item) {
        double vlrProduto = this.getValorTotalBruto(item);
        double valorCalc = 0.0;
        double percCalc = 0.0;
        if (ToolMethods.isEquals((Object)item.getTipoDespAcessoria(), (Object)0)) {
            valorCalc = ToolFormatter.arrredondarNumero((Double)(item.getPercDespAcessItemInf() / 100.0 * vlrProduto), (int)2);
            item.setValorDespAcessItemInf(Double.valueOf(valorCalc));
        } else {
            percCalc = item.getValorDespAcessItemInf() > 0.0 ? ToolFormatter.arrredondarNumero((Double)(item.getValorDespAcessItemInf() / vlrProduto * 100.0), (int)4) : 0.0;
            item.setPercDespAcessItemInf(Double.valueOf(percCalc));
        }
    }

    public void calcularSuframa(ItemPedido item, Cliente cliente) {
        Double valorTotalBruto;
        if (item.getItemPedidoFiscal() == null || item.getModeloFiscal() == null || cliente == null) {
            return;
        }
        ItemPedidoFiscal itemFiscal = item.getItemPedidoFiscal();
        SuframaParams params = new SuframaParams();
        params.setHabilitarSuframa(cliente.getPessoa().getComplemento().getHabilitarSuframa());
        params.setInscricaoSuframa(cliente.getPessoa().getComplemento().getSuframa());
        params.setNaoCalcularSuframaModelo(item.getModeloFiscal().getNaoCalcularSuframa());
        params.setNaoCalcularSuframaProduto(item.getProduto().getNaoAplicaSuframa());
        params.setAliqSuframaIpi(cliente.getFaturamento().getPercentualIpiSufr());
        params.setAliqSuframaPis(cliente.getFaturamento().getPercentualPisSufr());
        params.setAliqSuframaCofins(cliente.getFaturamento().getPercentualCofinsSufr());
        if (item.getModeloFiscal() == null || !item.getModeloFiscal().getModeloFiscalIcms().getIcmsDispensadoDesconto().equals((short)1) || !item.getModeloFiscal().getModeloFiscalIcms().getMotivoDesoneracaoIcms().getCodigo().equals("7")) {
            params.setAliqSuframaIcms(cliente.getFaturamento().getPercentualIcmsSufr());
        } else {
            params.setAliqSuframaIcms(Double.valueOf(0.0));
        }
        Double bcPis = valorTotalBruto = this.getValorTotalBruto(item);
        Double bcCofins = valorTotalBruto;
        Double bcIcms = valorTotalBruto;
        Double bcIpi = valorTotalBruto;
        if (ToolMethods.isEquals((Object)item.getModeloFiscal().getModeloFiscalIcms().getIncluiFrete(), (Object)1)) {
            bcIcms = bcIcms + item.getValorFrete();
        }
        if (ToolMethods.isEquals((Object)item.getModeloFiscal().getModeloFiscalIcms().getIncluiSeguro(), (Object)1)) {
            bcIcms = bcIcms + item.getValorSeguro();
        }
        if (ToolMethods.isEquals((Object)item.getModeloFiscal().getModeloFiscalIcms().getIncluiDespAcess(), (Object)1)) {
            bcIcms = bcIcms + item.getValorDespesaAcessoria();
        }
        if (ToolMethods.isEquals((Object)item.getModeloFiscal().getModeloFiscalIpi().getIncluiFrete(), (Object)1)) {
            bcIpi = bcIpi + item.getValorFrete();
        }
        if (ToolMethods.isEquals((Object)item.getModeloFiscal().getModeloFiscalIpi().getIncluiSeguro(), (Object)1)) {
            bcIpi = bcIpi + item.getValorSeguro();
        }
        if (ToolMethods.isEquals((Object)item.getModeloFiscal().getModeloFiscalIpi().getIncluiDespAcess(), (Object)1)) {
            bcIpi = bcIpi + item.getValorDespesaAcessoria();
        }
        if (ToolMethods.isEquals((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiFrete(), (Object)1)) {
            bcPis = bcPis + item.getValorFrete();
            bcCofins = bcCofins + item.getValorFrete();
        }
        if (ToolMethods.isEquals((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiSeguro(), (Object)1)) {
            bcPis = bcPis + item.getValorSeguro();
            bcCofins = bcCofins + item.getValorSeguro();
        }
        if (ToolMethods.isEquals((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiDespAcess(), (Object)1)) {
            bcPis = bcPis + item.getValorDespesaAcessoria();
            bcCofins = bcCofins + item.getValorDespesaAcessoria();
        }
        if (ToolMethods.isEquals((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getAbaterValorIcms(), (Object)1)) {
            bcPis = bcPis - itemFiscal.getVrIcms();
            bcCofins = bcCofins - itemFiscal.getVrIcms();
        }
        if (ToolMethods.isEquals((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIcmsDesonerado(), (Object)1)) {
            bcPis = bcPis - itemFiscal.getVrICMSDispensado();
            bcCofins = bcCofins - itemFiscal.getVrICMSDispensado();
        }
        if (ToolMethods.isEquals((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIcmsSemAproveitamento(), (Object)1)) {
            bcPis = bcPis - itemFiscal.getVrIcmsSemAprov();
            bcCofins = bcCofins - itemFiscal.getVrIcmsSemAprov();
        }
        params.setBcIcms(bcIcms);
        params.setBcIpi(bcIpi);
        params.setBcPis(bcPis);
        params.setBcCofins(bcCofins);
        SuframaCalculado calc = CompSuframa.calcularSuframa((SuframaParams)params);
        item.setPercDescontoTrib(calc.getPercSuframa());
        item.setValorDescontoTrib(calc.getValorSuframa());
        this.calcularTotalDesconto(item);
    }

    public void setOutrosValoresAcessoriosComplementares(ItemPedido i) {
        if (i.getValorDesconto() > 0.0 || i.getValorFrete() > 0.0 || i.getValorSeguro() > 0.0 || i.getValorDespesaAcessoria() > 0.0) {
            if (ToolMethods.isEquals((Object)i.getDescontoItem(), (Object)1)) {
                i.setPercDescontoItemInf(i.getPercDesconto());
                i.setValorDescontoItemInf(i.getValorDesconto());
            } else {
                i.setPercDescontoRateado(i.getPercDesconto());
                i.setValorDescontoRateado(i.getValorDesconto());
            }
            if (ToolMethods.isEquals((Object)i.getFreteItem(), (Object)1)) {
                i.setPercFreteItemInf(i.getPercFrete());
                i.setValorFreteItemInf(i.getValorFrete());
            } else {
                i.setPercFreteRateado(i.getPercFrete());
                i.setValorFreteRateado(i.getValorFrete());
            }
            if (ToolMethods.isEquals((Object)i.getSeguroItem(), (Object)1)) {
                i.setPercSeguroItemInf(i.getPercSeguro());
                i.setValorSeguroItemInf(i.getValorSeguro());
            } else {
                i.setPercSeguroRateado(i.getPercSeguro());
                i.setValorSeguroRateado(i.getValorSeguro());
            }
            if (ToolMethods.isEquals((Object)i.getDespAcessItem(), (Object)1)) {
                i.setPercDespAcessItemInf(i.getPercDespesaAcessoria());
                i.setValorDespAcessItemInf(i.getValorDespesaAcessoria());
            } else {
                i.setPercDespAcessRateado(i.getPercDespesaAcessoria());
                i.setValorDespAcessRateado(i.getValorDespesaAcessoria());
            }
        }
    }

    private Double getValorTotalBruto(ItemPedido item) {
        return ToolFormatter.arrredondarNumero((Double)(item.getValorUnitario() * item.getQuantidadeTotal()), (int)2);
    }

    public void calcularDescontoPromocional(ItemPedido vo) {
        if (vo.getTabPrecoPromocoesProd() != null && vo.getValorReferenciaDescontoPromocional() != null && vo.getValorReferenciaDescontoPromocional() > 0.0) {
            vo.setValorDescontoPromocional(ToolFormatter.arrredondarNumero((Double)(vo.getValorReferenciaDescontoPromocional() * vo.getQuantidadeTotal()), (int)2));
            vo.setPercDescontoPromocional(ToolFormatter.arrredondarNumero((Double)(vo.getValorDescontoPromocional() * (100.0 / (vo.getValorUnitario() * vo.getQuantidadeTotal()))), (int)4));
            for (TabelaPrecoPromocoesProdQtd tabQtde : vo.getTabPrecoPromocoesProd().getTabelaPrecoPromocoesProdQtd()) {
                if (!(vo.getQuantidadeTotal() >= tabQtde.getQuantidadeInicial()) || !(vo.getQuantidadeTotal() <= tabQtde.getQuantidadeFinal())) continue;
                vo.setValorDescontoPromocional(ToolFormatter.arrredondarNumero((Double)((vo.getValorUnitario() - tabQtde.getValor()) * vo.getQuantidadeTotal()), (int)2));
                vo.setPercDescontoPromocional(ToolFormatter.arrredondarNumero((Double)(vo.getValorDescontoPromocional() * (100.0 / (vo.getValorUnitario() * vo.getQuantidadeTotal()))), (int)4));
                return;
            }
        }
    }
}

