/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.pedido;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.modelodocfiscal.EnumConstModDocFiscal;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndicadorPresConsumidor;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstTipoDataTitulo;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProd;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCen;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemPedido;
import com.touchcomp.basementor.model.vo.InfPagamentoPedido;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.SituacaoPedidos;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.google.ExceptionGoogle;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoipi.ExceptionImpostoIPI;
import com.touchcomp.basementorexceptions.exceptions.impl.impostopiscofins.ExceptionImpostoPisCofins;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.jepparser.ExceptionJEPParser;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.components.calculovalores.venda.CompCalcValoresVenda;
import com.touchcomp.basementorservice.components.calculovalores.venda.model.InputCalcPedido;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.helpers.impl.calculofrete.HelperCalculoFrete;
import com.touchcomp.basementorservice.helpers.impl.condicoespagamento.HelperCondicoesPagamento;
import com.touchcomp.basementorservice.helpers.impl.endereco.HelperEndereco;
import com.touchcomp.basementorservice.helpers.impl.modelofiscal.HelperModeloFiscal;
import com.touchcomp.basementorservice.service.impl.paramtribcbsibs.ServiceParamTribCbsIbsImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import com.touchcomp.touchvomodel.vo.pedido.web.DTOPedido;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperPedido
implements AbstractHelper<Pedido> {
    private Pedido pedido;
    @Autowired
    private CompCalcValoresVenda compCalcVlrPedido;
    @Autowired
    HelperEndereco helperEndereco;
    @Autowired
    HelperCondicoesPagamento helperCondicoesPagamento;
    @Autowired
    HelperModeloFiscal helperModeloFiscal;

    public Pedido get() {
        return this.pedido;
    }

    public HelperPedido build(Pedido object) {
        this.pedido = object;
        return this;
    }

    public Double getDistancia(Empresa empresa, UnidadeFatCliente unidade, Endereco endEntrega) throws ExceptionGoogle {
        if (endEntrega == null) {
            endEntrega = unidade.getPessoa().getEndereco();
        }
        if (ToolMethods.isWithData((Number)unidade.getPessoa().getDistanciaKm())) {
            return unidade.getPessoa().getDistanciaKm();
        }
        return this.helperEndereco.build(empresa.getPessoa().getEndereco()).getDistancia(empresa, endEntrega);
    }

    public void calcularFrete(Pedido p) throws ExceptionJEPParser {
        p.setValorFrete(this.getValorFrete(p));
    }

    public Double getValorFrete(Pedido p) throws ExceptionJEPParser {
        HashMap values = new HashMap();
        this.prepararVariaveisCalcFrete(p, values);
        Cidade dest = p.getUnidadeFatCliente().getPessoa().getEndereco().getCidade();
        if (p.getEnderecoEntrega() != null) {
            dest = p.getEnderecoEntrega().getCidade();
        }
        return ((HelperCalculoFrete)Context.get(HelperCalculoFrete.class)).calcularValorFrete(p.getTransportador(), dest, values);
    }

    public Double getPercentualFrete(Pedido p) throws ExceptionJEPParser {
        Double valorFrete = this.getValorFrete(p);
        Double valorTotalItens = p.getItemPedido().stream().mapToDouble(it -> it.getValorUnitario() * (it.getQuantidadeTotal() * it.getFatorConversao())).sum();
        return ToolNumber.calcPercentual((Double)valorFrete, (Double)valorTotalItens);
    }

    public void prepararVariaveisCalcFrete(Pedido p, HashMap values) {
        if (!values.containsKey("distancia")) {
            values.put("distancia", 0.0);
        }
        if (!values.containsKey("pesoTotal")) {
            values.put("pesoTotal", 0.0);
        }
        if (!values.containsKey("valorTotal")) {
            values.put("valorTotal", 0.0);
        }
        if (!values.containsKey("valorTotalComImpostos")) {
            values.put("valorTotalComImpostos", 0.0);
        }
        if (!values.containsKey("nrDiasMedios")) {
            values.put("nrDiasMedios", 0.0);
        }
        double pesoTotal = 0.0;
        Double valorTotal = 0.0;
        Double vlrTotalImpostos = 0.0;
        for (ItemPedido it : p.getItemPedido()) {
            pesoTotal += it.getProduto().getPesoUnitario() * (it.getQuantidadeTotal() * it.getFatorConversao());
            valorTotal = valorTotal + it.getValorUnitario() * (it.getQuantidadeTotal() * it.getFatorConversao());
            vlrTotalImpostos = vlrTotalImpostos + it.getValorTotalComImpostos();
        }
        Double distancia = p.getUnidadeFatCliente().getPessoa().getDistanciaKm();
        distancia = distancia == null ? 0.0 : distancia;
        values.put("distancia", distancia + (Double)values.get("distancia"));
        values.put("pesoTotal", pesoTotal + (Double)values.get("pesoTotal"));
        values.put("valorTotal", valorTotal + (Double)values.get("valorTotal"));
        values.put("valorTotalComImpostos", vlrTotalImpostos + (Double)values.get("valorTotalComImpostos"));
        values.put("nrDiasMedios", this.helperCondicoesPagamento.calcularNrDiasMedios(p.getCondicoesPagamento(), p.getCondPagMut()));
    }

    public void calcularComissao(Pedido pedido, OpcoesFinanceiras opcoesFinanceiras) {
        Double valorComissao = 0.0;
        Double valorItensAbatendoDescontos = 0.0;
        for (ItemPedido it : pedido.getItemPedido()) {
            Double valorIcmsDesonerado = 0.0;
            if (opcoesFinanceiras.getDescontarIcmsDesoneradoComissao().equals((short)1)) {
                valorIcmsDesonerado = it.getItemPedidoFiscal().getVrICMSDispensado();
            }
            valorComissao = valorComissao + (it.getValorTotalBruto() - it.getValorDesconto() - it.getValorDescontoTrib() - valorIcmsDesonerado) * (it.getPercComissao() / 100.0);
            valorItensAbatendoDescontos = valorItensAbatendoDescontos + (it.getValorTotalBruto() - it.getValorDesconto() - it.getValorDescontoTrib() - valorIcmsDesonerado);
        }
        pedido.setTotalComissao(valorComissao);
        if (valorComissao > 0.0 && valorItensAbatendoDescontos > 0.0) {
            pedido.setPercComissao(Double.valueOf(valorComissao / valorItensAbatendoDescontos * 100.0));
        } else {
            pedido.setPercComissao(Double.valueOf(0.0));
        }
    }

    public Double calcularPercDescontoSuframa(Pedido pedido) {
        if (pedido != null) {
            Double valorTotalBruto = 0.0;
            Double valorTotalDescTrib = 0.0;
            for (ItemPedido itemPedido : pedido.getItemPedido()) {
                valorTotalBruto = valorTotalBruto + (itemPedido.getValorTotalBruto() - itemPedido.getValorDesconto());
                valorTotalDescTrib = valorTotalDescTrib + itemPedido.getValorDescontoTrib();
            }
            if (valorTotalBruto > 0.0 && valorTotalDescTrib > 0.0) {
                Double perc = ToolFormatter.arrredondarNumero((Double)(valorTotalDescTrib * 100.0 / valorTotalBruto), (int)4);
                return perc;
            }
        }
        return 0.0;
    }

    public InfPagamentoPedido novoPagamento(CondicoesPagamento condicoesPagamento, String parcelas) throws ExceptionValidacaoDados {
        InfPagamentoPedido inf = new InfPagamentoPedido();
        if (TMethods.isAffirmative((Number)condicoesPagamento.getCondMutante())) {
            if (TMethods.isAffirmative((Number)condicoesPagamento.getMutanteFixa())) {
                parcelas = condicoesPagamento.getParcelasMutante();
            } else {
                if (parcelas == null || parcelas.isEmpty()) {
                    throw new ExceptionValidacaoDados("E.ERP.0104.002", new Object[0]);
                }
                Boolean ret = this.helperCondicoesPagamento.validaNrDiasMedios(condicoesPagamento, parcelas);
                if (!ret.booleanValue()) {
                    throw new ExceptionValidacaoDados("01-02-00735", new Object[0]);
                }
            }
        }
        inf.setCondicoesPagamento(condicoesPagamento);
        inf.setParcelas(parcelas);
        if (inf.getCondicoesPagamento().getMeioPagamento() != null) {
            inf.setMeioPagamento(inf.getCondicoesPagamento().getMeioPagamento());
        } else if (inf.getCondicoesPagamento() != null && inf.getCondicoesPagamento().getMeioPagamento() != null) {
            inf.setMeioPagamento(inf.getCondicoesPagamento().getMeioPagamento());
        }
        if (inf.getMeioPagamento() != null && inf.getMeioPagamento().getTipoPagamentoNFe() != null) {
            inf.setTipoPagamentoNFe(inf.getMeioPagamento().getTipoPagamentoNFe());
        }
        return inf;
    }

    public Pedido getNovoPedido(Representante representante, Empresa empresa, Usuario usuario, OpcoesFaturamento opcoesFaturamento, OpcoesFinanceiras opcoesFinanceiras) {
        return this.getNovoPedido(null, opcoesFaturamento.getNatPrefFaturamento(), opcoesFaturamento.getSituacaoPedidos(), representante, empresa, usuario, opcoesFaturamento);
    }

    public Pedido getNovoPedido(UnidadeFatCliente unidadeFatCliente, NaturezaOperacao naturezaOperacao, SituacaoPedidos situacaoPedidos, Representante representante, Empresa empresa, Usuario usuario, OpcoesFaturamento opcoesFaturamento) {
        Pedido vo = new Pedido();
        vo.setDataCadastro(new Date());
        vo.setEmpresa(empresa);
        vo.setIndicadorPresencaConsumidor(opcoesFaturamento.getIndicadorPresencaConsumidor());
        vo.setTipoIntermediadorComercial(opcoesFaturamento.getTipoIntermediadorComercial());
        vo.setUsuario(usuario);
        if (TMethods.isNotNull((Object)unidadeFatCliente).booleanValue()) {
            vo.setCondicoesPagamento(unidadeFatCliente.getCliente().getFaturamento().getCondicaoPagamento());
            if (TMethods.isNotNull((Object)vo.getCondicoesPagamento()).booleanValue()) {
                vo.setCondPagMut(vo.getCondicoesPagamento().getParcelasMutante());
            }
        }
        if (vo.getCondicoesPagamento() != null) {
            vo.setMeioPagamento(vo.getCondicoesPagamento().getMeioPagamento());
        }
        vo.setRepresentante(representante);
        vo.setDataEmissao(new Date());
        vo.setDataPrevisaoFat(new Date());
        vo.setDataPrevisaoSaida(new Date());
        vo.setUnidadeFatCliente(unidadeFatCliente);
        if (vo.getUnidadeFatCliente() != null && vo.getUnidadeFatCliente().getCliente().getFaturamento().getTransportadora() != null) {
            vo.setTransportador(vo.getUnidadeFatCliente().getCliente().getFaturamento().getTransportadora());
        } else {
            vo.setTransportador(opcoesFaturamento.getTransportador());
        }
        if (vo.getUnidadeFatCliente() != null && vo.getUnidadeFatCliente().getCliente().getFaturamento().getTipoFrete() != null) {
            vo.setTipoFrete(vo.getUnidadeFatCliente().getCliente().getFaturamento().getTipoFrete());
        } else {
            vo.setTipoFrete(opcoesFaturamento.getTipoFrete());
        }
        vo.setMoeda(opcoesFaturamento.getMoeda());
        vo.setNaturezaOperacao(naturezaOperacao);
        vo.setNrSequencialPedido(Integer.valueOf(1));
        if (vo.getUnidadeFatCliente() != null) {
            vo.setTipoConsumidor(vo.getUnidadeFatCliente().getCliente().getFaturamento().getTipoConsumidor());
        }
        vo.setTipoDataTitulo(EnumConstTipoDataTitulo.GERAR_TITULO_EMISSAO.getValue());
        vo.setSituacaoPedido(situacaoPedidos);
        return vo;
    }

    public void setarNrSequencialItens() {
        Integer count = 1;
        for (ItemPedido i : this.pedido.getItemPedido()) {
            i.setNrSequencial(count);
            Integer n = count;
            count = count + 1;
        }
    }

    public void setarEstoqueReserva(OpcoesFaturamento opFat) {
        if (opFat != null) {
            this.pedido.setModoReservaEstoque(opFat.getTrabReservaEstPed());
            if (TMethods.isAffirmative((Number)this.pedido.getReservarEstoque())) {
                this.pedido.setCentroEstoqueReserva(opFat.getCentroEstoqueReserva());
            } else {
                this.pedido.setCentroEstoqueReserva(null);
            }
        }
    }

    public void calcularValoresPedido(OpcoesFaturamento opcoes, OpcoesContabeis opcoesContabeis) throws ExceptionImpostoPisCofins, ExceptionImpostoIPI, ExceptionImpostoIcms {
        this.compCalcVlrPedido.calcularValoresPedido(new InputCalcPedido(this.pedido), opcoes, opcoesContabeis);
    }

    public void setModeloFiscal(List<ItemPedido> itemPedido, Empresa empresa, UnidadeFatCliente unidadeFatCliente, NaturezaOperacao naturezaOp, boolean throwExNotFound) throws ExceptionBase {
        for (ItemPedido itemP : itemPedido) {
            try {
                this.setModeloFiscal(itemP, empresa, unidadeFatCliente, naturezaOp);
            }
            catch (ExceptionBase ex) {
                if (!throwExNotFound) continue;
                throw ex;
            }
        }
    }

    public void setModeloFiscal(ItemPedido item, Pedido ped) throws ExceptionBase {
        this.setModeloFiscal(item, ped.getEmpresa(), ped.getUnidadeFatCliente(), ped.getNaturezaOperacao());
    }

    public ModeloFiscal getModeloFiscalItem(Produto produto, Empresa empresa, UnidadeFatCliente unidadeFatCliente, NaturezaOperacao naturezaOp) throws ExceptionObjNotFound {
        ModeloFiscal modeloFiscal = this.helperModeloFiscal.getFirst(produto, unidadeFatCliente, naturezaOp, empresa);
        return modeloFiscal;
    }

    public void setModeloFiscal(ItemPedido itemPedido, Empresa empresa, UnidadeFatCliente unidadeFatCliente, NaturezaOperacao naturezaOp) throws ExceptionObjNotFound, ExceptionInvalidData {
        ModeloFiscal modeloFiscal = this.getModeloFiscalItem(itemPedido.getProduto(), empresa, unidadeFatCliente, naturezaOp);
        itemPedido.setModeloFiscal(modeloFiscal);
        itemPedido.setParamTribCbsIbsClass(((ServiceParamTribCbsIbsImpl)Context.get(ServiceParamTribCbsIbsImpl.class)).getParametrizacaoNFe(new Date(), empresa, unidadeFatCliente, itemPedido.getProduto(), EnumConstModDocFiscal.get((Object)naturezaOp.getModeloDocFiscal().getCodigo()), itemPedido.getModeloFiscal(), EnumConstNFeIndicadorPresConsumidor.OPERACAO_NAO_PRESENCIAL_OUTROS));
    }

    public GradeItemPedido getNovaGrade(GradeCor grade, Empresa empresa, Double quantidadeTotal) {
        GradeItemPedido gradeItem = new GradeItemPedido();
        gradeItem.setDataMovimentacao(new Date());
        gradeItem.setEmpresa(empresa);
        gradeItem.setGradeCor(grade);
        gradeItem.setQuantidade(quantidadeTotal);
        return gradeItem;
    }

    public void setDataPrevisaoSaida(Pedido vo, OpcoesFaturamento opcoesFaturamento) {
        if (ToolMethods.isEquals((Object)opcoesFaturamento.getPermInformarHoraSaidaPedido(), (Object)EnumConstantsMentorSimNao.NAO.getValue())) {
            vo.setDataPrevisaoSaida(ToolDate.dataPrimHora((Date)vo.getDataPrevisaoSaida()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void aplicarValorAnaliseCusto(Produto produto, DTOPedido.DTOItemPedido dto, AnalisePrVendaProd analise) throws ExceptionInvalidData {
        Optional<AnalisePrVendaProd> opt;
        if (TMethods.isNull((Object)analise).booleanValue()) {
            return;
        }
        if (TMethods.isNotNull((Object)analise.getAnalisePrVendaPCPEnc()).booleanValue()) {
            dto.setValorCusto(analise.getAnalisePrVendaPCPEnc().getValorTotal());
            dto.setValorUnitario(analise.getAnalisePrVendaPCPEnc().getValorTotal());
        }
        if ((opt = analise.getAnalises().stream().filter(i -> TMethods.isAffirmative((Number)i.getEscolhido())).findFirst()).isEmpty()) {
            Optional<AnalisePrVendaProdCen> optCen = analise.getCenarios().stream().filter(i -> TMethods.isAffirmative((Number)i.getCenarioEscolhido())).findFirst();
            if (!optCen.isPresent()) throw new ExceptionInvalidData("E.ERP.1511.013", new Object[0]);
            dto.setValorUnitario(optCen.get().getResultado());
        } else {
            AnalisePrVendaProd analiseEscolhida = opt.get();
            if (TMethods.isNotNull((Object)analiseEscolhida.getValorTotal()).booleanValue() && TMethods.isNotNull((Object)analiseEscolhida.getQuantidade()).booleanValue() && analiseEscolhida.getQuantidade() > 0.0) {
                dto.setValorUnitario(Double.valueOf(analiseEscolhida.getValorTotal() / analiseEscolhida.getQuantidade()));
                dto.setValorTotal(analiseEscolhida.getValorTotal());
                dto.setValorTotalBruto(analiseEscolhida.getValorTotal());
                dto.setQuantidadeTotal(analiseEscolhida.getQuantidade());
                if (TMethods.isWithData((Collection)dto.getGradeItemPedido())) {
                    ((DTOPedido.DTOGradeItemPedido)dto.getGradeItemPedido().getFirst()).setQuantidade(dto.getQuantidadeTotal());
                }
                this.ratearQuantidade(produto, dto);
            }
        }
        dto.setAnalisePrecoVendaIdentificador(analise.getIdentificador());
        dto.setAnalisePrecoVenda(String.valueOf(String.valueOf(analise)));
    }

    private void ratearQuantidade(Produto produto, DTOPedido.DTOItemPedido dto) {
        Double quantidade = dto.getQuantidadeTotal();
        Double quantidadePorGrade = quantidade / (double)dto.getGradeItemPedido().size();
        Double resto = quantidade % (double)dto.getGradeItemPedido().size();
        if (TMethods.isEquals((Object)resto, (Object)0.0) || resto > 0.0 && TMethods.isAffirmative((Number)produto.getQtdeNaoFracionada())) {
            dto.getGradeItemPedido().forEach(i -> i.setQuantidade(quantidadePorGrade));
        } else {
            dto.getGradeItemPedido().forEach(i -> i.setQuantidade(quantidadePorGrade));
            ((DTOPedido.DTOGradeItemPedido)dto.getGradeItemPedido().getFirst()).setQuantidade(Double.valueOf(quantidadePorGrade + resto));
        }
    }
}

