/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.pedidoalmoxarifado;

import com.touchcomp.basementor.constants.enums.opcoesestoque.EnumConstOpEstoqueOp;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.vo.GradeItemPedidoAlmoxarifado;
import com.touchcomp.basementor.model.vo.ItemPedidoAlmoxarifado;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.PedidoAlmoxarifado;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesestoque.HelperOpcoesEstoque;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperPedidoAlmoxarifado
implements AbstractHelper<PedidoAlmoxarifado> {
    private PedidoAlmoxarifado pedidoAlmoxarifado;
    @Autowired
    private HelperOpcoesEstoque helperOpcoesEstoque;

    public PedidoAlmoxarifado get() {
        return this.pedidoAlmoxarifado;
    }

    public HelperPedidoAlmoxarifado build(PedidoAlmoxarifado item) {
        this.pedidoAlmoxarifado = item;
        return this;
    }

    public void calcularQtdTotal() {
        if (this.pedidoAlmoxarifado.getItensPedido() == null) {
            this.pedidoAlmoxarifado.setItensPedido(new LinkedList());
        }
        for (ItemPedidoAlmoxarifado aux : this.pedidoAlmoxarifado.getItensPedido()) {
            aux.setPedidoAlmoxarifado(this.pedidoAlmoxarifado);
            double qtdTotal = aux.getGradesItensAlmoxarifado().stream().mapToDouble(i -> i.getQuantidade()).sum();
            aux.setQuantidadeTotal(Double.valueOf(qtdTotal));
            aux.getGradesItensAlmoxarifado().forEach(i -> i.setItemPedidoAlmoxarifado(aux));
        }
    }

    public void mesclarItens(OpcoesEstoque op) {
        if (!CompOpcoes.isAffirmative(this.helperOpcoesEstoque.build(op).getItens(), (EnumOpDinamicasInterface)EnumConstOpEstoqueOp.AGRUPAR_ITENS_PED_ALMOX_PR_IGUAIS)) {
            return;
        }
        LinkedList<ItemPedidoAlmoxarifado> ret = new LinkedList<ItemPedidoAlmoxarifado>();
        for (ItemPedidoAlmoxarifado aux : this.pedidoAlmoxarifado.getItensPedido()) {
            Optional<ItemPedidoAlmoxarifado> found = ret.stream().filter(i -> TMethods.isEquals((Object)i.getProduto(), (Object)aux.getProduto()) && TMethods.isEquals((Object)i.getCentroCusto(), (Object)aux.getCentroCusto()) && TMethods.isEquals((Object)i.getProdutoOriginal(), (Object)aux.getProdutoOriginal())).findFirst();
            if (found.isPresent()) {
                ItemPedidoAlmoxarifado item = found.get();
                if (TMethods.isStrWithData((String)item.getObservacao()) && TMethods.isStrWithData((String)aux.getObservacao())) {
                    item.setObservacao(item.getObservacao() + "\n" + aux.getObservacao());
                } else if (!TMethods.isStrWithData((String)item.getObservacao()) && TMethods.isStrWithData((String)aux.getObservacao())) {
                    item.setObservacao(aux.getObservacao());
                }
                this.mesclarGrades(item, aux);
                continue;
            }
            if (!TMethods.isStrWithData((String)aux.getObservacao())) {
                aux.setObservacao("");
            }
            ret.add(aux);
        }
        this.pedidoAlmoxarifado.setItensPedido(ret);
        this.calcularQtdTotal();
    }

    public void mesclarGrades(ItemPedidoAlmoxarifado dest, ItemPedidoAlmoxarifado source) {
        List ret = dest.getGradesItensAlmoxarifado();
        for (GradeItemPedidoAlmoxarifado gr : source.getGradesItensAlmoxarifado()) {
            Optional<GradeItemPedidoAlmoxarifado> found = ret.stream().filter(i -> TMethods.isEquals((Object)i.getGradeCor(), (Object)gr.getGradeCor()) && TMethods.isEquals((Object)i.getGradeCorOriginal(), (Object)gr.getGradeCorOriginal())).findFirst();
            if (found.isPresent()) {
                found.get().setQuantidade(Double.valueOf(gr.getQuantidade() + found.get().getQuantidade()));
                continue;
            }
            gr.setItemPedidoAlmoxarifado(dest);
            ret.add(gr);
        }
    }
}

