/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.pessoa;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoa;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoaComplementar;
import com.touchcomp.basementor.constants.enums.spedfiscal.EnumConstSpedFiscalTpLogPessoa;
import com.touchcomp.basementor.constants.enums.uf.EnumConstUF;
import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.LogPessoa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementorexceptions.exceptions.impl.google.ExceptionGoogle;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.helpers.impl.endereco.HelperEndereco;
import com.touchcomp.basementorservice.service.impl.logpessoa.ServiceLogPessoaImpl;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.googlelocations.model.GoogleGeographicPosition;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorvalidator.others.email.ValidateEmail;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperPessoa
implements AbstractHelper<Pessoa> {
    private Pessoa pessoa;
    @Autowired
    private HelperEndereco helperEndereco;
    @Autowired
    ServiceLogPessoaImpl serviceLogPessoaImpl;

    public Pessoa get() {
        return this.pessoa;
    }

    public HelperPessoa build(Pessoa object) {
        this.pessoa = object;
        return this;
    }

    public String getTelefonePrincipal() {
        if (ToolMethods.isStrWithData((String)this.pessoa.getComplemento().getFone1())) {
            return this.pessoa.getComplemento().getFone1();
        }
        if (ToolMethods.isStrWithData((String)this.pessoa.getComplemento().getFone2())) {
            return this.pessoa.getComplemento().getFone2();
        }
        if (ToolMethods.isStrWithData((String)this.pessoa.getComplemento().getCel1())) {
            return this.pessoa.getComplemento().getCel1();
        }
        if (ToolMethods.isStrWithData((String)this.pessoa.getComplemento().getCel2())) {
            return this.pessoa.getComplemento().getCel2();
        }
        return null;
    }

    public void calcularDistancia(Empresa emp) throws ExceptionGoogle {
        Double distancia = this.helperEndereco.build(emp.getPessoa().getEndereco()).getDistancia(emp, this.pessoa.getEndereco());
        this.pessoa.setDistanciaKm(distancia);
    }

    public void calcularPontosGeograficos(Empresa emp) throws ExceptionGoogle {
        if (!ToolMethods.isStrWithData((String)emp.getEmpresaDados().getKeyAPIGoogle())) {
            return;
        }
        Endereco end = this.pessoa.getEndereco();
        GoogleGeographicPosition pos = this.helperEndereco.build(emp.getPessoa().getEndereco()).getPontosGeograficos(emp, end);
        this.pessoa.setLatitude(Double.valueOf(pos.getLongLat().getLatitude()));
        this.pessoa.setLongitude(Double.valueOf(pos.getLongLat().getLongitude()));
    }

    private void buildLogPessoa(Pessoa p, EnumConstSpedFiscalTpLogPessoa i, String oldValue, Pessoa pessoa, List logs) {
        Date dataAlteracao = TDate.dataSemHora((Date)new Date());
        LogPessoa l = this.serviceLogPessoaImpl.getLog(p, i, dataAlteracao);
        if (l == null) {
            l = new LogPessoa();
        }
        l.setCodCampo(Integer.valueOf(i.getValue()));
        l.setConteudoAnterior(oldValue);
        l.setDataAlteracao(dataAlteracao);
        l.setPessoa(pessoa);
        logs.add(l);
    }

    public Pessoa getNew() {
        Pessoa pes = new Pessoa();
        pes.setDataCadastro(new Date());
        pes.setAtivo(Short.valueOf((short)1));
        pes.setDataInicioRelacionamento(new Date());
        pes.setEndereco(new Endereco());
        pes.setComplemento(new Complemento());
        return pes;
    }

    public List<LogPessoa> avaliaMudancasPessoa(Pessoa pessoa, Pessoa old) {
        ArrayList<LogPessoa> logs = new ArrayList<LogPessoa>();
        if (!TMethods.isStrWithData((String)pessoa.getComplemento().getCnpj())) {
            return logs;
        }
        if (!TMethods.isEqualsIgnoreCase((String)pessoa.getNome(), (String)old.getNome())) {
            this.buildLogPessoa(pessoa, EnumConstSpedFiscalTpLogPessoa.NOME_PESSOA, old.getNome(), pessoa, logs);
        }
        if (pessoa.getEndereco().getCidade() != null && old.getEndereco().getCidade() != null && !TMethods.isEqualsIgnoreCase((String)pessoa.getEndereco().getCidade().getUf().getPais().getCodIbge(), (String)old.getEndereco().getCidade().getUf().getPais().getCodIbge())) {
            this.buildLogPessoa(pessoa, EnumConstSpedFiscalTpLogPessoa.COD_PAIS, old.getEndereco().getCidade().getUf().getPais().getCodIbge(), pessoa, logs);
        }
        if (!TMethods.isEqualsIgnoreCase((String)TString.onlyNumbers((String)pessoa.getComplemento().getCnpj()), (String)TString.onlyNumbers((String)old.getComplemento().getCnpj())) && old.getComplemento().getCnpj() != null && TString.onlyNumbers((String)old.getComplemento().getCnpj()).length() > 11) {
            this.buildLogPessoa(pessoa, EnumConstSpedFiscalTpLogPessoa.CNPJ, old.getComplemento().getCnpj(), pessoa, logs);
        }
        if (!TMethods.isEqualsIgnoreCase((String)TString.onlyNumbers((String)pessoa.getComplemento().getCnpj()), (String)TString.onlyNumbers((String)old.getComplemento().getCnpj())) && old.getComplemento().getCnpj() != null && TString.onlyNumbers((String)old.getComplemento().getCnpj()).length() <= 11) {
            this.buildLogPessoa(pessoa, EnumConstSpedFiscalTpLogPessoa.CPF, old.getComplemento().getCnpj(), pessoa, logs);
        }
        if (pessoa.getEndereco().getCidade() != null && old.getEndereco().getCidade() != null && !TMethods.isEqualsIgnoreCase((String)TString.onlyNumbers((String)pessoa.getEndereco().getCidade().getCodIbge()), (String)TString.onlyNumbers((String)old.getEndereco().getCidade().getCodIbge()))) {
            this.buildLogPessoa(pessoa, EnumConstSpedFiscalTpLogPessoa.COD_MUNICIPIO, old.getEndereco().getCidade().getCodIbge(), pessoa, logs);
        }
        if (!TMethods.isEqualsIgnoreCase((String)TString.onlyNumbers((String)pessoa.getComplemento().getSuframa()), (String)TString.onlyNumbers((String)old.getComplemento().getSuframa()))) {
            this.buildLogPessoa(pessoa, EnumConstSpedFiscalTpLogPessoa.SUFRAMA, old.getComplemento().getSuframa(), pessoa, logs);
        }
        if (!TMethods.isEqualsIgnoreCase((String)pessoa.getEndereco().getLogradouro(), (String)old.getEndereco().getLogradouro())) {
            this.buildLogPessoa(pessoa, EnumConstSpedFiscalTpLogPessoa.ENDERECO, old.getEndereco().getLogradouro(), pessoa, logs);
        }
        if (!TMethods.isEqualsIgnoreCase((String)pessoa.getEndereco().getNumero(), (String)old.getEndereco().getNumero())) {
            this.buildLogPessoa(pessoa, EnumConstSpedFiscalTpLogPessoa.NUMERO, old.getEndereco().getNumero(), pessoa, logs);
        }
        if (!TMethods.isEqualsIgnoreCase((String)pessoa.getEndereco().getComplemento(), (String)old.getEndereco().getComplemento())) {
            this.buildLogPessoa(pessoa, EnumConstSpedFiscalTpLogPessoa.COMPLEMENTO, old.getEndereco().getComplemento(), pessoa, logs);
        }
        if (!TMethods.isEqualsIgnoreCase((String)pessoa.getEndereco().getBairro(), (String)old.getEndereco().getBairro())) {
            this.buildLogPessoa(pessoa, EnumConstSpedFiscalTpLogPessoa.BAIRRO, old.getEndereco().getBairro(), pessoa, logs);
        }
        return logs;
    }

    public List<String> getEmailsAtivos() {
        LinkedList<String> emails = new LinkedList<String>();
        for (EmailPessoa em : this.pessoa.getComplemento().getEmails()) {
            if (!TMethods.isAffirmative((Number)em.getAtivo()) || !TMethods.isStrWithData((String)em.getEmail())) continue;
            emails.add(em.getEmail());
        }
        return emails;
    }

    public String getEmailsAtivosStr() {
        List<String> emails = this.getEmailsAtivos();
        return ToolString.asString(emails, (String)";");
    }

    public Pessoa validarPessoa(Pessoa p) throws ExceptionInvalidData {
        if (ToolMethods.isNull((Object)p).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.0047.004", new Object[0]);
        }
        if (!ToolMethods.isAffirmative((Number)p.getAtivo())) {
            throw new ExceptionInvalidData("E.ERP.0047.007", new Object[0]);
        }
        if (ToolMethods.isEquals((Object)p.getEndereco().getCidade().getUf().getSigla(), (Object)EnumConstUF.EX.getValue())) {
            return p;
        }
        if (!ToolMethods.isEquals((Object)p.getTipoPessoa(), (Object)EnumConstTipoPessoa.PESSOA_PRIMARIA.getEnumId())) {
            throw new ExceptionInvalidData("E.ERP.0047.006", new Object[0]);
        }
        if (!ToolMethods.isStrWithData((String)p.getComplemento().getCnpj())) {
            throw new ExceptionInvalidData("E.ERP.0047.005", new Object[0]);
        }
        return p;
    }

    public EmailPessoa getNovo(String email, Pessoa pessoa) {
        Optional<EmailPessoa> found = pessoa.getComplemento().getEmails().stream().filter(i -> ToolMethods.isEqualsIgnoreCase((String)email, (String)i.getEmail())).findFirst();
        if (found.isPresent()) {
            return found.get();
        }
        EmailPessoa em = this.getNovo(email);
        em.setComplemento(pessoa.getComplemento());
        em.getComplemento().getEmails().add(em);
        return em;
    }

    public EmailPessoa getNovo(String email) {
        EmailPessoa em = new EmailPessoa();
        em.setAtivo(Short.valueOf((short)1));
        em.setEmail(email);
        return em;
    }

    public Short getPessoaFisicaJuridica(String cnpj) {
        if (cnpj != null && cnpj.trim().length() == 14) {
            return EnumConstTipoPessoaComplementar.JURIDICA.getEnumId();
        }
        return EnumConstTipoPessoaComplementar.FISICA.getEnumId();
    }

    public void analisaEmailsValidos(Pessoa pessoa) {
        Complemento c = pessoa.getComplemento();
        for (int i = 0; i < c.getEmails().size(); ++i) {
            EmailPessoa em = (EmailPessoa)c.getEmails().get(0);
            if (ValidateEmail.isValid((String)em.getEmail())) {
                em.setComplemento(c);
                em.setDescricao(em.getEmail());
                em.setDescricao(em.getEmail());
                if (em.getDescricao() != null && em.getDescricao().length() > 100) {
                    em.setDescricao(em.getDescricao().substring(0, 100));
                }
                if (em.getEmail() != null && em.getEmail().length() > 300) {
                    em.setEmail(em.getEmail().substring(0, 300));
                }
                if (em.getEnviarDadosCotacao() == null) {
                    em.setEnviarDadosCotacao(Short.valueOf((short)0));
                }
                if (em.getEnviarDadosCte() == null) {
                    em.setEnviarDadosCte(Short.valueOf((short)0));
                }
                if (em.getEnviarDadosNfe() == null) {
                    em.setEnviarDadosNfe(Short.valueOf((short)0));
                }
                if (em.getEnviarDadosRelacionamento() == null) {
                    em.setEnviarDadosRelacionamento(Short.valueOf((short)0));
                }
                em.setAtivo(pessoa.getAtivo());
                continue;
            }
            if (ToolMethods.isWithData((Number)em.getIdentificador())) {
                em.setAtivo(Short.valueOf((short)0));
                continue;
            }
            c.getEmails().remove(i);
        }
    }

    public String getCnpjCpfComZeros(String cnpj) {
        if (!ToolMethods.isStrWithData((String)cnpj)) {
            return cnpj;
        }
        if ((cnpj = ToolString.onlyNumbers((String)cnpj)).length() < 11) {
            return ToolString.completaZerosEsquerda((String)cnpj, (int)11);
        }
        if (cnpj.length() == 11) {
            return cnpj;
        }
        return ToolString.completaZerosEsquerda((String)cnpj, (int)14);
    }

    public EnumConstantsMentorSimNao isEstrangeira() {
        if (this.pessoa != null && this.pessoa.getEndereco() != null && this.pessoa.getEndereco().getCidade() != null && TMethods.isEquals((Object)this.pessoa.getEndereco().getCidade().getUf().getSigla(), (Object)EnumConstUF.EX.getValue())) {
            return EnumConstantsMentorSimNao.SIM;
        }
        return EnumConstantsMentorSimNao.NAO;
    }
}

