/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.planejamentomateriaisprodlin;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.necessidadecompra.EnumConstTipoGeracaoNecCompra;
import com.touchcomp.basementor.constants.enums.necessidadecompra.EnumConstTipoNecCompra;
import com.touchcomp.basementor.constants.enums.planejamentolinhaproducao.materiais.EnumTipoGrupoPlanejamentoMateriaisLin;
import com.touchcomp.basementor.model.vo.GrupoNecCompra;
import com.touchcomp.basementor.model.vo.GrupoPlanejamentoMateriaisLin;
import com.touchcomp.basementor.model.vo.ItemMaterialPlanejLin;
import com.touchcomp.basementor.model.vo.ItemNecCompraDetalhes;
import com.touchcomp.basementor.model.vo.ItemPlanejProdLinProdPrevConsProd;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.PlanejamentoMateriaisProdLin;
import com.touchcomp.basementor.model.vo.TransfEstoquePCPLin;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class HelperPlanejamentoMateriaisProdLin
implements AbstractHelper<PlanejamentoMateriaisProdLin> {
    private PlanejamentoMateriaisProdLin data;

    public PlanejamentoMateriaisProdLin get() {
        return this.data;
    }

    public HelperPlanejamentoMateriaisProdLin build(PlanejamentoMateriaisProdLin data) {
        this.data = data;
        return this;
    }

    public void gerarTransfEstoquePCPLin() {
        if (TMethods.isWithData((Collection)this.data.getGruposPlanejMat()) && TMethods.isAffirmative((Number)this.data.getLiberarCompras()) && TMethods.isNull((Object)this.data.getIdentificador()).booleanValue()) {
            for (GrupoPlanejamentoMateriaisLin grupo : this.data.getGruposPlanejMat()) {
                if (!TMethods.isEquals((Object)EnumTipoGrupoPlanejamentoMateriaisLin.RESERVA.getValue(), (Object)grupo.getTipo())) continue;
                TransfEstoquePCPLin vo = new TransfEstoquePCPLin();
                vo.setDataCadastro(new Date());
                vo.setEmpresa(this.data.getEmpresa());
                vo.setDescricao(grupo.getObservacao());
                vo.setCentroEstoqueReserva(this.data.getCentroEstoque());
            }
        }
    }

    public void gerarNecessidadeCompraPlanejamento(OpcoesCompraSuprimentos opcoesCompra) {
        if (TMethods.isWithData((Collection)this.data.getGruposPlanejMat()) && TMethods.isAffirmative((Number)this.data.getLiberarCompras()) && TMethods.isNull((Object)this.data.getIdentificador()).booleanValue()) {
            for (GrupoPlanejamentoMateriaisLin grupo : this.data.getGruposPlanejMat()) {
                if (!TMethods.isEquals((Object)EnumTipoGrupoPlanejamentoMateriaisLin.COMPRA.getValue(), (Object)grupo.getTipo())) continue;
                GrupoNecCompra grupoNecCompra = new GrupoNecCompra();
                grupoNecCompra.setTipoNecessidade(Short.valueOf(EnumConstTipoNecCompra.TIPO_NECESSIDADE_NORMAL.getValue()));
                grupoNecCompra.setUsuarioSolicitante(this.data.getUsuarioSolicitante());
                grupoNecCompra.setCentroCusto(this.data.getCentroCusto());
                grupoNecCompra.setObservacao(grupo.getObservacao());
                grupoNecCompra.setEmpresa(this.data.getEmpresa());
                grupoNecCompra.setDataCadastro(new Date());
                if (TMethods.isWithData((Collection)grupo.getItensMateriaisPlanejLin())) {
                    for (ItemMaterialPlanejLin material : grupo.getItensMateriaisPlanejLin()) {
                        grupoNecCompra.getNecessidadesCompra().add(this.gerarNecessidadeCompraMaterial(grupo, material, grupoNecCompra, opcoesCompra));
                    }
                }
                grupo.setGruponecCompras(grupoNecCompra);
            }
        }
    }

    private NecessidadeCompra gerarNecessidadeCompraMaterial(GrupoPlanejamentoMateriaisLin grupo, ItemMaterialPlanejLin material, GrupoNecCompra grupoNecCompra, OpcoesCompraSuprimentos opcoesCompra) {
        NecessidadeCompra necessidadeCompra = new NecessidadeCompra();
        necessidadeCompra.setEmpresa(this.data.getEmpresa());
        necessidadeCompra.setTipoNecessidade(Short.valueOf(EnumConstTipoNecCompra.TIPO_NECESSIDADE_NORMAL.getValue()));
        necessidadeCompra.setTipoGeracao(Short.valueOf(EnumConstTipoGeracaoNecCompra.TIPO_GERACAO_AUTOMATICA.getValue()));
        necessidadeCompra.setUsuarioSolicitante(this.data.getUsuarioSolicitante());
        necessidadeCompra.setCentroCusto(this.data.getCentroCusto());
        necessidadeCompra.setGrupoNecCompra(grupoNecCompra);
        necessidadeCompra.setQuantidadeNecessidade(material.getQuantidade());
        necessidadeCompra.setQuantidadeNecessidadeGerada(material.getQuantidade());
        if (TMethods.isNotNull((Object)material.getPrevisaoConsProduto()).booleanValue()) {
            necessidadeCompra.setGradeCor(material.getPrevisaoConsProduto().getGradeCor());
            necessidadeCompra.setEstoque(material.getPrevisaoConsProduto().getQtdeSaldo());
            necessidadeCompra.setEstoqueRessuprimento(material.getPrevisaoConsProduto().getQtdeRessuprimento());
            necessidadeCompra.setEstoqueMinimo(material.getPrevisaoConsProduto().getQtdeMin());
            necessidadeCompra.setEstoqueMaximo(material.getPrevisaoConsProduto().getQtdeMax());
        }
        necessidadeCompra.setDataCadastro(new Date());
        necessidadeCompra.setDataNecessidade(grupo.getData());
        necessidadeCompra.setObservacao(grupo.getObservacao());
        necessidadeCompra.setDesativarNecessidade(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        if (TMethods.isNotNull((Object)material.getPrevisaoConsProduto().getGradeCor().getProdutoGrade().getProduto().getTipoIemSped()).booleanValue()) {
            necessidadeCompra.setNaturezaOperacao(material.getPrevisaoConsProduto().getGradeCor().getProdutoGrade().getProduto().getTipoIemSped().getNaturezaOperacaoNecCompra());
        }
        if (TMethods.isNotNull((Object)opcoesCompra).booleanValue()) {
            necessidadeCompra.setSituacaoNecessidadeCompra(opcoesCompra.getSituacaoNecessidadeCadastro());
        }
        necessidadeCompra.setItemNecCompraDetalhes(this.getDetalhesNecessidadeCompra(material, necessidadeCompra));
        return necessidadeCompra;
    }

    private List<ItemNecCompraDetalhes> getDetalhesNecessidadeCompra(ItemMaterialPlanejLin material, NecessidadeCompra necessidadeCompra) {
        ArrayList<ItemNecCompraDetalhes> detalhes = new ArrayList<ItemNecCompraDetalhes>();
        ItemNecCompraDetalhes detalhesNecCompra = new ItemNecCompraDetalhes();
        detalhesNecCompra.setQuantidade(material.getQuantidade());
        if (TMethods.isWithData((Collection)material.getPrevisaoConsProduto().getItemPlanejProdLinProdPrevConsProd())) {
            detalhesNecCompra.setQtdReferencia(((ItemPlanejProdLinProdPrevConsProd)material.getPrevisaoConsProduto().getItemPlanejProdLinProdPrevConsProd().getFirst()).getQtdReferencia());
            detalhesNecCompra.setComprimento(((ItemPlanejProdLinProdPrevConsProd)material.getPrevisaoConsProduto().getItemPlanejProdLinProdPrevConsProd().getFirst()).getComprimento());
            detalhesNecCompra.setAltura(((ItemPlanejProdLinProdPrevConsProd)material.getPrevisaoConsProduto().getItemPlanejProdLinProdPrevConsProd().getFirst()).getAltura());
            detalhesNecCompra.setLargura(((ItemPlanejProdLinProdPrevConsProd)material.getPrevisaoConsProduto().getItemPlanejProdLinProdPrevConsProd().getFirst()).getLargura());
            detalhesNecCompra.setVolume(((ItemPlanejProdLinProdPrevConsProd)material.getPrevisaoConsProduto().getItemPlanejProdLinProdPrevConsProd().getFirst()).getVolume());
            detalhesNecCompra.setNecessidadeCompra(necessidadeCompra);
        }
        detalhes.add(detalhesNecCompra);
        return detalhes;
    }
}

