/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.planejtempotrabalhopcp;

import com.touchcomp.basementor.model.vo.DiaPlanejTempoTrabalhoPCP;
import com.touchcomp.basementor.model.vo.DiaPlanejTempoTrabalhoPCPHor;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class AuxDiasTrabalho {
    AuxDiasTrabalho() {
    }

    List<DiaPlanejTempoTrabalhoPCP> criar(Date periodo, Short infDom, Short infSeg, Short infTer, Short infQua, Short infQui, Short infSex, Short infSab, Date dataHoraInicio, Date dataHoraFim, Short horarioProdutivo, String obs, List<DiaPlanejTempoTrabalhoPCP> data) {
        if (data == null) {
            data = new LinkedList<DiaPlanejTempoTrabalhoPCP>();
        }
        String month = TDate.dateToStr((Date)periodo, (String)"MM");
        String year = TDate.dateToStr((Date)periodo, (String)"yyyy");
        int dias = TDate.getDaysOnMonth((Date)periodo);
        LinkedList<DiaPlanejTempoTrabalhoPCP> ret = new LinkedList<DiaPlanejTempoTrabalhoPCP>();
        for (int i = 1; i <= dias; ++i) {
            String day = ToolString.completaZeros((String)String.valueOf(i), (int)2, (boolean)true);
            Date dia = TDate.strToDate((String)(day + "/" + month + "/" + year));
            Optional<DiaPlanejTempoTrabalhoPCP> found = data.stream().filter(j -> TMethods.isEquals((Object)dia, (Object)j.getDia())).findFirst();
            DiaPlanejTempoTrabalhoPCP d = found.isPresent() ? found.get() : new DiaPlanejTempoTrabalhoPCP();
            d.setDia(TDate.dataSemHora((Date)dia));
            ret.add(d);
        }
        this.informarHoras(ret, infDom, infSeg, infTer, infQua, infQui, infSex, infSab, dataHoraInicio, dataHoraFim, horarioProdutivo, obs);
        return ret;
    }

    List<DiaPlanejTempoTrabalhoPCP> criar(Date periodo) {
        String month = TDate.dateToStr((Date)periodo, (String)"MM");
        String year = TDate.dateToStr((Date)periodo, (String)"yyyy");
        int dias = TDate.getDaysOnMonth((Date)periodo);
        LinkedList<DiaPlanejTempoTrabalhoPCP> ret = new LinkedList<DiaPlanejTempoTrabalhoPCP>();
        for (int i = 1; i <= dias; ++i) {
            String day = ToolString.completaZeros((String)String.valueOf(i), (int)2, (boolean)true);
            Date dia = TDate.strToDate((String)(day + "/" + month + "/" + year));
            DiaPlanejTempoTrabalhoPCP d = new DiaPlanejTempoTrabalhoPCP();
            d.setDia(TDate.dataSemHora((Date)dia));
            ret.add(d);
        }
        return ret;
    }

    private void informarHoras(List<DiaPlanejTempoTrabalhoPCP> ret, Short infDom, Short infSeg, Short infTer, Short infQua, Short infQui, Short infSex, Short infSab, Date dataHoraInicio, Date dataHoraFim, Short horarioProdutivo, String obs) {
        for (DiaPlanejTempoTrabalhoPCP aux : ret) {
            GregorianCalendar g = new GregorianCalendar();
            g.setTime(aux.getDia());
            int dayOfWeek = g.get(7);
            if (!(TMethods.isAffirmative((Number)infDom) && TMethods.isEquals((Object)dayOfWeek, (Object)1) || TMethods.isAffirmative((Number)infSeg) && TMethods.isEquals((Object)dayOfWeek, (Object)2) || TMethods.isAffirmative((Number)infTer) && TMethods.isEquals((Object)dayOfWeek, (Object)3) || TMethods.isAffirmative((Number)infQua) && TMethods.isEquals((Object)dayOfWeek, (Object)4) || TMethods.isAffirmative((Number)infQui) && TMethods.isEquals((Object)dayOfWeek, (Object)5) || TMethods.isAffirmative((Number)infSex) && TMethods.isEquals((Object)dayOfWeek, (Object)6)) && (!TMethods.isAffirmative((Number)infSab) || !TMethods.isEquals((Object)dayOfWeek, (Object)7))) continue;
            this.createSetHorario(aux, g, dataHoraInicio, dataHoraFim, horarioProdutivo, obs);
        }
        this.somarHoras(ret);
    }

    private void createSetHorario(DiaPlanejTempoTrabalhoPCP aux, GregorianCalendar g, Date dataHoraInicio, Date dataHoraFim, Short horarioProdutivo, String obs) {
        GregorianCalendar a = new GregorianCalendar();
        DiaPlanejTempoTrabalhoPCPHor horario = new DiaPlanejTempoTrabalhoPCPHor();
        horario.setObservacao(obs);
        a.setTime(dataHoraInicio);
        a.set(5, g.get(5));
        a.set(2, g.get(2));
        a.set(1, g.get(1));
        horario.setDataInicio(a.getTime());
        a.setTime(dataHoraFim);
        a.set(5, g.get(5));
        a.set(2, g.get(2));
        a.set(1, g.get(1));
        horario.setDataTermino(a.getTime());
        horario.setNumHoras(TDate.calcularDifHoras((Date)horario.getDataInicio(), (Date)horario.getDataTermino()));
        horario.setDiaPlanejTempoTrabPCP(aux);
        horario.setTipoTempo(horarioProdutivo);
        aux.getDiaPlanejHorarios().add(horario);
    }

    void somarHoras(List<DiaPlanejTempoTrabalhoPCP> diasPlanejamento) {
        for (DiaPlanejTempoTrabalhoPCP aux : diasPlanejamento) {
            Double soma = aux.getDiaPlanejHorarios().stream().mapToDouble(i -> TMethods.isAffirmative((Number)i.getTipoTempo()) ? ToolNumber.asZeroIfNull((Double)i.getNumHoras()) : 0.0).sum();
            aux.setNumeroHorasTrab(soma);
        }
    }
}

