/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.planoconta;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorvalidator.entities.impl.planoconta.ValidPlanoConta;
import org.springframework.stereotype.Component;

@Component
public class HelperPlanoConta
implements AbstractHelper<PlanoConta> {
    private PlanoConta planoConta;

    public PlanoConta get() {
        return this.planoConta;
    }

    public HelperPlanoConta build(PlanoConta object) {
        this.planoConta = object;
        return this;
    }

    public boolean isAnalitica() {
        return this.isAnalitica(this.planoConta);
    }

    public boolean isAnalitica(PlanoConta pc) {
        if (pc == null) {
            return false;
        }
        return ValidPlanoConta.isAnalitica((PlanoConta)pc);
    }

    public boolean isSintetica() {
        return this.isSintetica(this.planoConta);
    }

    public boolean isSintetica(PlanoConta pc) {
        if (pc == null) {
            return false;
        }
        return !ValidPlanoConta.isAnalitica((PlanoConta)pc);
    }

    public boolean isNivel4(PlanoConta pc) {
        return ValidPlanoConta.isNivel4((String)pc.getCodigo());
    }

    public boolean isNivel3(PlanoConta pc) {
        return ValidPlanoConta.isNivel3((String)pc.getCodigo());
    }

    public boolean isNivel2(PlanoConta pc) {
        return ValidPlanoConta.isNivel2((String)pc.getCodigo());
    }

    public boolean isNivel1(PlanoConta pc) {
        return ValidPlanoConta.isNivel1((String)pc.getCodigo());
    }

    public Integer getNivelPlanoConta(String codigo) {
        if (ValidPlanoConta.isNivel1((String)codigo)) {
            return 1;
        }
        if (ValidPlanoConta.isNivel2((String)codigo)) {
            return 2;
        }
        if (ValidPlanoConta.isNivel3((String)codigo)) {
            return 3;
        }
        if (ValidPlanoConta.isNivel4((String)codigo)) {
            return 4;
        }
        return 5;
    }

    public char getNivelPlanoContaChar(String codigo) {
        return String.valueOf(this.getNivelPlanoConta(codigo)).charAt(0);
    }

    public String getCodigoPlanoContaSuperior(String codigo) {
        if (ValidPlanoConta.isNivel1((String)codigo)) {
            return codigo;
        }
        if (ValidPlanoConta.isNivel2((String)codigo)) {
            return codigo.substring(0, 1) + "000000000";
        }
        if (ValidPlanoConta.isNivel3((String)codigo)) {
            return codigo.substring(0, 2) + "00000000";
        }
        if (ValidPlanoConta.isNivel4((String)codigo)) {
            return codigo.substring(0, 3) + "0000000";
        }
        return codigo.substring(0, 5) + "00000";
    }

    public String getGrupoCodigo(String codigo) {
        if (codigo.length() < 5) {
            return codigo;
        }
        return ToolString.subString((String)codigo, (int)5);
    }

    public void setMarca() {
        if (this.planoConta == null) {
            return;
        }
        String codigo = this.planoConta.getCodigo();
        if (codigo == null || codigo.endsWith("00000")) {
            this.planoConta.setMarca(Integer.valueOf(EnumConstSinteticoAnalitico.SINTETICO.getValueInt()));
        } else {
            this.planoConta.setMarca(Integer.valueOf(EnumConstSinteticoAnalitico.ANALITICO.getValueInt()));
        }
    }

    public void setSequencial() {
        if (this.planoConta == null) {
            return;
        }
        if (!TMethods.isStrWithData((String)this.planoConta.getCodigo())) {
            this.planoConta.setSeq("00001");
        }
        this.planoConta.setSeq(this.planoConta.getCodigo().substring(5));
    }
}

