/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.planomanutencaoativo;

import com.touchcomp.basementor.model.vo.AtivoDataUltimaManutencao;
import com.touchcomp.basementor.model.vo.AtivoTipoPontoControle;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.PlanoManutencaoAtivo;
import com.touchcomp.basementor.model.vo.PlanoManutencaoAtivoAtivo;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class HelperPlanoManutencaoAtivo {
    public List<PlanoManutencaoAtivoAtivo> clearPlanosSemAtivo(List<PlanoManutencaoAtivoAtivo> planos) {
        ArrayList<PlanoManutencaoAtivoAtivo> toReturn = new ArrayList<PlanoManutencaoAtivoAtivo>();
        for (PlanoManutencaoAtivoAtivo planoManutencaoAtivoAtivo : planos) {
            if (planoManutencaoAtivoAtivo.getAtivoTipoPontoControle().isEmpty()) continue;
            toReturn.add(planoManutencaoAtivoAtivo);
        }
        return toReturn;
    }

    public Boolean verificaIntevaloDataUltimaManutencao(Date dataUltimaManutencao, Date dataInicial, Date dataFinal, Integer periodicidade) {
        Integer periodicidadeReal = periodicidade;
        Integer diffDiasDatas = ToolDate.diferenceDayBetweenDates((Date)dataUltimaManutencao, (Date)dataFinal);
        Integer osPendentes = diffDiasDatas / periodicidadeReal;
        if (ToolDate.dateBetween((Date)dataUltimaManutencao, (Date)(dataInicial = ToolDate.dataPrimHora((Date)dataInicial)), (Date)(dataFinal = ToolDate.dataUltHora((Date)dataFinal))).booleanValue()) {
            return true;
        }
        for (int i = 0; i < osPendentes; ++i) {
            Date newDataUltimaManutencao = ToolDate.nextDays((Date)dataUltimaManutencao, (int)periodicidade);
            if (ToolDate.dateBetween((Date)newDataUltimaManutencao, (Date)dataInicial, (Date)dataFinal).booleanValue()) {
                return true;
            }
            periodicidade = periodicidade + periodicidadeReal;
        }
        return false;
    }

    public Date geraDataUltimaManutencaoComPeriodicidade(Date dataUltimaManutencao, Date dataInicial, Date dataFinal, Integer periodicidade) {
        if (dataInicial == null && dataFinal == null) {
            return ToolDate.nextDays((Date)dataUltimaManutencao, (int)periodicidade);
        }
        ArrayList<Date> datasManutencoes = new ArrayList<Date>();
        Integer periodicidadeReal = periodicidade;
        Integer diffDiasDatas = ToolDate.diferenceDayBetweenDates((Date)dataUltimaManutencao, (Date)dataFinal);
        Integer osPendentes = diffDiasDatas / periodicidadeReal;
        dataInicial = ToolDate.dataPrimHora((Date)dataInicial);
        dataFinal = ToolDate.dataUltHora((Date)dataFinal);
        if (ToolDate.dateBetween((Date)ToolDate.nextDays((Date)dataUltimaManutencao, (int)periodicidade), (Date)dataInicial, (Date)dataFinal).booleanValue()) {
            return ToolDate.nextDays((Date)dataUltimaManutencao, (int)periodicidade);
        }
        for (int i = 0; i < osPendentes; ++i) {
            Date newDataUltimaManutencao = ToolDate.nextDays((Date)dataUltimaManutencao, (int)periodicidade);
            datasManutencoes.add(newDataUltimaManutencao);
            periodicidade = periodicidade + periodicidadeReal;
        }
        if (!datasManutencoes.isEmpty() && ToolDate.dateBetween((Date)((Date)datasManutencoes.get(datasManutencoes.size() - 1)), (Date)dataInicial, (Date)dataFinal).booleanValue()) {
            return (Date)datasManutencoes.get(datasManutencoes.size() - 1);
        }
        return null;
    }

    public AtivoTipoPontoControle getAtivoTipoPontoControle(Empresa empresa, PlanoManutencaoAtivoAtivo planoManutencaoAtivoAtivo, AtivoDataUltimaManutencao ativo, PlanoManutencaoAtivo planoManutencaoAtivo) {
        AtivoTipoPontoControle ativoTipoPontoControle = new AtivoTipoPontoControle();
        ativoTipoPontoControle.setEmpresa(empresa);
        ativoTipoPontoControle.setDataCadastro(new Date());
        ativoTipoPontoControle.setPlanoManutencaoAtivoAtivo(planoManutencaoAtivoAtivo);
        if (ativo != null) {
            ativoTipoPontoControle.setAtivo(ativo.getAtivo());
        }
        if (planoManutencaoAtivo != null) {
            ativoTipoPontoControle.setTipoPontoControle(planoManutencaoAtivo.getTipoPontoControle());
        }
        return ativoTipoPontoControle;
    }
}

