/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.preferenciastabela;

import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorbinary.model.PreferenciasTabela;
import com.touchcomp.basementorbinary.service.impl.preferenciastabela.ServicePreferenciasTabelaImpl;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.temp.preferencias.impl.DTOPreferenciasTabela;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperPreferenciasTabela {
    @Autowired
    private ServicePreferenciasTabelaImpl servicePreferenciasTabela;

    public DTOPreferenciasTabela getPreferenciasTabela(String key, String controller, Usuario user) {
        if (!TMethods.isStrWithData((String)controller)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.GEN.000051"));
        }
        if (!TMethods.isStrWithData((String)key)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.GEN.000052"));
        }
        PreferenciasTabela vo = user != null ? this.servicePreferenciasTabela.getPreferenciasTabela(key, controller, user.getIdentificador()) : this.servicePreferenciasTabela.getPreferenciasTabela(key, controller);
        if (vo == null) {
            return null;
        }
        DTOPreferenciasTabela dto = new DTOPreferenciasTabela();
        dto.setKey(vo.getKey());
        dto.setColunas(vo.getColunas());
        return dto;
    }

    private DTOPreferenciasTabela buildDTO(PreferenciasTabela vo) {
        DTOPreferenciasTabela dto = new DTOPreferenciasTabela();
        dto.setKey(vo.getKey());
        dto.setColunas(vo.getColunas());
        return dto;
    }

    private List<DTOPreferenciasTabela> buildDTO(List<PreferenciasTabela> vo) {
        ArrayList<DTOPreferenciasTabela> ret = new ArrayList<DTOPreferenciasTabela>();
        for (PreferenciasTabela aux : vo) {
            ret.add(this.buildDTO(aux));
        }
        return ret;
    }

    public List<DTOPreferenciasTabela> getPreferenciasTabela(String controller, Usuario user) {
        List preferencias = new ArrayList();
        preferencias = user != null ? this.servicePreferenciasTabela.getPreferenciasTabelasNodo(controller, user.getIdentificador()) : this.servicePreferenciasTabela.getPreferenciasTabelasNodo(controller);
        if (preferencias != null) {
            return this.buildDTO(preferencias);
        }
        return new ArrayList<DTOPreferenciasTabela>();
    }

    public void savePreferences(List<DTOPreferenciasTabela> dto, String controller, Usuario user) {
        for (DTOPreferenciasTabela aux : dto) {
            this.savePreferences(aux, controller, user);
        }
    }

    public PreferenciasTabela savePreferences(DTOPreferenciasTabela dto, String controller, Usuario user) {
        if (TMethods.isNull((Object)dto).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.GEN.000050"));
        }
        if (!TMethods.isStrWithData((String)dto.getKey())) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.GEN.000052"));
        }
        if (!TMethods.isStrWithData((String)controller)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.GEN.000051"));
        }
        if (!TMethods.isStrWithData((String)dto.getColunas())) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.GEN.000053", new String[]{dto.getKey()}));
        }
        return (PreferenciasTabela)this.servicePreferenciasTabela.saveOrUpdate((Object)this.buildPreferencias(dto, controller, user));
    }

    private PreferenciasTabela buildPreferencias(DTOPreferenciasTabela dto, String controller, Usuario user) {
        PreferenciasTabela vo = user != null ? this.servicePreferenciasTabela.getPreferenciasTabela(dto.getKey(), controller, user.getIdentificador()) : this.servicePreferenciasTabela.getPreferenciasTabela(dto.getKey(), controller, null);
        if (vo == null) {
            vo = new PreferenciasTabela();
        }
        if (user != null) {
            vo.setUsuarioIdentificador(user.getIdentificador());
        }
        vo.setControllerNodo(controller);
        vo.setKey(dto.getKey());
        vo.setColunas(dto.getColunas());
        return vo;
    }
}

