/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.pretabelaprecos;

import com.touchcomp.basementor.constants.enums.EnumConstIncrementarSubstituir;
import com.touchcomp.basementor.constants.enums.EnumConstPercentualValor;
import com.touchcomp.basementor.model.vo.PreTabelaPrecoBaseProduto;
import com.touchcomp.basementorservice.components.tabelapreco.CompCalculosTabelaPreco;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import org.springframework.stereotype.Component;

@Component
public class HelperPreTabelaPrecosProduto
implements AbstractHelper<PreTabelaPrecoBaseProduto> {
    private PreTabelaPrecoBaseProduto preTabPreco;
    private Integer nrCasasDec = 0;
    private Integer fracaoArredondamento = 0;
    private final CompCalculosTabelaPreco compCalculos = new CompCalculosTabelaPreco();

    public HelperPreTabelaPrecosProduto() {
    }

    public HelperPreTabelaPrecosProduto(PreTabelaPrecoBaseProduto produto) {
        this.preTabPreco = produto;
    }

    public PreTabelaPrecoBaseProduto get() {
        return this.preTabPreco;
    }

    public HelperPreTabelaPrecosProduto build(PreTabelaPrecoBaseProduto data) {
        this.preTabPreco = data;
        return this;
    }

    public Double calcValorVenda() {
        Double valor = this.compCalculos.calcValorVenda(this.preTabPreco.getValorCusto(), this.preTabPreco.getMargemLucro(), this.nrCasasDec, this.fracaoArredondamento);
        this.preTabPreco.setValorVenda(valor);
        this.afterCalcVenda();
        return valor;
    }

    public Double calcValorMin() {
        Double valor = this.compCalculos.calcValorMin(this.preTabPreco.getValorVenda(), this.preTabPreco.getPercMinimo());
        this.preTabPreco.setVlrMinimo(valor);
        return valor;
    }

    public Double calcValorMax() {
        Double valor = this.compCalculos.calcValorMax(this.preTabPreco.getValorVenda(), this.preTabPreco.getPercMaximo());
        this.preTabPreco.setVlrMaximo(valor);
        return valor;
    }

    public Double calcPercMin() {
        Double valor = this.compCalculos.calcPercMin(this.preTabPreco.getValorVenda(), this.preTabPreco.getVlrMinimo());
        this.preTabPreco.setPercMinimo(valor);
        return valor;
    }

    public Double calcPercMax() {
        Double valor = this.compCalculos.calcPercMax(this.preTabPreco.getValorVenda(), this.preTabPreco.getVlrMaximo());
        this.preTabPreco.setPercMaximo(valor);
        return valor;
    }

    public Double calcMargemLucro() {
        Double ret = this.compCalculos.calcMargemLucro(this.preTabPreco.getValorCusto(), this.preTabPreco.getValorVenda());
        this.preTabPreco.setMargemLucro(ret);
        this.afterCalcVenda();
        return ret;
    }

    public Double calcMargemLucro(EnumConstIncrementarSubstituir operador, Double margemAdicional) {
        Double ret = this.compCalculos.calcMargemLucro(this.preTabPreco.getMargemLucro(), operador, margemAdicional);
        this.preTabPreco.setMargemLucro(ret);
        this.calcValorVenda();
        return ret;
    }

    public Double calcValorVenda(EnumConstIncrementarSubstituir operador, Double margemAdicional, EnumConstPercentualValor opcaoValor) {
        Double ret = this.compCalculos.calcValorVenda(this.preTabPreco.getValorVenda(), operador, margemAdicional, opcaoValor, this.nrCasasDec, this.fracaoArredondamento);
        this.preTabPreco.setValorVenda(ret);
        ret = this.compCalculos.calcMargemLucro(this.preTabPreco.getValorCusto(), this.preTabPreco.getValorVenda());
        this.preTabPreco.setMargemLucro(ret);
        this.afterCalcVenda();
        return ret;
    }

    private void afterCalcVenda() {
        this.calcValorMin();
        this.calcValorMax();
        this.calcDifCustoAnt();
        this.calcDifVendaAnt();
    }

    public Double ajustaValor(Double valor) {
        return this.compCalculos.ajustaValor(valor, this.nrCasasDec, this.fracaoArredondamento);
    }

    private Double calcDifCustoAnt() {
        Double dif = ToolNumber.calcDifPercentual((Double)this.preTabPreco.getValorCustoAnt(), (Double)this.preTabPreco.getValorCusto());
        this.preTabPreco.setPercValorCustoAnt(dif);
        return dif;
    }

    private Double calcDifVendaAnt() {
        Double dif = ToolNumber.calcDifPercentual((Double)this.preTabPreco.getValorVendaAnt(), (Double)this.preTabPreco.getValorVenda());
        this.preTabPreco.setPercValorVendaAnt(dif);
        return dif;
    }

    public Integer getNrCasasDec() {
        return this.nrCasasDec;
    }

    public HelperPreTabelaPrecosProduto setNrCasasDec(Integer nrCasasDec) {
        this.nrCasasDec = nrCasasDec;
        return this;
    }

    public Integer getFracaoArredondamento() {
        return this.fracaoArredondamento;
    }

    public HelperPreTabelaPrecosProduto setFracaoArredondamento(Integer fracaoArredondamento) {
        this.fracaoArredondamento = fracaoArredondamento;
        return this;
    }
}

