/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.produto;

import com.touchcomp.basementor.model.impl.CustoProdutoUltimaNF;
import com.touchcomp.basementor.model.vo.CodigoBarras;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.IncidenciaPisCofins;
import com.touchcomp.basementor.model.vo.ItemUnidadeMedida;
import com.touchcomp.basementor.model.vo.NaturezaReceitaPisCofins;
import com.touchcomp.basementor.model.vo.NaturezaRequisicao;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.ParamReceitaPisCofinsNatReceita;
import com.touchcomp.basementor.model.vo.ParametrizacaoCtbRequisicao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.ProdutoGrade;
import com.touchcomp.basementor.model.vo.ProdutoOpcoesOp;
import com.touchcomp.basementorrules.opcoesdinamicas.interfaces.ModelOpDinamicasInterface;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.produto.web.DTOCustoProdutoUltimaNF;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class HelperProduto
implements AbstractHelper<Produto> {
    private Produto produto;

    public Produto get() {
        return this.produto;
    }

    public String getStringIdOrCodAuxProduto(Long idProduto, String codAux, OpcoesFaturamento op) {
        if (op != null && op.getUsarCodAuxNfe() != null && op.getUsarCodAuxNfe() == 1 && codAux != null && !codAux.isEmpty()) {
            return codAux;
        }
        return idProduto.toString();
    }

    public HelperProduto build(Produto data) {
        this.produto = data;
        return this;
    }

    public List<ItemUnidadeMedida> getItensUnidMedidasAtivoUnProd() {
        LinkedList<ItemUnidadeMedida> toAdd = new LinkedList<ItemUnidadeMedida>();
        if (this.produto != null) {
            ItemUnidadeMedida i = new ItemUnidadeMedida();
            i.setFatorConversao(Double.valueOf(1.0));
            i.setProduto(this.produto);
            i.setUnidadeMedida(this.produto.getUnidadeMedida());
            toAdd.add(i);
        }
        toAdd.addAll(this.getItensUnidadesMedidasAtivo());
        return toAdd;
    }

    public List<NaturezaRequisicao> getItensNaturezaReqProd(List<ParametrizacaoCtbRequisicao> objects) {
        ArrayList<NaturezaRequisicao> listNaturezaRequiscao = new ArrayList<NaturezaRequisicao>();
        for (ParametrizacaoCtbRequisicao p : objects) {
            if (listNaturezaRequiscao.contains(p.getNaturezaRequisicao())) continue;
            listNaturezaRequiscao.add(p.getNaturezaRequisicao());
        }
        return listNaturezaRequiscao;
    }

    public List<ItemUnidadeMedida> getItensUnidadesMedidasAtivo() {
        LinkedList<ItemUnidadeMedida> aux = new LinkedList<ItemUnidadeMedida>();
        if (this.produto == null) {
            return aux;
        }
        for (ItemUnidadeMedida it : this.produto.getItemUnidadeMedida()) {
            if (!ToolMethods.isAffirmative((Number)it.getAtivo())) continue;
            aux.add(it);
        }
        return aux;
    }

    public List<GradeCor> getGradeCoresAtivas() {
        LinkedList<GradeCor> aux = new LinkedList<GradeCor>();
        if (this.produto == null || this.produto.getGradesProduto() == null || this.produto.getGradesProduto().isEmpty()) {
            return aux;
        }
        for (ProdutoGrade produtoGrade : this.produto.getGradesProduto()) {
            if (produtoGrade.getGradesCores() == null || produtoGrade.getGradesCores().isEmpty()) continue;
            for (GradeCor g : produtoGrade.getGradesCores()) {
                if (!ToolMethods.isAffirmative((Number)g.getAtivo())) continue;
                aux.add(g);
            }
        }
        return aux;
    }

    public NaturezaReceitaPisCofins getNaturezaReceitaPisCofins(IncidenciaPisCofins inc) {
        if (this.produto == null || inc == null) {
            return null;
        }
        for (ParamReceitaPisCofinsNatReceita p : this.produto.getNaturezasReceita()) {
            if (!p.getParamReceitaPisCofinsCST().getIncidenciaPisCofins().equals((Object)inc)) continue;
            return p.getNaturezaReceitaPisCofins();
        }
        if (this.produto.getNcm() == null) {
            return null;
        }
        for (ParamReceitaPisCofinsNatReceita p : this.produto.getNcm().getNaturezasReceita()) {
            if (!p.getParamReceitaPisCofinsCST().getIncidenciaPisCofins().equals((Object)inc)) continue;
            return p.getNaturezaReceitaPisCofins();
        }
        return null;
    }

    public List<String> getCodigosBarrasAtivos() {
        LinkedList<String> ret = new LinkedList<String>();
        if (this.produto == null) {
            return ret;
        }
        for (CodigoBarras code : this.produto.getCodigoBarras()) {
            if (!ToolMethods.isAffirmative((Number)code.getAtivo())) continue;
            ret.add(code.getCodigoBarras());
        }
        return ret;
    }

    public DTOCustoProdutoUltimaNF toDTO(CustoProdutoUltimaNF vo) {
        DTOCustoProdutoUltimaNF dto = new DTOCustoProdutoUltimaNF();
        if (vo == null) {
            return dto;
        }
        dto.setQtde(vo.getQtde());
        dto.setFornecedor(vo.getFornecedor());
        dto.setSerieNF(vo.getSerieNF());
        dto.setNumeroNF(vo.getNumeroNF());
        dto.setCentroEstoque(vo.getCentroEstoque());
        dto.setValorCusto(vo.getValorCusto());
        dto.setDataUltCompra(vo.getDataUltCompra());
        dto.setValorUltPrecoCompra(vo.getValorUltPrecoCompra());
        return dto;
    }

    public List<DTOCustoProdutoUltimaNF> toDTO(List<CustoProdutoUltimaNF> custos) {
        ArrayList<DTOCustoProdutoUltimaNF> ret = new ArrayList<DTOCustoProdutoUltimaNF>();
        if (custos == null) {
            return ret;
        }
        custos.forEach(s -> ret.add(this.toDTO((CustoProdutoUltimaNF)s)));
        return ret;
    }

    public String getCodReferencia() {
        if (this.produto.getCodigoReferencia() != null && this.produto.getCodigoReferencia().length() > 0) {
            return this.produto.getCodigoReferencia();
        }
        return this.produto.getCodigoAuxiliar();
    }

    public List<ModelOpDinamicasInterface> getItens() {
        if (TMethods.isNull((Object)this.produto).booleanValue() || !TMethods.isWithData((Collection)this.produto.getOutrasOpcoes())) {
            return new LinkedList<ModelOpDinamicasInterface>();
        }
        LinkedList<ModelOpDinamicasInterface> options = new LinkedList<ModelOpDinamicasInterface>();
        for (final ProdutoOpcoesOp produtoOp : this.produto.getOutrasOpcoes()) {
            ModelOpDinamicasInterface a = new ModelOpDinamicasInterface(){

                public String getValor() {
                    return produtoOp.getValor();
                }

                public String getChave() {
                    return produtoOp.getCodigo();
                }

                public String getObservacao() {
                    return produtoOp.getObservacao();
                }

                public Long getIdentificador() {
                    return produtoOp.getIdentificador();
                }
            };
            options.add(a);
        }
        return options;
    }

    public Double getQuantidadeMax(Produto prod, Double capacidadePeso, Double capacidadeVolume) {
        double n1 = 0.0;
        double n2 = 0.0;
        if (ToolMethods.isWithData((Number)prod.getPesoUnitario())) {
            n1 = capacidadePeso / prod.getPesoUnitario();
        }
        if (ToolMethods.isWithData((Number)prod.getVolume())) {
            n2 = capacidadeVolume / prod.getVolume();
        }
        return n1 > n2 ? n1 : n2;
    }
}

