/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.projeto;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.model.vo.Projeto;
import com.touchcomp.basementor.model.vo.ProjetoTarefa;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class HelperProjeto
implements AbstractHelper<Projeto> {
    private Projeto projeto;

    public Projeto get() {
        return this.projeto;
    }

    public HelperProjeto build(Projeto data) {
        this.projeto = data;
        return this;
    }

    public void ordenarTarefasProjeto() {
        if (this.projeto == null) {
            return;
        }
        int maxChar = 0;
        for (ProjetoTarefa tar : this.projeto.getTarefas()) {
            if (tar.getCodigoTarefa().length() <= maxChar) continue;
            maxChar = ToolString.onlyNumbers((String)tar.getCodigoTarefa()).length();
        }
        int maxCharF = maxChar;
        Collections.sort(this.projeto.getTarefas(), (a1, a2) -> ToolString.compareHierarchical((String)a1.getCodigoTarefa(), (String)a2.getCodigoTarefa()));
        int index = 0;
        for (ProjetoTarefa tarefa : this.projeto.getTarefas()) {
            tarefa.setIndice(Integer.valueOf(index));
            ++index;
        }
    }

    public void processarProjeto() {
        if (this.projeto == null) {
            return;
        }
        for (ProjetoTarefa tar : this.projeto.getTarefas()) {
            this.setInfo(tar, this.projeto.getTarefas());
        }
    }

    private void setInfo(ProjetoTarefa tar, List<ProjetoTarefa> temp) {
        List<ProjetoTarefa> auxChildren;
        OptionalDouble opd;
        List<ProjetoTarefa> children = this.getTarefasFilhas(tar, temp);
        for (ProjetoTarefa pt : children) {
            this.setInfo(pt, temp);
        }
        Optional pr = children.stream().min((i1, i2) -> TDate.compareTo((Date)i1.getDataInicial(), (Date)i2.getDataInicial()));
        if (pr.isPresent()) {
            tar.setDataInicial(((ProjetoTarefa)pr.get()).getDataInicial());
        }
        if ((pr = children.stream().max((i1, i2) -> i1.getDataFinal().compareTo(i2.getDataFinal()))).isPresent()) {
            tar.setDataFinal(((ProjetoTarefa)pr.get()).getDataFinal());
        }
        if ((opd = (auxChildren = this.getTarefasFilhasEmAndamento(tar, temp)).stream().mapToDouble(i -> ToolNumber.asZeroIfNull((Double)i.getPercentualAndamento())).average()).isPresent()) {
            tar.setPercentualAndamento(Double.valueOf(opd.getAsDouble()));
        }
    }

    public short getNivelTarefa(String code) {
        if (code == null) {
            return 0;
        }
        String[] data = code.split("\\.");
        return (short)data.length;
    }

    public short getNivelTarefa(ProjetoTarefa tarefa) {
        if (tarefa == null) {
            return 0;
        }
        String code = tarefa.getCodigoTarefa();
        return this.getNivelTarefa(code);
    }

    public List<ProjetoTarefa> getTarefasFilhas(ProjetoTarefa principal, List<ProjetoTarefa> tarefas) {
        LinkedList<ProjetoTarefa> temp = new LinkedList<ProjetoTarefa>();
        if (tarefas == null) {
            return temp;
        }
        for (ProjetoTarefa pt : tarefas) {
            if (!TMethods.isEquals((Object)principal.getCodigoTarefa(), (Object)pt.getCodigoTarefaVinculada())) continue;
            temp.add(pt);
        }
        return temp;
    }

    public List<ProjetoTarefa> getTarefasFilhasEmAndamento(ProjetoTarefa principal, List<ProjetoTarefa> tarefas) {
        List<ProjetoTarefa> temp = this.getTarefasFilhas(principal, tarefas);
        LinkedList<ProjetoTarefa> aux = new LinkedList<ProjetoTarefa>();
        for (ProjetoTarefa pt : temp) {
            if (!(ToolNumber.asZeroIfNull((Double)pt.getPercentualAndamento()) >= 0.0)) continue;
            aux.add(pt);
        }
        return aux;
    }

    public void calcPercProjeto() {
        int totalTar = this.projeto.getTarefas().size();
        int totalTarConcl = this.projeto.getTarefas().stream().mapToInt(i -> i.getPercentualAndamento() == 100.0 ? 1 : 0).sum();
        this.projeto.setPercentualTotal(ToolNumber.calcPercentual((Number)totalTarConcl, (Number)totalTar));
    }

    public void calcularDiasTarefa() {
        for (ProjetoTarefa tarefa : this.projeto.getTarefas()) {
            tarefa.setDiasExecucao(ToolDate.diferenceDayBetweenDates((Date)tarefa.getDataInicial(), (Date)tarefa.getDataFinal()));
        }
    }

    public void setMarcaTarefasProjeto() {
        this.projeto.getTarefas().sort(Comparator.comparing(ProjetoTarefa::getCodigoTarefa, ToolString::compareHierarchical));
        Map<String, Boolean> possuiSubtarefas = this.projeto.getTarefas().stream().filter(tarefa -> tarefa.getCodigoTarefa() != null).collect(Collectors.toMap(ProjetoTarefa::getCodigoTarefa, tarefa -> this.projeto.getTarefas().stream().map(ProjetoTarefa::getCodigoTarefa).filter(Objects::nonNull).anyMatch(codigoSub -> codigoSub.startsWith(tarefa.getCodigoTarefa() + "."))));
        this.projeto.getTarefas().forEach(i -> {
            String codigo = i.getCodigoTarefa();
            boolean isSintetico = possuiSubtarefas.getOrDefault(codigo, false);
            i.setMarca(Short.valueOf(isSintetico ? EnumConstSinteticoAnalitico.SINTETICO.getValue() : EnumConstSinteticoAnalitico.ANALITICO.getValue()));
        });
    }
}

