/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.provisaodecimoterceiro;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroResultadoContFin;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.ItemProvisaoDec;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.PlanoContaImpostoFolha;
import com.touchcomp.basementor.model.vo.ProvisaoDec;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidDataRuntime;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorservice.helpers.impl.lotecontabil.HelperLoteContabil;
import com.touchcomp.basementorservice.service.impl.planocontaimpostofolha.ServicePlanoContaImpostoFolhaImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperLancamentoProvisaoDecTerceiros {
    @Autowired
    private HelperLoteContabil helperLote;

    public ProvisaoDec salvarAndContabilizarprovisaoDec(ProvisaoDec vo, EmpresaRh empresaRh) {
        if (vo != null && empresaRh != null) {
            LoteContabil l = this.gerarLancamentos(vo, empresaRh.getAjustarContaInssProvisao(), empresaRh.getPossuiDesoneracao());
            vo.setLoteContabil(l);
            if (ToolMethods.isEquals((Object)empresaRh.getGerarLancamentosGerenciais(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
                this.integrandoLancamentosGerenciaisProvisaoDecimoTerceiros(vo);
            }
        }
        return vo;
    }

    private LoteContabil gerarLancamentos(ProvisaoDec vo, Short ajustarContaInss, Short empresaDesonerada) {
        LoteContabil lote = this.contabilizarProvisaoDecimentoTerceiro(vo, ajustarContaInss, empresaDesonerada);
        if (lote.getLancamentos() != null && ToolMethods.isWithData((Collection)lote.getLancamentos())) {
            return lote;
        }
        return null;
    }

    private LoteContabil contabilizarProvisaoDecimentoTerceiro(ProvisaoDec vo, Short ajustarContaInss, Short empresaDesonerada) {
        LoteContabil lote = this.helperLote.criaRecriaLoteContabil(vo.getLoteContabil(), vo.getPeriodo(), vo.getEmpresa(), ConstEnumOrigemLoteContabil.PROVISAO_DEC);
        for (ItemProvisaoDec item : vo.getItensProvisoes()) {
            Double vlrDec = item.getVlrDec();
            Double vlrInssEmpresa = item.getVlrInssEmpresa();
            Double vlrInssTerceiros = item.getVlrInssTerceiros();
            Double vlrFgts = item.getVlrFgts();
            Double vlrRat = item.getVlrRat();
            Double vlrAposentadoria = item.getVlrAposentadoria25Anos();
            this.criarLancamentos(lote, item.getColaborador(), vlrDec, vlrInssEmpresa, vlrInssTerceiros, vlrFgts, vlrRat, vlrAposentadoria, ajustarContaInss, empresaDesonerada);
        }
        return lote;
    }

    private void criarLancamentos(LoteContabil lote, Colaborador colaborador, Double vlrDec, Double vlrInssEmpresa, Double vlrInssTerceiros, Double vlrFgts, Double vlrRat, Double vlrAposentadoria, Short ajustarContaInss, Short empresaDesonerada) {
        List<PlanoContaImpostoFolha> ret = ((ServicePlanoContaImpostoFolhaImpl)ConfApplicationContext.getBean(ServicePlanoContaImpostoFolhaImpl.class)).getPlanoContaImpostoProvisao(colaborador.getCentroCusto());
        if (ret.size() > 1) {
            String retorno = "EXISTE MAIS DE UMA PARAMETRIZA\u00c7\u00c3O PARA: \nCentro de custo: " + colaborador.getCentroCusto().getNome() + " para Provis\u00e3o de Dec. Terceiro ";
            for (PlanoContaImpostoFolha p : ret) {
                retorno = retorno + " " + p.getIdentificador().toString() + ";";
            }
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.WEB-FOR.000.000", new String[]{retorno}));
        }
        if (!ToolMethods.isWithData(ret)) {
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.WEB-FOR.000.000", new String[]{"N\u00c3O EXISTE PARAMETRIZA\u00c7\u00c3O PARA: \nCentro de custo: " + colaborador.getCentroCusto().getNome() + " para a Provis\u00e3o de Dec. Terceiro"}));
        }
        PlanoContaImpostoFolha p = ret.get(0);
        if (ToolMethods.isWithData((Number)vlrDec)) {
            if (p.getPlanoCCCreditoDecSalarioProv() != null && p.getPlanoCCDebitoDecSalarioProv() != null) {
                this.getLancamento(vlrDec, p.getPlanoCCCreditoDecSalarioProv(), p.getPlanoCCDebitoDecSalarioProv(), p.getHistoricoDecSalarioProv(), lote, colaborador.getEmpresa().getEmpresaDados().getCentroResultadoContFin(), colaborador.getEmpresa());
            } else {
                throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.WEB-FOR.000.000", new String[]{"Nenhum Plano de Contas de D\u00e9bito/Cr\u00e9dito de D\u00e9cimo Sal\u00e1rio encontrado na Parametriza\u00e7\u00e3o de Contabiliza\u00e7\u00e3o da Folha encontrada para o Centro de Custo: " + colaborador.getCentroCusto().getCodigo() + " - " + colaborador.getCentroCusto().getNome()}));
            }
        }
        if (ToolMethods.isWithData((Number)vlrInssEmpresa) || ToolMethods.isEquals((Object)ajustarContaInss, (Object)EnumConstantsMentorSimNao.SIM.getValue()) && ToolMethods.isEquals((Object)empresaDesonerada, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            if (p.getPlanoCCCreditoInssDecProv() != null && p.getPlanoCCDebitoInssDecProv() != null) {
                this.getLancamento(vlrInssEmpresa, p.getPlanoCCCreditoInssDecProv(), p.getPlanoCCDebitoInssDecProv(), p.getHistoricoInssDecProv(), lote, colaborador.getEmpresa().getEmpresaDados().getCentroResultadoContFin(), colaborador.getEmpresa());
            } else {
                throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.WEB-FOR.000.000", new String[]{"Nenhum Plano de Contas de D\u00e9bito/Cr\u00e9dito de INSS Empresa encontrado na Parametriza\u00e7\u00e3o de Contabiliza\u00e7\u00e3o da Folha encontrada para o Centro de Custo: " + colaborador.getCentroCusto().getCodigo() + " - " + colaborador.getCentroCusto().getNome()}));
            }
        }
        if (ToolMethods.isWithData((Number)vlrInssTerceiros)) {
            if (p.getPlanoCCCreditoTerceirosDecProv() != null && p.getPlanoCCDebitoTerceirosDecProv() != null) {
                this.getLancamento(vlrInssTerceiros, p.getPlanoCCCreditoTerceirosDecProv(), p.getPlanoCCDebitoTerceirosDecProv(), p.getHistoricoTerceirosProvDec(), lote, colaborador.getEmpresa().getEmpresaDados().getCentroResultadoContFin(), colaborador.getEmpresa());
            } else {
                throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.WEB-FOR.000.000", new String[]{"Nenhum Plano de Contas de D\u00e9bito/Cr\u00e9dito de INSS Terceiros encontrado na Parametriza\u00e7\u00e3o de Contabiliza\u00e7\u00e3o da Folha encontrada para o Centro de Custo: " + colaborador.getCentroCusto().getCodigo() + " - " + colaborador.getCentroCusto().getNome()}));
            }
        }
        if (ToolMethods.isWithData((Number)vlrFgts)) {
            if (p.getPlanoCCCreditoFgtsDecProv() != null && p.getPlanoCCDebitoFgtsDecProv() != null) {
                this.getLancamento(vlrFgts, p.getPlanoCCCreditoFgtsDecProv(), p.getPlanoCCDebitoFgtsDecProv(), p.getHistoricoFgtsDecProv(), lote, colaborador.getEmpresa().getEmpresaDados().getCentroResultadoContFin(), colaborador.getEmpresa());
            } else {
                throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.WEB-FOR.000.000", new String[]{"Nenhum Plano de Contas de D\u00e9bito/Cr\u00e9dito de FGTS encontrado na Parametriza\u00e7\u00e3o de Contabiliza\u00e7\u00e3o da Folha encontrada para o Centro de Custo: " + colaborador.getCentroCusto().getCodigo() + " - " + colaborador.getCentroCusto().getNome()}));
            }
        }
        if (ToolMethods.isWithData((Number)vlrRat)) {
            if (p.getPlanoCCCreditoRatDecProv() != null && p.getPlanoCCDebitoRatDecProv() != null) {
                this.getLancamento(vlrRat, p.getPlanoCCCreditoRatDecProv(), p.getPlanoCCDebitoRatDecProv(), p.getHistoricoRatDecProv(), lote, colaborador.getEmpresa().getEmpresaDados().getCentroResultadoContFin(), colaborador.getEmpresa());
            } else {
                throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.WEB-FOR.000.000", new String[]{"Nenhum Plano de Contas de D\u00e9bito/Cr\u00e9dito de RAT encontrado na Parametriza\u00e7\u00e3o de Contabiliza\u00e7\u00e3o da Folha encontrada para o Centro de Custo: " + colaborador.getCentroCusto().getCodigo() + " - " + colaborador.getCentroCusto().getNome()}));
            }
        }
        if (ToolMethods.isWithData((Number)vlrAposentadoria)) {
            if (p.getPlanoCCCreditoRatDecProv() != null && p.getPlanoCCDebitoRatDecProv() != null) {
                this.getLancamento(vlrAposentadoria, p.getPlanoCCCreditoRatDecProv(), p.getPlanoCCDebitoRatDecProv(), p.getHistoricoRatDecProv(), lote, colaborador.getEmpresa().getEmpresaDados().getCentroResultadoContFin(), colaborador.getEmpresa());
            } else {
                throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.WEB-FOR.000.000", new String[]{"Nenhum Plano de Contas de D\u00e9bito/Cr\u00e9dito de RAT encontrado na Parametriza\u00e7\u00e3o de Contabiliza\u00e7\u00e3o da Folha encontrada para o Centro de Custo: " + colaborador.getCentroCusto().getCodigo() + " - " + colaborador.getCentroCusto().getNome()}));
            }
        }
    }

    private void getLancamento(Double valor, PlanoConta planoCredito, PlanoConta planoDebito, HistoricoPadrao historicoPadrao, LoteContabil lote, CentroResultadoContFin centroResultado, Empresa emp) {
        for (Lancamento lancamento : lote.getLancamentos()) {
            if (!ToolMethods.isEquals((Object)lancamento.getPlanoContaDeb(), (Object)planoDebito) || !ToolMethods.isEquals((Object)lancamento.getPlanoContaCred(), (Object)planoCredito) || !ToolMethods.isEquals((Object)lancamento.getCentroResultadoContFin(), (Object)centroResultado)) continue;
            lancamento.setValor(Double.valueOf(lancamento.getValor() + valor));
            return;
        }
        Lancamento vo = CompLancamentoBase.newLancamento(lote, emp);
        vo.setValor(valor);
        vo.setPlanoContaDeb(planoDebito);
        vo.setPlanoContaCred(planoCredito);
        vo.setHistoricoPadrao(historicoPadrao);
        vo.setHistorico(historicoPadrao.getDescricao());
        lote.getLancamentos().add(vo);
    }

    private void integrandoLancamentosGerenciaisProvisaoDecimoTerceiros(ProvisaoDec provisao) {
        ArrayList<LancamentoCtbGerencial> lancs = new ArrayList<LancamentoCtbGerencial>();
        for (ItemProvisaoDec item : provisao.getItensProvisoes()) {
            LancamentoCtbGerencial lanc;
            String historico;
            PlanoContaGerencial planoConta;
            Double valor;
            Short tipoLancamento;
            CentroCusto cc = item.getColaborador().getCentroCusto();
            List<PlanoContaImpostoFolha> ret = ((ServicePlanoContaImpostoFolhaImpl)ConfApplicationContext.getBean(ServicePlanoContaImpostoFolhaImpl.class)).getPlanoContaImpostoProvisao(cc);
            if (ret.size() > 1) {
                String retorno = "EXISTE MAIS DE UMA PARAMETRIZA\u00c7\u00c3O PARA: \nCentro de custo: " + cc.getNome() + "\n  Id: ";
                for (PlanoContaImpostoFolha p : ret) {
                    retorno = retorno + " " + p.getIdentificador().toString() + ";";
                }
                throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.WEB-FOR.000.000", new String[]{retorno}));
            }
            if (!ToolMethods.isWithData(ret)) {
                throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.WEB-FOR.000.000", new String[]{"N\u00c3O EXISTE PARAMETRIZA\u00c7\u00c3O PARA: \nCentro de custo: " + cc.getNome()}));
            }
            PlanoContaImpostoFolha p = ret.get(0);
            if (ToolMethods.isWithData((Number)item.getVlrDec())) {
                if (p.getPlanoCGDecSalarioProv() == null || p.getHistoricoDecSalarioProv() == null) {
                    throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.WEB-FOR.000.000", new String[]{"N\u00c3O EXISTE PLANO DE CONTA GERENCIAL PARA: \nCentro de custo: " + cc.getNome() + "\n" + "Valores Decimo Terceiro ".toUpperCase() + "\nIDENTIFICADOR: " + p.getIdentificador()}));
                }
                tipoLancamento = EnumLancamentoCTBGerencial.DEBITO.getValue();
                valor = item.getVlrDec();
                planoConta = p.getPlanoCGDecSalarioProv();
                historico = p.getHistoricoDecSalarioProv().getDescricao();
                lanc = HelperLancamentoProvisaoDecTerceiros.criarLancamentoGerencial(tipoLancamento, valor, historico, cc, planoConta, provisao.getPeriodo(), provisao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
                lancs.add(lanc);
            }
            if (ToolMethods.isWithData((Number)item.getVlrInssEmpresa())) {
                if (p.getPlanoCGInssDecProv() == null || p.getHistoricoInssDecProv() == null) {
                    throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.WEB-FOR.000.000", new String[]{"N\u00c3O EXISTE PLANO DE CONTA GERENCIAL PARA: \nCentro de custo: " + cc.getNome() + "\nINSS PARTE EMPRESA : \nIDENTIFICADOR: " + p.getIdentificador()}));
                }
                tipoLancamento = EnumLancamentoCTBGerencial.DEBITO.getValue();
                valor = item.getVlrInssEmpresa();
                planoConta = p.getPlanoCGInssDecProv();
                historico = p.getHistoricoInssDecProv().getDescricao();
                lanc = HelperLancamentoProvisaoDecTerceiros.criarLancamentoGerencial(tipoLancamento, valor, historico, cc, planoConta, provisao.getPeriodo(), provisao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
                lancs.add(lanc);
            }
            if (ToolMethods.isWithData((Number)item.getVlrFgts())) {
                if (p.getPlanoCGFgtsDecProv() == null || p.getHistoricoFgtsDecProv() == null) {
                    throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.WEB-FOR.000.000", new String[]{"N\u00c3O EXISTE PLANO DE CONTA GERENCIAL PARA: \nCentro de custo: " + cc.getNome() + "\nFGTS : \nIDENTIFICADOR: " + p.getIdentificador()}));
                }
                tipoLancamento = EnumLancamentoCTBGerencial.DEBITO.getValue();
                valor = item.getVlrFgts();
                planoConta = p.getPlanoCGFgtsDecProv();
                historico = p.getHistoricoFgtsDecProv().getDescricao();
                lanc = HelperLancamentoProvisaoDecTerceiros.criarLancamentoGerencial(tipoLancamento, valor, historico, cc, planoConta, provisao.getPeriodo(), provisao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
                lancs.add(lanc);
            }
            if (ToolMethods.isWithData((Number)item.getVlrInssTerceiros())) {
                if (p.getPlanoCGTerceirosDecProv() == null || p.getHistoricoTerceirosProvDec() == null) {
                    throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.WEB-FOR.000.000", new String[]{"N\u00c3O EXISTE PLANO DE CONTA GERENCIAL PARA: \nCentro de custo: " + cc.getNome() + "\n VALORES DE TERCEIROS : \nIDENTIFICADOR: " + p.getIdentificador()}));
                }
                tipoLancamento = EnumLancamentoCTBGerencial.DEBITO.getValue();
                valor = item.getVlrInssTerceiros();
                planoConta = p.getPlanoCGTerceirosDecProv();
                historico = p.getHistoricoTerceirosProvDec().getDescricao();
                lanc = HelperLancamentoProvisaoDecTerceiros.criarLancamentoGerencial(tipoLancamento, valor, historico, cc, planoConta, provisao.getPeriodo(), provisao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
                lancs.add(lanc);
            }
            if (ToolMethods.isWithData((Number)item.getVlrRat())) {
                if (p.getPlanoCGRatDecProv() == null || p.getHistoricoRatDecProv() == null) {
                    throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.WEB-FOR.000.000", new String[]{"N\u00c3O EXISTE PLANO DE CONTA GERENCIAL PARA: \nCentro de custo: " + cc.getNome() + "\n VALORES DE RAT : \n IDENTIFICADOR: " + p.getIdentificador()}));
                }
                tipoLancamento = EnumLancamentoCTBGerencial.DEBITO.getValue();
                valor = item.getVlrRat();
                planoConta = p.getPlanoCGRatDecProv();
                historico = p.getHistoricoRatDecProv().getDescricao();
                lanc = HelperLancamentoProvisaoDecTerceiros.criarLancamentoGerencial(tipoLancamento, valor, historico, cc, planoConta, provisao.getPeriodo(), provisao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
                lancs.add(lanc);
            }
            if (!ToolMethods.isWithData((Number)item.getVlrAposentadoria25Anos())) continue;
            if (p.getPlanoCGRatDecProv() == null || p.getHistoricoRatDecProv() == null) {
                throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.WEB-FOR.000.000", new String[]{"N\u00c3O EXISTE PLANO DE CONTA GERENCIAL PARA: \n" + "Centro de custo: ".toUpperCase() + cc.getNome() + "\n RAT : \nIDENTIFICADOR: " + p.getIdentificador()}));
            }
            tipoLancamento = EnumLancamentoCTBGerencial.DEBITO.getValue();
            valor = item.getVlrAposentadoria25Anos();
            planoConta = p.getPlanoCGRatDecProv();
            historico = p.getHistoricoRatDecProv().getDescricao();
            lanc = HelperLancamentoProvisaoDecTerceiros.criarLancamentoGerencial(tipoLancamento, valor, historico, cc, planoConta, provisao.getPeriodo(), provisao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
            lancs.add(lanc);
        }
        provisao.setLancsGerencial(lancs);
    }

    private static LancamentoCtbGerencial criarLancamentoGerencial(Short tipoLancamento, Double valor, String historico, CentroCusto centroCusto, PlanoContaGerencial planoConta, Date dataCadastro, Empresa empresa, Short gerado) {
        LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, dataCadastro, dataCadastro, tipoLancamento, empresa, gerado, historico, planoConta, EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO.getValue(), centroCusto, valor, null);
        return l;
    }
}

