/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.provisaodecimoterceiro;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemProvisaoDec;
import com.touchcomp.basementor.model.vo.ProvisaoDec;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.service.impl.provisaodec.ServiceProvisaoDecImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;

public class HelperProvisaoDec
implements AbstractHelper<ProvisaoDec> {
    private ProvisaoDec provisaoDec;

    public ProvisaoDec get() {
        return this.provisaoDec;
    }

    public HelperProvisaoDec build(ProvisaoDec data) {
        this.provisaoDec = data;
        return this;
    }

    public static List<ItemProvisaoDec> createItemProvisaoDec(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, EmpresaRh empresaRh, Double percDesoneracao) {
        ArrayList<ItemProvisaoDec> itens = new ArrayList<ItemProvisaoDec>();
        List<Object> colaboradores = new ArrayList();
        colaboradores = ToolMethods.isEquals((Object)empresaRh.getContabilizarProvisaoCC(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) ? ((ServiceProvisaoDecImpl)ConfApplicationContext.getBean(ServiceProvisaoDecImpl.class)).findColaboradoresProvisaoDecCentroCusto(dataInicial, dataFinal, empresaRh.getEmpresa()) : ((ServiceProvisaoDecImpl)ConfApplicationContext.getBean(ServiceProvisaoDecImpl.class)).findColaboradoresProvisaoDec(dataInicial, dataFinal, grupoEmpresa);
        for (Colaborador colaborador : colaboradores) {
            ItemProvisaoDec item = HelperProvisaoDec.calcularProvisaoDecimoTerceiro(colaborador, dataInicial, dataFinal, empresaRh, percDesoneracao);
            if (item == null) continue;
            itens.add(item);
        }
        return itens;
    }

    public static ItemProvisaoDec calcularProvisaoDecimoTerceiro(Colaborador colaborador, Date dataInicial, Date dataFinal, EmpresaRh empresaRh, Double percDesoneracao) {
        Double avosDec = HelperProvisaoDec.getNrAvosDec(colaborador, dataFinal);
        if (avosDec > 0.0) {
            Double vlrSalarioBase = HelperProvisaoDec.getSalarioBase(colaborador);
            Double vlrMedia = ((ServiceProvisaoDecImpl)ConfApplicationContext.getBean(ServiceProvisaoDecImpl.class)).vlrMediaProvDecimoTerceiro(colaborador, dataInicial);
            Double vlrMaiorRemuneracao = ToolFormatter.arrredondarNumero((Double)(vlrSalarioBase + vlrMedia / avosDec), (int)2);
            Double vlrDec = HelperProvisaoDec.getDec(vlrMaiorRemuneracao, avosDec);
            Double vlrInssEmpresa = HelperProvisaoDec.getVlrInssEmpresa(vlrDec, percDesoneracao, empresaRh);
            Double vlrInssTerceiros = HelperProvisaoDec.getVlrInssTer(vlrDec, empresaRh);
            Double vlrFgts = HelperProvisaoDec.getVlFgts(vlrDec);
            Double vlrRat = HelperProvisaoDec.getVlrRat(vlrDec, empresaRh);
            Double vlrAposentadoria25 = HelperProvisaoDec.getVlrAposentadoriaEspecial25(colaborador, vlrDec, empresaRh);
            Double vlrPis = HelperProvisaoDec.getValorPis(vlrDec, empresaRh);
            Double vlrMensal = ToolFormatter.arrredondarNumero((Double)((vlrDec + vlrAposentadoria25 + vlrFgts + vlrInssEmpresa + vlrInssTerceiros + vlrRat) / avosDec), (int)2);
            ItemProvisaoDec item = new ItemProvisaoDec(colaborador, vlrSalarioBase, vlrMedia, vlrMaiorRemuneracao, avosDec, vlrDec, vlrInssEmpresa, vlrInssTerceiros, vlrFgts, vlrRat, vlrAposentadoria25, vlrPis, vlrMensal);
            return item;
        }
        return null;
    }

    public static Double getNrAvosDec(Colaborador colaborador, Date periodoProvisao) {
        boolean continuar = true;
        Double avosAfastado = HelperProvisaoDec.colaboradorAfastadoProvisaoDec(colaborador, periodoProvisao);
        Integer avos = 0;
        GregorianCalendar dataAdmissao = new GregorianCalendar();
        GregorianCalendar periodo = new GregorianCalendar();
        dataAdmissao.setTime(colaborador.getDataAdmissao());
        periodo.setTime(periodoProvisao);
        if (ToolMethods.isEquals((Object)dataAdmissao.get(1), (Object)periodo.get(1))) {
            avos = HelperProvisaoDec.getPrimeiroAvos(colaborador.getDataAdmissao());
            dataAdmissao.add(2, 1);
            do {
                if (dataAdmissao.before(periodo)) {
                    avos = avos + 1;
                    continuar = true;
                } else {
                    continuar = false;
                }
                dataAdmissao.add(2, 1);
            } while (continuar);
            return avos.doubleValue() - avosAfastado;
        }
        if (dataAdmissao.get(1) < periodo.get(1)) {
            avos = periodo.get(2) + 1;
            if (periodo.get(5) < 15) {
                avos = avos - 1;
            }
            return avos.doubleValue() - avosAfastado;
        }
        return avosAfastado;
    }

    public static Double colaboradorAfastadoProvisaoDec(Colaborador colaborador, Date periodoProvisao) {
        List ret = ((ServiceProvisaoDecImpl)ConfApplicationContext.getBean(ServiceProvisaoDecImpl.class)).afastamentoColaborador(colaborador, periodoProvisao);
        if (ret == null || ret.isEmpty()) {
            return 0.0;
        }
        Double avosTotal = 0.0;
        for (Object ob : ret) {
            Double avos1;
            Date dataAfastamento;
            HashMap h = (HashMap)ob;
            String tipoAfastametento = (String)h.get("TIPO_AFASTAMENTO");
            if (tipoAfastametento.equals("SAIDA_ANO_SEM_RETORNO")) {
                dataAfastamento = (Date)h.get("DATA_AFASTAMENTO");
                avos1 = HelperProvisaoDec.calcularAvosAfastamento(dataAfastamento, periodoProvisao, HelperProvisaoDec.dataFimPrimeiroAvos(dataAfastamento));
                avosTotal = avos1 + avosTotal;
                continue;
            }
            if (tipoAfastametento.equals("SAIDA_ANO_COM_RETORNO")) {
                dataAfastamento = (Date)h.get("DATA_AFASTAMENTO");
                Date dataRetorno = (Date)h.get("DATA_RETORNO");
                Double avos12 = HelperProvisaoDec.calcularAvosAfastamento(dataAfastamento, dataRetorno, HelperProvisaoDec.dataFimPrimeiroAvos(dataAfastamento));
                avosTotal = avosTotal + avos12;
                continue;
            }
            if (!tipoAfastametento.equals("SAIDA_ANO_ANTERIOR_COM_RETORNO")) continue;
            Date dataRetorno = (Date)h.get("DATA_RETORNO");
            avos1 = HelperProvisaoDec.calcularAvosAfastamento(HelperProvisaoDec.dataInicioAno(periodoProvisao, colaborador), dataRetorno, dataRetorno);
            avosTotal = avosTotal + avos1;
        }
        return avosTotal;
    }

    private static Date dataFimPrimeiroAvos(Date data) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        g.set(5, g.getActualMaximum(5));
        return g.getTime();
    }

    private static Double calcularAvosAfastamento(Date dataInicio, Date dataFim, Date dataFimPrimeiroAvos) {
        Integer avos = 0;
        GregorianCalendar dataAdmissao = new GregorianCalendar();
        GregorianCalendar periodo = new GregorianCalendar();
        dataAdmissao.setTime(dataInicio);
        periodo.setTime(dataFim);
        boolean continuar = true;
        if (dataAdmissao.get(1) == periodo.get(1)) {
            avos = HelperProvisaoDec.getPrimeiroAvosAfastamento(dataInicio, dataFimPrimeiroAvos);
            dataAdmissao.add(2, 1);
            do {
                if (dataAdmissao.before(periodo)) {
                    avos = avos + 1;
                    continuar = true;
                } else {
                    continuar = false;
                }
                dataAdmissao.add(2, 1);
            } while (continuar);
            return avos.doubleValue();
        }
        if (dataAdmissao.get(1) < periodo.get(1)) {
            avos = periodo.get(2) + 1;
            if (periodo.get(5) < 15) {
                avos = avos - 1;
            }
            return avos.doubleValue();
        }
        return 0.0;
    }

    private static Date dataInicioAno(Date periodoProvisao, Colaborador c) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(periodoProvisao);
        Date janeiro = ToolDate.intToDate((Integer)g.get(1), (Integer)1, (Integer)1);
        if (c.getDataAdmissao().before(janeiro)) {
            return janeiro;
        }
        return c.getDataAdmissao();
    }

    private static Integer getPrimeiroAvosAfastamento(Date dataInicio, Date dataFim) {
        Integer dias = ToolDate.diferenceDayBetweenDates((Date)dataInicio, (Date)dataFim) + 1;
        if (dias >= 15) {
            return 1;
        }
        return 0;
    }

    private static Integer getPrimeiroAvos(Date dataP) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(dataP);
        Integer aux = ToolDate.getLastDayOnMonth((int)g.get(1), (int)g.get(2)) - g.get(5) + 1;
        if (aux >= 15) {
            return 1;
        }
        return 0;
    }

    private static Double getSalarioBase(Colaborador colaborador) {
        if (colaborador.getTipoSalario().getCodigo().equals("1")) {
            return colaborador.getValorSalario();
        }
        return colaborador.getValorSalario() * colaborador.getHorasTrabDia() * colaborador.getDiasJornada();
    }

    public static Double getDec(Double maiorRemuneracao, Double avos) {
        return ToolFormatter.arrredondarNumero((Double)(maiorRemuneracao / 12.0 * avos), (int)2);
    }

    public static Double getVlrInssEmpresa(Double vlrDec, Double percDesoneracao, EmpresaRh empresaRh) {
        if (empresaRh.getPossuiDesoneracao().equals(EnumConstantsMentorSimNao.NAO.getValue())) {
            Double vlrBaseInss = ToolFormatter.arrredondarNumero((Double)vlrDec, (int)2);
            Double percInssEmpresa = empresaRh.getPercEmpresa() / 100.0;
            return ToolFormatter.arrredondarNumero((Double)(vlrBaseInss * percInssEmpresa), (int)2);
        }
        Double vlrBaseInss = ToolFormatter.arrredondarNumero((Double)vlrDec, (int)2);
        Double percInssEmpresa = empresaRh.getPercEmpresa() / 100.0;
        Double inss = vlrBaseInss * percInssEmpresa;
        inss = inss * ((100.0 - percDesoneracao) / 100.0);
        return inss;
    }

    public static Double getVlrInssTer(Double vlrDec, EmpresaRh empresaRh) {
        Double vlrBase = ToolFormatter.arrredondarNumero((Double)vlrDec, (int)2);
        Double percInssTer = empresaRh.getPercTerceiros() / 100.0;
        return ToolFormatter.arrredondarNumero((Double)(vlrBase * percInssTer), (int)2);
    }

    public static Double getVlFgts(Double vlrDec) {
        Double vlrBase = ToolFormatter.arrredondarNumero((Double)vlrDec, (int)2);
        Double percFgts = 0.08;
        return ToolFormatter.arrredondarNumero((Double)(vlrBase * percFgts), (int)2);
    }

    public static Double getVlrRat(Double vlrDec, EmpresaRh empresaRh) {
        Double indiceFat = empresaRh.getIndiceFAP();
        Double rat = empresaRh.getPercRat();
        return ToolFormatter.arrredondarNumero((Double)(vlrDec * indiceFat * (rat / 100.0)), (int)2);
    }

    public static Double getVlrAposentadoriaEspecial25(Colaborador colaborador, Double vlrDec, EmpresaRh empresaRh) {
        if (colaborador.getCategoriaSefip().getCodigo().equals("04")) {
            Double percAposentadoria25 = empresaRh.getPercAposentadoriaEspecial25Anos();
            return ToolFormatter.arrredondarNumero((Double)(vlrDec * (percAposentadoria25 / 100.0)), (int)2);
        }
        return 0.0;
    }

    private static Double getValorPis(Double vlrDec, EmpresaRh empresaRh) {
        Empresa empresa = empresaRh.getEmpresa();
        if (empresa.getEmpresaDados().getIndicadorNaturezaJuridica() == null || !empresa.getEmpresaDados().getIndicadorNaturezaJuridica().getCodigo().equals("02")) {
            return 0.0;
        }
        if (empresaRh.getAliquotaPis() <= 0.0) {
            return 0.0;
        }
        return ToolFormatter.arrredondarNumero((Double)(vlrDec * empresaRh.getAliquotaPis() / 100.0), (int)2);
    }
}

