/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.relacionamentopessoa;

import com.touchcomp.basementor.model.vo.EmailEnviadoRelPessoa;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.OpcoesRelacionamento;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoa;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class HelperRelacionamentoPessoa
implements AbstractHelper<RelacionamentoPessoa> {
    private RelacionamentoPessoa relacionamentoPessoa;

    public RelacionamentoPessoa get() {
        return this.relacionamentoPessoa;
    }

    public HelperRelacionamentoPessoa build(RelacionamentoPessoa data) {
        this.relacionamentoPessoa = data;
        return this;
    }

    public EmailPessoa getEmailPrincipal(Pessoa pes) {
        String email = pes.getComplemento().getEmailPrincipal();
        EmailPessoa first = null;
        EmailPessoa found = null;
        for (EmailPessoa e : pes.getComplemento().getEmails()) {
            if (first == null && e.getAtivo() != null && e.getAtivo() == 1 && e.getEnviarDadosRelacionamento() != null && e.getEnviarDadosRelacionamento() == 1) {
                first = e;
            }
            if (e.getEmail() == null || !e.getEmail().equalsIgnoreCase(email)) continue;
            found = e;
            break;
        }
        return found != null ? found : first;
    }

    public List<EmailEnviadoRelPessoa> getEmailsParaEnvio(Pessoa pes, RelacionamentoPessoa rel) {
        ArrayList<EmailEnviadoRelPessoa> aux = new ArrayList<EmailEnviadoRelPessoa>();
        for (EmailPessoa e : pes.getComplemento().getEmails()) {
            if (e.getAtivo() == null || e.getAtivo() != 1 || e.getEnviarDadosRelacionamento() == null || e.getEnviarDadosRelacionamento() != 1) continue;
            EmailEnviadoRelPessoa el = new EmailEnviadoRelPessoa();
            el.setEmail(e.getEmail());
            el.setRelacionamentoPessoa(rel);
            aux.add(el);
        }
        return aux;
    }

    public String buildAssunto(RelacionamentoPessoa found) {
        StringBuilder sb = new StringBuilder();
        found.getItensTarefasRel().stream().forEach(item -> sb.append(item.getTarefa()).append("\n"));
        return sb.toString();
    }

    public void addEmailsUsuarioLogado(Usuario usuario, OpcoesRelacionamento opcoesRel) {
        StringBuilder sb = new StringBuilder();
        if (TMethods.isAffirmative((Number)opcoesRel.getEnviarEmailCRMUsuarios())) {
            for (EmailPessoa emailPessoa : usuario.getUsuarioBasico().getPessoa().getComplemento().getEmails()) {
                if (!TMethods.isAffirmative((Number)emailPessoa.getEnviarDadosRelacionamento()) || !TMethods.isAffirmative((Number)emailPessoa.getAtivo())) continue;
                sb.append(emailPessoa.getEmail()).append(";");
            }
        }
        this.relacionamentoPessoa.setEmailsEnviadosPara(sb.toString());
    }

    public String getDadosPessoa(Pessoa pessoa) {
        if (TMethods.isNull((Object)pessoa).booleanValue()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (pessoa.getNomeFantasia() != null && pessoa.getNomeFantasia().length() > 0) {
            sb.append(pessoa.getNomeFantasia()).append(", ");
        }
        if (pessoa.getEndereco().getCidade() != null) {
            sb.append(pessoa.getEndereco().getCidade().getDescricao()).append(" - ");
            sb.append(pessoa.getEndereco().getCidade().getUf().getSigla());
        }
        return sb.toString();
    }
}

